package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.DateUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.google.common.collect.Lists;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.mbmgmt.dao.MbPvBillingSchemeDao;
import com.iesms.openservices.mbmgmt.entity.MbPvBillingSchemeDo;
import com.iesms.openservices.pvstat.dao.PvStatInverterDao;
import com.iesms.openservices.pvstat.entity.PvStatInverterDayDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterYearDo;
import com.iesms.openservices.pvstat.service.PvStatInverterService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class PvStatInverterServiceImpl extends AbstractIesmsBaseService implements PvStatInverterService {

    Logger logger = LoggerFactory.getLogger(getClass());

    private PvStatInverterDao pvStatInverterDao;
    private MbPvBillingSchemeDao mbPvBillingSchemeDao;

    @Autowired
    public PvStatInverterServiceImpl(PvStatInverterDao pvStatInverterDao,
                                     MbPvBillingSchemeDao mbPvBillingSchemeDao
    ) {
        this.pvStatInverterDao = pvStatInverterDao;
        this.mbPvBillingSchemeDao = mbPvBillingSchemeDao;
    }


    /**
     * @param map
     * @return int
     * @Author ghl
     * @描述 更新逆变器累计收益数据
     * @Date 2019/11/6 20:31
     * @Param [map]
     */
    @Override
    public int updateInveterValueAccum(Map<String, String> map) {
        return pvStatInverterDao.updateInveterValueAccum(map);
    }

    /**
     * @return MbPvBillingSchemeDo 返回值：分布式光伏计费方案设置（用能点）
     * @Author ghl
     * @描述
     * @Date 2019/10/9 13:28
     * @Param [map] 封装查询条件
     */
    @Override
    public MbPvBillingSchemeDo getMbPvBillingSchemeByPointId(Map<String, Object> map) {
        return mbPvBillingSchemeDao.getMbPvBillingSchemeByPointId(map);
    }

    /***
     * @Author ghl
     * @描述 初始化逆变器数据
     * @Date 2019/11/25 14:53
     * @Param [list]
     * @return int
     *
     * @param list*/
    @Override
    public int initPvStatInverterDay(List<PvStatInverterDayDo> list) {
        List<PvStatInverterDayDo> pvStatInverterDayDoList = new ArrayList<>();
        if (list.size() > 0) {
            list.forEach(initPvStatInverterDay -> {
                initPvStatInverterDay.setId(idGenerator.nextId());
                initPvStatInverterDay.setGmtCreate(System.currentTimeMillis());
                initPvStatInverterDay.setGmtModified(System.currentTimeMillis());
                initPvStatInverterDay.setVersion(1);
                pvStatInverterDayDoList.add(initPvStatInverterDay);
            });
        }
        return pvStatInverterDao.initPvStatInverterDay(pvStatInverterDayDoList);
    }

    /**
     * 根据用能点统计当月逆变器发电量
     *
     * @param poitId :
     * @return java.util.List<com.iesms.openservices.pvstat.entity.PvStatInverterDayDo>
     * @throws
     * @Author ghl
     * @Date 2019/8/23 17:26
     */

    public List<PvStatInverterDayDo> getMonthPvStatInverterDayDoByPointId(Long poitId) {
        return pvStatInverterDao.getMonthPvStatInverterDayDoByPointId(poitId);
    }

    /**
     * 逆变器日发电量插入或更新
     *
     * @param list :
     * @return int
     * @throws
     * @Author ghl
     * @Date 2019/8/22 18:17
     */
    @Override
    public int insertOrUpdatePvStatInverterDay(List<PvStatInverterDayDo> list) {
        List<PvStatInverterDayDo> inverterDayDoList = Lists.newArrayList();
        if (list != null) {
            for (PvStatInverterDayDo pvStatInverterDayDo : list) {
                pvStatInverterDayDo.setId(idGenerator.nextId());
                pvStatInverterDayDo.setVersion(1);
                pvStatInverterDayDo.setGmtCreate(System.currentTimeMillis());
                pvStatInverterDayDo.setGmtModified(System.currentTimeMillis());
                inverterDayDoList.add(pvStatInverterDayDo);
            }
        }
        if (inverterDayDoList.size() > 0) {
            return pvStatInverterDao.insertOrUpdatePvStatInverterDay(inverterDayDoList);
        }
        return 0;
    }

    /**
     * 逆变器月发电量插入或更新
     *
     * @return int
     * @throws
     * @Author ghl
     * @Date 2019/8/22 10:33
     */

    @Override
    public int insertOrUpdatePvStatInverterMonth(Map<String, String> map) {
        List<PvStatInverterDayDo> PvStatInverterDayDolist = pvStatInverterDao.getMonthPvStatInverterMonth(map);
        List<PvStatInverterMonthDo> monthDoList = new ArrayList<>();

        String dateStat = map.get("dateStat");
        Date yyyyMM = DateConvertUtils.convertFromString(dateStat, "yyyy-MM-dd");

        int month = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(yyyyMM));
        if (PvStatInverterDayDolist.size() > 0) {
            // parallelStream并行流  groupingBy:按逆变器分组，得到的结果为map，k为map的键，v为map的值
            PvStatInverterDayDolist.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(PvStatInverterDayDo::getCePointId)).forEach((kye, statInverterDayDolist) -> {
                PvStatInverterMonthDo monthDo = null;
                if (statInverterDayDolist.size() > 0) {
                    monthDo = new PvStatInverterMonthDo();
                    // 月收益明细 pv_profit_detail_month
                    List<String> pvProfitDetailList = statInverterDayDolist.parallelStream().filter(s -> s.getPvProfitDetailDay() != null).map(PvStatInverterDayDo::getPvProfitDetailDay).collect(Collectors.toList());
                    String detailMonth = null;
                    if (pvProfitDetailList.size() > 0) {
                        detailMonth = PvstatUtil.getpvProfitDetail2(pvProfitDetailList);
                    }

                    //总发电量
                    BigDecimal egenValueMonth = statInverterDayDolist.parallelStream().filter(inv1 -> inv1.getEgenValueDay() != null).map(PvStatInverterDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
//                    BigDecimal startEgenValueMonth = statInverterDayDolist.parallelStream().filter(s -> s.getStartEgenValueDay() != null).map(s -> s.getStartEgenValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
//                    BigDecimal endEgenValueMonth = statInverterDayDolist.parallelStream().filter(s -> s.getEndEgenValueDay() != null).map(s -> s.getEndEgenValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);

                    // 逆变器月截止至
                    if (statInverterDayDolist.size() == 1) {
                        monthDo.setEndEgenValueMonth(statInverterDayDolist.get(0).getEndEgenValueDay());
                    } else {
                        monthDo.setEndEgenValueMonth(statInverterDayDolist.get(statInverterDayDolist.size() - 1).getEndEgenValueDay());
                    }

                    //逆变器容量
                    BigDecimal inverterCapacity = statInverterDayDolist.parallelStream().filter(s -> s.getInverterCapacity() != null).map(s -> s.getInverterCapacity()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    // 等效时数
                    BigDecimal eqHoursMonth = statInverterDayDolist.parallelStream().filter(s -> s.getEqHoursDay() != null).map(s -> s.getEqHoursDay()).reduce(BigDecimal.ZERO, BigDecimal::add);

                    monthDo.setEqHoursMonth(eqHoursMonth);

                    String orgNo = statInverterDayDolist.get(0).getOrgNo();
                    Long ceCustId = statInverterDayDolist.get(0).getCeCustId();
                    Long ceDeviceId = statInverterDayDolist.get(0).getCeDeviceId();
                    Long cePointId = statInverterDayDolist.get(0).getCePointId();
                    //月收益总额
                    BigDecimal pvProfitTotalMonth = statInverterDayDolist.parallelStream().filter(s11 -> s11.getPvProfitTotalDay() != null).map(PvStatInverterDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    //月节标准煤量
                    BigDecimal sscqValueMonth = statInverterDayDolist.parallelStream().filter(s12 -> s12.getSscqValueDay() != null).map(PvStatInverterDayDo::getSscqValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    //月减二氧化碳排放量
                    BigDecimal scdeValueMonth = statInverterDayDolist.parallelStream().filter(s13 -> s13.getScdeValueDay() != null).map(PvStatInverterDayDo::getScdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    //月减二氧化硫排放量
                    BigDecimal ssdeValueMonth = statInverterDayDolist.parallelStream().filter(s14 -> s14.getSsdeValueDay() != null).map(PvStatInverterDayDo::getSsdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    //月减森林砍伐面积
                    BigDecimal sdaValueMonth = statInverterDayDolist.parallelStream().filter(s15 -> s15.getSdaValueDay() != null).map(PvStatInverterDayDo::getSdaValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);

                    monthDo.setOrgNo(orgNo);
                    monthDo.setCeCustId(ceCustId);
                    monthDo.setCeDeviceId(ceDeviceId);
                    monthDo.setCePointId(cePointId);
                    monthDo.setEgenValueMonth(egenValueMonth);
                    monthDo.setStartEgenValueMonth(statInverterDayDolist.get(0).getStartEgenValueDay());
//                    monthDo.setEndEgenValueMonth(endEgenValueMonth);
                    monthDo.setInverterCapacity(inverterCapacity);
                    monthDo.setSscqValueMonth(sscqValueMonth);
                    monthDo.setScdeValueMonth(scdeValueMonth);
                    monthDo.setSsdeValueMonth(ssdeValueMonth);
                    monthDo.setSdaValueMonth(sdaValueMonth);
                    monthDo.setTmplPvBillingId(statInverterDayDolist.get(0).getTmplPvBillingId());
                    monthDo.setPvbType(statInverterDayDolist.get(0).getPvbType());
                    monthDo.setPvbParams(statInverterDayDolist.get(0).getPvbParams());
                    monthDo.setPvProfitTotalMonth(pvProfitTotalMonth);
                    monthDo.setPvProfitDetailMonth(statInverterDayDolist.get(0).getPvProfitDetailDay());
                    monthDo.setId(idGenerator.nextId());
                    monthDo.setGmtCreate(System.currentTimeMillis());
                    monthDo.setGmtModified(System.currentTimeMillis());
                    monthDo.setMonthStat(month);
                    monthDo.setVersion(1);
                    // 月收益明细
                    monthDo.setPvProfitDetailMonth(detailMonth);

                    monthDoList.add(monthDo);
                }
            });
        }

        if (monthDoList.size() > 0) {
            return pvStatInverterDao.insertOrUpdatePvStatInverterMonth(monthDoList);
        }
        return -1;
    }

    /**
     * 逆变器年发电量插入或更新
     *
     * @return int
     * @throws
     * @Author ghl
     * @Date 2019/8/23 9:48
     */
    @Override
    public int insertOrUpdatePvStatInverterYear(Map<String, String> map) {
        List<PvStatInverterDayDo> pvStatInverterDayDolist = pvStatInverterDao.getYearMonthPvStatInverterYear(map);
        List<PvStatInverterYearDo> yearDoList = new ArrayList<>();

        String dateStat = map.get("dateStat");
        Date yyyy = DateConvertUtils.convertFromString(dateStat, "yyyy-MM-dd");
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(yyyy));


        if (pvStatInverterDayDolist.size() > 0) {
            // stream流分组后是一个map集合，forEach对map进行遍历，k为map的键，v为map的值，在这里，v为PvStatInverterMonthDo list集合
            pvStatInverterDayDolist.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(PvStatInverterDayDo::getCePointId)).forEach((key, statInverterDayDolist) -> {
                PvStatInverterYearDo inverterYearDo = new PvStatInverterYearDo();
                if (statInverterDayDolist.size() > 0) {
                    String orgNo = statInverterDayDolist.get(0).getOrgNo();
                    Long ceCustId = statInverterDayDolist.get(0).getCeCustId();
                    Long ceDeviceId = statInverterDayDolist.get(0).getCeDeviceId();
                    Long cePointId = statInverterDayDolist.get(0).getCePointId();
                    statInverterDayDolist.sort(Comparator.comparing(PvStatInverterDayDo::getDateStat));
                    // 年总发电量
                    // parallelStream并行流  groupingBy:按逆变器分组，得到的结果为map，k为map的键，v为map的值
                    BigDecimal egenValueYear = statInverterDayDolist.parallelStream().filter(s -> s.getEgenValueDay() != null).map(PvStatInverterDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal startEgenValueYear = statInverterDayDolist.get(0).getStartEgenValueDay();
                    BigDecimal endEgenValueYear = statInverterDayDolist.get(statInverterDayDolist.size() - 1).getEndEgenValueDay();
                    if (statInverterDayDolist.size() == 1) {
                        inverterYearDo.setEndEgenValueYear(statInverterDayDolist.get(0).getEndEgenValueDay());
                    } else {
                        inverterYearDo.setEndEgenValueYear(statInverterDayDolist.get(statInverterDayDolist.size() - 1).getEndEgenValueDay());
                    }

                    // 逆变器容量
                    BigDecimal inverterCapacity = statInverterDayDolist.parallelStream().filter(s -> s.getInverterCapacity() != null).map(s -> s.getInverterCapacity()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    // 年等效时数
                    BigDecimal eqHoursYear = statInverterDayDolist.parallelStream().filter(s -> s.getEqHoursDay() != null).map(s -> s.getEqHoursDay()).reduce(BigDecimal.ZERO, BigDecimal::add);

                    inverterYearDo.setEqHoursYear(eqHoursYear);


                    //年收益总额
                    BigDecimal pvProfitTotalYear = statInverterDayDolist.parallelStream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatInverterDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    //年节标准煤量
                    BigDecimal sscqValueYear = statInverterDayDolist.parallelStream().filter(s -> s.getSscqValueDay() != null).map(PvStatInverterDayDo::getSscqValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    //年减二氧化碳排放量
                    BigDecimal scdeValueYear = statInverterDayDolist.parallelStream().filter(s -> s.getScdeValueDay() != null).map(PvStatInverterDayDo::getScdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    //年减二氧化硫排放量
                    BigDecimal ssdeValueYear = statInverterDayDolist.parallelStream().filter(s -> s.getSsdeValueDay() != null).map(PvStatInverterDayDo::getSsdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    //年减森林砍伐面积
                    BigDecimal sdaValueYear = statInverterDayDolist.parallelStream().filter(s -> s.getSdaValueDay() != null).map(PvStatInverterDayDo::getSdaValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);

                    // 年收益明细 pv_profit_detail_year
                    List<String> detailDayList = statInverterDayDolist.stream().filter(s -> s.getPvProfitDetailDay() != null).map(PvStatInverterDayDo::getPvProfitDetailDay).collect(Collectors.toList());
                    String detailYear = null;
                    if (detailDayList.size() > 0) {
                        detailYear = PvstatUtil.getpvProfitDetail2(detailDayList);
                    }

                    inverterYearDo.setId(idGenerator.nextId());
                    inverterYearDo.setOrgNo(orgNo);
                    inverterYearDo.setCeCustId(ceCustId);
                    inverterYearDo.setCeDeviceId(ceDeviceId);
                    inverterYearDo.setCePointId(cePointId);
                    inverterYearDo.setYearStat(year);
                    inverterYearDo.setEgenValueYear(egenValueYear);

                    inverterYearDo.setStartEgenValueYear(startEgenValueYear);
                    inverterYearDo.setEndEgenValueYear(endEgenValueYear);


                    inverterYearDo.setInverterCapacity(inverterCapacity);

                    inverterYearDo.setTmplPvBillingId(statInverterDayDolist.get(0).getTmplPvBillingId());
                    inverterYearDo.setPvbType(statInverterDayDolist.get(0).getPvbType());
                    inverterYearDo.setPvbParams(statInverterDayDolist.get(0).getPvbParams());
                    inverterYearDo.setPvProfitTotalYear(pvProfitTotalYear);
                    inverterYearDo.setPvProfitDetailYear(statInverterDayDolist.get(0).getPvProfitDetailDay());
                    inverterYearDo.setSscqValueYear(sscqValueYear);
                    inverterYearDo.setScdeValueYear(scdeValueYear);
                    inverterYearDo.setSsdeValueYear(ssdeValueYear);
                    inverterYearDo.setSdaValueYear(sdaValueYear);
                    // 年收益明细
                    inverterYearDo.setPvProfitDetailYear(detailYear);

                    inverterYearDo.setGmtCreate(System.currentTimeMillis());
                    inverterYearDo.setGmtModified(System.currentTimeMillis());
                    inverterYearDo.setVersion(1);

                    yearDoList.add(inverterYearDo);
                }
            });
        }

        if (yearDoList.size() > 0) {
            return pvStatInverterDao.insertOrUpdatePvStatInverterYear(yearDoList);
        }
        return -1;
    }
}
