package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cebase.util.CommonUtils;
import com.iesms.openservices.cestat.dao.CeResourceCommonDao;
import com.iesms.openservices.pvstat.dao.PvStatOrgEloadDao;
import com.iesms.openservices.pvstat.entity.*;
import com.iesms.openservices.pvstat.service.PvStatOrgEloadService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class PvStatOrgEloadServiceImpl extends AbstractIesmsBaseService implements PvStatOrgEloadService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private PvStatOrgEloadDao pvStatOrgEloadDao;

    @Resource
    private CeResourceCommonDao ceResourceCommonDao;

    @Override
    public int insertOrUpdatePvStatOrgEloadDay(Map<String, String> map) {

        // 先查询orgNo
        List<String> orgInfoList = ceResourceCommonDao.getOrgInfo();

        String date = map.get("dateStat");

        Map<String, String> params = new HashMap<>();
        params.put("dateStat", date);

        if (orgInfoList.size() > 0) {
            List<PvStatOrgEloadDayDo> pvStatOrgEloadDayDoList = new ArrayList<>();
            orgInfoList.forEach(orgNo -> {
                params.put("orgNo", orgNo);
                params.put("flag", "1");
                // 查询总公司和分公司功率
                List<PvStatPvstationEloadDayVo> pvstationEloadDayVoList = pvStatOrgEloadDao.getPvStatPvstationParentDayValue(params);
                if (pvstationEloadDayVoList.size() > 0) {
                    pvstationEloadDayVoList.forEach(pvstationEloadDay -> {
                        PvStatOrgEloadDayDo pvStatOrgEloadDayDo = new PvStatOrgEloadDayDo();
                        try {
                            BeanUtils.copyProperties(pvStatOrgEloadDayDo, pvstationEloadDay);
                        } catch (IllegalAccessException | InvocationTargetException e) {
                            logger.error("pvStatOrgEloadDayDo copyProperties error" + e.getMessage());
                        }

                        // 将bean转换为map，计算最大值最小值
                        Map<String, Object> stringObjectMap = PvstatUtil.beanToMap(pvStatOrgEloadDayDo);
                        stringObjectMap = PvstatUtil.getMaxAndMinValue(stringObjectMap);

                        // 计算最大值最小值和最大值时间最小值时间1
                        stringObjectMap = PvstatUtil.getMaxAndMinValue(stringObjectMap);

                        // 将map转换为实体类
                        pvStatOrgEloadDayDo = JsonConvertUtils.convertFromString(JsonConvertUtils.convertToString(stringObjectMap), PvStatOrgEloadDayDo.class);

                        pvStatOrgEloadDayDo.setPvTotalCapacity(pvstationEloadDay.getPvCapacity());
                        pvStatOrgEloadDayDo.setId(idGenerator.nextId());
                        pvStatOrgEloadDayDo.setGmtCreate(System.currentTimeMillis());
                        pvStatOrgEloadDayDo.setGmtModified(System.currentTimeMillis());
                        pvStatOrgEloadDayDo.setVersion(1);

                        pvStatOrgEloadDayDo.setPvTotalCapacity(pvstationEloadDay.getPvCapacity());

                        pvStatOrgEloadDayDoList.add(pvStatOrgEloadDayDo);
                    });
                }
            });


            // 查询总公司
            params.put("flag", "2");
            List<PvStatPvstationEloadDayVo> pvstationEloadDayVoList1 = pvStatOrgEloadDao.getPvStatPvstationParentDayValue2(params);
            if (pvstationEloadDayVoList1.size() > 0) {
                pvstationEloadDayVoList1.forEach(pvstationEloadDay -> {

                    // 总公司orgNo设置
                    pvstationEloadDay.setOrgNo(pvstationEloadDay.getParentOrgNo());

                    PvStatOrgEloadDayDo pvStatOrgEloadDayDo = new PvStatOrgEloadDayDo();
                    try {
                        BeanUtils.copyProperties(pvStatOrgEloadDayDo, pvstationEloadDay);
                    } catch (IllegalAccessException | InvocationTargetException e) {
                        logger.error("pvStatOrgEloadDayDo copyProperties error" + e.getMessage());
                    }

                    // 将bean转换为map，计算最大值最小值
                    Map<String, Object> stringObjectMap = PvstatUtil.beanToMap(pvStatOrgEloadDayDo);
                    stringObjectMap = PvstatUtil.getMaxAndMinValue(stringObjectMap);

                    // 计算最大值最小值和最大值时间最小值时间
                    stringObjectMap = PvstatUtil.getMaxAndMinValue(stringObjectMap);

                    // 将map转换为实体类
                    pvStatOrgEloadDayDo = JsonConvertUtils.convertFromString(JsonConvertUtils.convertToString(stringObjectMap), PvStatOrgEloadDayDo.class);

                    pvStatOrgEloadDayDo.setId(idGenerator.nextId());
                    pvStatOrgEloadDayDo.setGmtCreate(System.currentTimeMillis());
                    pvStatOrgEloadDayDo.setGmtModified(System.currentTimeMillis());
                    pvStatOrgEloadDayDo.setVersion(1);
                    pvStatOrgEloadDayDo.setPvTotalCapacity(pvstationEloadDay.getPvCapacity());

                    pvStatOrgEloadDayDoList.add(pvStatOrgEloadDayDo);

                });
            }

            if (pvStatOrgEloadDayDoList.size() > 0) {
                try {
                   return pvStatOrgEloadDao.insertOrUpdatePvStatOrgEloadDay(pvStatOrgEloadDayDoList);
                } catch (Exception e) {
                    logger.error("insertOrUpdatePvStatOrgEloadDay error" + e.getMessage());
                }
            }
        }
        return -1;
    }

    @Override
    public int insertOrUpdatePvStatOrgEloadMonth() {
        Map<String, String> map = CommonUtils.getFirstDayAndLastDayOfMonth();
        map.put("flag", "1");
        int month = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
        List<PvStatPvstationEloadDayVo> pvstationEloadDayVoList = pvStatOrgEloadDao.getPvStatPvstationMonthAndYear(map);
        PvStatPvstationEloadDayVo[] eloadDayVos = {null};
        List<PvStatOrgEloadMonthDo> eloadMonthDoList = new ArrayList<>();
        if (pvstationEloadDayVoList.size() > 0) {
            // 分公司
            pvstationEloadDayVoList.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(s -> s.getOrgNo())).forEach((key, values) -> {
                if (values.size() > 0) {
                    eloadDayVos[0] = new PvStatPvstationEloadDayVo();
                    // 遍历集合
                    BigDecimal[] maxormin = {null, null};
                    Date[] date = {null, null};
                    for (int i = 0; i < values.size(); i++) {
                        maxormin[0] = new BigDecimal("0.00000000");
                        maxormin[1] = new BigDecimal("0.00000000");
                        if (values.get(i).getMaxValue() != null && values.get(i).getMaxValue().compareTo(maxormin[0]) == 1) {
                            maxormin[0] = values.get(i).getMaxValue();
                            date[0] = values.get(i).getMaxValueTime();
                        }

                        if (values.get(i).getMinValue() != null && values.get(i).getMinValue().compareTo(maxormin[1]) == -1) {
                            maxormin[1] = values.get(i).getMinValue();
                            date[1] = values.get(i).getMinValueTime();
                        }
                    }

                    PvStatOrgEloadMonthDo orgEloadMonthDo = new PvStatOrgEloadMonthDo();

                    // 计算平均值
                    values.parallelStream().filter(s -> s.getAvgValue() != null).map(s -> s.getAvgValue()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal totalMonthValue = values.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatPvstationEloadDayVo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (totalMonthValue != null) {
                        BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(values.size()), 8, BigDecimal.ROUND_UP);
                        orgEloadMonthDo.setAvgValue(avgValueMonth);
                    }

                    orgEloadMonthDo.setMaxValue(maxormin[0]);
                    orgEloadMonthDo.setMaxValueTime(date[0]);

                    orgEloadMonthDo.setMinValue(maxormin[1]);
                    orgEloadMonthDo.setMinValueTime(date[1]);

                    orgEloadMonthDo.setId(idGenerator.nextId());
                    orgEloadMonthDo.setOrgNo(values.get(0).getOrgNo());
                    orgEloadMonthDo.setMonthStat(month);
                    orgEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                    orgEloadMonthDo.setGmtModified(System.currentTimeMillis());
                    orgEloadMonthDo.setVersion(1);
                    eloadMonthDoList.add(orgEloadMonthDo);
                }
            });

            // 总公司
            pvstationEloadDayVoList.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(s -> s.getParentOrgNo())).forEach((key, values) -> {
                if (values.size() > 0) {
                    eloadDayVos[0] = new PvStatPvstationEloadDayVo();
                    // 遍历集合
                    BigDecimal[] maxormin = {null, null};
                    Date[] date = {null, null};
                    for (int i = 0; i < values.size(); i++) {
                        maxormin[0] = new BigDecimal("0.00000000");
                        maxormin[1] = new BigDecimal("0.00000000");
                        if (values.get(i).getMaxValue() != null && values.get(i).getMaxValue().compareTo(maxormin[0]) == 1) {
                            maxormin[0] = values.get(i).getMaxValue();
                            date[0] = values.get(i).getMaxValueTime();
                        }

                        if (values.get(i).getMinValue() != null && values.get(i).getMinValue().compareTo(maxormin[1]) == -1) {
                            maxormin[1] = values.get(i).getMinValue();
                            date[1] = values.get(i).getMinValueTime();
                        }
                    }

                    PvStatOrgEloadMonthDo orgEloadMonthDo = new PvStatOrgEloadMonthDo();

                    // 计算平均值
                    BigDecimal totalMonthValue = values.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatPvstationEloadDayVo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (totalMonthValue != null) {
                        BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(values.size()), 8, BigDecimal.ROUND_UP);
                        orgEloadMonthDo.setAvgValue(avgValueMonth);
                    }

                    orgEloadMonthDo.setMaxValue(maxormin[0]);
                    orgEloadMonthDo.setMaxValueTime(date[0]);

                    orgEloadMonthDo.setMinValue(maxormin[1]);
                    orgEloadMonthDo.setMinValueTime(date[1]);

                    orgEloadMonthDo.setId(idGenerator.nextId());
                    orgEloadMonthDo.setOrgNo(values.get(0).getParentOrgNo());
                    orgEloadMonthDo.setMonthStat(month);
                    orgEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                    orgEloadMonthDo.setGmtModified(System.currentTimeMillis());
                    orgEloadMonthDo.setVersion(1);
                    eloadMonthDoList.add(orgEloadMonthDo);
                }
            });

        }


        if (eloadMonthDoList.size() > 0) {
            pvStatOrgEloadDao.insertOrUpdatePvStatOrgEloadMonth(eloadMonthDoList);
        }

        return -1;
    }

    @Override
    public int insertOrUpdatePvStatOrgEloadYear() {
        Map<String, String> map = CommonUtils.getFirstDayAndLastDayOfMonth();
        map.put("flag", "2");
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        List<PvStatPvstationEloadDayVo> pvstationEloadDayVoList = pvStatOrgEloadDao.getPvStatPvstationMonthAndYear(map);
        PvStatPvstationEloadDayVo[] eloadDayVos = {null};
        List<PvStatOrgEloadYearDo> eloadYearDoList = new ArrayList<>();

        if (pvstationEloadDayVoList.size() > 0) {
            // 分公司
            pvstationEloadDayVoList.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(s -> s.getOrgNo())).forEach((key, values) -> {
                if (values.size() > 0) {
                    eloadDayVos[0] = new PvStatPvstationEloadDayVo();
                    // 遍历集合
                    BigDecimal[] maxormin = {null, null};
                    Date[] date = {null, null};
                    for (int i = 0; i < values.size(); i++) {
                        maxormin[0] = new BigDecimal("0.00000000");
                        maxormin[1] = new BigDecimal("0.00000000");
                        if (values.get(i).getMaxValue() != null && values.get(i).getMaxValue().compareTo(maxormin[0]) == 1) {
                            maxormin[0] = values.get(i).getMaxValue();
                            date[0] = values.get(i).getMaxValueTime();
                        }

                        if (values.get(i).getMinValue() != null && values.get(i).getMinValue().compareTo(maxormin[1]) == -1) {
                            maxormin[1] = values.get(i).getMinValue();
                            date[1] = values.get(i).getMinValueTime();
                        }
                    }

                    PvStatOrgEloadYearDo orgEloadYearDo = new PvStatOrgEloadYearDo();

                    // 计算平均值
                    BigDecimal totalMonthValue = values.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatPvstationEloadDayVo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (totalMonthValue != null) {
                        BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(values.size()), 8, BigDecimal.ROUND_UP);
                        orgEloadYearDo.setAvgValue(avgValueMonth);
                    }

                    orgEloadYearDo.setMaxValue(maxormin[0]);
                    orgEloadYearDo.setMaxValueTime(date[0]);

                    orgEloadYearDo.setMinValue(maxormin[1]);
                    orgEloadYearDo.setMinValueTime(date[1]);

                    orgEloadYearDo.setId(idGenerator.nextId());
                    orgEloadYearDo.setOrgNo(values.get(0).getOrgNo());
                    orgEloadYearDo.setYearStat(year);
                    orgEloadYearDo.setGmtCreate(System.currentTimeMillis());
                    orgEloadYearDo.setGmtModified(System.currentTimeMillis());
                    orgEloadYearDo.setVersion(1);
                    eloadYearDoList.add(orgEloadYearDo);
                }
            });

            // 总公司
            pvstationEloadDayVoList.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(s -> s.getParentOrgNo())).forEach((key, values) -> {
                if (values.size() > 0) {
                    eloadDayVos[0] = new PvStatPvstationEloadDayVo();
                    // 遍历集合
                    BigDecimal[] maxormin = {null, null};
                    Date[] date = {null, null};
                    for (int i = 0; i < values.size(); i++) {
                        maxormin[0] = new BigDecimal("0.00000000");
                        maxormin[1] = new BigDecimal("0.00000000");
                        if (values.get(i).getMaxValue() != null && values.get(i).getMaxValue().compareTo(maxormin[0]) == 1) {
                            maxormin[0] = values.get(i).getMaxValue();
                            date[0] = values.get(i).getMaxValueTime();
                        }

                        if (values.get(i).getMinValue() != null && values.get(i).getMinValue().compareTo(maxormin[1]) == -1) {
                            maxormin[1] = values.get(i).getMinValue();
                            date[1] = values.get(i).getMinValueTime();
                        }
                    }

                    PvStatOrgEloadYearDo orgEloadYearDo = new PvStatOrgEloadYearDo();

                    // 计算平均值
                    BigDecimal totalMonthValue = values.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatPvstationEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (totalMonthValue != null) {
                        BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(values.size()), 8, BigDecimal.ROUND_UP);
                        orgEloadYearDo.setAvgValue(avgValueMonth);
                    }

                    orgEloadYearDo.setMaxValue(maxormin[0]);
                    orgEloadYearDo.setMaxValueTime(date[0]);

                    orgEloadYearDo.setMinValue(maxormin[1]);
                    orgEloadYearDo.setMinValueTime(date[1]);

                    orgEloadYearDo.setId(idGenerator.nextId());
                    orgEloadYearDo.setOrgNo(values.get(0).getParentOrgNo());
                    orgEloadYearDo.setYearStat(year);
                    orgEloadYearDo.setGmtCreate(System.currentTimeMillis());
                    orgEloadYearDo.setGmtModified(System.currentTimeMillis());
                    orgEloadYearDo.setVersion(1);
                    eloadYearDoList.add(orgEloadYearDo);
                }
            });
        }


        if (eloadYearDoList.size() > 0) {
            pvStatOrgEloadDao.insertOrUpdatePvStatOrgEloadYear(eloadYearDoList);
        }

        return -1;
    }

    public PvStatOrgEloadDayDo getOrgEloadDayDo(List<PvStatPvstationEloadDayVo> stationEloadDayVoList) {
        PvStatOrgEloadDayDo pvStatOrgEloadDayDo = new PvStatOrgEloadDayDo();

        // 计算96个点位的功率
        Map<String, Object> pvStationMap = PvstatUtil.beanToMap(pvStatOrgEloadDayDo);
        BigDecimal[] maxAndMin = {null, null, null, null};
        Date[] dataTime = {null, null, null, null};
        BigDecimal[] totalCapacity = {null};
        int[] avgLength = {0};
        stationEloadDayVoList.parallelStream().filter(s -> s != null).forEach(station -> {
            // 计算总装机容量
            if (totalCapacity[0] == null) {
                totalCapacity[0] = station.getPvCapacity();
            } else if (totalCapacity[0] != null && station.getPvCapacity() != null) {
                totalCapacity[0] = totalCapacity[0].add(station.getPvCapacity());
            }
            // 计算系统单位96个点的功率
            Map<String, Object> stationMap = PvstatUtil.beanToMap(station);
            for (int i = 1; i < 97; i++) {
                String name = "eloadValue" + String.format("%02d", i);
                if (pvStationMap.get(name) == null) {
                    pvStationMap.put(name, stationMap.get(name));
                } else if (pvStationMap.get(name) != null && stationMap.get(name) != null) {
                    BigDecimal bigDecimal = getBigdecimal(stationMap.get(name));
                    pvStationMap.put(name, bigDecimal.add(getBigdecimal(pvStationMap.get(name))));
                } else {

                }
            }

            // 最大值
            if (maxAndMin[0] == null) {
                maxAndMin[0] = station.getMaxValue();
                dataTime[0] = station.getMaxValueTime();
            } else if (maxAndMin[0] != null && station.getMaxValue() != null) {
                if (station.getMaxValue().compareTo(maxAndMin[0]) == 1) {
                    maxAndMin[0] = station.getMaxValue();
                    dataTime[0] = station.getMaxValueTime();
                }
            }

            // 最小值
            if (maxAndMin[1] == null) {
                maxAndMin[1] = station.getMaxValue();
                dataTime[1] = station.getMaxValueTime();
            } else if (maxAndMin[1] != null && station.getMaxValue() != null) {
                if (station.getMaxValue().compareTo(maxAndMin[1]) == -1) {
                    maxAndMin[1] = station.getMaxValue();
                    dataTime[1] = station.getMaxValueTime();
                }
            }
            // 平均值
            if (maxAndMin[2] == null) {
                maxAndMin[2] = station.getAvgValue();
                avgLength[0]++;
            } else if (maxAndMin[2] != null && station.getAvgValue() != null) {
                maxAndMin[2] = maxAndMin[2].add(station.getAvgValue());
                avgLength[0]++;
            }

            // 当前值
            if (maxAndMin[3] == null) {
                maxAndMin[3] = station.getCurValue();
                dataTime[3] = station.getCurValueTime();
            } else if (maxAndMin[3] != null && station.getCurValue() != null) {
                maxAndMin[3] = maxAndMin[3].add(station.getCurValue());
                dataTime[3] = station.getCurValueTime();
            }
        });

        pvStationMap.put("pvTotalCapacity", totalCapacity[0]);
        pvStationMap.put("maxValue", maxAndMin[0]);
        pvStationMap.put("maxValueTime", dataTime[0]);

        pvStationMap.put("minValue", maxAndMin[1]);
        pvStationMap.put("minValueTime", dataTime[1]);

//        pvStationMap.put("curValue", maxAndMin[3]);
//        pvStationMap.put("curValueTime", dataTime[3]);

        BigDecimal curValue = stationEloadDayVoList.parallelStream().filter(s -> s.getCurValue() != null).map(s -> s.getCurValue()).reduce(BigDecimal.ZERO, BigDecimal::add);

        pvStationMap.put("curValue", curValue);
        pvStationMap.put("curValueTime", stationEloadDayVoList.get(0).getCurValueTime());

        if (maxAndMin[2] != null && avgLength[0] > 0) {
            pvStationMap.put("avgValue", maxAndMin[2].divide(BigDecimal.valueOf(avgLength[0]), 8, BigDecimal.ROUND_UP));
        } else if (maxAndMin[2] != null && avgLength[0] == 0) {
            pvStationMap.put("avgValue", maxAndMin[2]);
        }

        PvStatOrgEloadDayDo statOrgEloadDayDo = JsonConvertUtils.convertFromString(JsonConvertUtils.convertToString(pvStationMap), PvStatOrgEloadDayDo.class);

        return statOrgEloadDayDo;

    }

    public BigDecimal getBigdecimal(Object obj) {
        BigDecimal retBig = null;
        if (obj != null) {
            if (obj instanceof BigDecimal) {
                retBig = (BigDecimal) obj;
            } else if (obj instanceof String) {
                retBig = new BigDecimal((String) obj);
            } else if (obj instanceof BigInteger) {
                retBig = new BigDecimal((BigInteger) obj);
            } else if (obj instanceof Number) {
                retBig = new BigDecimal(((Number) obj).doubleValue());
            } else {
                throw new ClassCastException("无法将 [" + obj + "] " + obj.getClass() + " 转换为BigDecimal.");
            }
        }
        return retBig;
    }
}
