package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cestat.dao.CeResourceCommonDao;
import com.iesms.openservices.pvstat.dao.PvStatOrgDao;
import com.iesms.openservices.pvstat.entity.*;
import com.iesms.openservices.pvstat.service.PvStatOrgService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class PvStatOrgServiceImpl extends AbstractIesmsBaseService implements PvStatOrgService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private PvStatOrgDao pvStatOrgDao;
    private CeResourceCommonDao ceResourceCommonDao;

    @Autowired
    public PvStatOrgServiceImpl(PvStatOrgDao pvStatOrgDao) {
        this.pvStatOrgDao = pvStatOrgDao;
    }

    /***
     * @Author ghl
     * @描述 系统单位发电量日统计
     * @Date 2019/10/8 17:04
     * @Param [list]
     * @return int
     */
    @Override
    public int insertOrUpdatePvStatOrgDay(Map<String, String> orgMap1) {

        String date = orgMap1.get("dateStat");
        orgMap1.put("flag", "1");

        // 查询分公司数据
        List<PvStatOrgDayVo> orgDayValueFromStation = pvStatOrgDao.getOrgDayValueFromStation(orgMap1);
        List<PvStatOrgDayDo> orgDayDoList = new ArrayList<>();
        if (orgDayValueFromStation.size() > 0) {

            orgDayValueFromStation.forEach(orgDayValue -> {
                PvStatOrgDayDo pvStatOrgDayDo = new PvStatOrgDayDo();

                // 使用BeanUtils工具类将vo数据拷贝到do
                try {
                    BeanUtils.copyProperties(pvStatOrgDayDo, orgDayValue);
                } catch (IllegalAccessException | InvocationTargetException e) {
                    logger.error("系统单位数据转换异常" + e.getMessage());
                }

                pvStatOrgDayDo.setId(idGenerator.nextId());
                pvStatOrgDayDo.setGmtCreate(System.currentTimeMillis());
                pvStatOrgDayDo.setGmtModified(System.currentTimeMillis());
                pvStatOrgDayDo.setVersion(1);

                BigDecimal egenValueDay = orgDayValue.getEgenValueDay();
                BigDecimal egenValueAccum = orgDayValue.getEgenValueAccum();
                BigDecimal pvTotalCapacity = orgDayValue.getPvTotalCapacity();

                // 日等效时数 = 日总发电量 / 总装机容量
                if (egenValueDay != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0)) > 0) {
                    BigDecimal eqHoursDay = egenValueDay.divide(pvTotalCapacity, 8, BigDecimal.ROUND_UP);
                    pvStatOrgDayDo.setEqHoursDay(eqHoursDay);
                }

                // 累计等效时数 = 累计总发电量 / 总装机容量
                if (egenValueAccum != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0)) > 0) {
                    BigDecimal eqHoursAccum = egenValueAccum.divide(pvTotalCapacity, 8, BigDecimal.ROUND_UP);
                    pvStatOrgDayDo.setEqHoursAccum(eqHoursAccum);
                }

                orgDayDoList.add(pvStatOrgDayDo);
            });
        }

        orgMap1.put("flag", "2");

        // 查询分公司数据
        List<PvStatOrgDayVo> orgDayValueFromStation1 = pvStatOrgDao.getOrgDayValueFromStation(orgMap1);
        if (orgDayValueFromStation1.size() > 0) {

            orgDayValueFromStation1.forEach(orgDayValue -> {
                PvStatOrgDayDo pvStatOrgDayDo = new PvStatOrgDayDo();

                // 使用BeanUtils工具类将vo数据拷贝到do
                try {
                    BeanUtils.copyProperties(pvStatOrgDayDo, orgDayValue);
                } catch (IllegalAccessException | InvocationTargetException e) {
                    logger.error("系统单位数据转换异常" + e.getMessage());
                }

                pvStatOrgDayDo.setId(idGenerator.nextId());
                pvStatOrgDayDo.setOrgNo(orgDayValue.getParentOrgNo());
                pvStatOrgDayDo.setGmtCreate(System.currentTimeMillis());
                pvStatOrgDayDo.setGmtModified(System.currentTimeMillis());
                pvStatOrgDayDo.setVersion(1);

                BigDecimal egenValueDay = orgDayValue.getEgenValueDay();
                BigDecimal egenValueAccum = orgDayValue.getEgenValueAccum();
                BigDecimal pvTotalCapacity = orgDayValue.getPvTotalCapacity();

                // 日等效时数 = 日总发电量 / 总装机容量
                if (egenValueDay != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0)) > 0) {
                    BigDecimal eqHoursDay = egenValueDay.divide(pvTotalCapacity, 8, BigDecimal.ROUND_UP);
                    pvStatOrgDayDo.setEqHoursDay(eqHoursDay);
                }

                // 累计等效时数 = 累计总发电量 / 总装机容量
                if (egenValueAccum != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0)) > 0) {
                    BigDecimal eqHoursAccum = egenValueAccum.divide(pvTotalCapacity, 8, BigDecimal.ROUND_UP);
                    pvStatOrgDayDo.setEqHoursAccum(eqHoursAccum);
                }

                orgDayDoList.add(pvStatOrgDayDo);
            });
        }
        if (orgDayDoList.size() > 0) {
            pvStatOrgDao.insertOrUpdatePvStatOrgDay(orgDayDoList);
        }
        return -1;
    }

    /***
     * @Author ghl
     * @描述 系统单位发电量月统计
     * @Date 2019/10/8 17:16
     * @Param [list]
     * @return int
     */
    @Override
    public int insertOrUpdatePvStatOrgMonth() {
        Map<String, String> paramMap = new HashMap<>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String format1 = format.format(PvstatUtil.getBeginDayOfMonth());
        String format2 = format.format(PvstatUtil.getEndDayOfMonth());
        paramMap.put("startDay", format1);
        paramMap.put("endDay", format2);

        List<PvStatOrgMonthDo> monthDoList = pvStatOrgDao.getOrgMonthValueFromOrgDay(paramMap);
        if (monthDoList != null && monthDoList.size() > 1) {
            monthDoList.forEach(pvStatOrgMonthDo -> {
                pvStatOrgMonthDo.setId(idGenerator.nextId());
                pvStatOrgMonthDo.setGmtCreate(System.currentTimeMillis());
                pvStatOrgMonthDo.setGmtModified(System.currentTimeMillis());
                pvStatOrgMonthDo.setVersion(1);
            });

            try {
                pvStatOrgDao.insertOrUpdatePvStatOrgMonth(monthDoList);
            } catch (Exception e) {
                logger.error("insertOrUpdatePvStatOrgMonth error:{}", e.getMessage());
            }
        }
        return 1;
    }

    /***
     * @Author ghl
     * @描述 系统单位发电量年统计
     * @Date 2019/10/8 17:16
     * @Param [list]
     * @return int
     */
    @Override
    public int insertOrUpdatePvStatOrgYear() {

        List<PvStatOrgYearDo> yearDoList = pvStatOrgDao.getOrgYearValueFromOrgDay();
        if (yearDoList != null && yearDoList.size() > 0) {
            yearDoList.forEach(pvStatOrgYearDo -> {
                pvStatOrgYearDo.setId(idGenerator.nextId());
                pvStatOrgYearDo.setGmtCreate(System.currentTimeMillis());
                pvStatOrgYearDo.setGmtModified(System.currentTimeMillis());
                pvStatOrgYearDo.setVersion(1);
            });
            try {
                pvStatOrgDao.insertOrUpdatePvStatOrgYear(yearDoList);
                Map<String, String> ymap = new HashMap<>();


                for (PvStatOrgYearDo orgYearDo : yearDoList) {
                    String value = String.valueOf(orgYearDo.getYearStat());
                    value = value + "-01-01";
                    ymap.put("dateStat", value);
                    ymap.put("orgNo", orgYearDo.getOrgNo());
                    pvStatOrgDao.updateOrgYearValue(ymap);
                }

            } catch (Exception e) {
                logger.error("insertOrUpdatePvStatOrgYear error: {}", e.getMessage());
            }
        }

        return -1;
    }

    @Override
    public int updateOrgDayAccum(Map<String, String> map) {
        if (map.get("orgNo").equals("1200000005")) {
            return pvStatOrgDao.updateMostLevel(map);
        } else {
            return pvStatOrgDao.updatePvStatPvstationParentDayAccum(map);
        }

    }

    /**
     * @return com.iesms.openservices.pvstat.entity.PvStatOrgDayDo
     * @Author ghl
     * @描述 分公司和总公司计算方法
     * @Date 2019/10/17 16:41
     * @Param [pvStationList]
     **/
    public PvStatOrgDayDo getPvStatOrgDayDo(List<PvStatPvstationDayDoVo> pvStationList) {
        PvStatOrgDayDo pvstationDayDo = null;
        PvStatOrgDayDo statOrgDayDo = null;

        // 电站数量
        int pvstationCount = pvStationList.parallelStream().filter(s -> s != null).filter(PvstatUtil.distinctByKey(s -> s.getCeCustId()))
                .collect(Collectors.groupingBy(PvStatPvstationDayDo::getCeCustId)).size();

        // 对分组后的客户数据进行求和
        Map<String, BigDecimal> beanMap = new HashMap<>();

        pvstationDayDo = new PvStatOrgDayDo();
        Map<String, Object> pvStationMap = PvstatUtil.beanToMap(pvstationDayDo);

        pvStationList.parallelStream().filter(s -> s != null).forEach(station -> {

            Map<String, Object> stationMap = PvstatUtil.beanToMap(station);
            // 24小时发电量计算
            for (int i = 0; i < 24; i++) {
                //String name = "eloadValueH" + String.format("%02d", i);
                String valueName = "egenValueH" + String.format("%02d", i);
                if (!pvStationMap.containsKey(valueName) && stationMap.containsKey(valueName)) {
                    pvStationMap.put(valueName, stationMap.get(valueName));
                } else if (pvStationMap.containsKey(valueName) && pvStationMap.get(valueName) == null) {
                    pvStationMap.put(valueName, stationMap.get(valueName));
                } else if (pvStationMap.containsKey(valueName) && pvStationMap.get(valueName) != null) {
                    BigDecimal value = getBigdecimal(stationMap.get(valueName));
                    if (value != null) {
                        pvStationMap.put(valueName, value.add(getBigdecimal(pvStationMap.get(valueName))));
                    }

                } else {

                }
            }
        });

        statOrgDayDo = JsonConvertUtils.convertFromString(JsonConvertUtils.convertToString(pvStationMap), PvStatOrgDayDo.class);

        // 总发电量 egen_value_day start_egen_value_day end_egen_value_day egen_value_accum pv_profit_total_day

        BigDecimal egenValueDay = pvStationList.parallelStream().filter(s -> s.getEgenValueDay() != null).map(PvStatPvstationDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal startEgenValueDay = pvStationList.parallelStream().filter(s -> s.getStartEgenValueDay() != null).map(PvStatPvstationDayDo::getStartEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal endEgenValueDay = pvStationList.parallelStream().filter(s -> s.getEndEgenValueDay() != null).map(PvStatPvstationDayDo::getEndEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 累计发电量

        BigDecimal pvProfitTotalDay = pvStationList.parallelStream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatPvstationDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);

        //发电补贴 money_subsidy_total_day  money_subsidy_detail_day
        BigDecimal moneySubsidyTotalDay = pvStationList.parallelStream().filter(s -> s.getMoneySubsidyTotalDay() != null).map(s -> s.getMoneySubsidyTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneSubsidyDetailDayList = pvStationList.parallelStream().filter(s -> s.getMoneySubsidyDetailDay() != null).map(s -> s.getMoneySubsidyDetailDay()).collect(Collectors.toList());
        String moneSubsidyDetailDay = null;
        if (moneSubsidyDetailDayList.size() > 0) {
            moneSubsidyDetailDay = PvstatUtil.getpvProfitDetail2(moneSubsidyDetailDayList);
        }

        if (statOrgDayDo == null) {
            statOrgDayDo = new PvStatOrgDayDo();
        }

        statOrgDayDo.setEgenValueDay(egenValueDay);
        statOrgDayDo.setStartEgenValueDay(startEgenValueDay);
        statOrgDayDo.setEndEgenValueDay(endEgenValueDay);

        BigDecimal totalValueAccum = pvStationList.parallelStream().filter(s -> s.getEgenValueAccum() != null).map(s -> s.getEgenValueAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        statOrgDayDo.setEgenValueAccum(totalValueAccum);
        statOrgDayDo.setPvProfitTotalDay(pvProfitTotalDay);

        statOrgDayDo.setMoneySubsidyTotalDay(moneySubsidyTotalDay);
        statOrgDayDo.setMoneySubsidyDetailDay(moneSubsidyDetailDay);

        // 上网收益 money_online_grid_total_day money_online_grid_detail_day
        BigDecimal moneyOnlineGridTotalDay = pvStationList.parallelStream().filter(s -> s.getMoneyOnlineGridTotalDay() != null).map(s -> s.getMoneyOnlineGridTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneyOnlineDetailTotalDayList = pvStationList.parallelStream().filter(s -> s.getMoneyOnlineGridDetailDay() != null).map(s -> s.getMoneyOnlineGridDetailDay()).collect(Collectors.toList());
        String moneyOnlineDetailTotalDay = null;
        if (moneyOnlineDetailTotalDayList.size() > 0) {
            moneyOnlineDetailTotalDay = PvstatUtil.getpvProfitDetail2(moneyOnlineDetailTotalDayList);
        }
        statOrgDayDo.setMoneyOnlineGridTotalDay(moneyOnlineGridTotalDay);
        statOrgDayDo.setMoneyOnlineGridDetailDay(moneyOnlineDetailTotalDay);

        // 自发自用 money_self_use_total_day money_self_use_detail_day
        BigDecimal moneySelfUseTotalDay = pvStationList.parallelStream().filter(s -> s.getMoneySelfUseTotalDay() != null).map(s -> s.getMoneySelfUseTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneySelfUseDetailDayList = pvStationList.parallelStream().filter(s -> s.getMoneySelfUseDetailDay() != null).map(s -> s.getMoneySelfUseDetailDay()).collect(Collectors.toList());
        String moneySelfUseDetailDay = null;
        if (moneySelfUseDetailDayList.size() > 0) {
            moneySelfUseDetailDay = PvstatUtil.getpvProfitDetail2(moneySelfUseDetailDayList);
        }
        statOrgDayDo.setMoneySelfUseTotalDay(moneySelfUseTotalDay);
        statOrgDayDo.setMoneySelfUseDetailDay(moneySelfUseDetailDay);

        // 累计收益 pv_profit_total_accum money_subsidy_total_accum money_subsidy_detail_accum
//        BigDecimal pvProfitTotalAccum = pvStationList.parallelStream().filter(s -> s.getPvProfitTotalAccum() != null).map(s -> s.getPvProfitTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);

        BigDecimal moneySubsidyTotalAccum = pvStationList.parallelStream().filter(s -> s.getMoneySubsidyTotalAccum() != null).map(s -> s.getMoneySubsidyTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneySubsidyDetailAccumList = pvStationList.parallelStream().filter(s -> s.getMoneySubsidyDetailAccum() != null).map(s -> s.getMoneySubsidyDetailAccum()).collect(Collectors.toList());
        String moneySubsidyDetailAccum = null;
        if (moneySubsidyDetailAccumList.size() > 0) {
            moneySubsidyDetailAccum = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailAccumList);
        }

        // 累计收益总额
        BigDecimal pvProfitTotalAccum = pvStationList.parallelStream().filter(s -> s.getPvProfitTotalAccum() != null).map(s -> s.getPvProfitTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        statOrgDayDo.setPvProfitTotalAccum(pvProfitTotalAccum);
        statOrgDayDo.setMoneySubsidyTotalAccum(moneySubsidyTotalAccum);
        statOrgDayDo.setMoneySubsidyDetailAccum(moneySubsidyDetailAccum);

        // 累计上网 money_online_grid_total_accum money_online_grid_detail_accum
        BigDecimal moneyOnlineGridTotalAccum = pvStationList.parallelStream().filter(s -> s.getMoneyOnlineGridTotalAccum() != null).map(s -> s.getMoneyOnlineGridTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneyOnlineGridDetailAccumList = pvStationList.parallelStream().filter(s -> s.getMoneyOnlineGridDetailAccum() != null).map(s -> s.getMoneyOnlineGridDetailAccum()).collect(Collectors.toList());
        String moneyOnlineGridDetailAccum = null;
        if (moneyOnlineGridDetailAccumList.size() > 0) {
            moneyOnlineGridDetailAccum = PvstatUtil.getpvProfitDetail2(moneyOnlineGridDetailAccumList);
        }
        statOrgDayDo.setMoneyOnlineGridTotalAccum(moneyOnlineGridTotalAccum);
        statOrgDayDo.setMoneyOnlineGridDetailAccum(moneyOnlineGridDetailAccum);

        // 累计自发自用 money_self_use_total_accum money_self_use_detail_accum
        BigDecimal moneySelfUseTotalAccum = pvStationList.parallelStream().filter(s -> s.getMoneySelfUseTotalAccum() != null).map(s -> s.getMoneySelfUseTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneySelfUseDetailAccumList = pvStationList.parallelStream().filter(s -> s.getMoneySelfUseDetailAccum() != null).map(s -> s.getMoneySelfUseDetailAccum()).collect(Collectors.toList());
        String moneySelfUseDetailAccum = null;
        if (moneySelfUseDetailAccumList.size() > 0) {
            moneySelfUseDetailAccum = PvstatUtil.getpvProfitDetail2(moneySelfUseDetailAccumList);
        }
        statOrgDayDo.setMoneySelfUseTotalAccum(moneySelfUseTotalAccum);
        statOrgDayDo.setMoneySelfUseDetailAccum(moneySelfUseDetailAccum);
        // 光伏电站数量 pvstation_count

        // 总装机容量 pv_total_capacity
        BigDecimal pvTotalCapacity = pvStationList.parallelStream().filter(s -> s.getPvCapacity() != null).map(s -> s.getPvCapacity()).reduce(BigDecimal.ZERO, BigDecimal::add);
        // 日等消时数 eq_hours_day egen_value_day
        // 累计等效时数 eq_hours_accum egen_value_accum
//        BigDecimal eqHoursDay = pvStationList.parallelStream().filter(s -> s.getEqHoursDay() != null).map(s -> s.getEqHoursDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
//        BigDecimal eqHoursAccum = pvStationList.parallelStream().filter(s -> s.getEqHoursAccum() != null).map(s -> s.getEqHoursAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);

        BigDecimal eqHoursDay = null;
        BigDecimal eqHoursAccum = null;

        // 系统单位等效时数 = 系统发电量 / 系统装机容量
        if (totalValueAccum != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0)) > 0) {
            eqHoursAccum = totalValueAccum.divide(pvTotalCapacity, 8, BigDecimal.ROUND_UP);
        }

        if (egenValueDay != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0)) > 0) {
            eqHoursDay = egenValueDay.divide(pvTotalCapacity, 8, BigDecimal.ROUND_UP);
        }

        statOrgDayDo.setEqHoursDay(eqHoursDay);
        statOrgDayDo.setEqHoursAccum(eqHoursAccum);

        // 节能减排计算
        BigDecimal sscqValueDay = new BigDecimal("0.00000000");
        BigDecimal scdeValueDay = new BigDecimal("0.00000000");
        BigDecimal ssdeValueDay = new BigDecimal("0.00000000");
        BigDecimal sdaValueDay = new BigDecimal("0.00000000");

        BigDecimal sscqValueAccum = new BigDecimal("0.00000000");
        BigDecimal scdeValueAccum = new BigDecimal("0.00000000");
        BigDecimal ssdeValueAccum = new BigDecimal("0.00000000");
        BigDecimal sdaValueAccum = new BigDecimal("0.00000000");

        sscqValueDay = pvStationList.stream().filter(s -> s.getSscqValueDay() != null).map(PvStatPvstationDayDo::getSscqValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        scdeValueDay = pvStationList.stream().filter(s -> s.getScdeValueDay() != null).map(PvStatPvstationDayDo::getScdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        ssdeValueDay = pvStationList.stream().filter(s -> s.getSsdeValueDay() != null).map(PvStatPvstationDayDo::getSsdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        sdaValueDay = pvStationList.stream().filter(s -> s.getSdaValueDay() != null).map(PvStatPvstationDayDo::getSdaValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);

        sscqValueAccum = pvStationList.stream().filter(s -> s.getSscqValueAccum() != null).map(PvStatPvstationDayDo::getSscqValueAccum).reduce(BigDecimal.ZERO, BigDecimal::add);
        scdeValueAccum = pvStationList.stream().filter(s -> s.getScdeValueAccum() != null).map(PvStatPvstationDayDo::getScdeValueAccum).reduce(BigDecimal.ZERO, BigDecimal::add);
        ssdeValueAccum = pvStationList.stream().filter(s -> s.getSsdeValueAccum() != null).map(PvStatPvstationDayDo::getSsdeValueAccum).reduce(BigDecimal.ZERO, BigDecimal::add);
        sdaValueAccum = pvStationList.stream().filter(s -> s.getSdaValueAccum() != null).map(PvStatPvstationDayDo::getSdaValueAccum).reduce(BigDecimal.ZERO, BigDecimal::add);

        statOrgDayDo.setSscqValueDay(sscqValueDay);
        statOrgDayDo.setScdeValueDay(scdeValueDay);
        statOrgDayDo.setSsdeValueDay(ssdeValueDay);
        statOrgDayDo.setSdaValueDay(sdaValueDay);

        statOrgDayDo.setSscqValueAccum(sscqValueAccum);
        statOrgDayDo.setScdeValueAccum(scdeValueAccum);
        statOrgDayDo.setSsdeValueAccum(ssdeValueAccum);
        statOrgDayDo.setSdaValueAccum(sdaValueAccum);

        statOrgDayDo.setPvstationCount(pvstationCount);

        statOrgDayDo.setId(idGenerator.nextId());
        if (pvStationList.get(0).getParentOrgNo() != null) {
            statOrgDayDo.setOrgNo(pvStationList.get(pvStationList.size() - 1).getParentOrgNo());
        } else {
            statOrgDayDo.setOrgNo(pvStationList.get(pvStationList.size() - 1).getOrgNo());
        }

        statOrgDayDo.setDateStat(new Date());
        statOrgDayDo.setGmtCreate(System.currentTimeMillis());
        statOrgDayDo.setGmtModified(System.currentTimeMillis());
        statOrgDayDo.setVersion(1);
        statOrgDayDo.setOrgNo(pvStationList.get(0).getOrgNo());

        return statOrgDayDo;
    }

    public Map<String, String> getFirstMonthOfYear() {
        Map<String, String> retMap = new HashMap<>();
        Date date1 = new Date();
        String ret = DateConvertUtils.convertToString(date1, "yyyy-01-01");
        retMap.put("startDay", ret);
        return retMap;
    }


    public BigDecimal getBigdecimal(Object obj) {
        BigDecimal retBig = null;
        if (obj != null) {
            if (obj instanceof BigDecimal) {
                retBig = (BigDecimal) obj;
            } else if (obj instanceof String) {
                retBig = new BigDecimal((String) obj);
            } else if (obj instanceof BigInteger) {
                retBig = new BigDecimal((BigInteger) obj);
            } else if (obj instanceof Number) {
                retBig = new BigDecimal(((Number) obj).doubleValue());
            } else {
                throw new ClassCastException("无法将 [" + obj + "] " + obj.getClass() + " 转换为BigDecimal.");
            }
        }
        return retBig;
    }

    /**
     * @return com.iesms.openservices.pvstat.entity.PvStatOrgDayDo
     * @Author ghl
     * @描述 获取24点发电量方法抽取
     * @Date 2019/11/9 16:47
     * @Param [pvStatOrgDayDo, orgDayValue]
     **/
    public PvStatOrgDayDo getpvStatOrgDayDo(PvStatOrgDayDo pvStatOrgDayDo, PvStatOrgDayVo orgDayValue) {
        // 将对象转为map
        Map<String, Object> stringObjectMap = PvstatUtil.beanToMap(orgDayValue);
        // 循环取出24小时发电量
        for (int i = 0; i < 24; i++) {
            if (stringObjectMap != null) {
                String name = String.format("egenValueH%02d", i);
                Object obj = stringObjectMap.get(name);
                BigDecimal bigdecimal = PvstatUtil.getBigdecimal(obj);
                try {
                    // 将24点数据拷贝到pvStatOrgDayDo
                    BeanUtils.copyProperty(pvStatOrgDayDo, name, bigdecimal);
                } catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
        return pvStatOrgDayDo;
    }
}
