package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cebase.entity.CeSourceDo;
import com.iesms.openservices.cebase.util.CommonUtils;
import com.iesms.openservices.cestat.dao.CeResourceCommonDao;
import com.iesms.openservices.pvstat.dao.PvStatPvstationDao;
import com.iesms.openservices.pvstat.dao.PvStatPvstationEloadDao;
import com.iesms.openservices.pvstat.entity.*;
import com.iesms.openservices.pvstat.service.PvStatPvstationEloadService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class PvStatPvstationEloadServiceImpl extends AbstractIesmsBaseService implements PvStatPvstationEloadService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private PvStatPvstationEloadDao pvStatPvstationEloadDao;

    @Resource
    private CeResourceCommonDao ceResourceCommonDao;

    @Resource
    private PvStatPvstationDao pvStatPvstationDao;

    @Override
    public int insertOrUpdatePvStatPvstationEloadDayDo(Map<String, String> params) {

        if (params == null) {
            params = new HashMap<>();
            params.put("dateStat", DateConvertUtils.convertToString(new Date(), DateConvertUtils.PATTERN_DATE_WITHSPR_DASH));
        }

        // 查询客户列表
        List<String> orgInfoList = ceResourceCommonDao.getOrgInfo();
        List<PvStatPvstationEloadDayDo> pvstationEloadDayDoList = new ArrayList<>();

        if (orgInfoList.size() > 0) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HHmm");
            Map<String, String> finalParams = params;
            orgInfoList.forEach(orgNo -> {
                finalParams.put("orgNo", orgNo);
                // 按逆变器统计电站功率
                List<PvStatInverterEloadDayDo> inverterEloadDayDoList = pvStatPvstationEloadDao.getPvstationEloadDayFromInverterDay(finalParams);
                if (inverterEloadDayDoList.size() > 0) {
                    inverterEloadDayDoList.forEach(inverterEloadDayDo -> {
                        PvStatPvstationEloadDayDo pvStatPvstationEloadDayDo = new PvStatPvstationEloadDayDo();
                        try {
                            BeanUtils.copyProperties(pvStatPvstationEloadDayDo, inverterEloadDayDo);
                        } catch (IllegalAccessException e) {
                            e.printStackTrace();
                        } catch (InvocationTargetException e) {
                            logger.error("pvStatPvstationEloadDayDo copy properties error" + e.getMessage());
                        }
                        // 计算电站功率最大值最小值
                        Map<String, Object> stringObjectMap = PvstatUtil.beanToMap(pvStatPvstationEloadDayDo);

                        stringObjectMap = PvstatUtil.getMaxAndMinValue(stringObjectMap);

                        // 将map转换为实体对象
                        pvStatPvstationEloadDayDo = JsonConvertUtils.convertFromString(JsonConvertUtils.convertToString(stringObjectMap), PvStatPvstationEloadDayDo.class);

                        pvStatPvstationEloadDayDo.setId(idGenerator.nextId());
                        pvStatPvstationEloadDayDo.setDateStat(new Date());
                        pvStatPvstationEloadDayDo.setGmtCreate(System.currentTimeMillis());
                        pvStatPvstationEloadDayDo.setGmtModified(System.currentTimeMillis());
                        pvStatPvstationEloadDayDo.setVersion(1);


                        // 根据电站id查询电站装机容量
                        Map<String, Long> propsMap = new HashMap<>();
                        propsMap.put("custId", pvStatPvstationEloadDayDo.getCeCustId());
                        CeSourceDo ceSourceDo = pvStatPvstationDao.getCustPropsByCustId(propsMap);
                        BigDecimal installCapacity = null;
                        if (ceSourceDo != null) {
                            installCapacity = ceSourceDo.getElecCapacity();
                        }
                        pvStatPvstationEloadDayDo.setPvCapacity(installCapacity);

                        pvstationEloadDayDoList.add(pvStatPvstationEloadDayDo);
                    });
                }
            });
        }

        if (pvstationEloadDayDoList.size() > 0) {
            try {
                pvStatPvstationEloadDao.insertOrUpdatePvStatPvstationEloadDay(pvstationEloadDayDoList);
            } catch (Exception e) {
                logger.error("insertOrUpdatePvStatPvstationEloadDay error: " + e.getMessage());
            }
        }

        return -1;
    }

    @Override
    public int insertOrUpdatePvStatPvstationEloadMonthDo(Map<String, String> params) {

        if (params == null) {
            params = CommonUtils.getFirstDayAndLastDayOfMonth();
        }
        params.put("flag", "1");

        List<PvStatPvstationEloadDayDo> pvStatPvstationEloadMonth = pvStatPvstationEloadDao.getPvStatPvstationEloadMonthAndYear(params);
        List<PvStatPvstationEloadMonthDo> eloadMonthDoList = new ArrayList<>();

        if (pvStatPvstationEloadMonth.size() > 0) {

            PvStatPvstationEloadMonthDo eloadMonthDo = new PvStatPvstationEloadMonthDo();
            pvStatPvstationEloadMonth.parallelStream().filter(s -> s.getCeCustId() != null).collect(Collectors.groupingBy(PvStatPvstationEloadDayDo::getCeCustId)).forEach((ley, station) -> {
                int month = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));

                BigDecimal[] maxormin = {null, null};
                Date[] date = {null, null};

                for (int i = 0; i < station.size(); i++) {
                    maxormin[0] = new BigDecimal("0.00000000");
                    maxormin[1] = new BigDecimal("0.00000000");
                    if (station.get(i).getMaxValue() != null && station.get(i).getMaxValue().compareTo(maxormin[0]) == 1) {
                        maxormin[0] = station.get(i).getMaxValue();
                        date[0] = station.get(i).getMaxValueTime();
                    }

                    if (station.get(i).getMinValue() != null && station.get(i).getMinValue().compareTo(maxormin[1]) == -1) {
                        maxormin[1] = station.get(i).getMinValue();
                        date[1] = station.get(i).getMinValueTime();
                    }
                }
                // 最大值
//                PvStatPvstationEloadDayDo maxValue = station.parallelStream().filter(s -> s.getMaxValue() != null).max((b1, b2) -> b1.getMaxValue().compareTo(b2.getMaxValue())).get();
                // 最小值
//                PvStatPvstationEloadDayDo minValue = station.parallelStream().filter(s -> s.getMaxValue() != null).max((b2, b1) -> b1.getMaxValue().compareTo(b2.getMaxValue())).get();


                eloadMonthDo.setId(idGenerator.nextId());
                eloadMonthDo.setOrgNo(pvStatPvstationEloadMonth.get(0).getOrgNo());
                eloadMonthDo.setCeCustId(pvStatPvstationEloadMonth.get(0).getCeCustId());
                eloadMonthDo.setMonthStat(month);
                eloadMonthDo.setMaxValue(maxormin[0]);
                eloadMonthDo.setMaxValueTime(date[0]);
                eloadMonthDo.setMinValue(maxormin[1]);
                eloadMonthDo.setMinValueTime(date[1]);
                eloadMonthDo.setPvCapacity(pvStatPvstationEloadMonth.get(0).getPvCapacity());
                eloadMonthDo.setGmtCreate(System.currentTimeMillis());
                eloadMonthDo.setGmtModified(System.currentTimeMillis());
                eloadMonthDo.setVersion(1);

                eloadMonthDoList.add(eloadMonthDo);
            });
        }
        if (pvStatPvstationEloadMonth.size() > 0) {
            return pvStatPvstationEloadDao.insertOrUpdatePvStatPvstationEloadMonth(eloadMonthDoList);
        }
        return -1;
    }

    @Override
    public int insertOrUpdatePvStatPvstationEloadYearDo(Map<String, String> params) {
        if (params == null) {
            params = getFirstMonthOfYear();
        }
        params.put("flag", "2");

        List<PvStatPvstationEloadDayDo> pvStatPvstationEloadYear = pvStatPvstationEloadDao.getPvStatPvstationEloadMonthAndYear(params);
        List<PvStatPvstationEloadYearDo> eloadYearDoList = new ArrayList<>();

        if (pvStatPvstationEloadYear.size() > 0) {

            PvStatPvstationEloadYearDo eloadYearDo = new PvStatPvstationEloadYearDo();
            pvStatPvstationEloadYear.parallelStream().filter(s -> s.getCeCustId() != null).collect(Collectors.groupingBy(PvStatPvstationEloadDayDo::getCeCustId)).forEach((ley, station) -> {
                int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));

                BigDecimal[] maxormin = {null, null};
                Date[] date = {null, null};

                for (int i = 0; i < station.size(); i++) {
                    maxormin[0] = new BigDecimal("0.00000000");
                    maxormin[1] = new BigDecimal("0.00000000");
                    if (station.get(i).getMaxValue() != null && station.get(i).getMaxValue().compareTo(maxormin[0]) == 1) {
                        maxormin[0] = station.get(i).getMaxValue();
                        date[0] = station.get(i).getMaxValueTime();
                    }

                    if (station.get(i).getMinValue() != null && station.get(i).getMinValue().compareTo(maxormin[1]) == -1) {
                        maxormin[1] = station.get(i).getMinValue();
                        date[1] = station.get(i).getMinValueTime();
                    }
                }

                eloadYearDo.setId(idGenerator.nextId());
                eloadYearDo.setOrgNo(pvStatPvstationEloadYear.get(0).getOrgNo());
                eloadYearDo.setCeCustId(pvStatPvstationEloadYear.get(0).getCeCustId());
                eloadYearDo.setYearStat(year);
                eloadYearDo.setMaxValue(maxormin[0]);
                eloadYearDo.setMaxValueTime(date[0]);
                eloadYearDo.setMinValue(maxormin[1]);
                eloadYearDo.setMinValueTime(date[1]);
                eloadYearDo.setPvCapacity(pvStatPvstationEloadYear.get(0).getPvCapacity());
                eloadYearDo.setGmtCreate(System.currentTimeMillis());
                eloadYearDo.setGmtModified(System.currentTimeMillis());
                eloadYearDo.setVersion(1);

                eloadYearDoList.add(eloadYearDo);
            });
        }
        if (pvStatPvstationEloadYear.size() > 0) {
            return pvStatPvstationEloadDao.insertPvStatPvstationEloadYear(eloadYearDoList);
        }
        return -1;
    }

    public Map<String, String> getFirstMonthOfYear() {
        Map<String, String> retMap = new HashMap<>();
        Date date1 = new Date();
        String ret = DateConvertUtils.convertToString(date1, "yyyy-01-01");
        retMap.put("startDay", ret);
        return retMap;
    }
}
