package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cebase.entity.CeSourceDo;
import com.iesms.openservices.cebase.util.CommonUtils;
import com.iesms.openservices.pvstat.dao.PvStatPvstationDao;
import com.iesms.openservices.pvstat.entity.*;
import com.iesms.openservices.pvstat.service.PvStatPvstationService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 电站发电量统计
 *
 * @author ghl
 */

@Service
public class PvStatPvstationServiceImpl extends AbstractIesmsBaseService implements PvStatPvstationService {
    private final Logger logger = LoggerFactory.getLogger(getClass());
    private PvStatPvstationDao pvStatPvstationDao;

    @Autowired
    public PvStatPvstationServiceImpl(
            PvStatPvstationDao pvStatPvstationDao
    ) {
        this.pvStatPvstationDao = pvStatPvstationDao;
    }

    /**
     * @return int mybatis返回值
     * @Author ghl
     * @描述 电站日发电量统计
     * @Date 2019/10/14 14:18
     * @Param [params] 查询时间参数
     **/
    @Override
    public int insertOrUpdatePvStatPvstationDayDo(Map<String, String> params) {

        String dateStat = params.get("dateStat");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date[] dates = {null, new Date()};

        if (dateStat != null) {
            try {
                dates[0] = simpleDateFormat.parse(dateStat);
            } catch (ParseException e) {
                logger.error("insertOrUpdatePvStatPvstationDayDo date parse exception:" + e.getMessage());
            }
        }
        // 初始化电站数据 -->先将投运的正常的电站信息插进去
        // 查询投运的正常的光伏电站信息
        List<PvStatPvstationDayDo> getInitCustMessage = pvStatPvstationDao.getInitCustMessage();
        List<PvStatPvstationDayDo> initPvStatPvstationDayDoList = new ArrayList<>();
        List<PvStatPvstationDayDo> pvstationDayDoList = new ArrayList<>();
        Set<String> orgNoSet = new HashSet<>();

        if (!CollectionUtils.isEmpty(getInitCustMessage)) {
            for (PvStatPvstationDayDo pvStatPvstationDayDo : getInitCustMessage) {
                pvStatPvstationDayDo.setId(idGenerator.nextId());
                pvStatPvstationDayDo.setDateStat(dates[0] == null ? dates[1] : dates[0]);
                pvStatPvstationDayDo.setGmtCreate(System.currentTimeMillis());
                pvStatPvstationDayDo.setGmtModified(System.currentTimeMillis());
                pvStatPvstationDayDo.setVersion(1);
                // 初始化节能减排信息
                // 节能减排初始化数据设置
                BigDecimal bigDecimal = new BigDecimal("0.00000000");

                pvStatPvstationDayDo.setSscqValueDay(bigDecimal);
                pvStatPvstationDayDo.setScdeValueDay(bigDecimal);
                pvStatPvstationDayDo.setSsdeValueDay(bigDecimal);
                pvStatPvstationDayDo.setSdaValueDay(bigDecimal);

                pvStatPvstationDayDo.setSscqValueAccum(bigDecimal);
                pvStatPvstationDayDo.setScdeValueAccum(bigDecimal);
                pvStatPvstationDayDo.setSsdeValueAccum(bigDecimal);
                pvStatPvstationDayDo.setSdaValueAccum(bigDecimal);
                // 统计来源默认设置为发电电表，设置为 1
                pvStatPvstationDayDo.setStatSource(1);

                initPvStatPvstationDayDoList.add(pvStatPvstationDayDo);

                String orgNo = pvStatPvstationDayDo.getOrgNo();

                if (!orgNoSet.contains(orgNo)) {
                    // 电站数据统计处理
                    params.put("orgNo", orgNo);

                    List<PvStatInverterDayDo> pvStatInverterDayDoList = pvStatPvstationDao.getStationDayValueFromInveter(params);
                    List<PvStatGenwattmeterDayDo> pvStatGenwattmeterDayDoList = pvStatPvstationDao.getStationDayValueFromGenwatt(params);

                    if ((pvStatInverterDayDoList != null && pvStatInverterDayDoList.size() > 0) || (pvStatGenwattmeterDayDoList != null && pvStatGenwattmeterDayDoList.size() > 0)) {

                        if (pvStatInverterDayDoList != null && pvStatInverterDayDoList.size() > 0) {
                            pvstationDayDoList = getInveterValue(pvStatInverterDayDoList, pvstationDayDoList, dates);
                        }

                        if (pvStatGenwattmeterDayDoList != null && pvStatGenwattmeterDayDoList.size() > 0) {
                            pvstationDayDoList = geGenwattmeterValue(pvStatGenwattmeterDayDoList, pvstationDayDoList, dates);
                        }
                    }
                    orgNoSet.add(orgNo);
                }
            }
        }

        if (initPvStatPvstationDayDoList.size() > 0) {
            try {
                pvStatPvstationDao.insertInitStationOrUpdate(initPvStatPvstationDayDoList);
            } catch (Exception e) {
                logger.error("insertInitStationOrUpdateError :" + e.getMessage());
            }
        }

        if (logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start insertOrUpdatePvStatPvstationDayDo >>>>>> ");
        }

        if (pvstationDayDoList.size() > 0) {
            try {
                pvStatPvstationDao.insertOrUpdatePvStatPvstationDayDo(pvstationDayDoList);


                for (PvStatPvstationDayDo pvStatPvstationDayDo : pvstationDayDoList) {

                    Map<String, String> upMap = new HashMap<>();

                    upMap.put("orgNo", pvStatPvstationDayDo.getOrgNo());
                    upMap.put("ceCustId", String.valueOf(pvStatPvstationDayDo.getCeCustId()));
//                    upMap.put("ceCustId", pvStatPvstationDayDo.getOrgNo());
                    upMap.put("dateStat", params.get("dateStat"));

                    // 执行电站累积量更新数据
                    pvStatPvstationDao.updatePvStationDayDo(upMap);
                }


            } catch (Exception e) {
                logger.error("insertOrUpdatePvStatPvstationDayDo error :" + e.getMessage());
            }
        }
        return -1;
    }

    /***
     * Description: 逆变器数据计算
     * @author: ghl
     * @param pvStatInverterDayDoList:
     * @param pvstationDayDoList:
     * @param dates:
     * @return: java.util.List<com.iesms.openservices.pvstat.entity.PvStatPvstationDayDo>
     * @date: 2020/4/4 11:58
     */
    private List<PvStatPvstationDayDo> getInveterValue(List<PvStatInverterDayDo> pvStatInverterDayDoList, List<PvStatPvstationDayDo> pvstationDayDoList, Date[] dates) {
        if (pvStatInverterDayDoList != null && pvStatInverterDayDoList.size() > 0) {
            for (PvStatInverterDayDo pvStatInverterDayDo : pvStatInverterDayDoList) {
                // 查询电站装机容量
                Map<String, Long> propsMap = new HashMap<>();
                Long ceCustId = pvStatInverterDayDo.getCeCustId();
                BigDecimal installCapacity = null;
                if (ceCustId != null) {
                    propsMap.put("custId", ceCustId);
                    // 电站装机容量修改为从resource资源表获取
                    CeSourceDo ceSourceDo = pvStatPvstationDao.getCustPropsByCustId(propsMap);

                    if (ceSourceDo != null) {
                        installCapacity = ceSourceDo.getElecCapacity();
                    }
                }
                // 逆变器
                PvStatPvstationDayDo pvstationDayDo = new PvStatPvstationDayDo();

                try {
                    BeanUtils.copyProperties(pvstationDayDo, pvStatInverterDayDo);
                } catch (IllegalAccessException | InvocationTargetException e) {
                    logger.error("pvStatInverterDayDo proper copy : " + e.getMessage());
                }
                pvstationDayDo.setId(idGenerator.nextId());
                pvstationDayDo.setDateStat(dates[0] == null ? dates[1] : dates[0]);
                pvstationDayDo.setStatSource(2);
                pvstationDayDo.setGmtCreate(System.currentTimeMillis());
                pvstationDayDo.setGmtModified(System.currentTimeMillis());
                pvstationDayDo.setVersion(1);
                pvstationDayDo.setPvCapacity(installCapacity);

                // 计算日等效时数
                if (pvStatInverterDayDo.getEgenValueDay() != null && installCapacity != null && installCapacity.compareTo(BigDecimal.valueOf(0)) > 0) {
                    BigDecimal eqHoursDay = pvStatInverterDayDo.getEgenValueDay().divide(installCapacity, 8, BigDecimal.ROUND_UP);
                    pvstationDayDo.setEqHoursDay(eqHoursDay);
                }

                // 计算累计等效时数
                if (pvStatInverterDayDo.getEgenValueAccum() != null && installCapacity != null && installCapacity.compareTo(BigDecimal.valueOf(0)) > 0) {
                    BigDecimal eqHoursAccum = pvStatInverterDayDo.getEgenValueAccum().divide(installCapacity, 8, BigDecimal.ROUND_UP);
                    pvstationDayDo.setEqHoursAccum(eqHoursAccum);
                }
                // 将电站数据放入集合
                pvstationDayDoList.add(pvstationDayDo);
            }
        }
        return pvstationDayDoList;
    }


    /***
     * Description: 按电表计算电站数据
     * @author: ghl
     * @param pvStatGenwattmeterDayDoList:
     * @param pvstationDayDoList:
     * @param dates:
     * @return: java.util.List<com.iesms.openservices.pvstat.entity.PvStatPvstationDayDo>
     * @date: 2020/4/4 12:57
     */
    private List<PvStatPvstationDayDo> geGenwattmeterValue(List<PvStatGenwattmeterDayDo> pvStatGenwattmeterDayDoList, List<PvStatPvstationDayDo> pvstationDayDoList, Date[] dates) {

        List<PvStatGenwattmeterDayDo> gList = pvStatGenwattmeterDayDoList;
        List<PvStatPvstationDayDo> pList = pvstationDayDoList;

        // 过滤同时有逆变器和电表的数据
        // TODO 后期改造
//        if (pList != null && pList.size() > 0) {
//            pvstationDayDoList = gList.stream()
//                    .map(g -> pList.stream().filter(p -> (p.getCeCustId().compareTo(g.getCeCustId()) != 0 && (g.getEgenValueDay() == null || g.getEgenValueDay().compareTo(new BigDecimal("0")) <= 0))))
//                    .findAny()
//                    .orElse(null)
//                    .collect(Collectors.toList());
//
//            List<PvStatGenwattmeterDayDo> collect = pList.stream()
//                    .map(p -> gList.stream().filter(g -> g.getCeCustId().compareTo(p.getCeCustId()) == 0)).findAny().orElse(null).collect(Collectors.toList());
//        }
        for (PvStatGenwattmeterDayDo genwattmeterDayDo : pvStatGenwattmeterDayDoList) {

            // 查询电站装机容量
            Map<String, Long> propsMap = new HashMap<>();
            Long ceCustId = genwattmeterDayDo.getCeCustId();
            BigDecimal installCapacity = null;
            if (ceCustId != null) {
                propsMap.put("custId", ceCustId);
                // 电站装机容量修改为从resource资源表获取
                CeSourceDo ceSourceDo = pvStatPvstationDao.getCustPropsByCustId(propsMap);

                if (ceSourceDo != null) {
                    installCapacity = ceSourceDo.getElecCapacity();
                }
            }

            PvStatPvstationDayDo pvstationDayDo1 = new PvStatPvstationDayDo();

            // 通过beanutils属性拷贝将电表数据拷贝到电站实体类
            try {
                BeanUtils.copyProperties(pvstationDayDo1, genwattmeterDayDo);
            } catch (IllegalAccessException | InvocationTargetException e) {
                logger.error("genwattmeterDayDo proper copy error" + e.getMessage());
            }
            pvstationDayDo1.setId(idGenerator.nextId());
            pvstationDayDo1.setDateStat(dates[0] == null ? dates[1] : dates[0]);
            pvstationDayDo1.setStatSource(1);
            pvstationDayDo1.setGmtCreate(System.currentTimeMillis());
            pvstationDayDo1.setGmtModified(System.currentTimeMillis());
            pvstationDayDo1.setVersion(1);
            pvstationDayDo1.setPvCapacity(installCapacity);

            // 计算日等效时数
            if (genwattmeterDayDo.getEgenValueDay() != null && installCapacity != null && installCapacity.compareTo(BigDecimal.valueOf(0)) > 0) {
                BigDecimal eqHoursDay = genwattmeterDayDo.getEgenValueDay().divide(installCapacity, 8, BigDecimal.ROUND_UP);
                pvstationDayDo1.setEqHoursDay(eqHoursDay);
            }

            // 计算累计等效时数
            if (genwattmeterDayDo.getEgenValueAccum() != null && installCapacity != null && installCapacity.compareTo(BigDecimal.valueOf(0)) > 0) {
                BigDecimal eqHoursAccum = genwattmeterDayDo.getEgenValueAccum().divide(installCapacity, 8, BigDecimal.ROUND_UP);
                pvstationDayDo1.setEqHoursAccum(eqHoursAccum);
            }

            if (pvstationDayDoList != null && pvstationDayDoList.size() > 0) {
                for (PvStatPvstationDayDo pvstationDayDo : pvstationDayDoList) {

                    if (genwattmeterDayDo.getCeCustId().compareTo(pvstationDayDo.getCeCustId()) == 0) {
                        if (pvstationDayDo1.getEgenValueDay() != null && pvstationDayDo1.getEgenValueDay().compareTo(new BigDecimal("0")) > 0) {
                            pvstationDayDoList.remove(pvstationDayDo);
                            break;
                        }
                    }
                }
            }

            // 将电站数据放入集合
            if (pvstationDayDo1.getEgenValueDay() != null && pvstationDayDo1.getEgenValueDay().compareTo(new BigDecimal("0")) > 0) {
                pvstationDayDoList.add(pvstationDayDo1);
            }


        }

        return pvstationDayDoList;
    }

    /**
     * 电站发电量月统计
     *
     * @param
     * @return
     */
    @Override
    public int insertOrUpdatePvStatPvstationMonthDo(Map<String, String> params) {

        params.put("flag", "1");
        List<PvStatPvstationDayDo> statPvstationDayDoList = pvStatPvstationDao.getPvstationFromStationDay(params);
        List<PvStatPvstationMonthDo> statPvstationMonthDoList = new ArrayList<>();
        if (statPvstationDayDoList.size() > 0) {
            // 数据按客户分组
            statPvstationDayDoList.stream().collect(Collectors.groupingBy(PvStatPvstationDayDo::getCeCustId)).forEach((key, dayDoList) -> {
                int size = dayDoList.size();
                if (size > 0) {
                    PvStatPvstationMonthDo stationMonthDo = new PvStatPvstationMonthDo();

                    BigDecimal egenValueMonth = dayDoList.stream().filter(s -> s.getEgenValueDay() != null).map(PvStatPvstationDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal pvProfitTotalMonth = dayDoList.stream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatPvstationDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);

                    //发电补贴 money_subsidy_total_month 明细：money_subsidy_detail_month
                    BigDecimal moneySubsidyTotalMonth = dayDoList.stream().filter(s -> s.getMoneySubsidyTotalDay() != null).map(p -> p.getMoneySubsidyTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> moneySubsidyDetailMonthList = dayDoList.stream().filter(s -> s.getMoneySubsidyDetailDay() != null).map(p -> p.getMoneySubsidyDetailDay()).collect(Collectors.toList());

                    BigDecimal moneySubsidyTotalAccum = dayDoList.stream().filter(s -> s.getMoneySubsidyTotalAccum() != null).map(p -> p.getMoneySubsidyTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> moneySubsidyDetailMonthAccumList = dayDoList.stream().filter(s -> s.getMoneySubsidyDetailAccum() != null).map(p -> p.getMoneySubsidyDetailAccum()).collect(Collectors.toList());

                    String moneySubsidyDetailMonth = null;
                    String moneySubsidyDetailMonthAccum = null;
                    if (moneySubsidyDetailMonthList.size() > 0) {
                        moneySubsidyDetailMonth = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailMonthList);
                    }
                    if (moneySubsidyDetailMonthAccumList.size() > 0) {
                        moneySubsidyDetailMonthAccum = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailMonthAccumList);
                    }

                    // 上网收益补贴 money_online_grid_total_day 明细 money_online_grid_detail_day OnlineGrid
                    BigDecimal moneyOnlineGridTotalMonth = dayDoList.stream().filter(s -> s.getMoneyOnlineGridTotalDay() != null).map(p -> p.getMoneyOnlineGridTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> moneyOnlineGridDetailMonthList = dayDoList.stream().filter(s -> s.getMoneyOnlineGridDetailDay() != null).map(p -> p.getMoneyOnlineGridDetailDay()).collect(Collectors.toList());

                    String moneyOnlineGridDetailMonth = null;
                    if (moneyOnlineGridDetailMonthList.size() > 0) {
                        moneyOnlineGridDetailMonth = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailMonthList);
                    }

                    // 自发自用 money_self_use_total_day SelfUse
                    BigDecimal moneySelfUseTotalMonth = dayDoList.stream().filter(s -> s.getMoneySelfUseTotalDay() != null).map(p -> p.getMoneySelfUseTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> moneySelfUseDetailMonthList = dayDoList.stream().filter(s -> s.getMoneySelfUseDetailDay() != null).map(p -> p.getMoneySelfUseDetailDay()).collect(Collectors.toList());

                    String moneySelfUseDetailMonth = null;
                    if (moneySelfUseDetailMonthList.size() > 0) {
                        moneySelfUseDetailMonth = PvstatUtil.getpvProfitDetail2(moneySelfUseDetailMonthList);
                    }
                    stationMonthDo.setStartEgenValueMonth(dayDoList.get(0).getStartEgenValueDay());
                    if (size == 1) {
                        stationMonthDo.setEndEgenValueMonth(dayDoList.get(0).getEndEgenValueDay());
                    } else {
                        stationMonthDo.setEndEgenValueMonth(dayDoList.get(size - 1).getEndEgenValueDay());
                    }
                    BigDecimal pvCapacity = dayDoList.get(dayDoList.size() - 1).getPvCapacity();
                    // 等效时数                dayDoList.parallelStream().filter(s -> s.getEqHoursDay() != null).map(s -> s.getEqHoursDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal eqHoursMonth = dayDoList.parallelStream().filter(s -> s.getEqHoursDay() != null).map(s -> s.getEqHoursDay()).reduce(BigDecimal.ZERO, BigDecimal::add);


                    // 节能减排计算
                    BigDecimal sscqValueMonth = dayDoList.stream().filter(s -> s.getSscqValueDay() != null).map(p -> p.getSscqValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal scdeValueMonth = dayDoList.stream().filter(s -> s.getScdeValueDay() != null).map(p -> p.getScdeValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal ssdeValueMonth = dayDoList.stream().filter(s -> s.getSsdeValueDay() != null).map(p -> p.getSsdeValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sdaValueMonth = dayDoList.stream().filter(s -> s.getSdaValueDay() != null).map(p -> p.getSdaValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);

                    stationMonthDo.setId(idGenerator.nextId());

                    // 根据客户id查询系统单位id
                    Long ceCustId = dayDoList.get(0).getCeCustId();

                    String orgNoByCustId = pvStatPvstationDao.getOrgNoByCustId(String.valueOf(ceCustId));

                    stationMonthDo.setOrgNo(orgNoByCustId);
                    stationMonthDo.setCeCustId(ceCustId);
                    stationMonthDo.setMonthStat(Integer.parseInt(DateConvertUtils.convertToString(new Date(), "yyyyMM")));
                    stationMonthDo.setEgenValueMonth(egenValueMonth);

                    // 收益总额
                    stationMonthDo.setPvProfitTotalMonth(pvProfitTotalMonth);
                    // 收益详情
                    stationMonthDo.setMoneySubsidyTotalMonth(moneySubsidyTotalMonth);
                    stationMonthDo.setMoneySubsidyDetailMonth(moneySubsidyDetailMonth);
                    stationMonthDo.setMoneyOnlineGridTotalMonth(moneyOnlineGridTotalMonth);
                    stationMonthDo.setMoneyOnlineGridDetailMonth(moneyOnlineGridDetailMonth);
                    stationMonthDo.setMoneySelfUseTotalMonth(moneySelfUseTotalMonth);
                    stationMonthDo.setMoneySelfUseDetailMonth(moneySelfUseDetailMonth);
                    // 装机容量
                    stationMonthDo.setPvCapacity(pvCapacity);
                    stationMonthDo.setEqHoursMonth(eqHoursMonth);
                    stationMonthDo.setSscqValueMonth(sscqValueMonth);
                    stationMonthDo.setScdeValueMonth(scdeValueMonth);
                    stationMonthDo.setSsdeValueMonth(ssdeValueMonth);
                    stationMonthDo.setSdaValueMonth(sdaValueMonth);
                    stationMonthDo.setStatSource(dayDoList.get(0).getStatSource());
                    stationMonthDo.setGmtCreate(System.currentTimeMillis());
                    stationMonthDo.setGmtModified(System.currentTimeMillis());
                    stationMonthDo.setVersion(1);

                    statPvstationMonthDoList.add(stationMonthDo);
                }
            });
        }
        if (statPvstationMonthDoList.size() > 0) {
            return pvStatPvstationDao.insertOrUpdatePvStatPvstationMonthDo(statPvstationMonthDoList);
        }
        return -1;
    }

    /**
     * 电站发电量年统计
     *
     * @param
     * @return
     */
    @Override
    public int insertOrUpdatePvStatPvstationYearDo(Map<String, String> params) {


        params.put("flag", "2");
        List<PvStatPvstationDayDo> statPvstationDayDoList = pvStatPvstationDao.getPvstationFromStationDay(params);
        List<PvStatPvstationYearDo> statPvstationYearDoList = new ArrayList<>();
        if (statPvstationDayDoList.size() > 0) {
            // 数据按客户分组
            statPvstationDayDoList.stream().collect(Collectors.groupingBy(PvStatPvstationDayDo::getCeCustId))
                    .forEach((key, dayDoList) -> {
                        int size = dayDoList.size();
                        if (size > 0) {
                            PvStatPvstationYearDo stationYearDo = new PvStatPvstationYearDo();


                            BigDecimal egenValueYear = dayDoList.stream().filter(s -> s.getEgenValueDay() != null).map(PvStatPvstationDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal pvProfitTotalYear = dayDoList.stream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatPvstationDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);

                            //发电补贴 money_subsidy_total_Year 明细：money_subsidy_detail_Year
                            BigDecimal moneySubsidyTotalYear = dayDoList.stream().filter(s -> s.getMoneySubsidyTotalDay() != null).map(p -> p.getMoneySubsidyTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                            List<String> moneySubsidyDetailYearList = dayDoList.stream().filter(s -> s.getMoneySubsidyDetailDay() != null).map(p -> p.getMoneySubsidyDetailDay()).collect(Collectors.toList());

                            BigDecimal moneySubsidyTotalAccum = dayDoList.stream().filter(s -> s.getMoneySubsidyTotalAccum() != null).map(p -> p.getMoneySubsidyTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                            List<String> moneySubsidyDetailYearAccumList = dayDoList.stream().filter(s -> s.getMoneySubsidyDetailAccum() != null).map(p -> p.getMoneySubsidyDetailAccum()).collect(Collectors.toList());

                            String moneySubsidyDetailYear = null;
                            String moneySubsidyDetailYearAccum = null;
                            if (moneySubsidyDetailYearList.size() > 0) {
                                moneySubsidyDetailYear = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailYearList);
                            }
                            if (moneySubsidyDetailYearAccumList.size() > 0) {
                                moneySubsidyDetailYearAccum = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailYearAccumList);
                            }

                            // 上网收益补贴 money_online_grid_total_day 明细 money_online_grid_detail_day OnlineGrid
                            BigDecimal moneyOnlineGridTotalYear = dayDoList.stream().filter(s -> s.getMoneyOnlineGridTotalDay() != null).map(p -> p.getMoneyOnlineGridTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                            List<String> moneyOnlineGridDetailYearList = dayDoList.stream().filter(s -> s.getMoneyOnlineGridDetailDay() != null).map(p -> p.getMoneyOnlineGridDetailDay()).collect(Collectors.toList());

                            String moneyOnlineGridDetailYear = null;
                            if (moneyOnlineGridDetailYearList.size() > 0) {
                                moneyOnlineGridDetailYear = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailYearList);
                            }

                            // 自发自用 money_self_use_total_day SelfUse
                            BigDecimal moneySelfUseTotalYear = dayDoList.stream().filter(s -> s.getMoneySelfUseTotalDay() != null).map(p -> p.getMoneySelfUseTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                            List<String> moneySelfUseDetailYearList = dayDoList.stream().filter(s -> s.getMoneySelfUseDetailDay() != null).map(p -> p.getMoneySelfUseDetailDay()).collect(Collectors.toList());

                            String moneySelfUseDetailYear = null;
                            if (moneySelfUseDetailYearList.size() > 0) {
                                moneySelfUseDetailYear = PvstatUtil.getpvProfitDetail2(moneySelfUseDetailYearList);
                            }
                            stationYearDo.setStartEgenValueYear(dayDoList.get(0).getStartEgenValueDay());
                            if (size == 1) {
                                stationYearDo.setEndEgenValueYear(dayDoList.get(0).getEndEgenValueDay());
                            } else {
                                stationYearDo.setEndEgenValueYear(dayDoList.get(size - 1).getEndEgenValueDay());
                            }
                            BigDecimal pvCapacity = dayDoList.get(dayDoList.size() - 1).getPvCapacity();
                            // 等效时数
                            BigDecimal eqHoursYear = dayDoList.parallelStream().filter(s -> s.getEqHoursDay() != null).map(s -> s.getEqHoursDay()).reduce(BigDecimal.ZERO, BigDecimal::add);


                            // 节能减排计算
                            BigDecimal sscqValueYear = dayDoList.stream().filter(s -> s.getSscqValueDay() != null).map(p -> p.getSscqValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal scdeValueYear = dayDoList.stream().filter(s -> s.getScdeValueDay() != null).map(p -> p.getScdeValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal ssdeValueYear = dayDoList.stream().filter(s -> s.getSsdeValueDay() != null).map(p -> p.getSsdeValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal sdaValueYear = dayDoList.stream().filter(s -> s.getSdaValueDay() != null).map(p -> p.getSdaValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);

                            stationYearDo.setId(idGenerator.nextId());

                            // 根据客户id查询系统单位id
                            Long ceCustId = dayDoList.get(0).getCeCustId();

                            String orgNoByCustId = pvStatPvstationDao.getOrgNoByCustId(String.valueOf(ceCustId));

                            stationYearDo.setOrgNo(orgNoByCustId);

                            stationYearDo.setCeCustId(ceCustId);
                            stationYearDo.setYearStat(Integer.parseInt(DateConvertUtils.convertToString(new Date(), "yyyy")));
                            stationYearDo.setEgenValueYear(egenValueYear);

                            // 收益总额
                            stationYearDo.setPvProfitTotalYear(pvProfitTotalYear);
                            // 收益详情
                            stationYearDo.setMoneySubsidyTotalYear(moneySubsidyTotalYear);
                            stationYearDo.setMoneySubsidyDetailYear(moneySubsidyDetailYear);
                            stationYearDo.setMoneyOnlineGridTotalYear(moneyOnlineGridTotalYear);
                            stationYearDo.setMoneyOnlineGridDetailYear(moneyOnlineGridDetailYear);
                            stationYearDo.setMoneySelfUseTotalYear(moneySelfUseTotalYear);
                            stationYearDo.setMoneySelfUseDetailYear(moneySelfUseDetailYear);
                            // 装机容量
                            stationYearDo.setPvCapacity(pvCapacity);
                            stationYearDo.setEqHoursYear(eqHoursYear);
                            stationYearDo.setSscqValueYear(sscqValueYear);
                            stationYearDo.setScdeValueYear(scdeValueYear);
                            stationYearDo.setSsdeValueYear(ssdeValueYear);
                            stationYearDo.setSdaValueYear(sdaValueYear);
                            stationYearDo.setStatSource(dayDoList.get(0).getStatSource());
                            stationYearDo.setGmtCreate(System.currentTimeMillis());
                            stationYearDo.setGmtModified(System.currentTimeMillis());
                            stationYearDo.setVersion(1);

                            statPvstationYearDoList.add(stationYearDo);
                        }
                    });
        }
        if (statPvstationYearDoList.size() > 0) {
            pvStatPvstationDao.insertOrUpdatePvStatPvstationYearDo(statPvstationYearDoList);

            Map<String, String> yMap = new HashMap<>();
            yMap.put("dateStat", params.get("dateStat"));

            for (PvStatPvstationYearDo pvstationYearDo : statPvstationYearDoList) {
                yMap.put("ceCustId", String.valueOf(pvstationYearDo.getCeCustId()));
                pvStatPvstationDao.updatePvStatYearValue(yMap);
            }

        }
        return -1;
    }

    /**
     * 获取电站装机容量通用方法
     *
     * @param capacity
     * @return
     */
    private BigDecimal getCapacity(String capacity) {
        String inverterCapacity = String.valueOf(JsonConvertUtils.convertFromString(capacity, Map.class).get("installCapacity"));
        BigDecimal inverterCapacity2 = JsonConvertUtils.convertFromString(inverterCapacity, BigDecimal.class);
        return inverterCapacity2;
    }

    /**
     * 获取每年一月，格式：201901
     *
     * @return
     */
    public Map<String, String> getFirstMonthOfYear() {
        Map<String, String> retMap = new HashMap<>();
        Date date1 = new Date();
        String ret = DateConvertUtils.convertToString(date1, "yyyy-01-01");
        retMap.put("startDay", ret);
        return retMap;
    }
}
