package com.iesms.openservices.pvstat.util;

import com.easesource.commons.util.convert.JsonConvertUtils;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

/***
 * @Author ghl
 * @描述 光伏电站工具类
 * @Date 2019/10/11 17:26
 **/
public class PvstatUtil {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    /**
     * @return int 每月天数
     * @Author ghl
     * @描述 获取每个月有多少天
     * @Date 2019/10/27 17:17
     * @Param []
     **/
    public static int getCurrentMonthLastDay() {
        Calendar a = Calendar.getInstance();
        a.set(Calendar.DATE, 1);//把日期设置为当月第一天
        a.roll(Calendar.DATE, -1);//日期回滚一天，也就是最后一天
        int maxDate = a.get(Calendar.DATE);
        return maxDate;
    }

    /**
     * @return Map<String, Object>
     * @Author ghl
     * @描述 bean转map
     * @Date 2019/10/16 14:09
     * @Param [obj]
     **/
    public static Map<String, Object> beanToMap(Object obj) {
        Map<String, Object> params = new HashMap<String, Object>(0);
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(obj);
            for (int i = 0; i < descriptors.length; i++) {
                String name = descriptors[i].getName();
                if (!"class".equals(name)) {
                    params.put(name, propertyUtilsBean.getNestedProperty(obj, name));
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    /***
     * @Author ghl
     * @描述 计算累计收益
     * @Date 2019/10/11 17:28
     * @Param [keys, detailMap, detailList]
     *          keys: map的key集合
     *          detailMap: 需要value相加的map集合
     *          detailList:  收益明细集合
     * @return java.util.Map<java.lang.String, java.math.BigDecimal>
     **/
    public static Map<String, BigDecimal> getpvProfitDetail(String[] keys, Map<String, BigDecimal> detailMap, List<String> detailList) {
        detailList.forEach(detail -> {
            if (null != detail) {
                Map detailMap1 = JsonConvertUtils.convertFromString(detail, Map.class);
                Arrays.asList(keys).forEach(key -> {
                    if (detailMap1.containsKey(key)) {
                        detailMap.put(key, detailMap.get(key).add((BigDecimal) detailMap1.get(key)));
                    }
                });
            }
        });
        return detailMap;
    }

    public static Map<String, Object> getpvProfitDetail1(String pvbParams, BigDecimal egenValueDay, BigDecimal endEgenValueDay) {

        Map<String, Object> retMap = new HashMap<>();

        String detailDay = null;
        String detailAccus = null;
        BigDecimal[] totalMoney = {null, null};

        if (null != pvbParams) {
            Map detailMap = JsonConvertUtils.convertFromString(pvbParams, Map.class);
            Map<String, BigDecimal> egenValueMap;
            Map<String, BigDecimal> endEgenValueMap;
            if (detailMap.size() > 0) {
                egenValueMap = new HashMap<>();
                endEgenValueMap = new HashMap<>();
                totalMoney[0] = new BigDecimal("0.00000000");
                totalMoney[1] = new BigDecimal("0.00000000");

                detailMap.forEach((k, v) -> {

                    if (v != null) {
                        String v1 = (String) v;

                        v1.replaceAll("\\\\", "");

                        if (v1.equals("") || v1.equals(" ")) {
                            return;
                        }

                        BigDecimal bigdecimal = getBigdecimal(v);
                        // 收益详情模板
                        if (egenValueDay != null && bigdecimal != null) {
                            egenValueMap.put((String) k, egenValueDay.multiply(bigdecimal));
                            totalMoney[0] = totalMoney[0].add(egenValueDay.multiply(bigdecimal));
                        }
                        if (endEgenValueDay != null && bigdecimal != null) {
                            endEgenValueMap.put((String) k, endEgenValueDay.multiply(bigdecimal));
                            totalMoney[1] = totalMoney[1].add(endEgenValueDay.multiply(bigdecimal));
                        }
                    }
                });
                detailDay = JsonConvertUtils.convertToString(egenValueMap);
                detailAccus = JsonConvertUtils.convertToString(endEgenValueMap);
            }
        }
        retMap.put("detailDay", detailDay);
        retMap.put("detailAccus", detailAccus);
        retMap.put("totalDay", totalMoney[0]);
        retMap.put("totalAccus", totalMoney[1]);
        return retMap;
    }

    /**
     * @return String 计算得出的累计收益明细
     * @Author ghl
     * @描述 月和年收益明细计算
     * @Date 2019/10/15 10:26
     * @Param [detailList] 日收入明细集合
     **/
    public static String getpvProfitDetail2(List<String> detailList) {
        Map<String, BigDecimal> profitDetailMap = new HashMap<>();
        detailList.forEach(detail -> {
            if (null != detail) {
                String detail1 = detail;
                detail1 = detail1.replaceAll("\\\\", "");
                Map detailMap = JsonConvertUtils.convertFromString(detail1, Map.class);
                detailMap.forEach((k, v) -> {

                    if (v.equals("")) {
                        return;
                    }

                    BigDecimal value = getBigdecimal(v);

                    if (value != null) {
                        value = value.setScale(8, BigDecimal.ROUND_HALF_UP);
                    }

                    if (profitDetailMap.containsKey((String) k) && value != null) {
                        // 如果包含相同的主键，则相加，否则插入
                        profitDetailMap.put((String) k, profitDetailMap.get(k).add(value));
                    } else {
                        profitDetailMap.put((String) k, value);
                    }
                });
            }
        });
        if (profitDetailMap.size() > 0) {
            return JsonConvertUtils.convertToString(profitDetailMap);
        }
        return null;
    }

    /***
     * @Author ghl
     * @描述 发电收益明细计算
     * @Date 2019/10/14 17:43
     * @Param [type, pvbParams, egenValueDay, Valueaccum]
     *          type：标杆电价类型，pvbParams：标杆电价参数，egenValueDay：日总发电量，Valueaccum：累计总发电量
     * @return Map<String, String>
     *         key：收益类型 value：收益总额
     **/
    public static Map<String, BigDecimal> getProfitDetail(int type, String pvbParams, BigDecimal egenValueDay, BigDecimal egenValueaccum) {
        // 日收益总额
        BigDecimal pvProfitTotalDay = null;
        // 累计收益总额
        BigDecimal pvProfitTotalAccum = null;
        if (null != pvbParams) {
            Map map = JsonConvertUtils.convertFromString(pvbParams, Map.class);
            if (type == 1) {
                // 标杆电价类型为1，日收益总额 = 日总发电量 * (国家补贴 + 省补贴 + 市补贴 + 区补贴)
                pvProfitTotalDay = new BigDecimal("0.00000000");
                pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal) map.get("price_subsidy_country")));
                pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal) map.get("price_subsidy_province")));
                pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal) map.get("price_subsidy_city")));
                pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal) map.get("price_subsidy_district")));

                pvProfitTotalAccum = new BigDecimal("0.00000000");
                pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal) map.get("price_subsidy_country")));
                pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal) map.get("price_subsidy_province")));
                pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal) map.get("price_subsidy_city")));
                pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal) map.get("price_subsidy_district")));

            } else if (type == 2) {
                /**
                 *发电量类型为2 上网电量标杆电价标杆电价类型为2上网电量标杆电价时：
                 * {"price_online_grid": 0.5}  price_online_grid：上网标杆电价；
                 * */
                pvProfitTotalDay = new BigDecimal("0.00000000");
                pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal) map.get("price_online_grid")));

                pvProfitTotalAccum = new BigDecimal("0.00000000");
                pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal) map.get("price_online_grid")));
            } else if (type == 3) {
                if (map.containsValue("single")) {
                    //自发自用收益
                    //{"price_self_use_rate_type": "single", "money_self_use_total": 1.0}
                    pvProfitTotalDay = new BigDecimal("0.00000000");
                    pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal) map.get("price_online_grid")));

                    pvProfitTotalAccum = new BigDecimal("0.00000000");
                    pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal) map.get("price_online_grid")));
                } else if (map.containsValue("multi")) {
                    //{"price_self_use_rate_type": "multi", "money_self_use_rate1": 1.0, "money_self_use_rate2": 2.0, "money_self_use_rate3": 3.0, "money_self_use_rate4": 4.0}
                    //自发自用电价复费率电费金额；
                    pvProfitTotalDay = new BigDecimal("0.00000000");
                    pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal) map.get("money_self_use_rate1")));
                    pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal) map.get("money_self_use_rate2")));
                    pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal) map.get("money_self_use_rate3")));
                    pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal) map.get("money_self_use_rate4")));

                    pvProfitTotalAccum = new BigDecimal("0.00000000");
                    pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal) map.get("money_self_use_rate1")));
                    pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal) map.get("money_self_use_rate2")));
                    pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal) map.get("money_self_use_rate3")));
                    pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal) map.get("money_self_use_rate4")));
                } else {

                }
            } else {

            }
        }
        // 返回Map
        Map<String, BigDecimal> resMap = new HashMap<>();
        resMap.put("pvProfitTotalDay", pvProfitTotalDay);
        resMap.put("pvProfitTotalAccum", pvProfitTotalAccum);
        return resMap;
    }

    public static BigDecimal getBigdecimal(Object obj) {
        BigDecimal retBig = null;
        if (obj != null) {
            if (obj instanceof BigDecimal) {
                retBig = (BigDecimal) obj;
            } else if (obj instanceof String) {
                retBig = new BigDecimal((String) obj);
            } else if (obj instanceof BigInteger) {
                retBig = new BigDecimal((BigInteger) obj);
            } else if (obj instanceof Number) {
                retBig = new BigDecimal(((Number) obj).doubleValue());
            } else {
                throw new ClassCastException("无法将 [" + obj + "] " + obj.getClass() + " 转换为BigDecimal.");
            }
        }
        return retBig;
    }

    /**
     * @return java.util.function.Predicate<T>
     * @Author ghl
     * @描述 根据属性去重方法
     * @Date 2019/10/31 14:57
     * @Param [keyExtractor]
     **/
    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        Map<Object, Boolean> seen = new ConcurrentHashMap<>();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    //获取当天的开始时间
    public static java.util.Date getDayBegin() {
        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 0);
        cal.set(Calendar.MINUTE, 0);
        cal.set(Calendar.SECOND, 0);
        cal.set(Calendar.MILLISECOND, 0);
        return cal.getTime();
    }

    //获取当天的结束时间
    public static java.util.Date getDayEnd() {
        Calendar cal = new GregorianCalendar();
        cal.set(Calendar.HOUR_OF_DAY, 23);
        cal.set(Calendar.MINUTE, 59);
        cal.set(Calendar.SECOND, 59);
        return cal.getTime();
    }

    //获取昨天的开始时间
    public static Date getBeginDayOfYesterday() {
        Calendar cal = new GregorianCalendar();
        cal.setTime(getDayBegin());
        cal.add(Calendar.DAY_OF_MONTH, -1);
        return cal.getTime();
    }

    //获取昨天的结束时间
    public static Date getEndDayOfYesterDay() {
        Calendar cal = new GregorianCalendar();
        cal.setTime(getDayEnd());
        cal.add(Calendar.DAY_OF_MONTH, -1);
        return cal.getTime();
    }

    //获取明天的开始时间
    public static Date getBeginDayOfTomorrow() {
        Calendar cal = new GregorianCalendar();
        cal.setTime(getDayBegin());
        cal.add(Calendar.DAY_OF_MONTH, 1);

        return cal.getTime();
    }

    //获取明天的结束时间
    public static Date getEndDayOfTomorrow() {
        Calendar cal = new GregorianCalendar();
        cal.setTime(getDayEnd());
        cal.add(Calendar.DAY_OF_MONTH, 1);
        return cal.getTime();
    }

    //获取本周的开始时间
    @SuppressWarnings("unused")
    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek);
        return getDayStartTime(cal.getTime());
    }

    //获取本周的结束时间
    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getBeginDayOfWeek());
        cal.add(Calendar.DAY_OF_WEEK, 6);
        Date weekEndSta = cal.getTime();
        return getDayEndTime(weekEndSta);
    }

    //获取上周的开始时间
    @SuppressWarnings("unused")
    public static Date getBeginDayOfLastWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(Calendar.DAY_OF_WEEK);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(Calendar.DATE, 2 - dayofweek - 7);
        return getDayStartTime(cal.getTime());
    }

    //获取上周的结束时间
    public static Date getEndDayOfLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(getBeginDayOfLastWeek());
        cal.add(Calendar.DAY_OF_WEEK, 6);
        Date weekEndSta = cal.getTime();
        return getDayEndTime(weekEndSta);
    }

    //获取本月的开始时间
    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(getNowYear(), getNowMonth() - 1, 1);
        return getDayStartTime(calendar.getTime());
    }

    //获取本月的结束时间
    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(getNowYear(), getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(getNowYear(), getNowMonth() - 1, day);
        return getDayEndTime(calendar.getTime());
    }

    //获取上月的开始时间
    public static Date getBeginDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(getNowYear(), getNowMonth() - 2, 1);
        return getDayStartTime(calendar.getTime());
    }

    //获取上月的结束时间
    public static Date getEndDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(getNowYear(), getNowMonth() - 2, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(getNowYear(), getNowMonth() - 2, day);
        return getDayEndTime(calendar.getTime());
    }

    //获取本年的开始时间
    public static java.util.Date getBeginDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, getNowYear());
        // cal.set
        cal.set(Calendar.MONTH, Calendar.JANUARY);
        cal.set(Calendar.DATE, 1);

        return getDayStartTime(cal.getTime());
    }

    //获取本年的结束时间
    public static java.util.Date getEndDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(Calendar.YEAR, getNowYear());
        cal.set(Calendar.MONTH, Calendar.DECEMBER);
        cal.set(Calendar.DATE, 31);
        return getDayEndTime(cal.getTime());
    }

    //获取某个日期的开始时间
    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        ;
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 0, 0, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    //获取某个日期的结束时间
    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(Calendar.YEAR), calendar.get(Calendar.MONTH), calendar.get(Calendar.DAY_OF_MONTH), 23, 59, 59);
        calendar.set(Calendar.MILLISECOND, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    //获取今年是哪一年
    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar) Calendar.getInstance();
        gc.setTime(date);
        return Integer.valueOf(gc.get(1));
    }

    //获取本月是哪一月
    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar) Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    //两个日期相减得到的天数
    public static int getDiffDays(Date beginDate, Date endDate) {

        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }

        long diff = (endDate.getTime() - beginDate.getTime())
                / (1000 * 60 * 60 * 24);

        int days = new Long(diff).intValue();

        return days;
    }

    //两个日期相减得到的毫秒数
    public static long dateDiff(Date beginDate, Date endDate) {
        long date1ms = beginDate.getTime();
        long date2ms = endDate.getTime();
        return date2ms - date1ms;
    }

    //获取两个日期中的最大日期
    public static Date max(Date beginDate, Date endDate) {
        if (beginDate == null) {
            return endDate;
        }
        if (endDate == null) {
            return beginDate;
        }
        if (beginDate.after(endDate)) {
            return beginDate;
        }
        return endDate;
    }

    //获取两个日期中的最小日期
    public static Date min(Date beginDate, Date endDate) {
        if (beginDate == null) {
            return endDate;
        }
        if (endDate == null) {
            return beginDate;
        }
        if (beginDate.after(endDate)) {
            return endDate;
        }
        return beginDate;
    }

    //返回某月该季度的第一个月
    public static Date getFirstSeasonDate(Date date) {
        final int[] SEASON = {1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = SEASON[cal.get(Calendar.MONTH)];
        cal.set(Calendar.MONTH, sean * 3 - 3);
        return cal.getTime();
    }

    //返回某个日期下几天的日期
    public static Date getNextDay(Date date, int i) {
        Calendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(Calendar.DATE, cal.get(Calendar.DATE) + i);
        return cal.getTime();
    }

    //返回某个日期前几天的日期
    public static Date getFrontDay(Date date, int i) {
        Calendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(Calendar.DATE, cal.get(Calendar.DATE) - i);
        return cal.getTime();
    }

    public static Map<String, Object> getMaxAndMinValue(Map<String, Object> stringObjectMap) {
        if (stringObjectMap != null) {
            // 计算电站功率最大值最小值
            // 最大值 最小值
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
            SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyyMMdd");
            String format = dateFormat1.format(new Date());
            BigDecimal[] maxAndMin = {null, null};
            int[] index = {0, 0};
            for (int i = 1; i <= 96; i++) {
                String name = String.format("eloadValue%02d", i);
                if (stringObjectMap.containsKey(name)) {
                    BigDecimal bigdecimal = PvstatUtil.getBigdecimal(stringObjectMap.get(name));
                    // 获取最大值
                    if (maxAndMin[0] == null) {
                        maxAndMin[0] = bigdecimal;
                        index[0] = i;
                    } else if (maxAndMin[0] != null && bigdecimal != null) {
                        if (bigdecimal.compareTo(maxAndMin[0]) > 0) {
                            maxAndMin[0] = bigdecimal;
                            index[0] = i;
                        }
                    }
                    // 获取最小值
                    if (maxAndMin[1] == null) {
                        maxAndMin[1] = bigdecimal;
                        index[1] = i;
                    } else if (maxAndMin[1] != null && bigdecimal != null) {
                        if (bigdecimal.compareTo(maxAndMin[1]) < 0) {
                            maxAndMin[1] = bigdecimal;
                            index[1] = i;
                        }
                    }
                }
            }
            // 最大值时间计算
            if (index[0] > 0) {
                // 计算最大值最小值时间
                int maxhh = (index[0] - 1) / 4;
                int maxmm = ((index[0] - 1) % 4) * 15;

                if (maxhh < 10) {
                    try {
                        Date maxValueTime = dateFormat.parse(format + String.format("%02d", maxhh) + "" + maxmm);
                        stringObjectMap.put("maxValueTime", maxValueTime);
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        Date maxValueTime = dateFormat.parse(format + maxhh + "" + maxmm);
                        stringObjectMap.put("maxValueTime", maxValueTime);
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }


            }
            // 最小值时间计算
            if (index[1] > 0) {
                // 计算最大值最小值时间
                int minhh = (index[1] - 1) / 4;
                int minmm = ((index[1] - 1) % 4) * 15;
                if (minhh < 10) {
                    try {
                        Date minValueTime = dateFormat.parse(format + String.format("%02d", minhh) + "" + minmm);
                        stringObjectMap.put("minValueTime", minValueTime);
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        Date minValueTime = dateFormat.parse(format + minhh + "" + minmm);
                        stringObjectMap.put("minValueTime", minValueTime);
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                }

            }
            stringObjectMap.put("maxValue",maxAndMin[0]);
            stringObjectMap.put("minValue",maxAndMin[1]);
        }

        return stringObjectMap;
    }

}
