/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.pvstat.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.pvstat.dao.PvStatGenwattmeterEloadDao;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterEloadDayDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterEloadMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterEloadYearDo;
import com.iesms.openservices.pvstat.service.PvStatGenwattmeterEloadService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PvStatGenwattmeterEloadServiceImpl
extends AbstractIesmsBaseService
implements PvStatGenwattmeterEloadService {
    private PvStatGenwattmeterEloadDao pvStatGenwattmeterEloadDao;

    @Autowired
    public PvStatGenwattmeterEloadServiceImpl(PvStatGenwattmeterEloadDao pvStatGenwattmeterEloadDao) {
        this.pvStatGenwattmeterEloadDao = pvStatGenwattmeterEloadDao;
    }

    public int insertOrUpdatePvStatGenwattmeterEloadDay(List<PvStatGenwattmeterEloadDayDo> list) {
        ArrayList<PvStatGenwattmeterEloadDayDo> genwattmeterEloadDayDoList = new ArrayList<PvStatGenwattmeterEloadDayDo>();
        if (list.size() > 0) {
            list.forEach(gen -> {
                gen.setId(Long.valueOf(this.idGenerator.nextId()));
                gen.setDateStat(new Date());
                gen.setGmtCreate(System.currentTimeMillis());
                gen.setGmtModified(System.currentTimeMillis());
                gen.setVersion(1);
                genwattmeterEloadDayDoList.add((PvStatGenwattmeterEloadDayDo)gen);
            });
        }
        if (genwattmeterEloadDayDoList.size() > 0) {
            return this.pvStatGenwattmeterEloadDao.insertOrUpdatePvStatGenwattmeterEloadDay(genwattmeterEloadDayDoList);
        }
        return -1;
    }

    public int insertOrUpdatePvStatGenwattmeterEloadMonth() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "1");
        List<PvStatGenwattmeterEloadDayDo> genwattmeterEloadMonth = this.pvStatGenwattmeterEloadDao.getPvStatGenwattmeterEloadMonthOrYear(map);
        if (genwattmeterEloadMonth.size() > 0) {
            ArrayList<PvStatGenwattmeterEloadMonthDo> genwattmeterEloadMonthDoList = new ArrayList<PvStatGenwattmeterEloadMonthDo>();
            int month = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
            genwattmeterEloadMonth.parallelStream().filter(inv -> inv != null).collect(Collectors.groupingBy(inv2 -> inv2.getCeDeviceId())).forEach((key, genwattmeterList) -> {
                PvStatGenwattmeterEloadMonthDo genwattmeterEloadMonthDo = new PvStatGenwattmeterEloadMonthDo();
                genwattmeterEloadMonthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                genwattmeterEloadMonthDo.setOrgNo(((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(0)).getOrgNo());
                genwattmeterEloadMonthDo.setCeCustId(((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(0)).getCeCustId());
                genwattmeterEloadMonthDo.setCeDeviceId(((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(0)).getCeDeviceId());
                genwattmeterEloadMonthDo.setCePointId(((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(0)).getCePointId());
                genwattmeterEloadMonthDo.setMonthStat(month);
                int[] maxAndMinIndex = new int[]{0, 0};
                String[] dataTime = new String[]{null, null};
                BigDecimal totalMonthValue = genwattmeterList.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatGenwattmeterEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalMonthValue != null) {
                    BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(genwattmeterList.size()), 8, 0);
                    genwattmeterEloadMonthDo.setAvgValue(avgValueMonth);
                }
                BigDecimal[] maxAndMin = new BigDecimal[]{null, null};
                Date[] times = new Date[]{null, null};
                for (int i = 0; i < genwattmeterList.size(); ++i) {
                    maxAndMin[0] = new BigDecimal("0.00000000");
                    maxAndMin[1] = new BigDecimal("0.00000000");
                    if (((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMaxValue() != null && ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMaxValue().compareTo(maxAndMin[0]) == 1) {
                        maxAndMin[0] = ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMaxValue();
                        times[0] = ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMaxValueTime();
                    }
                    if (((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMinValue() == null || ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMinValue().compareTo(maxAndMin[1]) != -1) continue;
                    maxAndMin[1] = ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMinValue();
                    times[1] = ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMinValueTime();
                }
                genwattmeterEloadMonthDo.setMaxValue(maxAndMin[0]);
                genwattmeterEloadMonthDo.setMaxValueTime(times[0]);
                genwattmeterEloadMonthDo.setMinValue(maxAndMin[1]);
                genwattmeterEloadMonthDo.setMinValueTime(times[1]);
                genwattmeterEloadMonthDo.setMeterType(((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(0)).getMeterType());
                genwattmeterEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                genwattmeterEloadMonthDo.setGmtModified(System.currentTimeMillis());
                genwattmeterEloadMonthDo.setVersion(1);
                genwattmeterEloadMonthDoList.add(genwattmeterEloadMonthDo);
            });
            if (genwattmeterEloadMonthDoList.size() > 0) {
                this.pvStatGenwattmeterEloadDao.insertOrUpdatePvStatGenwattmeterEloadMonth(genwattmeterEloadMonthDoList);
            }
        }
        return 0;
    }

    public int insertOrUpdatePvStatGenwattmeterEloadYear() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "2");
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        List<PvStatGenwattmeterEloadDayDo> genwattmeterEloadYear = this.pvStatGenwattmeterEloadDao.getPvStatGenwattmeterEloadMonthOrYear(map);
        if (genwattmeterEloadYear.size() > 0) {
            ArrayList<PvStatGenwattmeterEloadYearDo> genwattmeterEloadYearDoList = new ArrayList<PvStatGenwattmeterEloadYearDo>();
            int mear = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
            genwattmeterEloadYear.parallelStream().filter(inv -> inv != null).collect(Collectors.groupingBy(inv2 -> inv2.getCeDeviceId())).forEach((key, genwattmeterList) -> {
                PvStatGenwattmeterEloadYearDo genwattmeterEloadYearDo = new PvStatGenwattmeterEloadYearDo();
                genwattmeterEloadYearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                genwattmeterEloadYearDo.setOrgNo(((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(0)).getOrgNo());
                genwattmeterEloadYearDo.setCeCustId(((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(0)).getCeCustId());
                genwattmeterEloadYearDo.setCeDeviceId(((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(0)).getCeDeviceId());
                genwattmeterEloadYearDo.setCePointId(((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(0)).getCePointId());
                genwattmeterEloadYearDo.setYearStat(year);
                int[] maxAndMinIndex = new int[]{0, 0};
                String[] dataTime = new String[]{null, null};
                BigDecimal totalYearValue = genwattmeterList.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatGenwattmeterEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalYearValue != null) {
                    BigDecimal avgValueYear = totalYearValue.divide(BigDecimal.valueOf(genwattmeterList.size()), 8, 0);
                    genwattmeterEloadYearDo.setAvgValue(avgValueYear);
                }
                BigDecimal[] maxAndMin = new BigDecimal[]{null, null};
                Date[] times = new Date[]{null, null};
                for (int i = 0; i < genwattmeterList.size(); ++i) {
                    maxAndMin[0] = new BigDecimal("0.00000000");
                    maxAndMin[1] = new BigDecimal("0.00000000");
                    if (((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMaxValue() != null && ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMaxValue().compareTo(maxAndMin[0]) == 1) {
                        maxAndMin[0] = ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMaxValue();
                        times[0] = ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMaxValueTime();
                    }
                    if (((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMinValue() == null || ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMinValue().compareTo(maxAndMin[1]) != -1) continue;
                    maxAndMin[1] = ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMinValue();
                    times[1] = ((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(i)).getMinValueTime();
                }
                genwattmeterEloadYearDo.setMaxValue(maxAndMin[0]);
                genwattmeterEloadYearDo.setMaxValueTime(times[0]);
                genwattmeterEloadYearDo.setMinValue(maxAndMin[1]);
                genwattmeterEloadYearDo.setMinValueTime(times[1]);
                genwattmeterEloadYearDo.setMeterType(((PvStatGenwattmeterEloadDayDo)genwattmeterList.get(0)).getMeterType());
                genwattmeterEloadYearDo.setGmtCreate(System.currentTimeMillis());
                genwattmeterEloadYearDo.setGmtModified(System.currentTimeMillis());
                genwattmeterEloadYearDo.setVersion(1);
                genwattmeterEloadYearDoList.add(genwattmeterEloadYearDo);
            });
            if (genwattmeterEloadYearDoList.size() > 0) {
                this.pvStatGenwattmeterEloadDao.insertOrUpdatePvStatGenwattmeterEloadYear(genwattmeterEloadYearDoList);
            }
        }
        return 0;
    }
}

