/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cebase.util.CommonUtils;
import com.iesms.openservices.pvstat.dao.PvStatGenwattmeterDao;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterDayDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterYearDo;
import com.iesms.openservices.pvstat.service.PvStatGenwattmeterService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PvStatGenwattmeterServiceImpl
extends AbstractIesmsBaseService
implements PvStatGenwattmeterService {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PvStatGenwattmeterDao pvStatGenwattmeterDao;

    @Autowired
    public PvStatGenwattmeterServiceImpl(PvStatGenwattmeterDao pvStatGenwattmeterDao) {
        this.pvStatGenwattmeterDao = pvStatGenwattmeterDao;
    }

    public int updateGenwattmeterValueAccum(Map<String, String> map) {
        return this.pvStatGenwattmeterDao.updateGenwattmeterValueAccum(map);
    }

    public int initPvStatGenwattmeterDayDo(List<PvStatGenwattmeterDayDo> list) {
        ArrayList<PvStatGenwattmeterDayDo> pvStatGenwattmeterDayDoList = new ArrayList<PvStatGenwattmeterDayDo>();
        if (list == null) {
            return -1;
        }
        list.removeIf(Objects::isNull);
        if (list.size() < 1) {
            return -1;
        }
        for (PvStatGenwattmeterDayDo initPvStatGenwattmeterDayDo : list) {
            initPvStatGenwattmeterDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
            initPvStatGenwattmeterDayDo.setGmtCreate(System.currentTimeMillis());
            initPvStatGenwattmeterDayDo.setGmtModified(System.currentTimeMillis());
            initPvStatGenwattmeterDayDo.setVersion(1);
            pvStatGenwattmeterDayDoList.add(initPvStatGenwattmeterDayDo);
        }
        return this.pvStatGenwattmeterDao.initPvStatGenwattmeterDayDo(pvStatGenwattmeterDayDoList);
    }

    public int insertOrUpdatePvStatGenwattmeterDayDo(List<PvStatGenwattmeterDayDo> list) {
        ArrayList<PvStatGenwattmeterDayDo> genwattmeterDayDoList = new ArrayList<PvStatGenwattmeterDayDo>();
        if (list.size() > 0) {
            for (PvStatGenwattmeterDayDo gen : list) {
                try {
                    gen.setId(Long.valueOf(this.idGenerator.nextId()));
                    gen.setVersion(1);
                    gen.setGmtCreate(System.currentTimeMillis());
                    gen.setGmtModified(System.currentTimeMillis());
                    genwattmeterDayDoList.add(gen);
                }
                catch (Exception e) {
                    this.logger.error("insertOrUpdatePvStatGenwattmeterDayDo error:" + e.getMessage(), e.fillInStackTrace());
                    this.logger.error(gen.toString());
                }
            }
        }
        return this.pvStatGenwattmeterDao.insertOrUpdatePvStatGenwattmeterDayDo(genwattmeterDayDoList);
    }

    public int insertOrUpdatePvStatGenwattmeterMonthDo() {
        Map params = CommonUtils.getFirstDayAndLastDayOfMonth();
        ArrayList<PvStatGenwattmeterMonthDo> monthDoList = new ArrayList<PvStatGenwattmeterMonthDo>();
        List<PvStatGenwattmeterDayDo> pvGenwattmeterMonthDoList = this.pvStatGenwattmeterDao.getMonthPvStatGenwattmeterMonth(params);
        if (pvGenwattmeterMonthDoList.size() > 0) {
            pvGenwattmeterMonthDoList.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(PvStatGenwattmeterDayDo::getCeCustId)).forEach((k, genwattmeterMonthDoList) -> {
                PvStatGenwattmeterMonthDo monthDo = new PvStatGenwattmeterMonthDo();
                BigDecimal egenValueMonth = null;
                BigDecimal pvProfitTotalMonth = null;
                BigDecimal sscqValueMonth = new BigDecimal("0.00000000");
                BigDecimal scdeValueMonth = new BigDecimal("0.00000000");
                BigDecimal ssdeValueMonth = new BigDecimal("0.00000000");
                BigDecimal sdaValueMonth = new BigDecimal("0.00000000");
                if (genwattmeterMonthDoList.size() > 0) {
                    egenValueMonth = genwattmeterMonthDoList.parallelStream().filter(s -> s.getEgenValueDay() != null).map(PvStatGenwattmeterDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    pvProfitTotalMonth = genwattmeterMonthDoList.parallelStream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatGenwattmeterDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sscqValueMonthTotal = genwattmeterMonthDoList.parallelStream().filter(s -> s.getSscqValueDay() != null).map(PvStatGenwattmeterDayDo::getSscqValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    sscqValueMonth = sscqValueMonth.add(sscqValueMonthTotal);
                    BigDecimal scdeValueMonthTotal = genwattmeterMonthDoList.parallelStream().filter(s -> s.getScdeValueDay() != null).map(PvStatGenwattmeterDayDo::getScdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    scdeValueMonth = scdeValueMonth.add(scdeValueMonthTotal);
                    BigDecimal ssdeValueMonthTotal = genwattmeterMonthDoList.parallelStream().filter(s -> s.getSsdeValueDay() != null).map(PvStatGenwattmeterDayDo::getSsdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    ssdeValueMonth = ssdeValueMonth.add(ssdeValueMonthTotal);
                    BigDecimal sdaValueMonthTotal = genwattmeterMonthDoList.parallelStream().filter(s -> s.getSdaValueDay() != null).map(PvStatGenwattmeterDayDo::getSdaValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    sdaValueMonth = sdaValueMonth.add(sdaValueMonthTotal);
                    if (genwattmeterMonthDoList.size() == 1) {
                        monthDo.setEndEgenValueMonth(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(0)).getEndEgenValueDay());
                    } else {
                        monthDo.setEndEgenValueMonth(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(genwattmeterMonthDoList.size() - 1)).getEndEgenValueDay());
                    }
                    String pvProfitDetailMonth = null;
                    List<String> pvProfitDetailList = genwattmeterMonthDoList.parallelStream().filter(s -> s.getPvProfitDetailDay() != null).map(PvStatGenwattmeterDayDo::getPvProfitDetailDay).collect(Collectors.toList());
                    if (pvProfitDetailList.size() > 0) {
                        pvProfitDetailMonth = PvstatUtil.getpvProfitDetail2(pvProfitDetailList);
                    }
                    monthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                    monthDo.setOrgNo(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(0)).getOrgNo());
                    monthDo.setCeCustId(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(0)).getCeCustId());
                    monthDo.setCeDeviceId(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(0)).getCeDeviceId());
                    monthDo.setMeterType(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(0)).getMeterType());
                    monthDo.setCePointId(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(0)).getCePointId());
                    monthDo.setMonthStat(Integer.parseInt(DateConvertUtils.convertToString((Date)new Date(), (String)"yyyyMM")));
                    monthDo.setEgenValueMonth(egenValueMonth);
                    monthDo.setStartEgenValueMonth(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(0)).getStartEgenValueDay());
                    monthDo.setTmplPvBillingId(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(0)).getTmplPvBillingId());
                    monthDo.setPvbType(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(0)).getPvbType());
                    monthDo.setPvbParams(((PvStatGenwattmeterDayDo)genwattmeterMonthDoList.get(0)).getPvbParams());
                    monthDo.setPvProfitTotalMonth(pvProfitTotalMonth);
                    monthDo.setSscqValueMonth(sscqValueMonth);
                    monthDo.setScdeValueMonth(scdeValueMonth);
                    monthDo.setSsdeValueMonth(ssdeValueMonth);
                    monthDo.setSdaValueMonth(sdaValueMonth);
                    monthDo.setGmtCreate(System.currentTimeMillis());
                    monthDo.setGmtModified(System.currentTimeMillis());
                    monthDo.setVersion(1);
                    monthDo.setPvProfitDetailMonth(pvProfitDetailMonth);
                    monthDoList.add(monthDo);
                }
            });
        }
        if (monthDoList.size() > 0) {
            this.pvStatGenwattmeterDao.insertOrUpdatePvStatGenwattmeterMonthDo(monthDoList);
        }
        return -1;
    }

    public int insertOrUpdatePvStatGenwattmeterYearDo() {
        ArrayList<PvStatGenwattmeterYearDo> yearDoList = new ArrayList<PvStatGenwattmeterYearDo>();
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        HashMap<String, String> params = new HashMap<String, String>();
        String startDate = this.getFirstDayMonthOfYear();
        params.put("startDate", startDate);
        List<PvStatGenwattmeterDayDo> pvGenwattmeterYearDoList = this.pvStatGenwattmeterDao.getPvStatGenwattmeterYear(params);
        if (pvGenwattmeterYearDoList.size() > 0) {
            pvGenwattmeterYearDoList.parallelStream().filter(s -> s.getCeCustId() != null).collect(Collectors.groupingBy(s -> s.getCeCustId())).forEach((key, genwattmeterYearDoList) -> {
                PvStatGenwattmeterYearDo yearDo = new PvStatGenwattmeterYearDo();
                BigDecimal egenValueYear = null;
                BigDecimal pvProfitTotalYear = null;
                BigDecimal sscqValueYear = new BigDecimal("0.00000000");
                BigDecimal scdeValueYear = new BigDecimal("0.00000000");
                BigDecimal ssdeValueYear = new BigDecimal("0.00000000");
                BigDecimal sdaValueYear = new BigDecimal("0.00000000");
                egenValueYear = genwattmeterYearDoList.parallelStream().filter(s -> s.getEgenValueDay() != null).map(PvStatGenwattmeterDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                pvProfitTotalYear = genwattmeterYearDoList.parallelStream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatGenwattmeterDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal sscqValueYearTotal = genwattmeterYearDoList.parallelStream().filter(s -> s.getSscqValueDay() != null).map(PvStatGenwattmeterDayDo::getSscqValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                sscqValueYear = sscqValueYear.add(sscqValueYearTotal);
                BigDecimal scdeValueYearTotal = genwattmeterYearDoList.parallelStream().filter(s -> s.getScdeValueDay() != null).map(PvStatGenwattmeterDayDo::getScdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                scdeValueYear = scdeValueYear.add(scdeValueYearTotal);
                BigDecimal ssdeValueYearTotal = genwattmeterYearDoList.parallelStream().filter(s -> s.getSsdeValueDay() != null).map(PvStatGenwattmeterDayDo::getSsdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                ssdeValueYear = ssdeValueYear.add(ssdeValueYearTotal);
                BigDecimal sdaValueYearTotal = genwattmeterYearDoList.parallelStream().filter(s -> s.getSdaValueDay() != null).map(PvStatGenwattmeterDayDo::getSdaValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                sdaValueYear = sdaValueYear.add(sdaValueYearTotal);
                if (genwattmeterYearDoList.size() == 1) {
                    yearDo.setEndEgenValueYear(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(0)).getEndEgenValueDay());
                } else {
                    yearDo.setEndEgenValueYear(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(genwattmeterYearDoList.size() - 1)).getEndEgenValueDay());
                }
                String pvProfitDetailYear = null;
                List<String> pvProfitDetailList = genwattmeterYearDoList.parallelStream().filter(s -> s.getPvProfitDetailDay() != null).map(PvStatGenwattmeterDayDo::getPvProfitDetailDay).collect(Collectors.toList());
                if (pvProfitDetailList.size() > 0) {
                    pvProfitDetailYear = PvstatUtil.getpvProfitDetail2(pvProfitDetailList);
                }
                yearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                yearDo.setOrgNo(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(0)).getOrgNo());
                yearDo.setCeCustId(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(0)).getCeCustId());
                yearDo.setCePointId(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(0)).getCePointId());
                yearDo.setCeDeviceId(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(0)).getCeDeviceId());
                yearDo.setMeterType(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(0)).getMeterType());
                yearDo.setYearStat(year);
                yearDo.setEgenValueYear(egenValueYear);
                yearDo.setStartEgenValueYear(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(0)).getStartEgenValueDay());
                yearDo.setTmplPvBillingId(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(0)).getTmplPvBillingId());
                yearDo.setPvbType(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(0)).getPvbType());
                yearDo.setPvbParams(((PvStatGenwattmeterDayDo)genwattmeterYearDoList.get(0)).getPvbParams());
                yearDo.setPvProfitTotalYear(pvProfitTotalYear);
                yearDo.setSscqValueYear(sscqValueYear);
                yearDo.setScdeValueYear(scdeValueYear);
                yearDo.setSsdeValueYear(ssdeValueYear);
                yearDo.setSdaValueYear(sdaValueYear);
                yearDo.setGmtCreate(System.currentTimeMillis());
                yearDo.setGmtModified(System.currentTimeMillis());
                yearDo.setVersion(1);
                yearDo.setPvProfitDetailYear(pvProfitDetailYear);
                yearDoList.add(yearDo);
            });
        }
        if (yearDoList.size() > 0) {
            return this.pvStatGenwattmeterDao.insertOrUpdatePvStatGenwattmeterYearDo(yearDoList);
        }
        return -1;
    }

    public String getFirstDayMonthOfYear() {
        Calendar cale = Calendar.getInstance();
        int year = cale.get(1);
        String startDay = year + "0101";
        return startDay;
    }
}

