/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.pvstat.service.impl;

import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.base.util.CurveUtil;
import com.iesms.openservices.pvstat.dao.PvStatInverterEloadDao;
import com.iesms.openservices.pvstat.entity.PvStatInverterEloadDayDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterEloadMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterEloadYearDo;
import com.iesms.openservices.pvstat.service.PvStatInverterEloadService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PvStatInverterEloadServiceImpl
extends AbstractIesmsBaseService
implements PvStatInverterEloadService {
    private PvStatInverterEloadDao pvStatInverterEloadDao;

    @Autowired
    public PvStatInverterEloadServiceImpl(PvStatInverterEloadDao pvStatInverterEloadDao) {
        this.pvStatInverterEloadDao = pvStatInverterEloadDao;
    }

    public List<PvStatInverterEloadDayDo> getPvStatInverterEloadMonthOrYear(Map<String, String> map) {
        return null;
    }

    public int insertOrUpdatePvStatInverterEloadDay(List<PvStatInverterEloadDayDo> list) {
        ArrayList<PvStatInverterEloadDayDo> inverterEloadDayDoList = new ArrayList<PvStatInverterEloadDayDo>();
        if (list.size() > 0) {
            list.stream().filter(s -> s != null).forEach(inverter -> {
                inverter.setId(Long.valueOf(this.idGenerator.nextId()));
                inverter.setGmtCreate(System.currentTimeMillis());
                inverter.setGmtModified(System.currentTimeMillis());
                inverter.setVersion(1);
                inverterEloadDayDoList.add((PvStatInverterEloadDayDo)inverter);
            });
        }
        if (inverterEloadDayDoList.size() > 0) {
            return this.pvStatInverterEloadDao.insertOrUpdatePvStatInverterEloadDay(inverterEloadDayDoList);
        }
        return -1;
    }

    public int insertOrUpdatePvStatInverterEloadMonth() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "1");
        List<PvStatInverterEloadDayDo> inverterEloadMonth = this.pvStatInverterEloadDao.getPvStatInverterEloadMonthOrYear(map);
        if (inverterEloadMonth.size() > 0) {
            ArrayList<PvStatInverterEloadMonthDo> inverterEloadMonthDoList = new ArrayList<PvStatInverterEloadMonthDo>();
            int month = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
            inverterEloadMonth.parallelStream().filter(inv -> inv != null).collect(Collectors.groupingBy(inv2 -> inv2.getCePointId())).forEach((key, inverterList) -> {
                PvStatInverterEloadMonthDo inverterEloadMonthDo = new PvStatInverterEloadMonthDo();
                inverterEloadMonthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                inverterEloadMonthDo.setOrgNo(((PvStatInverterEloadDayDo)inverterList.get(0)).getOrgNo());
                inverterEloadMonthDo.setCeCustId(((PvStatInverterEloadDayDo)inverterList.get(0)).getCeCustId());
                inverterEloadMonthDo.setCeDeviceId(((PvStatInverterEloadDayDo)inverterList.get(0)).getCeDeviceId());
                inverterEloadMonthDo.setCePointId(((PvStatInverterEloadDayDo)inverterList.get(0)).getCePointId());
                inverterEloadMonthDo.setMonthStat(month);
                int[] maxAndMinIndex = new int[]{0, 0};
                String[] dataTime = new String[]{null, null};
                BigDecimal totalMonthValue = inverterList.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatInverterEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalMonthValue != null) {
                    BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(inverterList.size()), 8, 0);
                    inverterEloadMonthDo.setAvgValue(avgValueMonth);
                }
                BigDecimal[] maxAndMin = new BigDecimal[]{null, null};
                Date[] times = new Date[]{null, null};
                for (int i = 0; i < inverterList.size(); ++i) {
                    maxAndMin[0] = new BigDecimal("0.00000000");
                    maxAndMin[1] = new BigDecimal("0.00000000");
                    if (((PvStatInverterEloadDayDo)inverterList.get(i)).getMaxValue() != null && ((PvStatInverterEloadDayDo)inverterList.get(i)).getMaxValue().compareTo(maxAndMin[0]) == 1) {
                        maxAndMin[0] = ((PvStatInverterEloadDayDo)inverterList.get(i)).getMaxValue();
                        times[0] = ((PvStatInverterEloadDayDo)inverterList.get(i)).getMaxValueTime();
                    }
                    if (((PvStatInverterEloadDayDo)inverterList.get(i)).getMinValue() == null || ((PvStatInverterEloadDayDo)inverterList.get(i)).getMinValue().compareTo(maxAndMin[1]) != -1) continue;
                    maxAndMin[1] = ((PvStatInverterEloadDayDo)inverterList.get(i)).getMinValue();
                    times[1] = ((PvStatInverterEloadDayDo)inverterList.get(i)).getMinValueTime();
                }
                inverterEloadMonthDo.setMaxValue(maxAndMin[0]);
                inverterEloadMonthDo.setMaxValueTime(times[0]);
                inverterEloadMonthDo.setMinValue(maxAndMin[1]);
                inverterEloadMonthDo.setMinValueTime(times[1]);
                inverterEloadMonthDo.setInverterCapacity(((PvStatInverterEloadDayDo)inverterList.get(0)).getInverterCapacity());
                inverterEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                inverterEloadMonthDo.setGmtModified(System.currentTimeMillis());
                inverterEloadMonthDo.setVersion(1);
                inverterEloadMonthDoList.add(inverterEloadMonthDo);
            });
            if (inverterEloadMonthDoList.size() > 0) {
                this.pvStatInverterEloadDao.insertOrUpdatePvStatInverterEloadMonth(inverterEloadMonthDoList);
            }
        }
        return -1;
    }

    public int insertOrUpdatePvStatInverterEloadYear() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flag", "2");
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        List<PvStatInverterEloadDayDo> inverterEloadYear = this.pvStatInverterEloadDao.getPvStatInverterEloadMonthOrYear(map);
        if (inverterEloadYear.size() > 0) {
            ArrayList<PvStatInverterEloadYearDo> inverterEloadYearDoList = new ArrayList<PvStatInverterEloadYearDo>();
            int mear = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
            inverterEloadYear.parallelStream().filter(inv -> inv != null).collect(Collectors.groupingBy(inv2 -> inv2.getCePointId())).forEach((key, inverterList) -> {
                PvStatInverterEloadYearDo inverterEloadYearDo = new PvStatInverterEloadYearDo();
                inverterEloadYearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                inverterEloadYearDo.setOrgNo(((PvStatInverterEloadDayDo)inverterList.get(0)).getOrgNo());
                inverterEloadYearDo.setCeCustId(((PvStatInverterEloadDayDo)inverterList.get(0)).getCeCustId());
                inverterEloadYearDo.setCeDeviceId(((PvStatInverterEloadDayDo)inverterList.get(0)).getCeDeviceId());
                inverterEloadYearDo.setCePointId(((PvStatInverterEloadDayDo)inverterList.get(0)).getCePointId());
                inverterEloadYearDo.setYearStat(year);
                int[] maxAndMinIndex = new int[]{0, 0};
                String[] dataTime = new String[]{null, null};
                BigDecimal totalYearValue = inverterList.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatInverterEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (totalYearValue != null && inverterList.size() > 0) {
                    BigDecimal avgValueYear = totalYearValue.divide(BigDecimal.valueOf(inverterList.size()), 8, 0);
                    inverterEloadYearDo.setAvgValue(avgValueYear);
                }
                BigDecimal[] maxAndMin = new BigDecimal[]{null, null};
                Date[] times = new Date[]{null, null};
                for (int i = 0; i < inverterList.size(); ++i) {
                    maxAndMin[0] = new BigDecimal("0.00000000");
                    maxAndMin[1] = new BigDecimal("0.00000000");
                    if (((PvStatInverterEloadDayDo)inverterList.get(i)).getMaxValue() != null && ((PvStatInverterEloadDayDo)inverterList.get(i)).getMaxValue().compareTo(maxAndMin[0]) == 1) {
                        maxAndMin[0] = ((PvStatInverterEloadDayDo)inverterList.get(i)).getMaxValue();
                        times[0] = ((PvStatInverterEloadDayDo)inverterList.get(i)).getMaxValueTime();
                    }
                    if (((PvStatInverterEloadDayDo)inverterList.get(i)).getMinValue() == null || ((PvStatInverterEloadDayDo)inverterList.get(i)).getMinValue().compareTo(maxAndMin[1]) != -1) continue;
                    maxAndMin[1] = ((PvStatInverterEloadDayDo)inverterList.get(i)).getMinValue();
                    times[1] = ((PvStatInverterEloadDayDo)inverterList.get(i)).getMinValueTime();
                }
                inverterEloadYearDo.setMaxValue(maxAndMin[0]);
                inverterEloadYearDo.setMaxValueTime(times[0]);
                inverterEloadYearDo.setMinValue(maxAndMin[1]);
                inverterEloadYearDo.setMinValueTime(times[1]);
                inverterEloadYearDo.setInverterCapacity(((PvStatInverterEloadDayDo)inverterList.get(0)).getInverterCapacity());
                inverterEloadYearDo.setGmtCreate(System.currentTimeMillis());
                inverterEloadYearDo.setGmtModified(System.currentTimeMillis());
                inverterEloadYearDo.setVersion(1);
                inverterEloadYearDoList.add(inverterEloadYearDo);
            });
            if (inverterEloadYearDoList.size() > 0) {
                this.pvStatInverterEloadDao.insertOrUpdatePvStatInverterEloadYear(inverterEloadYearDoList);
            }
        }
        return -1;
    }

    public Map<String, Object> getPvStatInverterEloadDayDo(PvStatInverterEloadDayDo pvStatInverterEloadDayDo) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        pvStatInverterEloadDayDo.setNewDate(LocalDate.now().toString());
        PvStatInverterEloadDayDo pvStatInverterEloadDayDo1 = this.pvStatInverterEloadDao.getPvStatInverterEloadDayDo(pvStatInverterEloadDayDo);
        List eloadValue = CurveUtil.getValues((Object)pvStatInverterEloadDayDo1, (String)"eloadValue", (int)2, (int)97);
        String[] labels = CurveUtil.getDayLables((int)96, (int)15);
        returnMap.put("value", eloadValue);
        returnMap.put("labels", labels);
        return returnMap;
    }
}

