/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.convert.DateConvertUtils;
import com.google.common.collect.Lists;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.mbmgmt.dao.MbPvBillingSchemeDao;
import com.iesms.openservices.mbmgmt.entity.MbPvBillingSchemeDo;
import com.iesms.openservices.pvstat.dao.PvStatInverterDao;
import com.iesms.openservices.pvstat.entity.PvStatInverterDayDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterYearDo;
import com.iesms.openservices.pvstat.service.PvStatInverterService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PvStatInverterServiceImpl
extends AbstractIesmsBaseService
implements PvStatInverterService {
    Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PvStatInverterDao pvStatInverterDao;
    private MbPvBillingSchemeDao mbPvBillingSchemeDao;

    @Autowired
    public PvStatInverterServiceImpl(PvStatInverterDao pvStatInverterDao, MbPvBillingSchemeDao mbPvBillingSchemeDao) {
        this.pvStatInverterDao = pvStatInverterDao;
        this.mbPvBillingSchemeDao = mbPvBillingSchemeDao;
    }

    public int updateInveterValueAccum(Map<String, String> map) {
        return this.pvStatInverterDao.updateInveterValueAccum(map);
    }

    public MbPvBillingSchemeDo getMbPvBillingSchemeByPointId(Map<String, Object> map) {
        return this.mbPvBillingSchemeDao.getMbPvBillingSchemeByPointId(map);
    }

    public int initPvStatInverterDay(List<PvStatInverterDayDo> list) {
        ArrayList<PvStatInverterDayDo> pvStatInverterDayDoList = new ArrayList<PvStatInverterDayDo>();
        if (list.size() > 0) {
            list.forEach(initPvStatInverterDay -> {
                initPvStatInverterDay.setId(Long.valueOf(this.idGenerator.nextId()));
                initPvStatInverterDay.setGmtCreate(System.currentTimeMillis());
                initPvStatInverterDay.setGmtModified(System.currentTimeMillis());
                initPvStatInverterDay.setVersion(1);
                pvStatInverterDayDoList.add((PvStatInverterDayDo)initPvStatInverterDay);
            });
        }
        return this.pvStatInverterDao.initPvStatInverterDay(pvStatInverterDayDoList);
    }

    public List<PvStatInverterDayDo> getMonthPvStatInverterDayDoByPointId(Long poitId) {
        return this.pvStatInverterDao.getMonthPvStatInverterDayDoByPointId(poitId);
    }

    public int insertOrUpdatePvStatInverterDay(List<PvStatInverterDayDo> list) {
        ArrayList inverterDayDoList = Lists.newArrayList();
        if (list != null) {
            for (PvStatInverterDayDo pvStatInverterDayDo : list) {
                pvStatInverterDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
                pvStatInverterDayDo.setVersion(1);
                pvStatInverterDayDo.setGmtCreate(System.currentTimeMillis());
                pvStatInverterDayDo.setGmtModified(System.currentTimeMillis());
                inverterDayDoList.add(pvStatInverterDayDo);
            }
        }
        if (inverterDayDoList.size() > 0) {
            return this.pvStatInverterDao.insertOrUpdatePvStatInverterDay(inverterDayDoList);
        }
        return 0;
    }

    public int insertOrUpdatePvStatInverterMonth(Map<String, String> map) {
        List<PvStatInverterDayDo> PvStatInverterDayDolist = this.pvStatInverterDao.getMonthPvStatInverterMonth(map);
        ArrayList<PvStatInverterMonthDo> monthDoList = new ArrayList<PvStatInverterMonthDo>();
        String dateStat = map.get("dateStat");
        Date yyyyMM = DateConvertUtils.convertFromString((String)dateStat, (String[])new String[]{"yyyy-MM-dd"});
        int month = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(yyyyMM));
        if (PvStatInverterDayDolist.size() > 0) {
            PvStatInverterDayDolist.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(PvStatInverterDayDo::getCePointId)).forEach((kye, statInverterDayDolist) -> {
                PvStatInverterMonthDo monthDo = null;
                if (statInverterDayDolist.size() > 0) {
                    monthDo = new PvStatInverterMonthDo();
                    List<String> pvProfitDetailList = statInverterDayDolist.parallelStream().filter(s -> s.getPvProfitDetailDay() != null).map(PvStatInverterDayDo::getPvProfitDetailDay).collect(Collectors.toList());
                    String detailMonth = null;
                    if (pvProfitDetailList.size() > 0) {
                        detailMonth = PvstatUtil.getpvProfitDetail2(pvProfitDetailList);
                    }
                    BigDecimal egenValueMonth = statInverterDayDolist.parallelStream().filter(inv1 -> inv1.getEgenValueDay() != null).map(PvStatInverterDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (statInverterDayDolist.size() == 1) {
                        monthDo.setEndEgenValueMonth(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getEndEgenValueDay());
                    } else {
                        monthDo.setEndEgenValueMonth(((PvStatInverterDayDo)statInverterDayDolist.get(statInverterDayDolist.size() - 1)).getEndEgenValueDay());
                    }
                    BigDecimal inverterCapacity = statInverterDayDolist.parallelStream().filter(s -> s.getInverterCapacity() != null).map(s -> s.getInverterCapacity()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal eqHoursMonth = statInverterDayDolist.parallelStream().filter(s -> s.getEqHoursDay() != null).map(s -> s.getEqHoursDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    monthDo.setEqHoursMonth(eqHoursMonth);
                    String orgNo = ((PvStatInverterDayDo)statInverterDayDolist.get(0)).getOrgNo();
                    Long ceCustId = ((PvStatInverterDayDo)statInverterDayDolist.get(0)).getCeCustId();
                    Long ceDeviceId = ((PvStatInverterDayDo)statInverterDayDolist.get(0)).getCeDeviceId();
                    Long cePointId = ((PvStatInverterDayDo)statInverterDayDolist.get(0)).getCePointId();
                    BigDecimal pvProfitTotalMonth = statInverterDayDolist.parallelStream().filter(s11 -> s11.getPvProfitTotalDay() != null).map(PvStatInverterDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sscqValueMonth = statInverterDayDolist.parallelStream().filter(s12 -> s12.getSscqValueDay() != null).map(PvStatInverterDayDo::getSscqValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal scdeValueMonth = statInverterDayDolist.parallelStream().filter(s13 -> s13.getScdeValueDay() != null).map(PvStatInverterDayDo::getScdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal ssdeValueMonth = statInverterDayDolist.parallelStream().filter(s14 -> s14.getSsdeValueDay() != null).map(PvStatInverterDayDo::getSsdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sdaValueMonth = statInverterDayDolist.parallelStream().filter(s15 -> s15.getSdaValueDay() != null).map(PvStatInverterDayDo::getSdaValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    monthDo.setOrgNo(orgNo);
                    monthDo.setCeCustId(ceCustId);
                    monthDo.setCeDeviceId(ceDeviceId);
                    monthDo.setCePointId(cePointId);
                    monthDo.setEgenValueMonth(egenValueMonth);
                    monthDo.setStartEgenValueMonth(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getStartEgenValueDay());
                    monthDo.setInverterCapacity(inverterCapacity);
                    monthDo.setSscqValueMonth(sscqValueMonth);
                    monthDo.setScdeValueMonth(scdeValueMonth);
                    monthDo.setSsdeValueMonth(ssdeValueMonth);
                    monthDo.setSdaValueMonth(sdaValueMonth);
                    monthDo.setTmplPvBillingId(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getTmplPvBillingId());
                    monthDo.setPvbType(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getPvbType());
                    monthDo.setPvbParams(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getPvbParams());
                    monthDo.setPvProfitTotalMonth(pvProfitTotalMonth);
                    monthDo.setPvProfitDetailMonth(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getPvProfitDetailDay());
                    monthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                    monthDo.setGmtCreate(System.currentTimeMillis());
                    monthDo.setGmtModified(System.currentTimeMillis());
                    monthDo.setMonthStat(month);
                    monthDo.setVersion(1);
                    monthDo.setPvProfitDetailMonth(detailMonth);
                    monthDoList.add(monthDo);
                }
            });
        }
        if (monthDoList.size() > 0) {
            return this.pvStatInverterDao.insertOrUpdatePvStatInverterMonth(monthDoList);
        }
        return -1;
    }

    public int insertOrUpdatePvStatInverterYear(Map<String, String> map) {
        List<PvStatInverterDayDo> pvStatInverterDayDolist = this.pvStatInverterDao.getYearMonthPvStatInverterYear(map);
        ArrayList<PvStatInverterYearDo> yearDoList = new ArrayList<PvStatInverterYearDo>();
        String dateStat = map.get("dateStat");
        Date yyyy = DateConvertUtils.convertFromString((String)dateStat, (String[])new String[]{"yyyy-MM-dd"});
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(yyyy));
        if (pvStatInverterDayDolist.size() > 0) {
            pvStatInverterDayDolist.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(PvStatInverterDayDo::getCePointId)).forEach((key, statInverterDayDolist) -> {
                PvStatInverterYearDo inverterYearDo = new PvStatInverterYearDo();
                if (statInverterDayDolist.size() > 0) {
                    String orgNo = ((PvStatInverterDayDo)statInverterDayDolist.get(0)).getOrgNo();
                    Long ceCustId = ((PvStatInverterDayDo)statInverterDayDolist.get(0)).getCeCustId();
                    Long ceDeviceId = ((PvStatInverterDayDo)statInverterDayDolist.get(0)).getCeDeviceId();
                    Long cePointId = ((PvStatInverterDayDo)statInverterDayDolist.get(0)).getCePointId();
                    statInverterDayDolist.sort(Comparator.comparing(PvStatInverterDayDo::getDateStat));
                    BigDecimal egenValueYear = statInverterDayDolist.parallelStream().filter(s -> s.getEgenValueDay() != null).map(PvStatInverterDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal startEgenValueYear = ((PvStatInverterDayDo)statInverterDayDolist.get(0)).getStartEgenValueDay();
                    BigDecimal endEgenValueYear = ((PvStatInverterDayDo)statInverterDayDolist.get(statInverterDayDolist.size() - 1)).getEndEgenValueDay();
                    if (statInverterDayDolist.size() == 1) {
                        inverterYearDo.setEndEgenValueYear(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getEndEgenValueDay());
                    } else {
                        inverterYearDo.setEndEgenValueYear(((PvStatInverterDayDo)statInverterDayDolist.get(statInverterDayDolist.size() - 1)).getEndEgenValueDay());
                    }
                    BigDecimal inverterCapacity = statInverterDayDolist.parallelStream().filter(s -> s.getInverterCapacity() != null).map(s -> s.getInverterCapacity()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal eqHoursYear = statInverterDayDolist.parallelStream().filter(s -> s.getEqHoursDay() != null).map(s -> s.getEqHoursDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    inverterYearDo.setEqHoursYear(eqHoursYear);
                    BigDecimal pvProfitTotalYear = statInverterDayDolist.parallelStream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatInverterDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sscqValueYear = statInverterDayDolist.parallelStream().filter(s -> s.getSscqValueDay() != null).map(PvStatInverterDayDo::getSscqValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal scdeValueYear = statInverterDayDolist.parallelStream().filter(s -> s.getScdeValueDay() != null).map(PvStatInverterDayDo::getScdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal ssdeValueYear = statInverterDayDolist.parallelStream().filter(s -> s.getSsdeValueDay() != null).map(PvStatInverterDayDo::getSsdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sdaValueYear = statInverterDayDolist.parallelStream().filter(s -> s.getSdaValueDay() != null).map(PvStatInverterDayDo::getSdaValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> detailDayList = statInverterDayDolist.stream().filter(s -> s.getPvProfitDetailDay() != null).map(PvStatInverterDayDo::getPvProfitDetailDay).collect(Collectors.toList());
                    String detailYear = null;
                    if (detailDayList.size() > 0) {
                        detailYear = PvstatUtil.getpvProfitDetail2(detailDayList);
                    }
                    inverterYearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                    inverterYearDo.setOrgNo(orgNo);
                    inverterYearDo.setCeCustId(ceCustId);
                    inverterYearDo.setCeDeviceId(ceDeviceId);
                    inverterYearDo.setCePointId(cePointId);
                    inverterYearDo.setYearStat(year);
                    inverterYearDo.setEgenValueYear(egenValueYear);
                    inverterYearDo.setStartEgenValueYear(startEgenValueYear);
                    inverterYearDo.setEndEgenValueYear(endEgenValueYear);
                    inverterYearDo.setInverterCapacity(inverterCapacity);
                    inverterYearDo.setTmplPvBillingId(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getTmplPvBillingId());
                    inverterYearDo.setPvbType(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getPvbType());
                    inverterYearDo.setPvbParams(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getPvbParams());
                    inverterYearDo.setPvProfitTotalYear(pvProfitTotalYear);
                    inverterYearDo.setPvProfitDetailYear(((PvStatInverterDayDo)statInverterDayDolist.get(0)).getPvProfitDetailDay());
                    inverterYearDo.setSscqValueYear(sscqValueYear);
                    inverterYearDo.setScdeValueYear(scdeValueYear);
                    inverterYearDo.setSsdeValueYear(ssdeValueYear);
                    inverterYearDo.setSdaValueYear(sdaValueYear);
                    inverterYearDo.setPvProfitDetailYear(detailYear);
                    inverterYearDo.setGmtCreate(System.currentTimeMillis());
                    inverterYearDo.setGmtModified(System.currentTimeMillis());
                    inverterYearDo.setVersion(1);
                    yearDoList.add(inverterYearDo);
                }
            });
        }
        if (yearDoList.size() > 0) {
            return this.pvStatInverterDao.insertOrUpdatePvStatInverterYear(yearDoList);
        }
        return -1;
    }
}

