/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cebase.util.CommonUtils;
import com.iesms.openservices.cestat.dao.CeResourceCommonDao;
import com.iesms.openservices.pvstat.dao.PvStatOrgEloadDao;
import com.iesms.openservices.pvstat.entity.PvStatOrgEloadDayDo;
import com.iesms.openservices.pvstat.entity.PvStatOrgEloadMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatOrgEloadYearDo;
import com.iesms.openservices.pvstat.entity.PvStatPvstationEloadDayDo;
import com.iesms.openservices.pvstat.entity.PvStatPvstationEloadDayVo;
import com.iesms.openservices.pvstat.service.PvStatOrgEloadService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PvStatOrgEloadServiceImpl
extends AbstractIesmsBaseService
implements PvStatOrgEloadService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private PvStatOrgEloadDao pvStatOrgEloadDao;
    @Resource
    private CeResourceCommonDao ceResourceCommonDao;

    public int insertOrUpdatePvStatOrgEloadDay(Map<String, String> map) {
        List orgInfoList = this.ceResourceCommonDao.getOrgInfo();
        String date = map.get("dateStat");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dateStat", date);
        if (orgInfoList.size() > 0) {
            ArrayList<PvStatOrgEloadDayDo> pvStatOrgEloadDayDoList = new ArrayList<PvStatOrgEloadDayDo>();
            orgInfoList.forEach(orgNo -> {
                params.put("orgNo", (String)orgNo);
                params.put("flag", "1");
                List<PvStatPvstationEloadDayVo> pvstationEloadDayVoList = this.pvStatOrgEloadDao.getPvStatPvstationParentDayValue(params);
                if (pvstationEloadDayVoList.size() > 0) {
                    pvstationEloadDayVoList.forEach(pvstationEloadDay -> {
                        PvStatOrgEloadDayDo pvStatOrgEloadDayDo = new PvStatOrgEloadDayDo();
                        try {
                            BeanUtils.copyProperties((Object)pvStatOrgEloadDayDo, (Object)pvstationEloadDay);
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            this.logger.error("pvStatOrgEloadDayDo copyProperties error" + e.getMessage());
                        }
                        Map<String, Object> stringObjectMap = PvstatUtil.beanToMap(pvStatOrgEloadDayDo);
                        stringObjectMap = PvstatUtil.getMaxAndMinValue(stringObjectMap);
                        stringObjectMap = PvstatUtil.getMaxAndMinValue(stringObjectMap);
                        pvStatOrgEloadDayDo = (PvStatOrgEloadDayDo)JsonConvertUtils.convertFromString((String)JsonConvertUtils.convertToString(stringObjectMap), PvStatOrgEloadDayDo.class);
                        pvStatOrgEloadDayDo.setPvTotalCapacity(pvstationEloadDay.getPvCapacity());
                        pvStatOrgEloadDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
                        pvStatOrgEloadDayDo.setGmtCreate(System.currentTimeMillis());
                        pvStatOrgEloadDayDo.setGmtModified(System.currentTimeMillis());
                        pvStatOrgEloadDayDo.setVersion(1);
                        pvStatOrgEloadDayDo.setPvTotalCapacity(pvstationEloadDay.getPvCapacity());
                        pvStatOrgEloadDayDoList.add(pvStatOrgEloadDayDo);
                    });
                }
            });
            params.put("flag", "2");
            List<PvStatPvstationEloadDayVo> pvstationEloadDayVoList1 = this.pvStatOrgEloadDao.getPvStatPvstationParentDayValue2(params);
            if (pvstationEloadDayVoList1.size() > 0) {
                pvstationEloadDayVoList1.forEach(pvstationEloadDay -> {
                    pvstationEloadDay.setOrgNo(pvstationEloadDay.getParentOrgNo());
                    PvStatOrgEloadDayDo pvStatOrgEloadDayDo = new PvStatOrgEloadDayDo();
                    try {
                        BeanUtils.copyProperties((Object)pvStatOrgEloadDayDo, (Object)pvstationEloadDay);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        this.logger.error("pvStatOrgEloadDayDo copyProperties error" + e.getMessage());
                    }
                    Map<String, Object> stringObjectMap = PvstatUtil.beanToMap(pvStatOrgEloadDayDo);
                    stringObjectMap = PvstatUtil.getMaxAndMinValue(stringObjectMap);
                    stringObjectMap = PvstatUtil.getMaxAndMinValue(stringObjectMap);
                    pvStatOrgEloadDayDo = (PvStatOrgEloadDayDo)JsonConvertUtils.convertFromString((String)JsonConvertUtils.convertToString(stringObjectMap), PvStatOrgEloadDayDo.class);
                    pvStatOrgEloadDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
                    pvStatOrgEloadDayDo.setGmtCreate(System.currentTimeMillis());
                    pvStatOrgEloadDayDo.setGmtModified(System.currentTimeMillis());
                    pvStatOrgEloadDayDo.setVersion(1);
                    pvStatOrgEloadDayDo.setPvTotalCapacity(pvstationEloadDay.getPvCapacity());
                    pvStatOrgEloadDayDoList.add(pvStatOrgEloadDayDo);
                });
            }
            if (pvStatOrgEloadDayDoList.size() > 0) {
                try {
                    return this.pvStatOrgEloadDao.insertOrUpdatePvStatOrgEloadDay(pvStatOrgEloadDayDoList);
                }
                catch (Exception e) {
                    this.logger.error("insertOrUpdatePvStatOrgEloadDay error" + e.getMessage());
                }
            }
        }
        return -1;
    }

    public int insertOrUpdatePvStatOrgEloadMonth() {
        Map map = CommonUtils.getFirstDayAndLastDayOfMonth();
        map.put("flag", "1");
        int month = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
        List<PvStatPvstationEloadDayVo> pvstationEloadDayVoList = this.pvStatOrgEloadDao.getPvStatPvstationMonthAndYear(map);
        PvStatPvstationEloadDayVo[] eloadDayVos = new PvStatPvstationEloadDayVo[]{null};
        ArrayList<PvStatOrgEloadMonthDo> eloadMonthDoList = new ArrayList<PvStatOrgEloadMonthDo>();
        if (pvstationEloadDayVoList.size() > 0) {
            pvstationEloadDayVoList.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(s -> s.getOrgNo())).forEach((key, values) -> {
                if (values.size() > 0) {
                    eloadDayVos[0] = new PvStatPvstationEloadDayVo();
                    BigDecimal[] maxormin = new BigDecimal[]{null, null};
                    Date[] date = new Date[]{null, null};
                    for (int i = 0; i < values.size(); ++i) {
                        maxormin[0] = new BigDecimal("0.00000000");
                        maxormin[1] = new BigDecimal("0.00000000");
                        if (((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue() != null && ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue().compareTo(maxormin[0]) == 1) {
                            maxormin[0] = ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue();
                            date[0] = ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValueTime();
                        }
                        if (((PvStatPvstationEloadDayVo)values.get(i)).getMinValue() == null || ((PvStatPvstationEloadDayVo)values.get(i)).getMinValue().compareTo(maxormin[1]) != -1) continue;
                        maxormin[1] = ((PvStatPvstationEloadDayVo)values.get(i)).getMinValue();
                        date[1] = ((PvStatPvstationEloadDayVo)values.get(i)).getMinValueTime();
                    }
                    PvStatOrgEloadMonthDo orgEloadMonthDo = new PvStatOrgEloadMonthDo();
                    values.parallelStream().filter(s -> s.getAvgValue() != null).map(s -> s.getAvgValue()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal totalMonthValue = values.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatPvstationEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (totalMonthValue != null) {
                        BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(values.size()), 8, 0);
                        orgEloadMonthDo.setAvgValue(avgValueMonth);
                    }
                    orgEloadMonthDo.setMaxValue(maxormin[0]);
                    orgEloadMonthDo.setMaxValueTime(date[0]);
                    orgEloadMonthDo.setMinValue(maxormin[1]);
                    orgEloadMonthDo.setMinValueTime(date[1]);
                    orgEloadMonthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                    orgEloadMonthDo.setOrgNo(((PvStatPvstationEloadDayVo)values.get(0)).getOrgNo());
                    orgEloadMonthDo.setMonthStat(month);
                    orgEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                    orgEloadMonthDo.setGmtModified(System.currentTimeMillis());
                    orgEloadMonthDo.setVersion(1);
                    eloadMonthDoList.add(orgEloadMonthDo);
                }
            });
            pvstationEloadDayVoList.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(s -> s.getParentOrgNo())).forEach((key, values) -> {
                if (values.size() > 0) {
                    eloadDayVos[0] = new PvStatPvstationEloadDayVo();
                    BigDecimal[] maxormin = new BigDecimal[]{null, null};
                    Date[] date = new Date[]{null, null};
                    for (int i = 0; i < values.size(); ++i) {
                        maxormin[0] = new BigDecimal("0.00000000");
                        maxormin[1] = new BigDecimal("0.00000000");
                        if (((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue() != null && ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue().compareTo(maxormin[0]) == 1) {
                            maxormin[0] = ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue();
                            date[0] = ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValueTime();
                        }
                        if (((PvStatPvstationEloadDayVo)values.get(i)).getMinValue() == null || ((PvStatPvstationEloadDayVo)values.get(i)).getMinValue().compareTo(maxormin[1]) != -1) continue;
                        maxormin[1] = ((PvStatPvstationEloadDayVo)values.get(i)).getMinValue();
                        date[1] = ((PvStatPvstationEloadDayVo)values.get(i)).getMinValueTime();
                    }
                    PvStatOrgEloadMonthDo orgEloadMonthDo = new PvStatOrgEloadMonthDo();
                    BigDecimal totalMonthValue = values.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatPvstationEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (totalMonthValue != null) {
                        BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(values.size()), 8, 0);
                        orgEloadMonthDo.setAvgValue(avgValueMonth);
                    }
                    orgEloadMonthDo.setMaxValue(maxormin[0]);
                    orgEloadMonthDo.setMaxValueTime(date[0]);
                    orgEloadMonthDo.setMinValue(maxormin[1]);
                    orgEloadMonthDo.setMinValueTime(date[1]);
                    orgEloadMonthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                    orgEloadMonthDo.setOrgNo(((PvStatPvstationEloadDayVo)values.get(0)).getParentOrgNo());
                    orgEloadMonthDo.setMonthStat(month);
                    orgEloadMonthDo.setGmtCreate(System.currentTimeMillis());
                    orgEloadMonthDo.setGmtModified(System.currentTimeMillis());
                    orgEloadMonthDo.setVersion(1);
                    eloadMonthDoList.add(orgEloadMonthDo);
                }
            });
        }
        if (eloadMonthDoList.size() > 0) {
            this.pvStatOrgEloadDao.insertOrUpdatePvStatOrgEloadMonth(eloadMonthDoList);
        }
        return -1;
    }

    public int insertOrUpdatePvStatOrgEloadYear() {
        Map map = CommonUtils.getFirstDayAndLastDayOfMonth();
        map.put("flag", "2");
        int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        List<PvStatPvstationEloadDayVo> pvstationEloadDayVoList = this.pvStatOrgEloadDao.getPvStatPvstationMonthAndYear(map);
        PvStatPvstationEloadDayVo[] eloadDayVos = new PvStatPvstationEloadDayVo[]{null};
        ArrayList<PvStatOrgEloadYearDo> eloadYearDoList = new ArrayList<PvStatOrgEloadYearDo>();
        if (pvstationEloadDayVoList.size() > 0) {
            pvstationEloadDayVoList.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(s -> s.getOrgNo())).forEach((key, values) -> {
                if (values.size() > 0) {
                    eloadDayVos[0] = new PvStatPvstationEloadDayVo();
                    BigDecimal[] maxormin = new BigDecimal[]{null, null};
                    Date[] date = new Date[]{null, null};
                    for (int i = 0; i < values.size(); ++i) {
                        maxormin[0] = new BigDecimal("0.00000000");
                        maxormin[1] = new BigDecimal("0.00000000");
                        if (((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue() != null && ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue().compareTo(maxormin[0]) == 1) {
                            maxormin[0] = ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue();
                            date[0] = ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValueTime();
                        }
                        if (((PvStatPvstationEloadDayVo)values.get(i)).getMinValue() == null || ((PvStatPvstationEloadDayVo)values.get(i)).getMinValue().compareTo(maxormin[1]) != -1) continue;
                        maxormin[1] = ((PvStatPvstationEloadDayVo)values.get(i)).getMinValue();
                        date[1] = ((PvStatPvstationEloadDayVo)values.get(i)).getMinValueTime();
                    }
                    PvStatOrgEloadYearDo orgEloadYearDo = new PvStatOrgEloadYearDo();
                    BigDecimal totalMonthValue = values.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatPvstationEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (totalMonthValue != null) {
                        BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(values.size()), 8, 0);
                        orgEloadYearDo.setAvgValue(avgValueMonth);
                    }
                    orgEloadYearDo.setMaxValue(maxormin[0]);
                    orgEloadYearDo.setMaxValueTime(date[0]);
                    orgEloadYearDo.setMinValue(maxormin[1]);
                    orgEloadYearDo.setMinValueTime(date[1]);
                    orgEloadYearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                    orgEloadYearDo.setOrgNo(((PvStatPvstationEloadDayVo)values.get(0)).getOrgNo());
                    orgEloadYearDo.setYearStat(year);
                    orgEloadYearDo.setGmtCreate(System.currentTimeMillis());
                    orgEloadYearDo.setGmtModified(System.currentTimeMillis());
                    orgEloadYearDo.setVersion(1);
                    eloadYearDoList.add(orgEloadYearDo);
                }
            });
            pvstationEloadDayVoList.parallelStream().filter(s -> s != null).collect(Collectors.groupingBy(s -> s.getParentOrgNo())).forEach((key, values) -> {
                if (values.size() > 0) {
                    eloadDayVos[0] = new PvStatPvstationEloadDayVo();
                    BigDecimal[] maxormin = new BigDecimal[]{null, null};
                    Date[] date = new Date[]{null, null};
                    for (int i = 0; i < values.size(); ++i) {
                        maxormin[0] = new BigDecimal("0.00000000");
                        maxormin[1] = new BigDecimal("0.00000000");
                        if (((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue() != null && ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue().compareTo(maxormin[0]) == 1) {
                            maxormin[0] = ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValue();
                            date[0] = ((PvStatPvstationEloadDayVo)values.get(i)).getMaxValueTime();
                        }
                        if (((PvStatPvstationEloadDayVo)values.get(i)).getMinValue() == null || ((PvStatPvstationEloadDayVo)values.get(i)).getMinValue().compareTo(maxormin[1]) != -1) continue;
                        maxormin[1] = ((PvStatPvstationEloadDayVo)values.get(i)).getMinValue();
                        date[1] = ((PvStatPvstationEloadDayVo)values.get(i)).getMinValueTime();
                    }
                    PvStatOrgEloadYearDo orgEloadYearDo = new PvStatOrgEloadYearDo();
                    BigDecimal totalMonthValue = values.parallelStream().filter(s -> s.getAvgValue() != null).map(PvStatPvstationEloadDayDo::getAvgValue).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (totalMonthValue != null) {
                        BigDecimal avgValueMonth = totalMonthValue.divide(BigDecimal.valueOf(values.size()), 8, 0);
                        orgEloadYearDo.setAvgValue(avgValueMonth);
                    }
                    orgEloadYearDo.setMaxValue(maxormin[0]);
                    orgEloadYearDo.setMaxValueTime(date[0]);
                    orgEloadYearDo.setMinValue(maxormin[1]);
                    orgEloadYearDo.setMinValueTime(date[1]);
                    orgEloadYearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                    orgEloadYearDo.setOrgNo(((PvStatPvstationEloadDayVo)values.get(0)).getParentOrgNo());
                    orgEloadYearDo.setYearStat(year);
                    orgEloadYearDo.setGmtCreate(System.currentTimeMillis());
                    orgEloadYearDo.setGmtModified(System.currentTimeMillis());
                    orgEloadYearDo.setVersion(1);
                    eloadYearDoList.add(orgEloadYearDo);
                }
            });
        }
        if (eloadYearDoList.size() > 0) {
            this.pvStatOrgEloadDao.insertOrUpdatePvStatOrgEloadYear(eloadYearDoList);
        }
        return -1;
    }

    public PvStatOrgEloadDayDo getOrgEloadDayDo(List<PvStatPvstationEloadDayVo> stationEloadDayVoList) {
        PvStatOrgEloadDayDo pvStatOrgEloadDayDo = new PvStatOrgEloadDayDo();
        Map<String, Object> pvStationMap = PvstatUtil.beanToMap(pvStatOrgEloadDayDo);
        BigDecimal[] maxAndMin = new BigDecimal[]{null, null, null, null};
        Date[] dataTime = new Date[]{null, null, null, null};
        BigDecimal[] totalCapacity = new BigDecimal[]{null};
        int[] avgLength = new int[]{0};
        stationEloadDayVoList.parallelStream().filter(s -> s != null).forEach(station -> {
            if (totalCapacity[0] == null) {
                totalCapacity[0] = station.getPvCapacity();
            } else if (totalCapacity[0] != null && station.getPvCapacity() != null) {
                totalCapacity[0] = totalCapacity[0].add(station.getPvCapacity());
            }
            Map<String, Object> stationMap = PvstatUtil.beanToMap(station);
            for (int i = 1; i < 97; ++i) {
                String name = "eloadValue" + String.format("%02d", i);
                if (pvStationMap.get(name) == null) {
                    pvStationMap.put(name, stationMap.get(name));
                    continue;
                }
                if (pvStationMap.get(name) == null || stationMap.get(name) == null) continue;
                BigDecimal bigDecimal = this.getBigdecimal(stationMap.get(name));
                pvStationMap.put(name, bigDecimal.add(this.getBigdecimal(pvStationMap.get(name))));
            }
            if (maxAndMin[0] == null) {
                maxAndMin[0] = station.getMaxValue();
                dataTime[0] = station.getMaxValueTime();
            } else if (maxAndMin[0] != null && station.getMaxValue() != null && station.getMaxValue().compareTo(maxAndMin[0]) == 1) {
                maxAndMin[0] = station.getMaxValue();
                dataTime[0] = station.getMaxValueTime();
            }
            if (maxAndMin[1] == null) {
                maxAndMin[1] = station.getMaxValue();
                dataTime[1] = station.getMaxValueTime();
            } else if (maxAndMin[1] != null && station.getMaxValue() != null && station.getMaxValue().compareTo(maxAndMin[1]) == -1) {
                maxAndMin[1] = station.getMaxValue();
                dataTime[1] = station.getMaxValueTime();
            }
            if (maxAndMin[2] == null) {
                maxAndMin[2] = station.getAvgValue();
                avgLength[0] = avgLength[0] + 1;
            } else if (maxAndMin[2] != null && station.getAvgValue() != null) {
                maxAndMin[2] = maxAndMin[2].add(station.getAvgValue());
                avgLength[0] = avgLength[0] + 1;
            }
            if (maxAndMin[3] == null) {
                maxAndMin[3] = station.getCurValue();
                dataTime[3] = station.getCurValueTime();
            } else if (maxAndMin[3] != null && station.getCurValue() != null) {
                maxAndMin[3] = maxAndMin[3].add(station.getCurValue());
                dataTime[3] = station.getCurValueTime();
            }
        });
        pvStationMap.put("pvTotalCapacity", totalCapacity[0]);
        pvStationMap.put("maxValue", maxAndMin[0]);
        pvStationMap.put("maxValueTime", dataTime[0]);
        pvStationMap.put("minValue", maxAndMin[1]);
        pvStationMap.put("minValueTime", dataTime[1]);
        BigDecimal curValue = stationEloadDayVoList.parallelStream().filter(s -> s.getCurValue() != null).map(s -> s.getCurValue()).reduce(BigDecimal.ZERO, BigDecimal::add);
        pvStationMap.put("curValue", curValue);
        pvStationMap.put("curValueTime", stationEloadDayVoList.get(0).getCurValueTime());
        if (maxAndMin[2] != null && avgLength[0] > 0) {
            pvStationMap.put("avgValue", maxAndMin[2].divide(BigDecimal.valueOf(avgLength[0]), 8, 0));
        } else if (maxAndMin[2] != null && avgLength[0] == 0) {
            pvStationMap.put("avgValue", maxAndMin[2]);
        }
        PvStatOrgEloadDayDo statOrgEloadDayDo = (PvStatOrgEloadDayDo)JsonConvertUtils.convertFromString((String)JsonConvertUtils.convertToString(pvStationMap), PvStatOrgEloadDayDo.class);
        return statOrgEloadDayDo;
    }

    public BigDecimal getBigdecimal(Object obj) {
        BigDecimal retBig = null;
        if (obj != null) {
            if (obj instanceof BigDecimal) {
                retBig = (BigDecimal)obj;
            } else if (obj instanceof String) {
                retBig = new BigDecimal((String)obj);
            } else if (obj instanceof BigInteger) {
                retBig = new BigDecimal((BigInteger)obj);
            } else if (obj instanceof Number) {
                retBig = new BigDecimal(((Number)obj).doubleValue());
            } else {
                throw new ClassCastException("\u65e0\u6cd5\u5c06 [" + obj + "] " + obj.getClass() + " \u8f6c\u6362\u4e3aBigDecimal.");
            }
        }
        return retBig;
    }
}

