/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cestat.dao.CeResourceCommonDao;
import com.iesms.openservices.pvstat.dao.PvStatOrgDao;
import com.iesms.openservices.pvstat.entity.PvStatOrgDayDo;
import com.iesms.openservices.pvstat.entity.PvStatOrgDayVo;
import com.iesms.openservices.pvstat.entity.PvStatOrgMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatOrgYearDo;
import com.iesms.openservices.pvstat.entity.PvStatPvstationDayDo;
import com.iesms.openservices.pvstat.entity.PvStatPvstationDayDoVo;
import com.iesms.openservices.pvstat.service.PvStatOrgService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PvStatOrgServiceImpl
extends AbstractIesmsBaseService
implements PvStatOrgService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PvStatOrgDao pvStatOrgDao;
    private CeResourceCommonDao ceResourceCommonDao;

    @Autowired
    public PvStatOrgServiceImpl(PvStatOrgDao pvStatOrgDao) {
        this.pvStatOrgDao = pvStatOrgDao;
    }

    public int insertOrUpdatePvStatOrgDay(Map<String, String> orgMap1) {
        String date = orgMap1.get("dateStat");
        orgMap1.put("flag", "1");
        List<PvStatOrgDayVo> orgDayValueFromStation = this.pvStatOrgDao.getOrgDayValueFromStation(orgMap1);
        ArrayList<PvStatOrgDayDo> orgDayDoList = new ArrayList<PvStatOrgDayDo>();
        if (orgDayValueFromStation.size() > 0) {
            orgDayValueFromStation.forEach(orgDayValue -> {
                PvStatOrgDayDo pvStatOrgDayDo = new PvStatOrgDayDo();
                try {
                    BeanUtils.copyProperties((Object)pvStatOrgDayDo, (Object)orgDayValue);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.logger.error("\u7cfb\u7edf\u5355\u4f4d\u6570\u636e\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                }
                pvStatOrgDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
                pvStatOrgDayDo.setGmtCreate(System.currentTimeMillis());
                pvStatOrgDayDo.setGmtModified(System.currentTimeMillis());
                pvStatOrgDayDo.setVersion(1);
                BigDecimal egenValueDay = orgDayValue.getEgenValueDay();
                BigDecimal egenValueAccum = orgDayValue.getEgenValueAccum();
                BigDecimal pvTotalCapacity = orgDayValue.getPvTotalCapacity();
                if (egenValueDay != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
                    BigDecimal eqHoursDay = egenValueDay.divide(pvTotalCapacity, 8, 0);
                    pvStatOrgDayDo.setEqHoursDay(eqHoursDay);
                }
                if (egenValueAccum != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
                    BigDecimal eqHoursAccum = egenValueAccum.divide(pvTotalCapacity, 8, 0);
                    pvStatOrgDayDo.setEqHoursAccum(eqHoursAccum);
                }
                orgDayDoList.add(pvStatOrgDayDo);
            });
        }
        orgMap1.put("flag", "2");
        List<PvStatOrgDayVo> orgDayValueFromStation1 = this.pvStatOrgDao.getOrgDayValueFromStation(orgMap1);
        if (orgDayValueFromStation1.size() > 0) {
            orgDayValueFromStation1.forEach(orgDayValue -> {
                PvStatOrgDayDo pvStatOrgDayDo = new PvStatOrgDayDo();
                try {
                    BeanUtils.copyProperties((Object)pvStatOrgDayDo, (Object)orgDayValue);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.logger.error("\u7cfb\u7edf\u5355\u4f4d\u6570\u636e\u8f6c\u6362\u5f02\u5e38" + e.getMessage());
                }
                pvStatOrgDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
                pvStatOrgDayDo.setOrgNo(orgDayValue.getParentOrgNo());
                pvStatOrgDayDo.setGmtCreate(System.currentTimeMillis());
                pvStatOrgDayDo.setGmtModified(System.currentTimeMillis());
                pvStatOrgDayDo.setVersion(1);
                BigDecimal egenValueDay = orgDayValue.getEgenValueDay();
                BigDecimal egenValueAccum = orgDayValue.getEgenValueAccum();
                BigDecimal pvTotalCapacity = orgDayValue.getPvTotalCapacity();
                if (egenValueDay != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
                    BigDecimal eqHoursDay = egenValueDay.divide(pvTotalCapacity, 8, 0);
                    pvStatOrgDayDo.setEqHoursDay(eqHoursDay);
                }
                if (egenValueAccum != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
                    BigDecimal eqHoursAccum = egenValueAccum.divide(pvTotalCapacity, 8, 0);
                    pvStatOrgDayDo.setEqHoursAccum(eqHoursAccum);
                }
                orgDayDoList.add(pvStatOrgDayDo);
            });
        }
        if (orgDayDoList.size() > 0) {
            this.pvStatOrgDao.insertOrUpdatePvStatOrgDay(orgDayDoList);
        }
        return -1;
    }

    public int insertOrUpdatePvStatOrgMonth() {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String format1 = format.format(PvstatUtil.getBeginDayOfMonth());
        String format2 = format.format(PvstatUtil.getEndDayOfMonth());
        paramMap.put("startDay", format1);
        paramMap.put("endDay", format2);
        List<PvStatOrgMonthDo> monthDoList = this.pvStatOrgDao.getOrgMonthValueFromOrgDay(paramMap);
        if (monthDoList != null && monthDoList.size() > 1) {
            monthDoList.forEach(pvStatOrgMonthDo -> {
                pvStatOrgMonthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                pvStatOrgMonthDo.setGmtCreate(System.currentTimeMillis());
                pvStatOrgMonthDo.setGmtModified(System.currentTimeMillis());
                pvStatOrgMonthDo.setVersion(1);
            });
            try {
                this.pvStatOrgDao.insertOrUpdatePvStatOrgMonth(monthDoList);
            }
            catch (Exception e) {
                this.logger.error("insertOrUpdatePvStatOrgMonth error:{}", (Object)e.getMessage());
            }
        }
        return 1;
    }

    public int insertOrUpdatePvStatOrgYear() {
        List<PvStatOrgYearDo> yearDoList = this.pvStatOrgDao.getOrgYearValueFromOrgDay();
        if (yearDoList != null && yearDoList.size() > 0) {
            yearDoList.forEach(pvStatOrgYearDo -> {
                pvStatOrgYearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                pvStatOrgYearDo.setGmtCreate(System.currentTimeMillis());
                pvStatOrgYearDo.setGmtModified(System.currentTimeMillis());
                pvStatOrgYearDo.setVersion(1);
            });
            try {
                this.pvStatOrgDao.insertOrUpdatePvStatOrgYear(yearDoList);
                HashMap<String, String> ymap = new HashMap<String, String>();
                for (PvStatOrgYearDo orgYearDo : yearDoList) {
                    String value = String.valueOf(orgYearDo.getYearStat());
                    value = value + "-01-01";
                    ymap.put("dateStat", value);
                    ymap.put("orgNo", orgYearDo.getOrgNo());
                    this.pvStatOrgDao.updateOrgYearValue(ymap);
                }
            }
            catch (Exception e) {
                this.logger.error("insertOrUpdatePvStatOrgYear error: {}", (Object)e.getMessage());
            }
        }
        return -1;
    }

    public int updateOrgDayAccum(Map<String, String> map) {
        if (map.get("orgNo").equals("1200000005")) {
            return this.pvStatOrgDao.updateMostLevel(map);
        }
        return this.pvStatOrgDao.updatePvStatPvstationParentDayAccum(map);
    }

    public PvStatOrgDayDo getPvStatOrgDayDo(List<PvStatPvstationDayDoVo> pvStationList) {
        PvStatOrgDayDo pvstationDayDo = null;
        PvStatOrgDayDo statOrgDayDo = null;
        int pvstationCount = pvStationList.parallelStream().filter(s -> s != null).filter(PvstatUtil.distinctByKey(s -> s.getCeCustId())).collect(Collectors.groupingBy(PvStatPvstationDayDo::getCeCustId)).size();
        HashMap beanMap = new HashMap();
        pvstationDayDo = new PvStatOrgDayDo();
        Map<String, Object> pvStationMap = PvstatUtil.beanToMap(pvstationDayDo);
        pvStationList.parallelStream().filter(s -> s != null).forEach(station -> {
            Map<String, Object> stationMap = PvstatUtil.beanToMap(station);
            for (int i = 0; i < 24; ++i) {
                BigDecimal value;
                String valueName = "egenValueH" + String.format("%02d", i);
                if (!pvStationMap.containsKey(valueName) && stationMap.containsKey(valueName)) {
                    pvStationMap.put(valueName, stationMap.get(valueName));
                    continue;
                }
                if (pvStationMap.containsKey(valueName) && pvStationMap.get(valueName) == null) {
                    pvStationMap.put(valueName, stationMap.get(valueName));
                    continue;
                }
                if (!pvStationMap.containsKey(valueName) || pvStationMap.get(valueName) == null || (value = this.getBigdecimal(stationMap.get(valueName))) == null) continue;
                pvStationMap.put(valueName, value.add(this.getBigdecimal(pvStationMap.get(valueName))));
            }
        });
        statOrgDayDo = (PvStatOrgDayDo)JsonConvertUtils.convertFromString((String)JsonConvertUtils.convertToString(pvStationMap), PvStatOrgDayDo.class);
        BigDecimal egenValueDay = pvStationList.parallelStream().filter(s -> s.getEgenValueDay() != null).map(PvStatPvstationDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal startEgenValueDay = pvStationList.parallelStream().filter(s -> s.getStartEgenValueDay() != null).map(PvStatPvstationDayDo::getStartEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal endEgenValueDay = pvStationList.parallelStream().filter(s -> s.getEndEgenValueDay() != null).map(PvStatPvstationDayDo::getEndEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal pvProfitTotalDay = pvStationList.parallelStream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatPvstationDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal moneySubsidyTotalDay = pvStationList.parallelStream().filter(s -> s.getMoneySubsidyTotalDay() != null).map(s -> s.getMoneySubsidyTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneSubsidyDetailDayList = pvStationList.parallelStream().filter(s -> s.getMoneySubsidyDetailDay() != null).map(s -> s.getMoneySubsidyDetailDay()).collect(Collectors.toList());
        String moneSubsidyDetailDay = null;
        if (moneSubsidyDetailDayList.size() > 0) {
            moneSubsidyDetailDay = PvstatUtil.getpvProfitDetail2(moneSubsidyDetailDayList);
        }
        if (statOrgDayDo == null) {
            statOrgDayDo = new PvStatOrgDayDo();
        }
        statOrgDayDo.setEgenValueDay(egenValueDay);
        statOrgDayDo.setStartEgenValueDay(startEgenValueDay);
        statOrgDayDo.setEndEgenValueDay(endEgenValueDay);
        BigDecimal totalValueAccum = pvStationList.parallelStream().filter(s -> s.getEgenValueAccum() != null).map(s -> s.getEgenValueAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        statOrgDayDo.setEgenValueAccum(totalValueAccum);
        statOrgDayDo.setPvProfitTotalDay(pvProfitTotalDay);
        statOrgDayDo.setMoneySubsidyTotalDay(moneySubsidyTotalDay);
        statOrgDayDo.setMoneySubsidyDetailDay(moneSubsidyDetailDay);
        BigDecimal moneyOnlineGridTotalDay = pvStationList.parallelStream().filter(s -> s.getMoneyOnlineGridTotalDay() != null).map(s -> s.getMoneyOnlineGridTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneyOnlineDetailTotalDayList = pvStationList.parallelStream().filter(s -> s.getMoneyOnlineGridDetailDay() != null).map(s -> s.getMoneyOnlineGridDetailDay()).collect(Collectors.toList());
        String moneyOnlineDetailTotalDay = null;
        if (moneyOnlineDetailTotalDayList.size() > 0) {
            moneyOnlineDetailTotalDay = PvstatUtil.getpvProfitDetail2(moneyOnlineDetailTotalDayList);
        }
        statOrgDayDo.setMoneyOnlineGridTotalDay(moneyOnlineGridTotalDay);
        statOrgDayDo.setMoneyOnlineGridDetailDay(moneyOnlineDetailTotalDay);
        BigDecimal moneySelfUseTotalDay = pvStationList.parallelStream().filter(s -> s.getMoneySelfUseTotalDay() != null).map(s -> s.getMoneySelfUseTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneySelfUseDetailDayList = pvStationList.parallelStream().filter(s -> s.getMoneySelfUseDetailDay() != null).map(s -> s.getMoneySelfUseDetailDay()).collect(Collectors.toList());
        String moneySelfUseDetailDay = null;
        if (moneySelfUseDetailDayList.size() > 0) {
            moneySelfUseDetailDay = PvstatUtil.getpvProfitDetail2(moneySelfUseDetailDayList);
        }
        statOrgDayDo.setMoneySelfUseTotalDay(moneySelfUseTotalDay);
        statOrgDayDo.setMoneySelfUseDetailDay(moneySelfUseDetailDay);
        BigDecimal moneySubsidyTotalAccum = pvStationList.parallelStream().filter(s -> s.getMoneySubsidyTotalAccum() != null).map(s -> s.getMoneySubsidyTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneySubsidyDetailAccumList = pvStationList.parallelStream().filter(s -> s.getMoneySubsidyDetailAccum() != null).map(s -> s.getMoneySubsidyDetailAccum()).collect(Collectors.toList());
        String moneySubsidyDetailAccum = null;
        if (moneySubsidyDetailAccumList.size() > 0) {
            moneySubsidyDetailAccum = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailAccumList);
        }
        BigDecimal pvProfitTotalAccum = pvStationList.parallelStream().filter(s -> s.getPvProfitTotalAccum() != null).map(s -> s.getPvProfitTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        statOrgDayDo.setPvProfitTotalAccum(pvProfitTotalAccum);
        statOrgDayDo.setMoneySubsidyTotalAccum(moneySubsidyTotalAccum);
        statOrgDayDo.setMoneySubsidyDetailAccum(moneySubsidyDetailAccum);
        BigDecimal moneyOnlineGridTotalAccum = pvStationList.parallelStream().filter(s -> s.getMoneyOnlineGridTotalAccum() != null).map(s -> s.getMoneyOnlineGridTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneyOnlineGridDetailAccumList = pvStationList.parallelStream().filter(s -> s.getMoneyOnlineGridDetailAccum() != null).map(s -> s.getMoneyOnlineGridDetailAccum()).collect(Collectors.toList());
        String moneyOnlineGridDetailAccum = null;
        if (moneyOnlineGridDetailAccumList.size() > 0) {
            moneyOnlineGridDetailAccum = PvstatUtil.getpvProfitDetail2(moneyOnlineGridDetailAccumList);
        }
        statOrgDayDo.setMoneyOnlineGridTotalAccum(moneyOnlineGridTotalAccum);
        statOrgDayDo.setMoneyOnlineGridDetailAccum(moneyOnlineGridDetailAccum);
        BigDecimal moneySelfUseTotalAccum = pvStationList.parallelStream().filter(s -> s.getMoneySelfUseTotalAccum() != null).map(s -> s.getMoneySelfUseTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
        List<String> moneySelfUseDetailAccumList = pvStationList.parallelStream().filter(s -> s.getMoneySelfUseDetailAccum() != null).map(s -> s.getMoneySelfUseDetailAccum()).collect(Collectors.toList());
        String moneySelfUseDetailAccum = null;
        if (moneySelfUseDetailAccumList.size() > 0) {
            moneySelfUseDetailAccum = PvstatUtil.getpvProfitDetail2(moneySelfUseDetailAccumList);
        }
        statOrgDayDo.setMoneySelfUseTotalAccum(moneySelfUseTotalAccum);
        statOrgDayDo.setMoneySelfUseDetailAccum(moneySelfUseDetailAccum);
        BigDecimal pvTotalCapacity = pvStationList.parallelStream().filter(s -> s.getPvCapacity() != null).map(s -> s.getPvCapacity()).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal eqHoursDay = null;
        BigDecimal eqHoursAccum = null;
        if (totalValueAccum != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
            eqHoursAccum = totalValueAccum.divide(pvTotalCapacity, 8, 0);
        }
        if (egenValueDay != null && pvTotalCapacity != null && pvTotalCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
            eqHoursDay = egenValueDay.divide(pvTotalCapacity, 8, 0);
        }
        statOrgDayDo.setEqHoursDay(eqHoursDay);
        statOrgDayDo.setEqHoursAccum(eqHoursAccum);
        BigDecimal sscqValueDay = new BigDecimal("0.00000000");
        BigDecimal scdeValueDay = new BigDecimal("0.00000000");
        BigDecimal ssdeValueDay = new BigDecimal("0.00000000");
        BigDecimal sdaValueDay = new BigDecimal("0.00000000");
        BigDecimal sscqValueAccum = new BigDecimal("0.00000000");
        BigDecimal scdeValueAccum = new BigDecimal("0.00000000");
        BigDecimal ssdeValueAccum = new BigDecimal("0.00000000");
        BigDecimal sdaValueAccum = new BigDecimal("0.00000000");
        sscqValueDay = pvStationList.stream().filter(s -> s.getSscqValueDay() != null).map(PvStatPvstationDayDo::getSscqValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        scdeValueDay = pvStationList.stream().filter(s -> s.getScdeValueDay() != null).map(PvStatPvstationDayDo::getScdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        ssdeValueDay = pvStationList.stream().filter(s -> s.getSsdeValueDay() != null).map(PvStatPvstationDayDo::getSsdeValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        sdaValueDay = pvStationList.stream().filter(s -> s.getSdaValueDay() != null).map(PvStatPvstationDayDo::getSdaValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
        sscqValueAccum = pvStationList.stream().filter(s -> s.getSscqValueAccum() != null).map(PvStatPvstationDayDo::getSscqValueAccum).reduce(BigDecimal.ZERO, BigDecimal::add);
        scdeValueAccum = pvStationList.stream().filter(s -> s.getScdeValueAccum() != null).map(PvStatPvstationDayDo::getScdeValueAccum).reduce(BigDecimal.ZERO, BigDecimal::add);
        ssdeValueAccum = pvStationList.stream().filter(s -> s.getSsdeValueAccum() != null).map(PvStatPvstationDayDo::getSsdeValueAccum).reduce(BigDecimal.ZERO, BigDecimal::add);
        sdaValueAccum = pvStationList.stream().filter(s -> s.getSdaValueAccum() != null).map(PvStatPvstationDayDo::getSdaValueAccum).reduce(BigDecimal.ZERO, BigDecimal::add);
        statOrgDayDo.setSscqValueDay(sscqValueDay);
        statOrgDayDo.setScdeValueDay(scdeValueDay);
        statOrgDayDo.setSsdeValueDay(ssdeValueDay);
        statOrgDayDo.setSdaValueDay(sdaValueDay);
        statOrgDayDo.setSscqValueAccum(sscqValueAccum);
        statOrgDayDo.setScdeValueAccum(scdeValueAccum);
        statOrgDayDo.setSsdeValueAccum(ssdeValueAccum);
        statOrgDayDo.setSdaValueAccum(sdaValueAccum);
        statOrgDayDo.setPvstationCount(pvstationCount);
        statOrgDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
        if (pvStationList.get(0).getParentOrgNo() != null) {
            statOrgDayDo.setOrgNo(pvStationList.get(pvStationList.size() - 1).getParentOrgNo());
        } else {
            statOrgDayDo.setOrgNo(pvStationList.get(pvStationList.size() - 1).getOrgNo());
        }
        statOrgDayDo.setDateStat(new Date());
        statOrgDayDo.setGmtCreate(System.currentTimeMillis());
        statOrgDayDo.setGmtModified(System.currentTimeMillis());
        statOrgDayDo.setVersion(1);
        statOrgDayDo.setOrgNo(pvStationList.get(0).getOrgNo());
        return statOrgDayDo;
    }

    public Map<String, String> getFirstMonthOfYear() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Date date1 = new Date();
        String ret = DateConvertUtils.convertToString((Date)date1, (String)"yyyy-01-01");
        retMap.put("startDay", ret);
        return retMap;
    }

    public BigDecimal getBigdecimal(Object obj) {
        BigDecimal retBig = null;
        if (obj != null) {
            if (obj instanceof BigDecimal) {
                retBig = (BigDecimal)obj;
            } else if (obj instanceof String) {
                retBig = new BigDecimal((String)obj);
            } else if (obj instanceof BigInteger) {
                retBig = new BigDecimal((BigInteger)obj);
            } else if (obj instanceof Number) {
                retBig = new BigDecimal(((Number)obj).doubleValue());
            } else {
                throw new ClassCastException("\u65e0\u6cd5\u5c06 [" + obj + "] " + obj.getClass() + " \u8f6c\u6362\u4e3aBigDecimal.");
            }
        }
        return retBig;
    }

    public PvStatOrgDayDo getpvStatOrgDayDo(PvStatOrgDayDo pvStatOrgDayDo, PvStatOrgDayVo orgDayValue) {
        Map<String, Object> stringObjectMap = PvstatUtil.beanToMap(orgDayValue);
        for (int i = 0; i < 24; ++i) {
            if (stringObjectMap == null) continue;
            String name = String.format("egenValueH%02d", i);
            Object obj = stringObjectMap.get(name);
            BigDecimal bigdecimal = PvstatUtil.getBigdecimal(obj);
            try {
                BeanUtils.copyProperty((Object)pvStatOrgDayDo, (String)name, (Object)bigdecimal);
                continue;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return pvStatOrgDayDo;
    }
}

