/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cebase.entity.CeSourceDo;
import com.iesms.openservices.cebase.util.CommonUtils;
import com.iesms.openservices.cestat.dao.CeResourceCommonDao;
import com.iesms.openservices.pvstat.dao.PvStatPvstationDao;
import com.iesms.openservices.pvstat.dao.PvStatPvstationEloadDao;
import com.iesms.openservices.pvstat.entity.PvStatInverterEloadDayDo;
import com.iesms.openservices.pvstat.entity.PvStatPvstationEloadDayDo;
import com.iesms.openservices.pvstat.entity.PvStatPvstationEloadMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatPvstationEloadYearDo;
import com.iesms.openservices.pvstat.service.PvStatPvstationEloadService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PvStatPvstationEloadServiceImpl
extends AbstractIesmsBaseService
implements PvStatPvstationEloadService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private PvStatPvstationEloadDao pvStatPvstationEloadDao;
    @Resource
    private CeResourceCommonDao ceResourceCommonDao;
    @Resource
    private PvStatPvstationDao pvStatPvstationDao;

    public int insertOrUpdatePvStatPvstationEloadDayDo(Map<String, String> params) {
        if (params == null) {
            params = new HashMap<String, String>();
            params.put("dateStat", DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy-MM-dd"));
        }
        List orgInfoList = this.ceResourceCommonDao.getOrgInfo();
        ArrayList<PvStatPvstationEloadDayDo> pvstationEloadDayDoList = new ArrayList<PvStatPvstationEloadDayDo>();
        if (orgInfoList.size() > 0) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("HHmm");
            Map<String, String> finalParams = params;
            orgInfoList.forEach(orgNo -> {
                finalParams.put("orgNo", (String)orgNo);
                List<PvStatInverterEloadDayDo> inverterEloadDayDoList = this.pvStatPvstationEloadDao.getPvstationEloadDayFromInverterDay(finalParams);
                if (inverterEloadDayDoList.size() > 0) {
                    inverterEloadDayDoList.forEach(inverterEloadDayDo -> {
                        PvStatPvstationEloadDayDo pvStatPvstationEloadDayDo = new PvStatPvstationEloadDayDo();
                        try {
                            BeanUtils.copyProperties((Object)pvStatPvstationEloadDayDo, (Object)inverterEloadDayDo);
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            this.logger.error("pvStatPvstationEloadDayDo copy properties error" + e.getMessage());
                        }
                        Map<String, Object> stringObjectMap = PvstatUtil.beanToMap(pvStatPvstationEloadDayDo);
                        stringObjectMap = PvstatUtil.getMaxAndMinValue(stringObjectMap);
                        pvStatPvstationEloadDayDo = (PvStatPvstationEloadDayDo)JsonConvertUtils.convertFromString((String)JsonConvertUtils.convertToString(stringObjectMap), PvStatPvstationEloadDayDo.class);
                        pvStatPvstationEloadDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
                        pvStatPvstationEloadDayDo.setDateStat(new Date());
                        pvStatPvstationEloadDayDo.setGmtCreate(System.currentTimeMillis());
                        pvStatPvstationEloadDayDo.setGmtModified(System.currentTimeMillis());
                        pvStatPvstationEloadDayDo.setVersion(1);
                        HashMap<String, Long> propsMap = new HashMap<String, Long>();
                        propsMap.put("custId", pvStatPvstationEloadDayDo.getCeCustId());
                        CeSourceDo ceSourceDo = this.pvStatPvstationDao.getCustPropsByCustId(propsMap);
                        BigDecimal installCapacity = null;
                        if (ceSourceDo != null) {
                            installCapacity = ceSourceDo.getElecCapacity();
                        }
                        pvStatPvstationEloadDayDo.setPvCapacity(installCapacity);
                        pvstationEloadDayDoList.add(pvStatPvstationEloadDayDo);
                    });
                }
            });
        }
        if (pvstationEloadDayDoList.size() > 0) {
            try {
                this.pvStatPvstationEloadDao.insertOrUpdatePvStatPvstationEloadDay(pvstationEloadDayDoList);
            }
            catch (Exception e) {
                this.logger.error("insertOrUpdatePvStatPvstationEloadDay error: " + e.getMessage());
            }
        }
        return -1;
    }

    public int insertOrUpdatePvStatPvstationEloadMonthDo(Map<String, String> params) {
        if (params == null) {
            params = CommonUtils.getFirstDayAndLastDayOfMonth();
        }
        params.put("flag", "1");
        List<PvStatPvstationEloadDayDo> pvStatPvstationEloadMonth = this.pvStatPvstationEloadDao.getPvStatPvstationEloadMonthAndYear(params);
        ArrayList<PvStatPvstationEloadMonthDo> eloadMonthDoList = new ArrayList<PvStatPvstationEloadMonthDo>();
        if (pvStatPvstationEloadMonth.size() > 0) {
            PvStatPvstationEloadMonthDo eloadMonthDo = new PvStatPvstationEloadMonthDo();
            pvStatPvstationEloadMonth.parallelStream().filter(s -> s.getCeCustId() != null).collect(Collectors.groupingBy(PvStatPvstationEloadDayDo::getCeCustId)).forEach((ley, station) -> {
                int month = Integer.parseInt(new SimpleDateFormat("yyyyMM").format(new Date()));
                BigDecimal[] maxormin = new BigDecimal[]{null, null};
                Date[] date = new Date[]{null, null};
                for (int i = 0; i < station.size(); ++i) {
                    maxormin[0] = new BigDecimal("0.00000000");
                    maxormin[1] = new BigDecimal("0.00000000");
                    if (((PvStatPvstationEloadDayDo)station.get(i)).getMaxValue() != null && ((PvStatPvstationEloadDayDo)station.get(i)).getMaxValue().compareTo(maxormin[0]) == 1) {
                        maxormin[0] = ((PvStatPvstationEloadDayDo)station.get(i)).getMaxValue();
                        date[0] = ((PvStatPvstationEloadDayDo)station.get(i)).getMaxValueTime();
                    }
                    if (((PvStatPvstationEloadDayDo)station.get(i)).getMinValue() == null || ((PvStatPvstationEloadDayDo)station.get(i)).getMinValue().compareTo(maxormin[1]) != -1) continue;
                    maxormin[1] = ((PvStatPvstationEloadDayDo)station.get(i)).getMinValue();
                    date[1] = ((PvStatPvstationEloadDayDo)station.get(i)).getMinValueTime();
                }
                eloadMonthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                eloadMonthDo.setOrgNo(((PvStatPvstationEloadDayDo)pvStatPvstationEloadMonth.get(0)).getOrgNo());
                eloadMonthDo.setCeCustId(((PvStatPvstationEloadDayDo)pvStatPvstationEloadMonth.get(0)).getCeCustId());
                eloadMonthDo.setMonthStat(month);
                eloadMonthDo.setMaxValue(maxormin[0]);
                eloadMonthDo.setMaxValueTime(date[0]);
                eloadMonthDo.setMinValue(maxormin[1]);
                eloadMonthDo.setMinValueTime(date[1]);
                eloadMonthDo.setPvCapacity(((PvStatPvstationEloadDayDo)pvStatPvstationEloadMonth.get(0)).getPvCapacity());
                eloadMonthDo.setGmtCreate(System.currentTimeMillis());
                eloadMonthDo.setGmtModified(System.currentTimeMillis());
                eloadMonthDo.setVersion(1);
                eloadMonthDoList.add(eloadMonthDo);
            });
        }
        if (pvStatPvstationEloadMonth.size() > 0) {
            return this.pvStatPvstationEloadDao.insertOrUpdatePvStatPvstationEloadMonth(eloadMonthDoList);
        }
        return -1;
    }

    public int insertOrUpdatePvStatPvstationEloadYearDo(Map<String, String> params) {
        if (params == null) {
            params = this.getFirstMonthOfYear();
        }
        params.put("flag", "2");
        List<PvStatPvstationEloadDayDo> pvStatPvstationEloadYear = this.pvStatPvstationEloadDao.getPvStatPvstationEloadMonthAndYear(params);
        ArrayList<PvStatPvstationEloadYearDo> eloadYearDoList = new ArrayList<PvStatPvstationEloadYearDo>();
        if (pvStatPvstationEloadYear.size() > 0) {
            PvStatPvstationEloadYearDo eloadYearDo = new PvStatPvstationEloadYearDo();
            pvStatPvstationEloadYear.parallelStream().filter(s -> s.getCeCustId() != null).collect(Collectors.groupingBy(PvStatPvstationEloadDayDo::getCeCustId)).forEach((ley, station) -> {
                int year = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
                BigDecimal[] maxormin = new BigDecimal[]{null, null};
                Date[] date = new Date[]{null, null};
                for (int i = 0; i < station.size(); ++i) {
                    maxormin[0] = new BigDecimal("0.00000000");
                    maxormin[1] = new BigDecimal("0.00000000");
                    if (((PvStatPvstationEloadDayDo)station.get(i)).getMaxValue() != null && ((PvStatPvstationEloadDayDo)station.get(i)).getMaxValue().compareTo(maxormin[0]) == 1) {
                        maxormin[0] = ((PvStatPvstationEloadDayDo)station.get(i)).getMaxValue();
                        date[0] = ((PvStatPvstationEloadDayDo)station.get(i)).getMaxValueTime();
                    }
                    if (((PvStatPvstationEloadDayDo)station.get(i)).getMinValue() == null || ((PvStatPvstationEloadDayDo)station.get(i)).getMinValue().compareTo(maxormin[1]) != -1) continue;
                    maxormin[1] = ((PvStatPvstationEloadDayDo)station.get(i)).getMinValue();
                    date[1] = ((PvStatPvstationEloadDayDo)station.get(i)).getMinValueTime();
                }
                eloadYearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                eloadYearDo.setOrgNo(((PvStatPvstationEloadDayDo)pvStatPvstationEloadYear.get(0)).getOrgNo());
                eloadYearDo.setCeCustId(((PvStatPvstationEloadDayDo)pvStatPvstationEloadYear.get(0)).getCeCustId());
                eloadYearDo.setYearStat(year);
                eloadYearDo.setMaxValue(maxormin[0]);
                eloadYearDo.setMaxValueTime(date[0]);
                eloadYearDo.setMinValue(maxormin[1]);
                eloadYearDo.setMinValueTime(date[1]);
                eloadYearDo.setPvCapacity(((PvStatPvstationEloadDayDo)pvStatPvstationEloadYear.get(0)).getPvCapacity());
                eloadYearDo.setGmtCreate(System.currentTimeMillis());
                eloadYearDo.setGmtModified(System.currentTimeMillis());
                eloadYearDo.setVersion(1);
                eloadYearDoList.add(eloadYearDo);
            });
        }
        if (pvStatPvstationEloadYear.size() > 0) {
            return this.pvStatPvstationEloadDao.insertPvStatPvstationEloadYear(eloadYearDoList);
        }
        return -1;
    }

    public Map<String, String> getFirstMonthOfYear() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Date date1 = new Date();
        String ret = DateConvertUtils.convertToString((Date)date1, (String)"yyyy-01-01");
        retMap.put("startDay", ret);
        return retMap;
    }
}

