/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.pvstat.service.impl;

import com.easesource.commons.util.BeanUtils;
import com.easesource.commons.util.convert.DateConvertUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.openservices.base.service.AbstractIesmsBaseService;
import com.iesms.openservices.cebase.entity.CeSourceDo;
import com.iesms.openservices.pvstat.dao.PvStatPvstationDao;
import com.iesms.openservices.pvstat.entity.PvStatGenwattmeterDayDo;
import com.iesms.openservices.pvstat.entity.PvStatInverterDayDo;
import com.iesms.openservices.pvstat.entity.PvStatPvstationDayDo;
import com.iesms.openservices.pvstat.entity.PvStatPvstationMonthDo;
import com.iesms.openservices.pvstat.entity.PvStatPvstationYearDo;
import com.iesms.openservices.pvstat.service.PvStatPvstationService;
import com.iesms.openservices.pvstat.util.PvstatUtil;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PvStatPvstationServiceImpl
extends AbstractIesmsBaseService
implements PvStatPvstationService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private PvStatPvstationDao pvStatPvstationDao;

    @Autowired
    public PvStatPvstationServiceImpl(PvStatPvstationDao pvStatPvstationDao) {
        this.pvStatPvstationDao = pvStatPvstationDao;
    }

    public int insertOrUpdatePvStatPvstationDayDo(Map<String, String> params) {
        String dateStat = params.get("dateStat");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date[] dates = new Date[]{null, new Date()};
        if (dateStat != null) {
            try {
                dates[0] = simpleDateFormat.parse(dateStat);
            }
            catch (ParseException e) {
                this.logger.error("insertOrUpdatePvStatPvstationDayDo date parse exception:" + e.getMessage());
            }
        }
        List<PvStatPvstationDayDo> getInitCustMessage = this.pvStatPvstationDao.getInitCustMessage();
        ArrayList<PvStatPvstationDayDo> initPvStatPvstationDayDoList = new ArrayList<PvStatPvstationDayDo>();
        List<PvStatPvstationDayDo> pvstationDayDoList = new ArrayList<PvStatPvstationDayDo>();
        HashSet<String> orgNoSet = new HashSet<String>();
        if (!CollectionUtils.isEmpty(getInitCustMessage)) {
            for (PvStatPvstationDayDo pvStatPvstationDayDo : getInitCustMessage) {
                pvStatPvstationDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
                pvStatPvstationDayDo.setDateStat(dates[0] == null ? dates[1] : dates[0]);
                pvStatPvstationDayDo.setGmtCreate(System.currentTimeMillis());
                pvStatPvstationDayDo.setGmtModified(System.currentTimeMillis());
                pvStatPvstationDayDo.setVersion(1);
                BigDecimal bigDecimal = new BigDecimal("0.00000000");
                pvStatPvstationDayDo.setSscqValueDay(bigDecimal);
                pvStatPvstationDayDo.setScdeValueDay(bigDecimal);
                pvStatPvstationDayDo.setSsdeValueDay(bigDecimal);
                pvStatPvstationDayDo.setSdaValueDay(bigDecimal);
                pvStatPvstationDayDo.setSscqValueAccum(bigDecimal);
                pvStatPvstationDayDo.setScdeValueAccum(bigDecimal);
                pvStatPvstationDayDo.setSsdeValueAccum(bigDecimal);
                pvStatPvstationDayDo.setSdaValueAccum(bigDecimal);
                pvStatPvstationDayDo.setStatSource(1);
                initPvStatPvstationDayDoList.add(pvStatPvstationDayDo);
                String orgNo = pvStatPvstationDayDo.getOrgNo();
                if (orgNoSet.contains(orgNo)) continue;
                params.put("orgNo", orgNo);
                List<PvStatInverterDayDo> pvStatInverterDayDoList = this.pvStatPvstationDao.getStationDayValueFromInveter(params);
                List<PvStatGenwattmeterDayDo> pvStatGenwattmeterDayDoList = this.pvStatPvstationDao.getStationDayValueFromGenwatt(params);
                if (pvStatInverterDayDoList != null && pvStatInverterDayDoList.size() > 0 || pvStatGenwattmeterDayDoList != null && pvStatGenwattmeterDayDoList.size() > 0) {
                    if (pvStatInverterDayDoList != null && pvStatInverterDayDoList.size() > 0) {
                        pvstationDayDoList = this.getInveterValue(pvStatInverterDayDoList, pvstationDayDoList, dates);
                    }
                    if (pvStatGenwattmeterDayDoList != null && pvStatGenwattmeterDayDoList.size() > 0) {
                        pvstationDayDoList = this.geGenwattmeterValue(pvStatGenwattmeterDayDoList, pvstationDayDoList, dates);
                    }
                }
                orgNoSet.add(orgNo);
            }
        }
        if (initPvStatPvstationDayDoList.size() > 0) {
            try {
                this.pvStatPvstationDao.insertInitStationOrUpdate(initPvStatPvstationDayDoList);
            }
            catch (Exception e) {
                this.logger.error("insertInitStationOrUpdateError :" + e.getMessage());
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(" >>>>>> start insertOrUpdatePvStatPvstationDayDo >>>>>> ");
        }
        if (pvstationDayDoList.size() > 0) {
            try {
                this.pvStatPvstationDao.insertOrUpdatePvStatPvstationDayDo(pvstationDayDoList);
                for (PvStatPvstationDayDo pvStatPvstationDayDo : pvstationDayDoList) {
                    HashMap<String, String> upMap = new HashMap<String, String>();
                    upMap.put("orgNo", pvStatPvstationDayDo.getOrgNo());
                    upMap.put("ceCustId", String.valueOf(pvStatPvstationDayDo.getCeCustId()));
                    upMap.put("dateStat", params.get("dateStat"));
                    this.pvStatPvstationDao.updatePvStationDayDo(upMap);
                }
            }
            catch (Exception e) {
                this.logger.error("insertOrUpdatePvStatPvstationDayDo error :" + e.getMessage());
            }
        }
        return -1;
    }

    private List<PvStatPvstationDayDo> getInveterValue(List<PvStatInverterDayDo> pvStatInverterDayDoList, List<PvStatPvstationDayDo> pvstationDayDoList, Date[] dates) {
        if (pvStatInverterDayDoList != null && pvStatInverterDayDoList.size() > 0) {
            for (PvStatInverterDayDo pvStatInverterDayDo : pvStatInverterDayDoList) {
                HashMap<String, Long> propsMap = new HashMap<String, Long>();
                Long ceCustId = pvStatInverterDayDo.getCeCustId();
                BigDecimal installCapacity = null;
                if (ceCustId != null) {
                    propsMap.put("custId", ceCustId);
                    CeSourceDo ceSourceDo = this.pvStatPvstationDao.getCustPropsByCustId(propsMap);
                    if (ceSourceDo != null) {
                        installCapacity = ceSourceDo.getElecCapacity();
                    }
                }
                PvStatPvstationDayDo pvstationDayDo = new PvStatPvstationDayDo();
                try {
                    BeanUtils.copyProperties((Object)pvstationDayDo, (Object)pvStatInverterDayDo);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    this.logger.error("pvStatInverterDayDo proper copy : " + e.getMessage());
                }
                pvstationDayDo.setId(Long.valueOf(this.idGenerator.nextId()));
                pvstationDayDo.setDateStat(dates[0] == null ? dates[1] : dates[0]);
                pvstationDayDo.setStatSource(2);
                pvstationDayDo.setGmtCreate(System.currentTimeMillis());
                pvstationDayDo.setGmtModified(System.currentTimeMillis());
                pvstationDayDo.setVersion(1);
                pvstationDayDo.setPvCapacity(installCapacity);
                if (pvStatInverterDayDo.getEgenValueDay() != null && installCapacity != null && installCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
                    BigDecimal eqHoursDay = pvStatInverterDayDo.getEgenValueDay().divide(installCapacity, 8, 0);
                    pvstationDayDo.setEqHoursDay(eqHoursDay);
                }
                if (pvStatInverterDayDo.getEgenValueAccum() != null && installCapacity != null && installCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
                    BigDecimal eqHoursAccum = pvStatInverterDayDo.getEgenValueAccum().divide(installCapacity, 8, 0);
                    pvstationDayDo.setEqHoursAccum(eqHoursAccum);
                }
                pvstationDayDoList.add(pvstationDayDo);
            }
        }
        return pvstationDayDoList;
    }

    private List<PvStatPvstationDayDo> geGenwattmeterValue(List<PvStatGenwattmeterDayDo> pvStatGenwattmeterDayDoList, List<PvStatPvstationDayDo> pvstationDayDoList, Date[] dates) {
        List<PvStatGenwattmeterDayDo> gList = pvStatGenwattmeterDayDoList;
        List<PvStatPvstationDayDo> pList = pvstationDayDoList;
        for (PvStatGenwattmeterDayDo genwattmeterDayDo : pvStatGenwattmeterDayDoList) {
            HashMap<String, Long> propsMap = new HashMap<String, Long>();
            Long ceCustId = genwattmeterDayDo.getCeCustId();
            BigDecimal installCapacity = null;
            if (ceCustId != null) {
                propsMap.put("custId", ceCustId);
                CeSourceDo ceSourceDo = this.pvStatPvstationDao.getCustPropsByCustId(propsMap);
                if (ceSourceDo != null) {
                    installCapacity = ceSourceDo.getElecCapacity();
                }
            }
            PvStatPvstationDayDo pvstationDayDo1 = new PvStatPvstationDayDo();
            try {
                BeanUtils.copyProperties((Object)pvstationDayDo1, (Object)genwattmeterDayDo);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                this.logger.error("genwattmeterDayDo proper copy error" + e.getMessage());
            }
            pvstationDayDo1.setId(Long.valueOf(this.idGenerator.nextId()));
            pvstationDayDo1.setDateStat(dates[0] == null ? dates[1] : dates[0]);
            pvstationDayDo1.setStatSource(1);
            pvstationDayDo1.setGmtCreate(System.currentTimeMillis());
            pvstationDayDo1.setGmtModified(System.currentTimeMillis());
            pvstationDayDo1.setVersion(1);
            pvstationDayDo1.setPvCapacity(installCapacity);
            if (genwattmeterDayDo.getEgenValueDay() != null && installCapacity != null && installCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
                BigDecimal eqHoursDay = genwattmeterDayDo.getEgenValueDay().divide(installCapacity, 8, 0);
                pvstationDayDo1.setEqHoursDay(eqHoursDay);
            }
            if (genwattmeterDayDo.getEgenValueAccum() != null && installCapacity != null && installCapacity.compareTo(BigDecimal.valueOf(0L)) > 0) {
                BigDecimal eqHoursAccum = genwattmeterDayDo.getEgenValueAccum().divide(installCapacity, 8, 0);
                pvstationDayDo1.setEqHoursAccum(eqHoursAccum);
            }
            if (pvstationDayDoList != null && pvstationDayDoList.size() > 0) {
                for (PvStatPvstationDayDo pvstationDayDo : pvstationDayDoList) {
                    if (genwattmeterDayDo.getCeCustId().compareTo(pvstationDayDo.getCeCustId()) != 0 || pvstationDayDo1.getEgenValueDay() == null || pvstationDayDo1.getEgenValueDay().compareTo(new BigDecimal("0")) <= 0) continue;
                    pvstationDayDoList.remove(pvstationDayDo);
                    break;
                }
            }
            if (pvstationDayDo1.getEgenValueDay() == null || pvstationDayDo1.getEgenValueDay().compareTo(new BigDecimal("0")) <= 0) continue;
            pvstationDayDoList.add(pvstationDayDo1);
        }
        return pvstationDayDoList;
    }

    public int insertOrUpdatePvStatPvstationMonthDo(Map<String, String> params) {
        params.put("flag", "1");
        List<PvStatPvstationDayDo> statPvstationDayDoList = this.pvStatPvstationDao.getPvstationFromStationDay(params);
        ArrayList<PvStatPvstationMonthDo> statPvstationMonthDoList = new ArrayList<PvStatPvstationMonthDo>();
        if (statPvstationDayDoList.size() > 0) {
            statPvstationDayDoList.stream().collect(Collectors.groupingBy(PvStatPvstationDayDo::getCeCustId)).forEach((key, dayDoList) -> {
                int size = dayDoList.size();
                if (size > 0) {
                    PvStatPvstationMonthDo stationMonthDo = new PvStatPvstationMonthDo();
                    BigDecimal egenValueMonth = dayDoList.stream().filter(s -> s.getEgenValueDay() != null).map(PvStatPvstationDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal pvProfitTotalMonth = dayDoList.stream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatPvstationDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal moneySubsidyTotalMonth = dayDoList.stream().filter(s -> s.getMoneySubsidyTotalDay() != null).map(p -> p.getMoneySubsidyTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> moneySubsidyDetailMonthList = dayDoList.stream().filter(s -> s.getMoneySubsidyDetailDay() != null).map(p -> p.getMoneySubsidyDetailDay()).collect(Collectors.toList());
                    BigDecimal moneySubsidyTotalAccum = dayDoList.stream().filter(s -> s.getMoneySubsidyTotalAccum() != null).map(p -> p.getMoneySubsidyTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> moneySubsidyDetailMonthAccumList = dayDoList.stream().filter(s -> s.getMoneySubsidyDetailAccum() != null).map(p -> p.getMoneySubsidyDetailAccum()).collect(Collectors.toList());
                    String moneySubsidyDetailMonth = null;
                    String moneySubsidyDetailMonthAccum = null;
                    if (moneySubsidyDetailMonthList.size() > 0) {
                        moneySubsidyDetailMonth = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailMonthList);
                    }
                    if (moneySubsidyDetailMonthAccumList.size() > 0) {
                        moneySubsidyDetailMonthAccum = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailMonthAccumList);
                    }
                    BigDecimal moneyOnlineGridTotalMonth = dayDoList.stream().filter(s -> s.getMoneyOnlineGridTotalDay() != null).map(p -> p.getMoneyOnlineGridTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List moneyOnlineGridDetailMonthList = dayDoList.stream().filter(s -> s.getMoneyOnlineGridDetailDay() != null).map(p -> p.getMoneyOnlineGridDetailDay()).collect(Collectors.toList());
                    String moneyOnlineGridDetailMonth = null;
                    if (moneyOnlineGridDetailMonthList.size() > 0) {
                        moneyOnlineGridDetailMonth = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailMonthList);
                    }
                    BigDecimal moneySelfUseTotalMonth = dayDoList.stream().filter(s -> s.getMoneySelfUseTotalDay() != null).map(p -> p.getMoneySelfUseTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> moneySelfUseDetailMonthList = dayDoList.stream().filter(s -> s.getMoneySelfUseDetailDay() != null).map(p -> p.getMoneySelfUseDetailDay()).collect(Collectors.toList());
                    String moneySelfUseDetailMonth = null;
                    if (moneySelfUseDetailMonthList.size() > 0) {
                        moneySelfUseDetailMonth = PvstatUtil.getpvProfitDetail2(moneySelfUseDetailMonthList);
                    }
                    stationMonthDo.setStartEgenValueMonth(((PvStatPvstationDayDo)dayDoList.get(0)).getStartEgenValueDay());
                    if (size == 1) {
                        stationMonthDo.setEndEgenValueMonth(((PvStatPvstationDayDo)dayDoList.get(0)).getEndEgenValueDay());
                    } else {
                        stationMonthDo.setEndEgenValueMonth(((PvStatPvstationDayDo)dayDoList.get(size - 1)).getEndEgenValueDay());
                    }
                    BigDecimal pvCapacity = ((PvStatPvstationDayDo)dayDoList.get(dayDoList.size() - 1)).getPvCapacity();
                    BigDecimal eqHoursMonth = dayDoList.parallelStream().filter(s -> s.getEqHoursDay() != null).map(s -> s.getEqHoursDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sscqValueMonth = dayDoList.stream().filter(s -> s.getSscqValueDay() != null).map(p -> p.getSscqValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal scdeValueMonth = dayDoList.stream().filter(s -> s.getScdeValueDay() != null).map(p -> p.getScdeValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal ssdeValueMonth = dayDoList.stream().filter(s -> s.getSsdeValueDay() != null).map(p -> p.getSsdeValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sdaValueMonth = dayDoList.stream().filter(s -> s.getSdaValueDay() != null).map(p -> p.getSdaValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    stationMonthDo.setId(Long.valueOf(this.idGenerator.nextId()));
                    Long ceCustId = ((PvStatPvstationDayDo)dayDoList.get(0)).getCeCustId();
                    String orgNoByCustId = this.pvStatPvstationDao.getOrgNoByCustId(String.valueOf(ceCustId));
                    stationMonthDo.setOrgNo(orgNoByCustId);
                    stationMonthDo.setCeCustId(ceCustId);
                    stationMonthDo.setMonthStat(Integer.parseInt(DateConvertUtils.convertToString((Date)new Date(), (String)"yyyyMM")));
                    stationMonthDo.setEgenValueMonth(egenValueMonth);
                    stationMonthDo.setPvProfitTotalMonth(pvProfitTotalMonth);
                    stationMonthDo.setMoneySubsidyTotalMonth(moneySubsidyTotalMonth);
                    stationMonthDo.setMoneySubsidyDetailMonth(moneySubsidyDetailMonth);
                    stationMonthDo.setMoneyOnlineGridTotalMonth(moneyOnlineGridTotalMonth);
                    stationMonthDo.setMoneyOnlineGridDetailMonth(moneyOnlineGridDetailMonth);
                    stationMonthDo.setMoneySelfUseTotalMonth(moneySelfUseTotalMonth);
                    stationMonthDo.setMoneySelfUseDetailMonth(moneySelfUseDetailMonth);
                    stationMonthDo.setPvCapacity(pvCapacity);
                    stationMonthDo.setEqHoursMonth(eqHoursMonth);
                    stationMonthDo.setSscqValueMonth(sscqValueMonth);
                    stationMonthDo.setScdeValueMonth(scdeValueMonth);
                    stationMonthDo.setSsdeValueMonth(ssdeValueMonth);
                    stationMonthDo.setSdaValueMonth(sdaValueMonth);
                    stationMonthDo.setStatSource(((PvStatPvstationDayDo)dayDoList.get(0)).getStatSource());
                    stationMonthDo.setGmtCreate(System.currentTimeMillis());
                    stationMonthDo.setGmtModified(System.currentTimeMillis());
                    stationMonthDo.setVersion(1);
                    statPvstationMonthDoList.add(stationMonthDo);
                }
            });
        }
        if (statPvstationMonthDoList.size() > 0) {
            return this.pvStatPvstationDao.insertOrUpdatePvStatPvstationMonthDo(statPvstationMonthDoList);
        }
        return -1;
    }

    public int insertOrUpdatePvStatPvstationYearDo(Map<String, String> params) {
        params.put("flag", "2");
        List<PvStatPvstationDayDo> statPvstationDayDoList = this.pvStatPvstationDao.getPvstationFromStationDay(params);
        ArrayList<PvStatPvstationYearDo> statPvstationYearDoList = new ArrayList<PvStatPvstationYearDo>();
        if (statPvstationDayDoList.size() > 0) {
            statPvstationDayDoList.stream().collect(Collectors.groupingBy(PvStatPvstationDayDo::getCeCustId)).forEach((key, dayDoList) -> {
                int size = dayDoList.size();
                if (size > 0) {
                    PvStatPvstationYearDo stationYearDo = new PvStatPvstationYearDo();
                    BigDecimal egenValueYear = dayDoList.stream().filter(s -> s.getEgenValueDay() != null).map(PvStatPvstationDayDo::getEgenValueDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal pvProfitTotalYear = dayDoList.stream().filter(s -> s.getPvProfitTotalDay() != null).map(PvStatPvstationDayDo::getPvProfitTotalDay).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal moneySubsidyTotalYear = dayDoList.stream().filter(s -> s.getMoneySubsidyTotalDay() != null).map(p -> p.getMoneySubsidyTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> moneySubsidyDetailYearList = dayDoList.stream().filter(s -> s.getMoneySubsidyDetailDay() != null).map(p -> p.getMoneySubsidyDetailDay()).collect(Collectors.toList());
                    BigDecimal moneySubsidyTotalAccum = dayDoList.stream().filter(s -> s.getMoneySubsidyTotalAccum() != null).map(p -> p.getMoneySubsidyTotalAccum()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> moneySubsidyDetailYearAccumList = dayDoList.stream().filter(s -> s.getMoneySubsidyDetailAccum() != null).map(p -> p.getMoneySubsidyDetailAccum()).collect(Collectors.toList());
                    String moneySubsidyDetailYear = null;
                    String moneySubsidyDetailYearAccum = null;
                    if (moneySubsidyDetailYearList.size() > 0) {
                        moneySubsidyDetailYear = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailYearList);
                    }
                    if (moneySubsidyDetailYearAccumList.size() > 0) {
                        moneySubsidyDetailYearAccum = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailYearAccumList);
                    }
                    BigDecimal moneyOnlineGridTotalYear = dayDoList.stream().filter(s -> s.getMoneyOnlineGridTotalDay() != null).map(p -> p.getMoneyOnlineGridTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List moneyOnlineGridDetailYearList = dayDoList.stream().filter(s -> s.getMoneyOnlineGridDetailDay() != null).map(p -> p.getMoneyOnlineGridDetailDay()).collect(Collectors.toList());
                    String moneyOnlineGridDetailYear = null;
                    if (moneyOnlineGridDetailYearList.size() > 0) {
                        moneyOnlineGridDetailYear = PvstatUtil.getpvProfitDetail2(moneySubsidyDetailYearList);
                    }
                    BigDecimal moneySelfUseTotalYear = dayDoList.stream().filter(s -> s.getMoneySelfUseTotalDay() != null).map(p -> p.getMoneySelfUseTotalDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    List<String> moneySelfUseDetailYearList = dayDoList.stream().filter(s -> s.getMoneySelfUseDetailDay() != null).map(p -> p.getMoneySelfUseDetailDay()).collect(Collectors.toList());
                    String moneySelfUseDetailYear = null;
                    if (moneySelfUseDetailYearList.size() > 0) {
                        moneySelfUseDetailYear = PvstatUtil.getpvProfitDetail2(moneySelfUseDetailYearList);
                    }
                    stationYearDo.setStartEgenValueYear(((PvStatPvstationDayDo)dayDoList.get(0)).getStartEgenValueDay());
                    if (size == 1) {
                        stationYearDo.setEndEgenValueYear(((PvStatPvstationDayDo)dayDoList.get(0)).getEndEgenValueDay());
                    } else {
                        stationYearDo.setEndEgenValueYear(((PvStatPvstationDayDo)dayDoList.get(size - 1)).getEndEgenValueDay());
                    }
                    BigDecimal pvCapacity = ((PvStatPvstationDayDo)dayDoList.get(dayDoList.size() - 1)).getPvCapacity();
                    BigDecimal eqHoursYear = dayDoList.parallelStream().filter(s -> s.getEqHoursDay() != null).map(s -> s.getEqHoursDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sscqValueYear = dayDoList.stream().filter(s -> s.getSscqValueDay() != null).map(p -> p.getSscqValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal scdeValueYear = dayDoList.stream().filter(s -> s.getScdeValueDay() != null).map(p -> p.getScdeValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal ssdeValueYear = dayDoList.stream().filter(s -> s.getSsdeValueDay() != null).map(p -> p.getSsdeValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    BigDecimal sdaValueYear = dayDoList.stream().filter(s -> s.getSdaValueDay() != null).map(p -> p.getSdaValueDay()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    stationYearDo.setId(Long.valueOf(this.idGenerator.nextId()));
                    Long ceCustId = ((PvStatPvstationDayDo)dayDoList.get(0)).getCeCustId();
                    String orgNoByCustId = this.pvStatPvstationDao.getOrgNoByCustId(String.valueOf(ceCustId));
                    stationYearDo.setOrgNo(orgNoByCustId);
                    stationYearDo.setCeCustId(ceCustId);
                    stationYearDo.setYearStat(Integer.parseInt(DateConvertUtils.convertToString((Date)new Date(), (String)"yyyy")));
                    stationYearDo.setEgenValueYear(egenValueYear);
                    stationYearDo.setPvProfitTotalYear(pvProfitTotalYear);
                    stationYearDo.setMoneySubsidyTotalYear(moneySubsidyTotalYear);
                    stationYearDo.setMoneySubsidyDetailYear(moneySubsidyDetailYear);
                    stationYearDo.setMoneyOnlineGridTotalYear(moneyOnlineGridTotalYear);
                    stationYearDo.setMoneyOnlineGridDetailYear(moneyOnlineGridDetailYear);
                    stationYearDo.setMoneySelfUseTotalYear(moneySelfUseTotalYear);
                    stationYearDo.setMoneySelfUseDetailYear(moneySelfUseDetailYear);
                    stationYearDo.setPvCapacity(pvCapacity);
                    stationYearDo.setEqHoursYear(eqHoursYear);
                    stationYearDo.setSscqValueYear(sscqValueYear);
                    stationYearDo.setScdeValueYear(scdeValueYear);
                    stationYearDo.setSsdeValueYear(ssdeValueYear);
                    stationYearDo.setSdaValueYear(sdaValueYear);
                    stationYearDo.setStatSource(((PvStatPvstationDayDo)dayDoList.get(0)).getStatSource());
                    stationYearDo.setGmtCreate(System.currentTimeMillis());
                    stationYearDo.setGmtModified(System.currentTimeMillis());
                    stationYearDo.setVersion(1);
                    statPvstationYearDoList.add(stationYearDo);
                }
            });
        }
        if (statPvstationYearDoList.size() > 0) {
            this.pvStatPvstationDao.insertOrUpdatePvStatPvstationYearDo(statPvstationYearDoList);
            HashMap<String, String> yMap = new HashMap<String, String>();
            yMap.put("dateStat", params.get("dateStat"));
            for (PvStatPvstationYearDo pvstationYearDo : statPvstationYearDoList) {
                yMap.put("ceCustId", String.valueOf(pvstationYearDo.getCeCustId()));
                this.pvStatPvstationDao.updatePvStatYearValue(yMap);
            }
        }
        return -1;
    }

    private BigDecimal getCapacity(String capacity) {
        String inverterCapacity = String.valueOf(((Map)JsonConvertUtils.convertFromString((String)capacity, Map.class)).get("installCapacity"));
        BigDecimal inverterCapacity2 = (BigDecimal)JsonConvertUtils.convertFromString((String)inverterCapacity, BigDecimal.class);
        return inverterCapacity2;
    }

    public Map<String, String> getFirstMonthOfYear() {
        HashMap<String, String> retMap = new HashMap<String, String>();
        Date date1 = new Date();
        String ret = DateConvertUtils.convertToString((Date)date1, (String)"yyyy-01-01");
        retMap.put("startDay", ret);
        return retMap;
    }
}

