/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.openservices.pvstat.util;

import com.easesource.commons.util.convert.JsonConvertUtils;
import java.beans.PropertyDescriptor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PvstatUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public static int getCurrentMonthLastDay() {
        Calendar a = Calendar.getInstance();
        a.set(5, 1);
        a.roll(5, -1);
        int maxDate = a.get(5);
        return maxDate;
    }

    public static Map<String, Object> beanToMap(Object obj) {
        HashMap<String, Object> params = new HashMap<String, Object>(0);
        try {
            PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
            PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(obj);
            for (int i = 0; i < descriptors.length; ++i) {
                String name = descriptors[i].getName();
                if ("class".equals(name)) continue;
                params.put(name, propertyUtilsBean.getNestedProperty(obj, name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return params;
    }

    public static Map<String, BigDecimal> getpvProfitDetail(String[] keys, Map<String, BigDecimal> detailMap, List<String> detailList) {
        detailList.forEach(detail -> {
            if (null != detail) {
                Map detailMap1 = (Map)JsonConvertUtils.convertFromString((String)detail, Map.class);
                Arrays.asList(keys).forEach(key -> {
                    if (detailMap1.containsKey(key)) {
                        detailMap.put((String)key, ((BigDecimal)detailMap.get(key)).add((BigDecimal)detailMap1.get(key)));
                    }
                });
            }
        });
        return detailMap;
    }

    public static Map<String, Object> getpvProfitDetail1(String pvbParams, BigDecimal egenValueDay, BigDecimal endEgenValueDay) {
        Map detailMap;
        HashMap<String, Object> retMap = new HashMap<String, Object>();
        String detailDay = null;
        String detailAccus = null;
        BigDecimal[] totalMoney = new BigDecimal[]{null, null};
        if (null != pvbParams && (detailMap = (Map)JsonConvertUtils.convertFromString((String)pvbParams, Map.class)).size() > 0) {
            HashMap egenValueMap = new HashMap();
            HashMap endEgenValueMap = new HashMap();
            totalMoney[0] = new BigDecimal("0.00000000");
            totalMoney[1] = new BigDecimal("0.00000000");
            detailMap.forEach((k, v) -> {
                if (v != null) {
                    String v1 = (String)v;
                    v1.replaceAll("\\\\", "");
                    if (v1.equals("") || v1.equals(" ")) {
                        return;
                    }
                    BigDecimal bigdecimal = PvstatUtil.getBigdecimal(v);
                    if (egenValueDay != null && bigdecimal != null) {
                        egenValueMap.put((String)k, egenValueDay.multiply(bigdecimal));
                        totalMoney[0] = totalMoney[0].add(egenValueDay.multiply(bigdecimal));
                    }
                    if (endEgenValueDay != null && bigdecimal != null) {
                        endEgenValueMap.put((String)k, endEgenValueDay.multiply(bigdecimal));
                        totalMoney[1] = totalMoney[1].add(endEgenValueDay.multiply(bigdecimal));
                    }
                }
            });
            detailDay = JsonConvertUtils.convertToString(egenValueMap);
            detailAccus = JsonConvertUtils.convertToString(endEgenValueMap);
        }
        retMap.put("detailDay", detailDay);
        retMap.put("detailAccus", detailAccus);
        retMap.put("totalDay", totalMoney[0]);
        retMap.put("totalAccus", totalMoney[1]);
        return retMap;
    }

    public static String getpvProfitDetail2(List<String> detailList) {
        HashMap profitDetailMap = new HashMap();
        detailList.forEach(detail -> {
            if (null != detail) {
                String detail1 = detail;
                detail1 = detail1.replaceAll("\\\\", "");
                Map detailMap = (Map)JsonConvertUtils.convertFromString((String)detail1, Map.class);
                detailMap.forEach((k, v) -> {
                    if (v.equals("")) {
                        return;
                    }
                    BigDecimal value = PvstatUtil.getBigdecimal(v);
                    if (value != null) {
                        value = value.setScale(8, 4);
                    }
                    if (profitDetailMap.containsKey((String)k) && value != null) {
                        profitDetailMap.put((String)k, ((BigDecimal)profitDetailMap.get(k)).add(value));
                    } else {
                        profitDetailMap.put((String)k, value);
                    }
                });
            }
        });
        if (profitDetailMap.size() > 0) {
            return JsonConvertUtils.convertToString(profitDetailMap);
        }
        return null;
    }

    public static Map<String, BigDecimal> getProfitDetail(int type, String pvbParams, BigDecimal egenValueDay, BigDecimal egenValueaccum) {
        BigDecimal pvProfitTotalDay = null;
        BigDecimal pvProfitTotalAccum = null;
        if (null != pvbParams) {
            Map map = (Map)JsonConvertUtils.convertFromString((String)pvbParams, Map.class);
            if (type == 1) {
                pvProfitTotalDay = new BigDecimal("0.00000000");
                pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal)map.get("price_subsidy_country")));
                pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal)map.get("price_subsidy_province")));
                pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal)map.get("price_subsidy_city")));
                pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal)map.get("price_subsidy_district")));
                pvProfitTotalAccum = new BigDecimal("0.00000000");
                pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal)map.get("price_subsidy_country")));
                pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal)map.get("price_subsidy_province")));
                pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal)map.get("price_subsidy_city")));
                pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal)map.get("price_subsidy_district")));
            } else if (type == 2) {
                pvProfitTotalDay = new BigDecimal("0.00000000");
                pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal)map.get("price_online_grid")));
                pvProfitTotalAccum = new BigDecimal("0.00000000");
                pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal)map.get("price_online_grid")));
            } else if (type == 3) {
                if (map.containsValue("single")) {
                    pvProfitTotalDay = new BigDecimal("0.00000000");
                    pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal)map.get("price_online_grid")));
                    pvProfitTotalAccum = new BigDecimal("0.00000000");
                    pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal)map.get("price_online_grid")));
                } else if (map.containsValue("multi")) {
                    pvProfitTotalDay = new BigDecimal("0.00000000");
                    pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal)map.get("money_self_use_rate1")));
                    pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal)map.get("money_self_use_rate2")));
                    pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal)map.get("money_self_use_rate3")));
                    pvProfitTotalDay = pvProfitTotalDay.add(egenValueDay.multiply((BigDecimal)map.get("money_self_use_rate4")));
                    pvProfitTotalAccum = new BigDecimal("0.00000000");
                    pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal)map.get("money_self_use_rate1")));
                    pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal)map.get("money_self_use_rate2")));
                    pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal)map.get("money_self_use_rate3")));
                    pvProfitTotalAccum = pvProfitTotalAccum.add(egenValueaccum.multiply((BigDecimal)map.get("money_self_use_rate4")));
                }
            }
        }
        HashMap<String, BigDecimal> resMap = new HashMap<String, BigDecimal>();
        resMap.put("pvProfitTotalDay", pvProfitTotalDay);
        resMap.put("pvProfitTotalAccum", pvProfitTotalAccum);
        return resMap;
    }

    public static BigDecimal getBigdecimal(Object obj) {
        BigDecimal retBig = null;
        if (obj != null) {
            if (obj instanceof BigDecimal) {
                retBig = (BigDecimal)obj;
            } else if (obj instanceof String) {
                retBig = new BigDecimal((String)obj);
            } else if (obj instanceof BigInteger) {
                retBig = new BigDecimal((BigInteger)obj);
            } else if (obj instanceof Number) {
                retBig = new BigDecimal(((Number)obj).doubleValue());
            } else {
                throw new ClassCastException("\u65e0\u6cd5\u5c06 [" + obj + "] " + obj.getClass() + " \u8f6c\u6362\u4e3aBigDecimal.");
            }
        }
        return retBig;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static Date getDayBegin() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDayEnd() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static Date getBeginDayOfYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(PvstatUtil.getDayBegin());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getEndDayOfYesterDay() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(PvstatUtil.getDayEnd());
        ((Calendar)cal).add(5, -1);
        return cal.getTime();
    }

    public static Date getBeginDayOfTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(PvstatUtil.getDayBegin());
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static Date getEndDayOfTomorrow() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(PvstatUtil.getDayEnd());
        ((Calendar)cal).add(5, 1);
        return cal.getTime();
    }

    public static Date getBeginDayOfWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek);
        return PvstatUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(PvstatUtil.getBeginDayOfWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return PvstatUtil.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfLastWeek() {
        Date date = new Date();
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int dayofweek = cal.get(7);
        if (dayofweek == 1) {
            dayofweek += 7;
        }
        cal.add(5, 2 - dayofweek - 7);
        return PvstatUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfLastWeek() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(PvstatUtil.getBeginDayOfLastWeek());
        cal.add(7, 6);
        Date weekEndSta = cal.getTime();
        return PvstatUtil.getDayEndTime(weekEndSta);
    }

    public static Date getBeginDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(PvstatUtil.getNowYear(), PvstatUtil.getNowMonth() - 1, 1);
        return PvstatUtil.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(PvstatUtil.getNowYear(), PvstatUtil.getNowMonth() - 1, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(PvstatUtil.getNowYear(), PvstatUtil.getNowMonth() - 1, day);
        return PvstatUtil.getDayEndTime(calendar.getTime());
    }

    public static Date getBeginDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(PvstatUtil.getNowYear(), PvstatUtil.getNowMonth() - 2, 1);
        return PvstatUtil.getDayStartTime(calendar.getTime());
    }

    public static Date getEndDayOfLastMonth() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(PvstatUtil.getNowYear(), PvstatUtil.getNowMonth() - 2, 1);
        int day = calendar.getActualMaximum(5);
        calendar.set(PvstatUtil.getNowYear(), PvstatUtil.getNowMonth() - 2, day);
        return PvstatUtil.getDayEndTime(calendar.getTime());
    }

    public static Date getBeginDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, PvstatUtil.getNowYear());
        cal.set(2, 0);
        cal.set(5, 1);
        return PvstatUtil.getDayStartTime(cal.getTime());
    }

    public static Date getEndDayOfYear() {
        Calendar cal = Calendar.getInstance();
        cal.set(1, PvstatUtil.getNowYear());
        cal.set(2, 11);
        cal.set(5, 31);
        return PvstatUtil.getDayEndTime(cal.getTime());
    }

    public static Timestamp getDayStartTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Timestamp getDayEndTime(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (null != d) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        return new Timestamp(calendar.getTimeInMillis());
    }

    public static Integer getNowYear() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(1);
    }

    public static int getNowMonth() {
        Date date = new Date();
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        return gc.get(2) + 1;
    }

    public static int getDiffDays(Date beginDate, Date endDate) {
        if (beginDate == null || endDate == null) {
            throw new IllegalArgumentException("getDiffDays param is null!");
        }
        long diff = (endDate.getTime() - beginDate.getTime()) / 86400000L;
        int days = new Long(diff).intValue();
        return days;
    }

    public static long dateDiff(Date beginDate, Date endDate) {
        long date1ms = beginDate.getTime();
        long date2ms = endDate.getTime();
        return date2ms - date1ms;
    }

    public static Date max(Date beginDate, Date endDate) {
        if (beginDate == null) {
            return endDate;
        }
        if (endDate == null) {
            return beginDate;
        }
        if (beginDate.after(endDate)) {
            return beginDate;
        }
        return endDate;
    }

    public static Date min(Date beginDate, Date endDate) {
        if (beginDate == null) {
            return endDate;
        }
        if (endDate == null) {
            return beginDate;
        }
        if (beginDate.after(endDate)) {
            return endDate;
        }
        return beginDate;
    }

    public static Date getFirstSeasonDate(Date date) {
        int[] SEASON = new int[]{1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int sean = SEASON[cal.get(2)];
        cal.set(2, sean * 3 - 3);
        return cal.getTime();
    }

    public static Date getNextDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) + i);
        return cal.getTime();
    }

    public static Date getFrontDay(Date date, int i) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.set(5, cal.get(5) - i);
        return cal.getTime();
    }

    public static Map<String, Object> getMaxAndMinValue(Map<String, Object> stringObjectMap) {
        if (stringObjectMap != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
            SimpleDateFormat dateFormat1 = new SimpleDateFormat("yyyyMMdd");
            String format = dateFormat1.format(new Date());
            BigDecimal[] maxAndMin = new BigDecimal[]{null, null};
            int[] index = new int[]{0, 0};
            for (int i = 1; i <= 96; ++i) {
                String name = String.format("eloadValue%02d", i);
                if (!stringObjectMap.containsKey(name)) continue;
                BigDecimal bigdecimal = PvstatUtil.getBigdecimal(stringObjectMap.get(name));
                if (maxAndMin[0] == null) {
                    maxAndMin[0] = bigdecimal;
                    index[0] = i;
                } else if (maxAndMin[0] != null && bigdecimal != null && bigdecimal.compareTo(maxAndMin[0]) > 0) {
                    maxAndMin[0] = bigdecimal;
                    index[0] = i;
                }
                if (maxAndMin[1] == null) {
                    maxAndMin[1] = bigdecimal;
                    index[1] = i;
                    continue;
                }
                if (maxAndMin[1] == null || bigdecimal == null || bigdecimal.compareTo(maxAndMin[1]) >= 0) continue;
                maxAndMin[1] = bigdecimal;
                index[1] = i;
            }
            if (index[0] > 0) {
                Date maxValueTime;
                int maxhh = (index[0] - 1) / 4;
                int maxmm = (index[0] - 1) % 4 * 15;
                if (maxhh < 10) {
                    try {
                        maxValueTime = dateFormat.parse(format + String.format("%02d", maxhh) + "" + maxmm);
                        stringObjectMap.put("maxValueTime", maxValueTime);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        maxValueTime = dateFormat.parse(format + maxhh + "" + maxmm);
                        stringObjectMap.put("maxValueTime", maxValueTime);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (index[1] > 0) {
                Date minValueTime;
                int minhh = (index[1] - 1) / 4;
                int minmm = (index[1] - 1) % 4 * 15;
                if (minhh < 10) {
                    try {
                        minValueTime = dateFormat.parse(format + String.format("%02d", minhh) + "" + minmm);
                        stringObjectMap.put("minValueTime", minValueTime);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        minValueTime = dateFormat.parse(format + minhh + "" + minmm);
                        stringObjectMap.put("minValueTime", minValueTime);
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            stringObjectMap.put("maxValue", maxAndMin[0]);
            stringObjectMap.put("minValue", maxAndMin[1]);
        }
        return stringObjectMap;
    }
}

