package com.iesms.springbootapps.bizprocessors.timuiot.config;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 *
 * @author Nick Zhang
 * @date 2020-05-20
 */
@Configuration
public class IesmsDataSourceConfig {

    @Bean(name = "iesmsDataSource")
    @Qualifier("iesmsDataSource")
    @Primary
    @ConfigurationProperties(prefix = "spring.datasource.hikari.iesms")
    DataSource iesmsDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Bean(name = "iesmsTransactionManager")
    @Qualifier("iesmsTransactionManager")
    @Primary
    public DataSourceTransactionManager iesmsTransactionManager(@Qualifier("iesmsDataSource") DataSource iesmsDataSource) {
        return new DataSourceTransactionManager(iesmsDataSource);
    }

}
