package com.iesms.springbootapps.bizprocessors.timuiot.config;

import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;

/**
 *
 * @author Nick Zhang
 * @date 2020-05-20
 */
@Configuration
@MapperScan(basePackages = {"com.iesms.bizprocessors.common.dao", "com.iesms.bizprocessors.timuiotgateway.dao", "com.iesms.openservices.**.dao"}, sqlSessionTemplateRef = "iesmsSqlSessionTemplate")
public class IesmsMyBatisSqlSessionConfig {

    @Bean(name = "iesmsSqlSessionFactory")
    @Qualifier("iesmsSqlSessionFactory")
    @Primary
    public SqlSessionFactory iesmsSqlSessionFactory(@Qualifier("iesmsDataSource") DataSource iesmsDataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        org.apache.ibatis.session.Configuration mybatisGlobalConfiguration = new org.apache.ibatis.session.Configuration();
        mybatisGlobalConfiguration.setCallSettersOnNulls(true);
        mybatisGlobalConfiguration.setMapUnderscoreToCamelCase(true);
        bean.setConfiguration(mybatisGlobalConfiguration);
        bean.setDataSource(iesmsDataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:iesms/**/mybatis/mapper/**/*.xml"));
        return bean.getObject();
    }

    @Bean(name = "iesmsSqlSessionTemplate")
    @Primary
    public SqlSessionTemplate iesmsSqlSessionTemplate(@Qualifier("iesmsSqlSessionFactory") SqlSessionFactory iesmsSqlSessionFactory) {
        return new SqlSessionTemplate(iesmsSqlSessionFactory);
    }

}
