package com.iesms.springbootapps.bizprocessors.timuiot.config;

import com.zaxxer.hikari.HikariDataSource;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

import javax.sql.DataSource;

/**
 *
 * @author Nick Zhang
 * @date 2019-02-28
 */
@Configuration
public class SystemDataSourceConfig {

    @Bean(name = "systemDataSource")
    @Qualifier("systemDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.hikari.system")
    DataSource systemDataSource() {
        return DataSourceBuilder.create().type(HikariDataSource.class).build();
    }

    @Bean(name = "systemTransactionManager")
    @Qualifier("systemTransactionManager")
    public DataSourceTransactionManager systemTransactionManager(@Qualifier("systemDataSource") DataSource systemDataSource) {
        return new DataSourceTransactionManager(systemDataSource);
    }

}
