package com.iesms.springbootapps.bizprocessors.timuiot.config;

import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

import javax.sql.DataSource;

/**
 *
 * @author Nick Zhang
 * @date 2019-02-28
 */
@Configuration
@MapperScan(basePackages = {"com.easesource.system.openservices.**.dao"}, sqlSessionTemplateRef = "systemSqlSessionTemplate")
public class SystemMyBatisSqlSessionConfig {

    @Bean(name = "systemSqlSessionFactory")
    @Qualifier("systemSqlSessionFactory")
    public SqlSessionFactory systemSqlSessionFactory(@Qualifier("systemDataSource") DataSource systemDataSource) throws Exception {
        SqlSessionFactoryBean bean = new SqlSessionFactoryBean();
        org.apache.ibatis.session.Configuration mybatisGlobalConfiguration = new org.apache.ibatis.session.Configuration();
        mybatisGlobalConfiguration.setCallSettersOnNulls(true);
        mybatisGlobalConfiguration.setMapUnderscoreToCamelCase(true);
        bean.setConfiguration(mybatisGlobalConfiguration);
        bean.setDataSource(systemDataSource);
        bean.setMapperLocations(new PathMatchingResourcePatternResolver().getResources("classpath*:easesystem/mybatis/mapper/**/*.xml"));
        return bean.getObject();
    }

    @Bean(name = "systemSqlSessionTemplate")
    public SqlSessionTemplate systemSqlSessionTemplate(@Qualifier("systemSqlSessionFactory") SqlSessionFactory systemSqlSessionFactory) {
        return new SqlSessionTemplate(systemSqlSessionFactory);
    }

}
