package com.iesms.springbootapps.bizprocessors.timuiot.frame;

import com.iesms.springbootapps.bizprocessors.timuiot.frame.request.ServiceIssuesTheSwitchCommand;
import com.iesms.springbootapps.bizprocessors.timuiot.frame.request.SubmitCircuitBreakerData1p;
import com.iesms.springbootapps.bizprocessors.timuiot.frame.request.SubmitCircuitBreakerData3p;
import com.iesms.springbootapps.bizprocessors.timuiot.procotol.BaseInformationElement;
import io.netty.buffer.ByteBuf;

import javax.annotation.Nullable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

/**
 * @param
 * @ClassName FrameFactory
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/5/19 10:05
 * @Version 1.0
 **/
public class FrameFactory {


    private static final HashMap<FrameType, Class<? extends BaseInformationElement>> TYPE_CLASS_HASH_MAP = new HashMap<>();

    /**
     * 构造器缓存 提高反射的性能
     */
    /**
     * 构造器缓存 提高反射的性能
     */
    private static final ConcurrentHashMap<Class<? extends BaseInformationElement>, Constructor<? extends BaseInformationElement>> CONSTRUCTOR_CACHE = new ConcurrentHashMap<>();

    static {
        TYPE_CLASS_HASH_MAP.put(FrameType.SUBMIT_CIRCUIT_BREAKER__DATA1P, SubmitCircuitBreakerData1p.class);
        TYPE_CLASS_HASH_MAP.put(FrameType.SUBMIT_CIRCUIT_BREAKER_DATA3P, SubmitCircuitBreakerData3p.class);
        TYPE_CLASS_HASH_MAP.put(FrameType.SERVICE_ISSUES_THE_SWITCH_COMMAND, ServiceIssuesTheSwitchCommand.class);

    }

    private static final ReentrantLock LOCK = new ReentrantLock(true);

    @Nullable
    public static Class<? extends BaseInformationElement> getClass(FrameType cmd) {
        return TYPE_CLASS_HASH_MAP.get(cmd);
    }

    @Nullable
    /***
     * 反序列化
     * @author zhouyi
     * @return T
     * @data 2021/5/21
     * @param clazz
     * @param byteBuf
     */
    public static <T extends BaseInformationElement> T deserialize(Class<T> clazz, ByteBuf byteBuf) {

        if (null == clazz) {
            return null;
        }
        try {
            Constructor constructor = CONSTRUCTOR_CACHE.get(clazz);
            if (constructor == null) {
                // 确保多线程情况下只要调用一次反射的构造方法
                LOCK.lock();
                try {
                    // 需要多判断一次是否为空
                    if (CONSTRUCTOR_CACHE.get(clazz) == null) {
                        Constructor c = clazz.getConstructor(ByteBuf.class);
                        c.setAccessible(true);
                        //cache Constructor
                        CONSTRUCTOR_CACHE.put(clazz, c);
                        constructor = c;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                } finally {
                    // 避免死锁
                    LOCK.unlock();
                }

            }
            return (T) constructor.newInstance(byteBuf);
        } catch (InvocationTargetException | InstantiationException | IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }
}
