package com.iesms.springbootapps.bizprocessors.timuiot.frame;

import java.util.HashMap;
import java.util.Map;

/***
 * 功能描述 功能码 枚举类
 * @author zhouyi
 * @return
 * @data 2021/5/18
 */
public enum FrameType {

    /**
     * 上报断路器数据--35H(半小时上报一次)
     */
    SUBMIT_CIRCUIT_BREAKER__DATA1P(0x35),

    /**
     * 上报断路器数据--48H(半小时上报一次)
     */
    SUBMIT_CIRCUIT_BREAKER_DATA3P(0x48),

    /***
     * 下发服务开关命令
     */
    SERVICE_ISSUES_THE_SWITCH_COMMAND(0x37);

    private static final Map<Short, FrameType> TYPES = new HashMap<>();

    private final short value;


    FrameType(int type) {
        this.value = (short) type;
    }

    public short getValue() {
        return value;
    }

    static {
        for (FrameType cmd : FrameType.values()) {
            if (TYPES.put(cmd.getValue(), cmd) != null) {
                throw new IllegalArgumentException("duplicate ID: " + cmd.getValue());
            }
        }
    }


    public static FrameType typeFor(short id) {
        return TYPES.get(id);
    }
}
