package com.iesms.springbootapps.bizprocessors.timuiot.frame.request;

import com.iesms.springbootapps.bizprocessors.timuiot.procotol.BaseInformationElement;
import io.netty.buffer.ByteBuf;

/**
 * @param
 * @ClassName SubmitCircuitBreakerData1p   1p  数据域
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/5/18 18:34
 * @Version 1.0
 **/
public class SubmitCircuitBreakerData1p  extends BaseInformationElement {
    /***
     * 状态   一个字节
     */
    private Short genWattStateOpen;

    /***
     * 电压值  两个字节
     */
    private Integer genWattUa;

    /***
     * 电流值  两个字节
     */
    private Integer genWattIa;

    /***
     * 电流值小数位  一个字节
     */
    private Short genWattIaX;

    /***
     * 有功功率值  四个字节
     */
    private Integer genWattAcpa;

    /***
     * 有功功率小数位  一个字节
     */
    private Short genWattAcpaX;

    /***
     * 无功功率值  四个字节
     */
    private Integer GenWattRepa;

    /***
     * 无功功率小数位  四个字节
     */
    private Short GenWattRepaX;

    /***
     * 功率因素  一个字节
     */
    private Short genWattPft;

    /***
     * 漏电量  两个字节
     */
    private Integer leakagePower;

    /***
     * 电量值  四个字节
     */
    private Integer  electricQuantity;


    /***
     * 电量值小数位  四个字节
     */
    private Short  electricQuantityX;

    /***
     * 目前开关次数  四个字节
     */
    private Integer  switchNum;

    /***
     * DATA9-Hour  一个字节
     */
    private short  data9Hour;

    /***
     * 内部温度  一个字节
     */
    //private short  coreTemperature;

    /***
     * A进线温度  一个字节
     */
   // private short  temperatureInA;

    /***
     * A出现温度  一个字节
     */
   // private short  temperatureOutA;

    /***
     * M进线温度  一个字节
     */
   // private short  temperatureInM;

    /***
     * M出现温度  一个字节
     */
    //private short  temperatureOutM;

    /***
     * 异常码  四个字节
     */
   // private Integer  exceptionCode;








    public SubmitCircuitBreakerData1p(ByteBuf byteBuffer) {
        super(byteBuffer);
        genWattStateOpen=byteBuffer.readUnsignedByte();
        genWattUa=byteBuffer.readUnsignedShort();
        genWattIa=byteBuffer.readUnsignedShort();
        genWattIaX=byteBuffer.readUnsignedByte();
        genWattAcpa=byteBuffer.readInt();
        genWattAcpaX=byteBuffer.readUnsignedByte();
        GenWattRepa=byteBuffer.readInt();
        GenWattRepaX=byteBuffer.readUnsignedByte();
        genWattPft=byteBuffer.readUnsignedByte();
        leakagePower=byteBuffer.readUnsignedShort();
        electricQuantity=byteBuffer.readInt();
        electricQuantityX=byteBuffer.readUnsignedByte();
        switchNum=byteBuffer.readInt();
        data9Hour=byteBuffer.readUnsignedByte();
        /*coreTemperature=byteBuffer.readUnsignedByte();
        temperatureInA=byteBuffer.readUnsignedByte();
        temperatureOutA=byteBuffer.readUnsignedByte();
        temperatureInM=byteBuffer.readUnsignedByte();
        temperatureOutM=byteBuffer.readUnsignedByte();
        exceptionCode=byteBuffer.readInt();*/
    }

    @Override
    public void encode(ByteBuf byteBuf) {

    }

    @Override
    public int getLen() {
        return 0;
    }

    public Short getGenWattStateOpen() {
        return genWattStateOpen;
    }

    public Integer getGenWattUa() {
        return genWattUa;
    }

    public Integer getGenWattIa() {
        return genWattIa;
    }

    public Short getGenWattIaX() {
        return genWattIaX;
    }

    public Integer getGenWattAcpa() {
        return genWattAcpa;
    }

    public Short getGenWattAcpaX() {
        return genWattAcpaX;
    }

    public Integer getGenWattRepa() {
        return GenWattRepa;
    }

    public Short getGenWattRepaX() {
        return GenWattRepaX;
    }

    public Short getGenWattPft() {
        return genWattPft;
    }

    public Integer getLeakagePower() {
        return leakagePower;
    }

    public Integer getElectricQuantity() {
        return electricQuantity;
    }

    public Short getElectricQuantityX() {
        return electricQuantityX;
    }

    public Integer getSwitchNum() {
        return switchNum;
    }

    public short getData9Hour() {
        return data9Hour;
    }

    @Override
    public String toString() {
        return "SubmitCircuitBreakerData1p{" +
                "genWattStateOpen=" + genWattStateOpen +
                ", genWattUa=" + genWattUa +
                ", genWattIa=" + genWattIa +
                ", genWattIaX=" + genWattIaX +
                ", genWattAcpa=" + genWattAcpa +
                ", genWattAcpaX=" + genWattAcpaX +
                ", GenWattRepa=" + GenWattRepa +
                ", GenWattRepaX=" + GenWattRepaX +
                ", genWattPft=" + genWattPft +
                ", leakagePower=" + leakagePower +
                ", electricQuantity=" + electricQuantity +
                ", electricQuantityX=" + electricQuantityX +
                ", switchNum=" + switchNum +
                ", data9Hour=" + data9Hour +
                '}';
    }
}
