package com.iesms.springbootapps.bizprocessors.timuiot.frame.request;

import com.iesms.springbootapps.bizprocessors.timuiot.procotol.BaseInformationElement;
import io.netty.buffer.ByteBuf;
import jdk.nashorn.internal.objects.annotations.Getter;

/**
 * @param
 * @ClassName SubmitCircuitBreakerData3p     3p  数据域
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/5/18 19:10
 * @Version 1.0
 **/
public class SubmitCircuitBreakerData3p extends BaseInformationElement {
    /***
     * 总状态   一个字节
     */
    private Short genWattStateOpen;

    /***
     * 总电压  两个字节
     */
    private Integer totalVoltage;

    /***
     * 总电流  两个字节
     */
    private Integer  totalCurrent;

    /***
     * 总电量  四个字节
     */
    private Integer totalPower;

    /***
     * 总漏电  两个字节
     */
    private Integer totalCreepage;

    /***
     * 总有功功率  三个字节
     */
    private Integer totalActivePower;

    /***
     * 总无功功率  三个字节
     */
    private Integer totalReactivePower;

    /***
     * 功率因素  一个字节
     */
    private Short powerFactor;

    /***
     * A电压值  两个字节
     */
    private Integer genWattUa;

    /***
     * A电流值  两个字节
     */
    private Integer genWattIa;

    /***
     * A有功功率值  三个字节
     */
    private Integer genWattAcpa;

    /***
     * A无功功率值  三个字节
     */
    private Integer GenWattRepa;

    /***
     * A功率因素  一个字节
     */
    private Short genWattPfta;

    /***
     * A温度  一个字节
     */
    private Short temperatureA;


    /***
     * B电压值  两个字节
     */
    private Integer genWattUb;

    /***
     * B电流值 两个字节
     */
    private Integer genWattIb;

    /***
     * B有功功率值  三个字节
     */
    private Integer genWattAcpb;

    /***
     * B无功功率值 三个字节
     */
    private Integer GenWattRepb;

    /***
     * B功率因素 一个字节
     */
    private Short genWattPftb;

    /***
     * B温度  一个字节
     */
    private Short temperatureB;


    /***
     * C电压值 两个字节
     */
    private Integer genWattUc;

    /***
     * C电流值 两个字节
     */
    private Integer genWattIc;

    /***
     * C有功功率值 三个字节
     */
    private Integer genWattAcpc;

    /***
     * C无功功率值  三个字节
     */
    private Integer GenWattRepc;

    /***
     * C功率因素  一个字节
     */
    private Short genWattPftc;

    /***
     * C温度  一个字节
     */
    private Short temperatureC;

    /***
     * N线电流值 两个字节
     */
    private Integer genWattIn;

    /***
     * N线温度  一个字节
     */
    private Short temperatureN;

    public SubmitCircuitBreakerData3p(ByteBuf byteBuffer) {
        super(byteBuffer);
        genWattStateOpen=byteBuffer.readUnsignedByte();
        totalVoltage=byteBuffer.readUnsignedShort();
        totalCurrent=byteBuffer.readUnsignedShort();
        totalPower=byteBuffer.readInt();
        totalCreepage=byteBuffer.readUnsignedShort();
        totalActivePower=byteBuffer.readMedium();
        totalReactivePower=byteBuffer.readMedium();
        powerFactor=byteBuffer.readUnsignedByte();

        genWattUa=byteBuffer.readUnsignedShort();
        genWattIa=byteBuffer.readUnsignedShort();
        genWattAcpa=byteBuffer.readMedium();
        GenWattRepa=byteBuffer.readMedium();
        genWattPfta=byteBuffer.readUnsignedByte();
        temperatureA=byteBuffer.readUnsignedByte();

        genWattUb=byteBuffer.readUnsignedShort();
        genWattIb=byteBuffer.readUnsignedShort();
        genWattAcpb=byteBuffer.readMedium();
        GenWattRepb=byteBuffer.readMedium();
        genWattPftb=byteBuffer.readUnsignedByte();
        temperatureB=byteBuffer.readUnsignedByte();

        genWattUc=byteBuffer.readUnsignedShort();
        genWattIc=byteBuffer.readUnsignedShort();
        genWattAcpc=byteBuffer.readMedium();
        GenWattRepc=byteBuffer.readMedium();
        genWattPftc=byteBuffer.readUnsignedByte();
        temperatureC=byteBuffer.readUnsignedByte();

        genWattIn=byteBuffer.readUnsignedShort();
        temperatureN=byteBuffer.readUnsignedByte();
    }

    @Override
    public void encode(ByteBuf byteBuf) {

    }

    @Override
    public int getLen() {
        return 0;
    }

    public Short getGenWattStateOpen() {
        return genWattStateOpen;
    }

    public Integer getTotalVoltage() {
        return totalVoltage;
    }

    public Integer getTotalCurrent() {
        return totalCurrent;
    }

    public Integer getTotalPower() {
        return totalPower;
    }

    public Integer getTotalCreepage() {
        return totalCreepage;
    }

    public Integer getTotalActivePower() {
        return totalActivePower;
    }

    public Integer getTotalReactivePower() {
        return totalReactivePower;
    }

    public Short getPowerFactor() {
        return powerFactor;
    }

    public Integer getGenWattUa() {
        return genWattUa;
    }

    public Integer getGenWattIa() {
        return genWattIa;
    }

    public Integer getGenWattAcpa() {
        return genWattAcpa;
    }

    public Integer getGenWattRepa() {
        return GenWattRepa;
    }

    public Short getGenWattPfta() {
        return genWattPfta;
    }

    public Short getTemperatureA() {
        return temperatureA;
    }

    public Integer getGenWattUb() {
        return genWattUb;
    }

    public Integer getGenWattIb() {
        return genWattIb;
    }

    public Integer getGenWattAcpb() {
        return genWattAcpb;
    }

    public Integer getGenWattRepb() {
        return GenWattRepb;
    }

    public Short getGenWattPftb() {
        return genWattPftb;
    }

    public Short getTemperatureB() {
        return temperatureB;
    }

    public Integer getGenWattUc() {
        return genWattUc;
    }

    public Integer getGenWattIc() {
        return genWattIc;
    }

    public Integer getGenWattAcpc() {
        return genWattAcpc;
    }

    public Integer getGenWattRepc() {
        return GenWattRepc;
    }

    public Short getGenWattPftc() {
        return genWattPftc;
    }

    public Short getTemperatureC() {
        return temperatureC;
    }

    public Integer getGenWattIn() {
        return genWattIn;
    }

    public Short getTemperatureN() {
        return temperatureN;
    }

    @Override
    public String toString() {
        return "SubmitCircuitBreakerData3p{" +
                "genWattStateOpen=" + genWattStateOpen +
                ", totalVoltage=" + totalVoltage +
                ", totalCurrent=" + totalCurrent +
                ", totalPower=" + totalPower +
                ", totalCreepage=" + totalCreepage +
                ", totalActivePower=" + totalActivePower +
                ", totalReactivePower=" + totalReactivePower +
                ", powerFactor=" + powerFactor +
                ", genWattUa=" + genWattUa +
                ", genWattIa=" + genWattIa +
                ", genWattAcpa=" + genWattAcpa +
                ", GenWattRepa=" + GenWattRepa +
                ", genWattPfta=" + genWattPfta +
                ", temperatureA=" + temperatureA +
                ", genWattUb=" + genWattUb +
                ", genWattIb=" + genWattIb +
                ", genWattAcpb=" + genWattAcpb +
                ", GenWattRepb=" + GenWattRepb +
                ", genWattPftb=" + genWattPftb +
                ", temperatureB=" + temperatureB +
                ", genWattUc=" + genWattUc +
                ", genWattIc=" + genWattIc +
                ", genWattAcpc=" + genWattAcpc +
                ", GenWattRepc=" + GenWattRepc +
                ", genWattPftc=" + genWattPftc +
                ", temperatureC=" + temperatureC +
                ", genWattIn=" + genWattIn +
                ", temperatureN=" + temperatureN +
                '}';
    }
}
