package com.iesms.springbootapps.bizprocessors.timuiot.gateway;

import org.springframework.integration.annotation.MessagingGateway;
import org.springframework.integration.mqtt.support.MqttHeaders;
import org.springframework.messaging.handler.annotation.Header;

/**
 *
 * @author Nick Zhang
 * @date 2020-05-20
 */
@MessagingGateway(defaultRequestChannel = "mqttOutboundChannel")
public interface TimuIotMqttSendGateway {

    /**
     * payload，topic为主题。指定topic，qos 默认为 1
     * 则我们的接口可以根据需要，向不同的主题发送消息，
     * 方便灵活应用。如果不指定，则使用默认配置的主题
     *
     * @param payload 消息体
     */
    void sendToMqtt(byte[] payload);

    /**
     * payload，topic为主题。指定topic，qos 默认为 1
     * 则我们的接口可以根据需要，向不同的主题发送消息，
     * 方便灵活应用。如果不指定，则使用默认配置的主题
     *
     * @param payload 消息体
     * @param topic 主题
     */
    void sendToMqtt(byte[] payload, @Header(MqttHeaders.TOPIC) String topic);

    /**
     * payload，topic为主题。指定topic，qos 默认为 1
     * 则我们的接口可以根据需要，向不同的主题发送消息，
     * 方便灵活应用。如果不指定，则使用默认配置的主题
     *
     * @param payload 消息体
     * @param topic 主题
     * @param qos 服务质量等级
     */
    void sendToMqtt(byte[] payload, @Header(MqttHeaders.TOPIC) String topic, @Header(MqttHeaders.QOS) int qos);

}
