package com.iesms.springbootapps.bizprocessors.timuiot.handler;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.AccessMgmtService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.common.service.GmDevMeterService;
import com.iesms.bizprocessors.common.service.GmopsDevMeterService;
import com.iesms.bizprocessors.common.service.SoeRecordOnOffAlarmService;
import com.iesms.bizprocessors.timuiotgateway.request.TimuMqttmsgReceivedLogInsertRequest;
import com.iesms.bizprocessors.timuiotgateway.service.TimuDevMeterService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttMessageService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttSubscriptionsService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttmsgLogService;
import com.iesms.springbootapps.bizprocessors.timuiot.gateway.TimuIotMqttSendGateway;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

import javax.annotation.Nonnull;
import javax.annotation.Resource;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;

/**
 * @author Nick Zhang
 * @date 2020-05-20
 */
public class ReceiveMessageHandler implements MessageHandler {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String UPCOMM_PROTO = "MQTT_TIMU";

    private final Map<String, Long> measPointIdReverseMap = Maps.newConcurrentMap();

    @Resource
    private TimuIotMqttSendGateway mqttSendGateway;

    @Resource
    private TimuMqttSubscriptionsService timuMqttSubscriptionsService;

    @Resource
    private TimuMqttmsgLogService timuMqttmsgLogService;

    @Resource
    private TimuMqttMessageService mqttMessageService;

    @DubboReference
    private AccessMgmtService accessMgmtService;

    @DubboReference
    private MeasDataStoreService measDataStoreService;

    @DubboReference
    private MeasDataService measDataService;

    @Resource
    private GmDevMeterService gmDevMeterService;

    @Resource(name = "gmopsDevMeterServiceImpl")
    private GmopsDevMeterService gmopsDevMeterService;

    @Resource
    private TimuDevMeterService timuDevMeterService;

    @Resource
    private SoeRecordOnOffAlarmService soeRecordOnOffAlarmService;

    @Override
    public void handleMessage(@Nonnull Message<?> message) throws MessagingException {
        Object payload = message.getPayload();
        byte[] payloadBytes;
        if (payload instanceof String) {
            payloadBytes = ((String) payload).getBytes(Charset.forName("GBK"));
        } else {
            payloadBytes = (byte[]) payload;
        }
        String receivedProductKey = "";
        String receivedClientId = "";
        String topic = (String) message.getHeaders().get("mqtt_receivedTopic");

        int qos = (int) message.getHeaders().get("mqtt_receivedQos");
        boolean retained = (boolean) message.getHeaders().get("mqtt_receivedRetained");
        boolean duplicate = (boolean) message.getHeaders().get("mqtt_duplicate");
        UUID uuid = (UUID) message.getHeaders().get("id");
        String receivedMessageId = (uuid != null ? uuid.toString() : "");
        Long receivedMessageTimestamp = (Long) message.getHeaders().get("timestamp");
        String payloadByte = byteToHex(payloadBytes).toUpperCase();
        if (logger.isDebugEnabled()) {
            logger.debug("   time                       : " + System.currentTimeMillis());
            logger.debug("   Message                    : " + JsonConvertUtils.convertToString(message));
            logger.debug("   MessageHeaders             : " + JsonConvertUtils.convertToString(message.getHeaders()));
            logger.debug("   payloadBytes               : " + payloadByte);
            logger.debug("   payloadBytes Array         : " + Arrays.toString(payloadBytes));
            logger.debug("   topic                      : " + topic);
            logger.debug("   qos                        : " + qos);
            logger.debug("   retained                   : " + retained);
            logger.debug("   duplicate                  : " + duplicate);
            logger.debug("   receivedMessageId          : " + receivedMessageId);
            logger.debug("   receivedMessageTimestamp   : " + receivedMessageTimestamp);
        }

        String[] tpcs = StringUtils.split(topic, "/");

        if (logger.isDebugEnabled()) {
            logger.debug("   tpcs                       : " + JsonConvertUtils.convertToString(tpcs));
        }

        if (tpcs == null || tpcs.length < 3) {
            return;
        }

        if (!tpcs[1].equals("LINKtoSERVER")) {
            return;
        }

        receivedProductKey = tpcs[0];
        receivedClientId = payloadByte.substring(8, 20);

        try {
            TimuMqttmsgReceivedLogInsertRequest insertRequest = new TimuMqttmsgReceivedLogInsertRequest();
            String payloadStr = byteToHex(payloadBytes);
            insertRequest.setPayload(payloadStr);
            insertRequest.setPayloadBytes(payloadBytes);
            insertRequest.setTopic(topic);
            insertRequest.setQos(qos);
            insertRequest.setRetained(retained);
            insertRequest.setDuplicate(duplicate);
            insertRequest.setReceivedProductKey(receivedProductKey);
            insertRequest.setReceivedClientId(receivedClientId);
            insertRequest.setReceivedMessageId(receivedMessageId);
            insertRequest.setReceivedMessageTimestamp(receivedMessageTimestamp);

            TimuMessageResolver messageResolver = new TimuMessageResolver();
            messageResolver.resolver(insertRequest, timuMqttmsgLogService, timuMqttSubscriptionsService, accessMgmtService,
                    measDataStoreService, gmDevMeterService, timuDevMeterService, mqttSendGateway, measPointIdReverseMap,
                    payloadByte, measDataService, soeRecordOnOffAlarmService);
        } catch (RuntimeException e) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }
    }

    /**
     * byte数组转hex
     *
     * @param bytes
     * @return
     */
    private static String byteToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; n++) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            // 每个字节由两个字符表示，位数不够，高位补0
            sb.append((strHex.length() == 1) ? "0" + strHex : strHex);
        }
        return sb.toString().trim();
    }

}
