package com.iesms.springbootapps.bizprocessors.timuiot.handler;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.AccessMgmtService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.common.service.GmDevMeterService;
import com.iesms.bizprocessors.common.service.GmopsDevMeterService;
import com.iesms.bizprocessors.common.service.SoeRecordOnOffAlarmService;
import com.iesms.bizprocessors.timuiotgateway.request.TimuMqttmsgReceivedLogInsertRequest;
import com.iesms.bizprocessors.timuiotgateway.service.TimuDevMeterService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttMessageService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttSubscriptionsService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttmsgLogService;
import com.iesms.springbootapps.bizprocessors.timuiot.gateway.TimuIotMqttSendGateway;
import com.iesms.springbootapps.bizprocessors.timuiot.pack.BasePacket;
import io.netty.buffer.Unpooled;
import org.apache.commons.codec.binary.Hex;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.MessagingException;

import javax.annotation.Resource;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;

/**
 * @param
 * @ClassName ReceiveMessageHandlerNew   提姆业务处理器
 * @Description TODO
 * @Author zhouyi
 * @Data 2021/5/20 9:42
 * @Version 1.0
 **/
public class ReceiveMessageHandlerNew implements MessageHandler {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static final String UPCOMM_PROTO = "MQTT_TIMU";

    private final Map<String, Long> measPointIdReverseMap = Maps.newConcurrentMap();

    @Resource
    private TimuIotMqttSendGateway mqttSendGateway;

    @Resource
    //Timu数据更新业务接口
    private TimuMqttSubscriptionsService timuMqttSubscriptionsService;

    @Resource
    //插入接收MQTT消息报文接口
    private TimuMqttmsgLogService timuMqttmsgLogService;

    @Resource
    private TimuMqttMessageService mqttMessageService;

    @DubboReference
    private AccessMgmtService accessMgmtService;

    @DubboReference
    private MeasDataStoreService measDataStoreService;

    @DubboReference
    private MeasDataService measDataService;

    @Resource
    private GmDevMeterService gmDevMeterService;

    @Resource(name = "gmopsDevMeterServiceImpl")
    private GmopsDevMeterService gmopsDevMeterService;

    @Resource
    private TimuDevMeterService timuDevMeterService;

    @Resource
    private SoeRecordOnOffAlarmService soeRecordOnOffAlarmService;

    @Override
    public void handleMessage(Message<?> message) throws MessagingException {
        //获取报文的消息体
        Object payload = message.getPayload();
        byte[] payloadBytes;

        if (payload instanceof String) {
            payloadBytes = ((String) payload).getBytes(Charset.forName("GBK"));
        } else {
            payloadBytes = (byte[]) payload;
        }
        System.err.println(Hex.encodeHexString(payloadBytes));


        //在此处将消息体转换为BasePacket对象  在对象内对进行递归解析
        BasePacket basePacket = new BasePacket(Unpooled.wrappedBuffer(payloadBytes));

        System.err.println(basePacket);
        //主题
        String topic = (String) message.getHeaders().get("mqtt_receivedTopic");
        /***
         * 服务质量
         * QoS 0：最多分发一次。消息的传递完全依赖底层的TCP/IP网络，协议里没有定义应答和重试，消息要么只会到达服务端一次，要么根本没有到达。
         * QoS 1：至少分发一次。服务器的消息接收由PUBACK消息进行确认，如果通信链路或发送设备异常，或者指定时间内没有收到确认消息，发送端会重发这条在消息头中设置了DUP位的消息。
         * QoS 2：只分发一次。这是最高级别的消息传递，消息丢失和重复都是不可接受的，使用这个服务质量等级会有额外的开销。 
         */
        int qos = (int) message.getHeaders().get("mqtt_receivedQos");
        //是否保留
        boolean retained = (boolean) message.getHeaders().get("mqtt_receivedRetained");
        //是否复制
        boolean duplicate = (boolean) message.getHeaders().get("mqtt_duplicate");
        UUID uuid = (UUID) message.getHeaders().get("id");
        //接收消息标识
        String receivedMessageId = (uuid != null ? uuid.toString() : "");
        //接收消息客户端标识
        String receivedClientId = basePacket.getAddr().toString();
        //接收报文时间
        Long receivedMessageTimestamp = (Long) message.getHeaders().get("timestamp");
        //16进制报文
        String payloadStr = byteToHex(payloadBytes);
        String[] tpcs = StringUtils.split(topic, "/");
        if (logger.isDebugEnabled()) {
            logger.debug("   tpcs                       : " + JsonConvertUtils.convertToString(tpcs));
        }
        if (tpcs == null || tpcs.length < 3) {
            return;
        }
        if (!tpcs[1].equals("LINKtoSERVER")) {
            return;
        }
        try {
            //接收消息产品
            String receivedProductKey = tpcs[0];
            //插入提姆MQTT消息接收日志表对象
            TimuMqttmsgReceivedLogInsertRequest insertRequest = new TimuMqttmsgReceivedLogInsertRequest();
            insertRequest.setPayload(payloadStr);
            insertRequest.setPayloadBytes(payloadBytes);
            insertRequest.setTopic(topic);
            insertRequest.setQos(qos);
            insertRequest.setRetained(retained);
            insertRequest.setDuplicate(duplicate);
            insertRequest.setReceivedProductKey(receivedProductKey);
            insertRequest.setReceivedClientId(receivedClientId);
            insertRequest.setReceivedMessageId(receivedMessageId);
            insertRequest.setReceivedMessageTimestamp(receivedMessageTimestamp);
            TimuMessageResolverNew messageResolverNew = new TimuMessageResolverNew();
            messageResolverNew.resolver(insertRequest, timuMqttmsgLogService, timuMqttSubscriptionsService, accessMgmtService, measDataStoreService,
                    gmDevMeterService, timuDevMeterService, mqttSendGateway, measPointIdReverseMap, basePacket,topic,
                    measDataService, soeRecordOnOffAlarmService);
        } catch (RuntimeException e) {
            logger.error(e.getMessage(), e.fillInStackTrace());
        }


    }


    /**
     * byte数组转hex
     *
     * @param bytes
     * @return
     */
    private static String byteToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; n++) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            // 每个字节由两个字符表示，位数不够，高位补0
            sb.append((strHex.length() == 1) ? "0" + strHex : strHex);
        }
        return sb.toString().trim();
    }
}
