package com.iesms.springbootapps.bizprocessors.timuiot.handler;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.AccessMgmtService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointVo;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayGetRequest;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayGetResponse;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDo;
import com.iesms.bizprocessors.common.service.GmDevMeterService;
import com.iesms.bizprocessors.common.service.GmopsDevMeterService;
import com.iesms.bizprocessors.common.service.SoeRecordOnOffAlarmService;
import com.iesms.bizprocessors.timuiotgateway.entity.*;
import com.iesms.bizprocessors.timuiotgateway.request.TimuMqttmsgReceivedLogInsertRequest;
import com.iesms.bizprocessors.timuiotgateway.response.TimuReturnResponse;
import com.iesms.bizprocessors.timuiotgateway.service.TimuDevMeterService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttMessageService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttSubscriptionsService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttmsgLogService;
import com.iesms.springbootapps.bizprocessors.timuiot.gateway.TimuIotMqttSendGateway;
import com.iesms.springbootapps.bizprocessors.timuiot.utils.ByteUtil;
import com.iesms.springbootapps.bizprocessors.timuiot.utils.TimuUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 解析
 *
 * @author ghl
 */
public class TimuMessageResolver {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final String UPCOMM_PROTO = "MQTT_TIMUIOT";


    @Resource
    private GmDevMeterService gmDevMeterService;

    @Resource(name = "gmopsDevMeterServiceImpl")
    private GmopsDevMeterService gmopsDevMeterService;

    /**
     * 规约解析入口
     *
     * @param insertRequest
     * @param timuMqttmsgLogService
     * @param timuMqttSubscriptionsService
     */
    public void resolver(TimuMqttmsgReceivedLogInsertRequest insertRequest,
                         TimuMqttmsgLogService timuMqttmsgLogService,
                         TimuMqttSubscriptionsService timuMqttSubscriptionsService,
                         AccessMgmtService accessMgmtService,
                         MeasDataStoreService measDataStoreService,
                         GmDevMeterService gmDevMeterService,
                         TimuDevMeterService timuDevMeterService,
                         TimuIotMqttSendGateway mqttSendGateway,
                         Map<String, Long> measPointIdReverseMap,
                         String payloadByte,
                         MeasDataService measDataService,
                         SoeRecordOnOffAlarmService soeRecordOnOffAlarmService) {


        String[] tpcs = insertRequest.getTopic().split("/");
        String receivedProductKey = tpcs[0];
        String receivedControllerId = tpcs[2];
        TimuReturnResponse returnResponse = timuMqttmsgLogService.insertTimuMqttmsgReceivedLog(insertRequest);
        String receivedClientId = payloadByte.substring(8, 20).toUpperCase();
        RunAccessGatewayGetRequest runAccessGatewayGetRequest = new RunAccessGatewayGetRequest();
        runAccessGatewayGetRequest.setProductKey(receivedProductKey);
        runAccessGatewayGetRequest.setUpcommProto(UPCOMM_PROTO);
        runAccessGatewayGetRequest.setUpcommLogicAddr(receivedControllerId);
        RunAccessGatewayGetResponse runAccessGatewayGetResponse = null;
        try {
            runAccessGatewayGetResponse = accessMgmtService.getRunAccessGateway(runAccessGatewayGetRequest);
        } catch (RuntimeException e) {
            e.printStackTrace();
        }

        // gen_watt_ua:A相电压, gen_watt_ia,A相电流
        /**
         *
         *group_watt_acp,有功功率
         * group_watt_rep,无功功率
         * group_watt_pf,功率因数
         * gen_watt_pft,总功率因数
         * gen_watt_pfa,A相功率因数
         * gen_watt_paet,正向有功总电能示值
         */

        byte[] payloads = insertRequest.getPayloadBytes();
        String decCmd = "";
        int type = 0;
        byte payload3 = payloads[10];
        short aShort = ByteUtil.byteToShort(payload3);
        logger.info("payload : " + insertRequest.getPayload());
        String subType = insertRequest.getPayload().substring(6, 8);
        logger.info("subType : " + subType);
        logger.info("receivedClientId : " + receivedClientId);
        String meterAddress = insertRequest.getPayload().substring(8, 20);
        logger.info("meterAddress : " + meterAddress);
        if (!subType.equals("80") && !subType.equals("81") && !subType.equals("82")) {
            // 三项报文解密
            //decCmd = TimuUtil.decCmd("201803", TimuUtil.hesStrToInts(payloadByte)).replaceAll(" ", "").trim();
            String substring = payloadByte.substring(6, payloadByte.length() - 4);
            //int[] ints = TimuUtil.hesStrToInts(substring);
            //decCmd = TimuUtil.decCmd("201803", ints).replaceAll(" ", "").trim();
            decCmd = substring;
            String controlCode = decCmd.substring(0, 2);
            String subType2 = decCmd.substring(14, 16);
            logger.info("controlCode    : " + controlCode);
            logger.info("subType2       : " + subType2);
            logger.info("decCmd : " + decCmd);
            if (!controlCode.equals("81")) {
                return;
            }
            type = Integer.valueOf(subType2);
        } else {
            if (!subType.equals("81")) {
                return;
            }
            type = payload3;
        }
        // 获取功能码
        logger.info("type           : " + type);
        Long measPointId = null;
        if (type != 49 && runAccessGatewayGetResponse != null) {
            List<RunMeasPointVo> list = runAccessGatewayGetResponse.getRunMeasPointList().stream().filter(elem -> elem.getAccessMeasureNo().equals(receivedClientId)).collect(Collectors.toList());
            list.removeIf(Objects::isNull);
            if (list.size() > 0) {
                measPointId = list.get(0).getId();
            }
        }

        // 更新网关状态
        Map<String, String> map = new HashMap<>();
        map.put("devTermCommAddr", receivedControllerId);
        TimuGmopsDevTermDo timuGmopsDevTermByAddr = timuDevMeterService.getTimuGmopsDevTermByAddr(map);
        if (timuGmopsDevTermByAddr != null && timuGmopsDevTermByAddr.getDevTermId() != null) {
            // 更新网关状态
            timuDevMeterService.insertOrUpdateTimuGmopsDevTerm(timuGmopsDevTermByAddr);
        }


        switch (type) {
            case 49:
                resolver31(mqttSendGateway, payloads, receivedControllerId);
                break;
            case 50:
                resolver32(payloads, measPointId, measDataStoreService, accessMgmtService, tpcs, soeRecordOnOffAlarmService);
                break;
//            case 51:
//                resolver33(mqttDataCommonDo, mqttMessageService);
            case 53:
                resolver35(payloads, timuDevMeterService, measDataStoreService, accessMgmtService, tpcs, measDataService,
                        soeRecordOnOffAlarmService, timuMqttmsgLogService);
                break;
//            case 54:
//                resolver36(mqttDataCommonDo, mqttMessageService);
            case 55:
                resolver37(payloads, timuDevMeterService, tpcs, soeRecordOnOffAlarmService);
                break;
            case 72:
                resolver48(decCmd, timuDevMeterService, measDataStoreService, accessMgmtService, tpcs, measDataService,
                        soeRecordOnOffAlarmService);
                break;
            default:
                break;
        }
    }


    /**
     * 2.1.	Link网关请求时间－－31H
     *
     * @param mqttSendGateway
     * @param payloads
     * @param receivedControllerId
     * @return
     */
    private void resolver31(TimuIotMqttSendGateway mqttSendGateway, byte[] payloads, String receivedControllerId) {
        // 获取时间，年份为后两位1字节表示。比如2017-04-22 13:58:00是170422135800

        String time = TimuUtil.getTime();
        byte[] timeBytes = ByteUtil.hexStringToByteArray(time);
        System.out.println("timebytes ===" + Arrays.toString(timeBytes));
        int tlen = timeBytes.length;
        int plen = payloads.length;
        int totalLen = tlen + plen;
        byte[] retByte = new byte[totalLen];
        int tIndex = 0;
        int pIndex = 0;
        for (int i = 0; i < totalLen; i++) {
            if (i < 11) {
                retByte[i] = payloads[pIndex++];
            } else {
                if (tIndex < tlen) {
                    retByte[i] = timeBytes[tIndex++];
                } else {
                    retByte[i] = payloads[pIndex++];
                }
            }
        }
        retByte[3] = (byte) 128;

        // 数据校验计算，计算规则：加密前，控制域、地址域、功能码、数据域、数据时效的累加和。
        byte[] bytes1 = Arrays.copyOfRange(retByte, 3, 23);
        byte checkCode = ByteUtil.getCheckCode(bytes1);
        // 计算长度
        // 获取长度
        byte b1 = payloads[1];
        byte b2 = payloads[2];

        short len = ByteUtil.bytesToShort(b1, b2);
        len = (short) (len + timeBytes.length);
        byte[] bytes = ByteUtil.shortToByte(len);
        retByte[1] = bytes[0];
        retByte[2] = bytes[1];
        retByte[retByte.length - 2] = checkCode;
        String resTopic = "YINDE/SERVERtoLINK/" + receivedControllerId;
        // YINDE/SERVERtoLINK/
        mqttSendGateway.sendToMqtt(retByte, resTopic, 0);

    }

    /**
     * 2.2.	上报网关设备信息--32H
     *
     * @return
     */
    private void resolver32(byte[] payloads, Long measPointId, MeasDataStoreService measDataStoreService, AccessMgmtService accessMgmtService,
                            String[] tpcs, SoeRecordOnOffAlarmService soeRecordOnOffAlarmService) {

        if (!tpcs[1].equals("SERVERtoLINK")) {
            return;
        }

        if (measPointId == null) {
            return;
        }

        Map<String, Object> valueMap = new HashMap<>();
        // 开关状态 gen_watt_state_open
        byte data0 = payloads[11];
        if (data0 == 3) {
            data0 = 1;
        }

        // 开关状态，ture：开，false：闭合
        Boolean status = data0 == 2 ? true : false;

        valueMap.put("gen_watt_state_open", data0);
        // 电压值
        short data1_V = ByteUtil.bytesToShort(payloads[12], payloads[13]);
        valueMap.put("gen_watt_ua", data1_V);
        // 电流值
        short data1_A = ByteUtil.bytesToShort(payloads[14], payloads[15]);
        valueMap.put("gen_watt_ia", data1_A);
        // 有功功率
        byte[] bytes = new byte[4];
        bytes[0] = payloads[17];
        bytes[1] = payloads[18];
        bytes[2] = payloads[19];
        bytes[3] = payloads[20];

        String data1_P_str = ByteUtil.byteToHex(new byte[]{payloads[17], payloads[18], payloads[19], payloads[20]});
        String data1_P_str_int = String.valueOf(Integer.parseInt(data1_P_str, 16));

        valueMap.put("group_watt_acp", data1_P_str_int);
        // 无功功率值
        String data4_P_str = ByteUtil.byteToHex(new byte[]{payloads[22], payloads[23], payloads[24], payloads[25]});
        String data4_P_str_int = String.valueOf(Integer.parseInt(data4_P_str, 16));

        valueMap.put("group_watt_rep", data4_P_str_int);
        // 功率因素 百分比
        short data5_P = ByteUtil.byteToShort(payloads[27]);
        valueMap.put("group_watt_pf", data5_P);
        // 漏电量
        short data5_kw = ByteUtil.bytesToShort(payloads[28], payloads[29]);
        //电量值

        String data6_kw_str = ByteUtil.byteToHex(new byte[]{payloads[30], payloads[31], payloads[32], payloads[33]});
        String data6_kw_str_int = String.valueOf(Integer.parseInt(data6_kw_str, 16));

        valueMap.put("gen_watt_paet", data6_kw_str_int);

//        updateValue(measPointId, valueMap, measDataStoreService, accessMgmtService);
        TimuUtil.updateValue(measPointId, valueMap, measDataStoreService, accessMgmtService);
        // 更新开关状态
        TimuUtil.updateRunMeasPointOpsInfo(accessMgmtService, measPointId);

        Map<String, Object> measDataInfoSet = Maps.newHashMap();
        measDataInfoSet.put("meter_state_open", status);
        TimuUtil.updateGmopsDevMeter(gmopsDevMeterService, gmDevMeterService, measPointId, measDataInfoSet);
        TimuUtil.updateMeasDataLatest(measDataStoreService, measPointId, "gen_watt_state_open", status);

        SoeRecordOnOffAlarmDo onOffAlarmDo = new SoeRecordOnOffAlarmDo();
        onOffAlarmDo.setOnOff(status);
        String toHex = byteToHex(payloads);
        String substring = toHex.substring(8, 20);
        onOffAlarmDo.setDevMeterCommAddr(substring);
        onOffAlarmDo.setDevTermCommAddr(tpcs[2]);
        soeRecordOnOffAlarmService.updateSoeRecordOnOffAlarmDo(onOffAlarmDo);

    }

    /**
     * 2.3.	上报断路器设备信息--33H
     *
     * @param mqttDataCommonDo
     * @param mqttMessageService
     */
    private void resolver33(TimuMqttDataCommonDo mqttDataCommonDo, TimuMqttMessageService mqttMessageService) {
//        mqttMessageService.insertOrUpdateTimuMqttSubscriptions(mqttDataCommonDo);
    }


    /**
     * 2.5.	上报断路器数据--35H(半小时上报一次)
     *
     * @param payloads
     * @param timuDevMeterService
     */
    private void resolver35(byte[] payloads, TimuDevMeterService timuDevMeterService, MeasDataStoreService measDataStoreService,
                            AccessMgmtService accessMgmtService, String[] tpcs, MeasDataService measDataService,
                            SoeRecordOnOffAlarmService soeRecordOnOffAlarmService,
                            TimuMqttmsgLogService timuMqttmsgLogService) {

        if (!tpcs[1].equals("LINKtoSERVER")) {
            return;
        }

        /**
         * 除了开关状态，其它数据类型都用 bigdecimal
         *gen_watt_ua:A相电压,
         * gen_watt_ia,A相电流
         * gen_watt_acpt,有功功率 w转换为kw 乘以  0.001
         * gen_watt_rept,无功功率 w转换为kw 乘以 0.001
         * gen_watt_pft,总功率因数 百分比 乘以 0。01
         * gen_watt_paet,正向有功总电能示值
         */
        String payloadByte = byteToHex(payloads).toUpperCase();
        String addr = payloadByte.substring(8, 20);

        if (addr.equals("000000000000")) {
            return;
        }

        Map<String, Object> valueMap = new HashMap<>();
        // 开关状态 gen_watt_state_open
        byte data0 = payloads[11];
        Boolean status = false;
        if (data0 == 2) {
            status = true;
            data0 = 1;
        } else {
            data0 = 0;
        }

        valueMap.put("gen_watt_state_open", status);
        // 电压值
        short data1_V = ByteUtil.bytesToShort(payloads[12], payloads[13]);
        valueMap.put("gen_watt_ua", new BigDecimal(data1_V + ""));

        // 电流值
        short data2_A = ByteUtil.bytesToShort(payloads[14], payloads[15]);
        // 电流值小数位
        short data3_AF = ByteUtil.byteToShort(payloads[16]);
        valueMap.put("gen_watt_ia", new BigDecimal(data2_A + "." + data3_AF));

        // 有功功率
        String data4_P_str = ByteUtil.byteToHex(new byte[]{payloads[17], payloads[18], payloads[19], payloads[20]});
        String data4_P_str_int = String.valueOf(Integer.parseInt(data4_P_str, 16));
        // 有功功率小数位
        short data5_P = ByteUtil.byteToShort(payloads[21]);
        valueMap.put("gen_watt_acpt", new BigDecimal(data4_P_str_int + "." + data5_P).multiply(new BigDecimal("0.001")));

        // 无功功率值
        String data4_P1_str = ByteUtil.byteToHex(new byte[]{payloads[22], payloads[23], payloads[24], payloads[25]});
        String data4_P1_str_int = String.valueOf(Integer.parseInt(data4_P1_str, 16));
        // 无功功率小数位
        short data5_P1 = ByteUtil.byteToShort(payloads[26]);
        valueMap.put("gen_watt_rept", new BigDecimal(data4_P1_str_int + "." + data5_P1).multiply(new BigDecimal("0.001")));

        // 功率因素 百分比
        short data5_P2 = ByteUtil.byteToShort(payloads[27]);
        valueMap.put("gen_watt_pft", new BigDecimal(data5_P2 + "").multiply(new BigDecimal("0.01")));
        // 漏电量
        short data5_kw = ByteUtil.bytesToShort(payloads[28], payloads[29]);
        //电量值
        String data6_kw_str = ByteUtil.byteToHex(new byte[]{payloads[30], payloads[31], payloads[32], payloads[33]});
        String data6_kw_str_int = String.valueOf(Integer.parseInt(data6_kw_str, 16));
        // 电量值小数位
        short data7_kw = ByteUtil.byteToShort(payloads[34]);
        String data7_kw_str = "";
        if (data7_kw < 10) {
            data7_kw_str = "0" + data7_kw;
        }else {
            data7_kw_str = String.valueOf(data7_kw);
        }
//        valueMap.put("gen_watt_paet", new BigDecimal(data6_kw_str_int + "." + data7_kw).multiply(new BigDecimal("0.001")));
        // 度 ---> KwH
        valueMap.put("gen_watt_paet", new BigDecimal(data6_kw_str_int + "." + data7_kw_str));
        Map<String, String> mapAddr = new HashMap<>();
        mapAddr.put("devMeterCommAddr", addr);
        mapAddr.put("devTermCommAddr", tpcs[2]);
        TimuGmDevMeterDo devMeterByDevMeterCommAddr = timuDevMeterService.getDevMeterByDevMeterCommAddr(mapAddr);
        TimuGmopsDevMeter timuGmDevMeterDo = new TimuGmopsDevMeter();
        timuGmDevMeterDo.setDevMeterId(devMeterByDevMeterCommAddr.getId());
        long timeStamp = System.currentTimeMillis();
        timuGmDevMeterDo.setGmtMessageUp(timeStamp);
        timuGmDevMeterDo.setGmtMeasdataUp(timeStamp);
        timuGmDevMeterDo.setGmtAlarmUp(timeStamp);
        timuGmDevMeterDo.setGmtReadingUp(timeStamp);
        timuGmDevMeterDo.setValid(true);

        /**
         *  insertRequest.getPayload(),
         *                     insertRequest.getTopic(),
         *                     insertRequest.getTopic(),
         *                     insertRequest.getQos(),
         *                     insertRequest.isRetained(),
         *                     insertRequest.isDuplicate(),
         *                     insertRequest.getReceivedProductKey(),
         *                     insertRequest.getReceivedClientId(),
         *                     insertRequest.getReceivedMessageId(),
         */

        // 解析的数据记录日志
        TimuMqttmsgReceivedLogDo receivedLogDo = new TimuMqttmsgReceivedLogDo();
        receivedLogDo.setPayload(payloadByte);
        receivedLogDo.setReceivedClientId(addr);
        receivedLogDo.setTopic("");
        receivedLogDo.setAnalysis(JsonConvertUtils.convertToString(valueMap));
        receivedLogDo.setRetained(false);
        receivedLogDo.setDuplicate(false);
        receivedLogDo.setReceivedMessageId(addr);
        receivedLogDo.setReceivedProductKey("YINDE");
        timuMqttmsgLogService.insertOrUpdateTimuMqttmsgReceivedValueLog(receivedLogDo);

        // 1 打开，0，关闭
        timuGmDevMeterDo.setMeterStateOpen(data0);
        timuDevMeterService.insertOrUpdateTimuGmDevMeterDo(timuGmDevMeterDo);
        TimuUtil.updateValue(devMeterByDevMeterCommAddr.getMeasPointId(), valueMap, measDataStoreService, accessMgmtService);
        soeRecordOnOffAlarmService.updateBoundSoeRecordOnOffAlarmDo(measDataService);
        SoeRecordOnOffAlarmDo onOffAlarmDo = new SoeRecordOnOffAlarmDo();
        onOffAlarmDo.setOnOff(status);
        onOffAlarmDo.setDevMeterCommAddr(addr);
        onOffAlarmDo.setDevTermCommAddr(tpcs[2]);
        soeRecordOnOffAlarmService.updateSoeRecordOnOffAlarmDo(onOffAlarmDo);

    }

    /**
     * 2.6.	错误码--36H
     *
     * @param mqttDataCommonDo
     * @param mqttMessageService
     */
    private void resolver36(TimuMqttDataCommonDo mqttDataCommonDo, TimuMqttMessageService mqttMessageService) {
//        mqttMessageService.insertOrUpdateTimuMqttSubscriptions(mqttDataCommonDo);
    }

    /**
     * 2.7.	服务下发开关命令--37H
     */
    private void resolver37(byte[] payloads, TimuDevMeterService timuDevMeterService, String[] tpcs, SoeRecordOnOffAlarmService soeRecordOnOffAlarmService) {

        String payloadByte = byteToHex(payloads).toUpperCase();
        String addr = payloadByte.substring(8, 20);

        String value = payloadByte.substring(22, 24);

        // 根据开关地址查询表计地址
        Map<String, String> mapAddr = new HashMap<>();
        mapAddr.put("devMeterCommAddr", addr);
        mapAddr.put("devTermCommAddr", tpcs[2]);
        TimuGmDevMeterDo devMeterByDevMeterCommAddr = timuDevMeterService.getDevMeterByDevMeterCommAddr(mapAddr);
        if (devMeterByDevMeterCommAddr != null) {
            TimuGmopsDevMeter timuGmDevMeterDo = new TimuGmopsDevMeter();
            timuGmDevMeterDo.setDevMeterId(devMeterByDevMeterCommAddr.getId());
            // 1 打开，0，关闭
            timuGmDevMeterDo.setMeterStateOpen(value.equals("02") ? 1 : 0);

            long timeStamp = System.currentTimeMillis();
            timuGmDevMeterDo.setGmtMessageUp(timeStamp);
            timuGmDevMeterDo.setGmtMeasdataUp(timeStamp);
            timuGmDevMeterDo.setGmtAlarmUp(timeStamp);
            timuGmDevMeterDo.setGmtReadingUp(timeStamp);
            timuGmDevMeterDo.setValid(true);
            timuGmDevMeterDo.setCreator("");
            timuGmDevMeterDo.setModifier("");
            timuGmDevMeterDo.setInvalider("");
            timuGmDevMeterDo.setGmtInvalid(timeStamp);

            timuDevMeterService.insertOrUpdateTimuGmDevMeterDo(timuGmDevMeterDo);
        }

        SoeRecordOnOffAlarmDo onOffAlarmDo = new SoeRecordOnOffAlarmDo();
        onOffAlarmDo.setOnOff(value.equals("02"));
        String toHex = byteToHex(payloads);
        String substring = toHex.substring(8, 20);
        onOffAlarmDo.setDevMeterCommAddr(substring);
        onOffAlarmDo.setDevTermCommAddr(tpcs[2]);
        soeRecordOnOffAlarmService.updateSoeRecordOnOffAlarmDo(onOffAlarmDo);
    }


    /**
     * 2.18.	上报三相重合闸数据--48H(半小时上报一次)
     */
    private void resolver48(String decCmd, TimuDevMeterService timuDevMeterService, MeasDataStoreService measDataStoreService,
                            AccessMgmtService accessMgmtService, String[] tpcs, MeasDataService measDataService,
                            SoeRecordOnOffAlarmService soeRecordOnOffAlarmService) {
        // 表记地址
        String meterAddress = decCmd.substring(2, 14);
        logger.info("meterAddress : " + meterAddress);
        Map<String, Object> valueMap = new HashMap<>();
        valueMap = value48(decCmd, valueMap);

        String statu = decCmd.substring(16, 18);
        Boolean status = false;
        byte data0 = 0;
        if (statu.equals("02")) {
            status = true;
            data0 = 1;
        } else {
            status = false;
            data0 = 0;
        }
        Map<String, String> mapAddr = new HashMap<>();
        mapAddr.put("devMeterCommAddr", meterAddress);
        mapAddr.put("devTermCommAddr", tpcs[2]);
        TimuGmDevMeterDo devMeterByDevMeterCommAddr = timuDevMeterService.getDevMeterByDevMeterCommAddr(mapAddr);
        TimuGmopsDevMeter timuGmDevMeterDo = new TimuGmopsDevMeter();
        timuGmDevMeterDo.setDevMeterId(devMeterByDevMeterCommAddr.getId());
        long timeStamp = System.currentTimeMillis();
        timuGmDevMeterDo.setGmtMessageUp(timeStamp);
        timuGmDevMeterDo.setGmtMeasdataUp(timeStamp);
        timuGmDevMeterDo.setGmtAlarmUp(timeStamp);
        timuGmDevMeterDo.setGmtReadingUp(timeStamp);
        timuGmDevMeterDo.setValid(true);
        // 1 打开，0，关闭
        timuGmDevMeterDo.setMeterStateOpen(data0);
        timuDevMeterService.insertOrUpdateTimuGmDevMeterDo(timuGmDevMeterDo);
        TimuUtil.updateValue(devMeterByDevMeterCommAddr.getMeasPointId(), valueMap, measDataStoreService, accessMgmtService);
        soeRecordOnOffAlarmService.updateBoundSoeRecordOnOffAlarmDo(measDataService);

        SoeRecordOnOffAlarmDo onOffAlarmDo = new SoeRecordOnOffAlarmDo();
        onOffAlarmDo.setOnOff(status);
        onOffAlarmDo.setDevMeterCommAddr(meterAddress);
        onOffAlarmDo.setDevTermCommAddr(tpcs[2]);
        soeRecordOnOffAlarmService.updateSoeRecordOnOffAlarmDo(onOffAlarmDo);
    }

    private Map<String, Object> value48(String decCmd, Map<String, Object> valueMap) {

        String statu = decCmd.substring(16, 18);

        String genWattPaet = decCmd.substring(26, 34);
        String genWattIl = decCmd.substring(34, 38);
        String genWattAcpt = decCmd.substring(38, 44);
        String genWattRept = decCmd.substring(44, 50);
        String groupWattPf = decCmd.substring(50, 52);
        String genWattUa = decCmd.substring(52, 56);
        String genWattIa = decCmd.substring(56, 60);
        String genWattAcpa = decCmd.substring(60, 66);
        String genWattRepa = decCmd.substring(66, 72);
        String genWattPfa = decCmd.substring(72, 74);
        String genWattTempa = decCmd.substring(74, 76);
        String genWattUb = decCmd.substring(76, 80);
        String genWattIb = decCmd.substring(80, 84);
        String genWattAcpb = decCmd.substring(84, 90);
        String genWattRepb = decCmd.substring(90, 96);
        String genWattPfb = decCmd.substring(96, 98);
        String genWattTempb = decCmd.substring(98, 100);
        String genWattUc = decCmd.substring(100, 104);
        String genWattIc = decCmd.substring(104, 108);
        String genWattAcpc = decCmd.substring(108, 114);
        String genWattRepc = decCmd.substring(114, 120);
        String genWattPfc = decCmd.substring(120, 122);
        String genWattTempc = decCmd.substring(122, 124);
        String genWattSvgLoadIn = decCmd.substring(124, 128);
        String genWattTempn = decCmd.substring(128, 130);

        Boolean status = false;

        if (statu.equals("02")) {
            status = true;
        } else {
            status = false;
        }
        valueMap.put("gen_watt_state_open", status);

        /**
         * 除了开关状态，其它数据类型都用 bigdecimal
         * status			1			总状态
         * group_watt_u 	2		三相电压（群组）
         * group_watt_i	2		三相电流（群组）
         * stats_usage_watt_paet 4	正向有功总用电量 gen_watt_paet genWattPaet
         * gen_watt_il		2		漏电电流
         * gen_watt_acpt	3		总有功功率
         * gen_watt_rept	3		总无功功率    gen_watt_rept      genWattRept
         * group_watt_pf	1		功率因数      gen_watt_pft
         *
         * gen_watt_ua		2		A相电压
         * gen_watt_ia		2		A相电流
         * gen_watt_acpa	3		A相有功功率
         * gen_watt_repa	3		A相无功功率
         * gen_watt_pfa	1		A相功率因数
         * gen_watt_tempa	1		A相线温度
         * gen_watt_ub		2		B相电压
         * gen_watt_ib		2		B相电流
         * gen_watt_acpb	3		B相有功功率
         * gen_watt_repb	3		B相无功功率
         * gen_watt_pfb	1		B相功率因数
         * gen_watt_tempb	1		B相线温度
         *
         * gen_watt_uc		2		C相电压
         * gen_watt_ic		2		C相电流
         * gen_watt_acpc	3		C相有功功率
         * gen_watt_repc	3		C相无功功率
         * gen_watt_pfc	1		C相功率因数
         * gen_watt_tempc	1		C相线温度
         * gen_watt_in 2	负载N线电流
         * gen_watt_tempn	1		零线温度
         *
         * 总状态 1 HEX data 01H  ：断开  ：02H  闭合  03H:离线      - gen_watt_state_open
         * 总电压 2 HEX data 总电压，精确度0.1V  (不要存)
         * 总电流 2 HEX data 总电流，精确度0.01A  (不要存)
         * 总电量 4 HEX data 总电量，精确度0.01KW.H                  - gen_watt_paet
         * 总漏电 2 HEX data 总漏电，精确度1mA                       - gen_watt_il
         * 总有功功率 3 HEX data 有功总功率，精确度1W                 - gen_watt_acpt
         * 总无功功率 3 HEX data 无功总功率，精确度1W                 - gen_watt_rept
         * 功率因素 1 HEX data 功率因素 百分比                          - gen_watt_pft * 0.01
         * A相电压 2 HEX data A相电压，精确度0.1V                      - gen_watt_ua
         * A相电流 2 HEX data A相电流，精确度0.01A   `                 - gen_watt_ia
         * A有功功率 3 HEX data A有功功率，精确度1W                   - gen_watt_acpa
         * A无功功率 3 HEX data A无功功率，精确度1W                   - gen_watt_repa
         * A功率因素 1 HEX data A功率因素 百分比                      - gen_watt_pfa * 0.01
         * A相温度 1 HEX data A相温度，补码格式，-127~128温度            - gen_watt_tempa
         * B相电压 2 HEX data B相电压，精确度0.1V                        - gen_watt_ub
         * B相电流 2 HEX data B相电流，精确度0.01A                       - gen_watt_ib
         * B有功功率 3 HEX data B  功率，精确度1W                     - gen_watt_acpb
         * B无功功率 3 HEX data B功率，精确度1W                       - gen_watt_repb
         * B功率因素 1 HEX data B功率因素 百分比                       - gen_watt_pfb * 0.01
         * B相温度 1 HEX data B相温度，补码格式，-127~128温度            - gen_watt_tempb
         * C相电压 2 HEX data C相电压，精确度0.1V                        - gen_watt_uc
         * C相电流 2 HEX data C相电流，精确度0.01A                       - gen_watt_ic
         * C有功功率 3 HEX data C有功功率，精确度1W                     - gen_watt_acpc
         * C无功功率 3 HEX data C无功功率，精确度1W                     - gen_watt_repc
         * C功率因素 1 HEX data C功率因素 百分比                        - gen_watt_pfc * 0.01
         * C相温度 1 HEX data C相温度，补码格式，-127~128温度            - gen_watt_tempc
         * N线电流 2 HEX data N线电流，精确度0.01A                      - gen_watt_in
         * N线温度 1 HEX data N线温度，补码格式，-127~128温度            - gen_watt_tempn
         * DATA8-KEY 4 HEX data 目前开关次数  (不要存)
         * DATA-Hour 1 HEX Data 半个小时标记，1-48  (不要存)
         */

        int gen_watt_paet = TimuUtil.hexStrToInt(genWattPaet);
        BigDecimal gen_watt_paet1 = new BigDecimal(gen_watt_paet).multiply(BigDecimal.valueOf(0.01));
        valueMap.put("gen_watt_paet", gen_watt_paet1);

        int gen_watt_il = TimuUtil.hexStrToInt(genWattIl);
        valueMap.put("gen_watt_il", new BigDecimal(gen_watt_il));

        int gen_watt_acpt = TimuUtil.hexStrToInt(genWattAcpt);
        BigDecimal gen_watt_acpt1 = new BigDecimal(gen_watt_acpt).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_acpt", gen_watt_acpt1);

        int gen_watt_rept = TimuUtil.hexStrToInt(genWattRept);
        BigDecimal gen_watt_rept1 = new BigDecimal(gen_watt_rept).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_rept", gen_watt_rept1);

//        int gen_watt_pft = TimuUtil.hexStrToInt(genWattRept);
//        BigDecimal gen_watt_pft1 = new BigDecimal(gen_watt_pft).multiply(BigDecimal.valueOf(0.001));
//        valueMap.put("gen_watt_pft", gen_watt_pft1);

        int gen_watt_pft = TimuUtil.hexStrToInt(groupWattPf);
        BigDecimal gen_watt_pft1 = new BigDecimal(gen_watt_pft).multiply(new BigDecimal("0.01"));
        valueMap.put("gen_watt_pft", gen_watt_pft1);

        int gen_watt_ua = TimuUtil.hexStrToInt(genWattUa);
        BigDecimal gen_watt_ua1 = new BigDecimal(gen_watt_ua).multiply(BigDecimal.valueOf(0.1));
        valueMap.put("gen_watt_ua", gen_watt_ua1);

        int gen_watt_ia = TimuUtil.hexStrToInt(genWattIa);
        BigDecimal gen_watt_ia1 = new BigDecimal(gen_watt_ia).multiply(BigDecimal.valueOf(0.01));
        valueMap.put("gen_watt_ia", gen_watt_ia1);

        int gen_watt_acpa = TimuUtil.hexStrToInt(genWattAcpa);
        BigDecimal gen_watt_acpa1 = new BigDecimal(gen_watt_acpa).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_acpa", gen_watt_acpa1);

        int gen_watt_repa = TimuUtil.hexStrToInt(genWattRepa);
        BigDecimal gen_watt_repa1 = new BigDecimal(gen_watt_repa).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_repa", gen_watt_repa1);

        int gen_watt_pfa = TimuUtil.hexStrToInt(genWattPfa);
        BigDecimal gen_watt_pfa1 = new BigDecimal(gen_watt_pfa).multiply(new BigDecimal("0.01"));
        valueMap.put("gen_watt_pfa", gen_watt_pfa1);

        int gen_watt_tempa = TimuUtil.hexStrToInt(genWattTempa);
        BigDecimal gen_watt_tempa1 = new BigDecimal(gen_watt_tempa);
        valueMap.put("gen_watt_tempa", gen_watt_tempa1);


        int gen_watt_ub = TimuUtil.hexStrToInt(genWattUb);
        BigDecimal gen_watt_ub1 = new BigDecimal(gen_watt_ub).multiply(BigDecimal.valueOf(0.1));
        valueMap.put("gen_watt_ub", gen_watt_ub1);

        int gen_watt_ib = TimuUtil.hexStrToInt(genWattIb);
        BigDecimal gen_watt_ib1 = new BigDecimal(gen_watt_ib).multiply(BigDecimal.valueOf(0.01));
        valueMap.put("gen_watt_ib", gen_watt_ib1);

        int gen_watt_acpb = TimuUtil.hexStrToInt(genWattAcpb);
        BigDecimal gen_watt_acpb1 = new BigDecimal(gen_watt_acpb).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_acpb", gen_watt_acpb1);

        int gen_watt_repb = TimuUtil.hexStrToInt(genWattRepb);
        BigDecimal gen_watt_repb1 = new BigDecimal(gen_watt_repb).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_repb", gen_watt_repb1);

        int gen_watt_pfb = TimuUtil.hexStrToInt(genWattPfb);
        BigDecimal gen_watt_pfb1 = new BigDecimal(gen_watt_pfb).multiply(new BigDecimal("0.01"));
        valueMap.put("gen_watt_pfb", gen_watt_pfb1);

        int gen_watt_tempb = TimuUtil.hexStrToInt(genWattTempb);
        BigDecimal gen_watt_tempb1 = new BigDecimal(gen_watt_tempb);
        valueMap.put("gen_watt_tempb", gen_watt_tempb1);

        int gen_watt_uc = TimuUtil.hexStrToInt(genWattUc);
        BigDecimal gen_watt_uc1 = new BigDecimal(gen_watt_uc).multiply(BigDecimal.valueOf(0.1));
        valueMap.put("gen_watt_uc", gen_watt_uc1);

        int gen_watt_ic = TimuUtil.hexStrToInt(genWattIc);
        BigDecimal gen_watt_ic1 = new BigDecimal(gen_watt_ic).multiply(BigDecimal.valueOf(0.01));
        valueMap.put("gen_watt_ic", gen_watt_ic1);

        int gen_watt_acpc = TimuUtil.hexStrToInt(genWattAcpc);
        BigDecimal gen_watt_acpc1 = new BigDecimal(gen_watt_acpc).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_acpc", gen_watt_acpc1);

        int gen_watt_repc = TimuUtil.hexStrToInt(genWattRepc);
        BigDecimal gen_watt_repc1 = new BigDecimal(gen_watt_repc).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_repc", gen_watt_repc1);

        int gen_watt_pfc = TimuUtil.hexStrToInt(genWattPfc);
        BigDecimal gen_watt_pfc1 = new BigDecimal(gen_watt_pfc).multiply(new BigDecimal("0.01"));
        valueMap.put("gen_watt_pfc", gen_watt_pfc1);

        int gen_watt_tempc = TimuUtil.hexStrToInt(genWattTempc);
        BigDecimal gen_watt_tempc1 = new BigDecimal(gen_watt_tempc);
        valueMap.put("gen_watt_tempc", gen_watt_tempc1);

        int gen_watt_in = TimuUtil.hexStrToInt(genWattSvgLoadIn);
        BigDecimal gen_watt_in1 = new BigDecimal(gen_watt_in).multiply(BigDecimal.valueOf(0.01));
        valueMap.put("gen_watt_in", gen_watt_in1);

        int gen_watt_tempn = TimuUtil.hexStrToInt(genWattTempn);
        BigDecimal gen_watt_tempn1 = new BigDecimal(gen_watt_tempn);
        valueMap.put("gen_watt_tempn", gen_watt_tempn1);

        return valueMap;
    }

    /**
     * byte数组转hex
     *
     * @param bytes
     * @return
     */
    private static String byteToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; n++) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            // 每个字节由两个字符表示，位数不够，高位补0
            sb.append((strHex.length() == 1) ? "0" + strHex : strHex);
        }
        return sb.toString().trim();
    }


}
