package com.iesms.springbootapps.bizprocessors.timuiot.handler;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.AccessMgmtService;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.easesource.iot.datacenter.openservice.entity.RunMeasPointVo;
import com.easesource.iot.datacenter.openservice.request.RunAccessGatewayGetRequest;
import com.easesource.iot.datacenter.openservice.response.RunAccessGatewayGetResponse;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDo;
import com.iesms.bizprocessors.common.service.GmDevMeterService;
import com.iesms.bizprocessors.common.service.GmopsDevMeterService;
import com.iesms.bizprocessors.common.service.SoeRecordOnOffAlarmService;
import com.iesms.bizprocessors.timuiotgateway.entity.*;
import com.iesms.bizprocessors.timuiotgateway.request.TimuMqttmsgReceivedLogInsertRequest;
import com.iesms.bizprocessors.timuiotgateway.response.TimuReturnResponse;
import com.iesms.bizprocessors.timuiotgateway.service.TimuDevMeterService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttMessageService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttSubscriptionsService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuMqttmsgLogService;
import com.iesms.springbootapps.bizprocessors.timuiot.frame.request.ServiceIssuesTheSwitchCommand;
import com.iesms.springbootapps.bizprocessors.timuiot.frame.request.SubmitCircuitBreakerData1p;
import com.iesms.springbootapps.bizprocessors.timuiot.frame.request.SubmitCircuitBreakerData3p;
import com.iesms.springbootapps.bizprocessors.timuiot.gateway.TimuIotMqttSendGateway;
import com.iesms.springbootapps.bizprocessors.timuiot.pack.BasePacket;
import com.iesms.springbootapps.bizprocessors.timuiot.utils.ByteUtil;
import com.iesms.springbootapps.bizprocessors.timuiot.utils.TimuUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.*;
import java.util.stream.Collectors;

/***
 * 功能描述   数据入库
 * @author zhouyi
 * @return
 * @data 2021/5/20
 *
 */
public class TimuMessageResolverNew {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private final String UPCOMM_PROTO = "MQTT_TIMUIOT";


    @Resource
    private GmDevMeterService gmDevMeterService;

    @Resource(name = "gmopsDevMeterServiceImpl")
    private GmopsDevMeterService gmopsDevMeterService;


    /**
     * 规约解析入口
     *
     * @param insertRequest
     * @param timuMqttmsgLogService
     * @param timuMqttSubscriptionsService
     * @param topic
     */
    public void resolver(TimuMqttmsgReceivedLogInsertRequest insertRequest,
                         TimuMqttmsgLogService timuMqttmsgLogService,
                         TimuMqttSubscriptionsService timuMqttSubscriptionsService,
                         AccessMgmtService accessMgmtService,
                         MeasDataStoreService measDataStoreService,
                         GmDevMeterService gmDevMeterService,
                         TimuDevMeterService timuDevMeterService,
                         TimuIotMqttSendGateway mqttSendGateway,
                         Map<String, Long> measPointIdReverseMap,
                         BasePacket basePacket,
                         String topic, MeasDataService measDataService,
                         SoeRecordOnOffAlarmService soeRecordOnOffAlarmService) {


        String[] tpcs = insertRequest.getTopic().split("/");
        byte[] payloads = insertRequest.getPayloadBytes();
        //接收消息产品
        String receivedProductKey = tpcs[0];
        //
        String receivedControllerId = tpcs[2];
        /*TIMU MQTT消息接收日志表插入数据*/
        TimuReturnResponse returnResponse = timuMqttmsgLogService.insertTimuMqttmsgReceivedLog(insertRequest);
        //接收消息客户端标识
        String receivedClientId = basePacket.getAddr().toString();
        RunAccessGatewayGetRequest runAccessGatewayGetRequest = new RunAccessGatewayGetRequest();
        runAccessGatewayGetRequest.setProductKey(receivedProductKey);
        runAccessGatewayGetRequest.setUpcommProto(UPCOMM_PROTO);
        runAccessGatewayGetRequest.setUpcommLogicAddr(receivedControllerId);
        RunAccessGatewayGetResponse runAccessGatewayGetResponse = null;
        try {
            runAccessGatewayGetResponse = accessMgmtService.getRunAccessGateway(runAccessGatewayGetRequest);
        } catch (RuntimeException e) {
            e.printStackTrace();
        }

        // gen_watt_ua:A相电压, gen_watt_ia,A相电流
        /**
         *
         *group_watt_acp,有功功率
         * group_watt_rep,无功功率
         * group_watt_pf,功率因数
         * gen_watt_pft,总功率因数
         * gen_watt_pfa,A相功率因数
         * gen_watt_paet,正向有功总电能示值
         */
        logger.info("receivedClientId : " + receivedClientId);
        //地址域
        String addr = basePacket.getAddr().toString();
        //控制域
        String controlCode = Integer.toHexString(basePacket.getCtrl().intValue());
        if (!controlCode.equals("81")) {
            return;
        }
        //功能码
        Short type = null;
       if(basePacket.getFrameType() == null){
           return;
       }else {
           type = basePacket.getFrameType().getValue();
       }

        Long measPointId = null;
        if (type != 49 && runAccessGatewayGetResponse != null) {
            List<RunMeasPointVo> list = runAccessGatewayGetResponse.getRunMeasPointList().stream().filter(elem -> elem.getAccessMeasureNo().equals(receivedClientId)).collect(Collectors.toList());
            list.removeIf(Objects::isNull);
            if (list.size() > 0) {
                measPointId = list.get(0).getId();
            }
        }


        // 更新网关状态
        Map<String, String> map = new HashMap<>();
        map.put("devTermCommAddr", receivedControllerId);
        TimuGmopsDevTermDo timuGmopsDevTermByAddr = timuDevMeterService.getTimuGmopsDevTermByAddr(map);
        if (timuGmopsDevTermByAddr != null && timuGmopsDevTermByAddr.getDevTermId() != null) {
            // 更新网关状态
            timuDevMeterService.insertOrUpdateTimuGmopsDevTerm(timuGmopsDevTermByAddr);
        }
        /*根据功能码来解析对应得数据入库*/
        switch (type) {
            case 53:
                resolver35(topic, payloads, basePacket, timuDevMeterService, measDataStoreService, accessMgmtService, tpcs, measDataService,
                        soeRecordOnOffAlarmService, timuMqttmsgLogService);
                break;
            case 72:
                resolver48(topic, payloads, basePacket, timuDevMeterService, measDataStoreService, accessMgmtService, tpcs, measDataService,
                        soeRecordOnOffAlarmService, timuMqttmsgLogService);
                break;
            case 55:
                resolver37(basePacket, timuDevMeterService, tpcs, soeRecordOnOffAlarmService);
                break;
            default:
                break;
        }
    }

    /**
     * 2.5.	上报断路器数据--35H(半小时上报一次)
     *
     * @param payloads
     * @param timuDevMeterService
     */
    private void resolver35(String topic, byte[] payloads, BasePacket basePacket, TimuDevMeterService timuDevMeterService, MeasDataStoreService measDataStoreService,
                            AccessMgmtService accessMgmtService, String[] tpcs, MeasDataService measDataService,
                            SoeRecordOnOffAlarmService soeRecordOnOffAlarmService,
                            TimuMqttmsgLogService timuMqttmsgLogService) {
        if (!tpcs[1].equals("LINKtoSERVER")) {
            logger.error("主题有误");
            return;
        }

        /**
         * 除了开关状态，其它数据类型都用 bigdecimal
         *gen_watt_ua:A相电压,
         * gen_watt_ia,A相电流
         * gen_watt_acpt,有功功率 w转换为kw 乘以  0.001
         * gen_watt_rept,无功功率 w转换为kw 乘以 0.001
         * gen_watt_pft,总功率因数 百分比 乘以 0。01
         * gen_watt_paet,正向有功总电能示值
         */
        String addr = basePacket.getAddr().toString();
        String payloadByte = byteToHex(payloads).toUpperCase();
        SubmitCircuitBreakerData1p submitCircuitBreakerData1p = (SubmitCircuitBreakerData1p) basePacket.getFrame();

        if (addr.equals("000000000000")) {
            logger.error("地址有误");
            return;
        }
        Map<String, Object> valueMap = new HashMap<>();
        // 开关状态 gen_watt_state_open
        String genWattStateOpen = submitCircuitBreakerData1p.getGenWattStateOpen().toString();
        byte data0;
        Boolean status = false;
        if (genWattStateOpen.equals("2")) {
            status = true;
            data0 = 1;
        } else {
            data0 = 0;
        }
        valueMap.put("gen_watt_state_open", status);
        // 电压值
        int genWattUa = submitCircuitBreakerData1p.getGenWattUa();
        valueMap.put("gen_watt_ua", new BigDecimal(genWattUa + ""));
        // 电流值
        int genWattIa = submitCircuitBreakerData1p.getGenWattIa();
        // 电流值小数位
        int genWattIaX = submitCircuitBreakerData1p.getGenWattIaX();
        valueMap.put("gen_watt_ia", new BigDecimal(genWattIa + "." + genWattIaX));

        // 有功功率
        int genWattAcpa = submitCircuitBreakerData1p.getGenWattAcpa();
        // 有功功率小数位
        int genWattAcpaX = submitCircuitBreakerData1p.getGenWattAcpaX();
        valueMap.put("gen_watt_acpt", new BigDecimal(genWattAcpa + "." + genWattAcpaX).multiply(new BigDecimal("0.001")));

        // 无功功率值
        int genWattRepa = submitCircuitBreakerData1p.getGenWattRepa();
        // 无功功率小数位
        int genWattRepaX = submitCircuitBreakerData1p.getGenWattRepaX();
        valueMap.put("gen_watt_rept", new BigDecimal(genWattRepa + "." + genWattRepaX).multiply(new BigDecimal("0.001")));

        // 功率因素 百分比
        short genWattPft = submitCircuitBreakerData1p.getGenWattPft();
        valueMap.put("gen_watt_pft", new BigDecimal(genWattPft + "").multiply(new BigDecimal("0.01")));
        // 漏电量
        int leakagePower = submitCircuitBreakerData1p.getLeakagePower();
        //电量值
        int electricQuantity = submitCircuitBreakerData1p.getElectricQuantity();
        // 电量值小数位
        int electricQuantityX = submitCircuitBreakerData1p.getElectricQuantityX();
        valueMap.put("gen_watt_paet", new BigDecimal(electricQuantity + "." + electricQuantityX));
        if (logger.isDebugEnabled()) {
            logger.debug("valueMap:    " + valueMap);
        }

        Map<String, String> mapAddr = new HashMap<>();
        mapAddr.put("devMeterCommAddr", addr);
        mapAddr.put("devTermCommAddr", tpcs[2]);
        //根据通讯地址查询表计地址
        TimuGmDevMeterDo devMeterByDevMeterCommAddr = timuDevMeterService.getDevMeterByDevMeterCommAddr(mapAddr);
        //入库
        dataProcessing(topic, payloadByte, valueMap, timuDevMeterService, measDataStoreService, accessMgmtService, tpcs, measDataService,
                soeRecordOnOffAlarmService, timuMqttmsgLogService, devMeterByDevMeterCommAddr, data0, status, addr);

    }


    /**
     * 2.18.	上报三相重合闸数据--48H(半小时上报一次)
     */
    private void resolver48(String topic, byte[] payloads, BasePacket basePacket, TimuDevMeterService timuDevMeterService, MeasDataStoreService measDataStoreService,
                            AccessMgmtService accessMgmtService, String[] tpcs, MeasDataService measDataService,
                            SoeRecordOnOffAlarmService soeRecordOnOffAlarmService,
                            TimuMqttmsgLogService timuMqttmsgLogService) {
        if (!tpcs[1].equals("LINKtoSERVER")) {
            logger.error("主题有误");
            return;
        }

        //16进制报文
        String payloadByte = byteToHex(payloads).toUpperCase();
        // 表记地址
        String addr = basePacket.getAddr().toString();

        if (addr.equals("000000000000")) {
            logger.error("地址有误");
            return;
        }
        logger.info("meterAddress : " + addr);
        Map<String, Object> valueMap = new HashMap<>();
        valueMap = value48(basePacket, valueMap);
        SubmitCircuitBreakerData3p submitCircuitBreakerData3p = (SubmitCircuitBreakerData3p) basePacket.getFrame();
        String genWattStateOpen = submitCircuitBreakerData3p.getGenWattStateOpen().toString();
        Boolean status = false;
        byte data0 = 0;
        if (genWattStateOpen.equals("2")) {
            status = true;
            data0 = 1;
        } else {
            status = false;
            data0 = 0;
        }
        Map<String, String> mapAddr = new HashMap<>();
        mapAddr.put("devMeterCommAddr", addr);
        mapAddr.put("devTermCommAddr", tpcs[2]);
        TimuGmDevMeterDo devMeterByDevMeterCommAddr = timuDevMeterService.getDevMeterByDevMeterCommAddr(mapAddr);

        dataProcessing(topic, payloadByte, valueMap, timuDevMeterService, measDataStoreService, accessMgmtService, tpcs, measDataService,
                soeRecordOnOffAlarmService, timuMqttmsgLogService, devMeterByDevMeterCommAddr, data0, status, addr);
    }

    /***
     * 功能描述  服务器下发开关命令
     * @author zhouyi
     * @return java.util.Map<java.lang.String, java.lang.Object>
     * @data 2021/5/21
     */
    private void resolver37(BasePacket basePacket, TimuDevMeterService timuDevMeterService, String[] tpcs, SoeRecordOnOffAlarmService soeRecordOnOffAlarmService) {

        //地址域
        String addr = basePacket.getAddr().toString();
        ServiceIssuesTheSwitchCommand command = (ServiceIssuesTheSwitchCommand) basePacket.getFrame();
        if(command.getStatus() == null){
            return;
        }
        //状态
        String value = command.getStatus().toString();

        // 根据开关地址查询表计地址
        Map<String, String> mapAddr = new HashMap<>();
        mapAddr.put("devMeterCommAddr", addr);
        mapAddr.put("devTermCommAddr", tpcs[2]);
        TimuGmDevMeterDo devMeterByDevMeterCommAddr = timuDevMeterService.getDevMeterByDevMeterCommAddr(mapAddr);
        if (devMeterByDevMeterCommAddr != null) {
            TimuGmopsDevMeter timuGmDevMeterDo = new TimuGmopsDevMeter();
            timuGmDevMeterDo.setDevMeterId(devMeterByDevMeterCommAddr.getId());
            // 1 打开，0，关闭
            timuGmDevMeterDo.setMeterStateOpen(value.equals("2") ? 1 : 0);

            long timeStamp = System.currentTimeMillis();
            timuGmDevMeterDo.setGmtMessageUp(timeStamp);
            timuGmDevMeterDo.setGmtMeasdataUp(timeStamp);
            timuGmDevMeterDo.setGmtAlarmUp(timeStamp);
            timuGmDevMeterDo.setGmtReadingUp(timeStamp);
            timuGmDevMeterDo.setValid(true);
            timuGmDevMeterDo.setCreator("");
            timuGmDevMeterDo.setModifier("");
            timuGmDevMeterDo.setInvalider("");
            timuGmDevMeterDo.setGmtInvalid(timeStamp);

            timuDevMeterService.insertOrUpdateTimuGmDevMeterDo(timuGmDevMeterDo);
        }
        SoeRecordOnOffAlarmDo onOffAlarmDo = new SoeRecordOnOffAlarmDo();
        onOffAlarmDo.setOnOff(value.equals("2"));
        onOffAlarmDo.setDevMeterCommAddr(addr);
        onOffAlarmDo.setDevTermCommAddr(tpcs[2]);
        soeRecordOnOffAlarmService.updateSoeRecordOnOffAlarmDo(onOffAlarmDo);
    }


    private Map<String, Object> value48(BasePacket basePacket, Map<String, Object> valueMap) {

        /*获取解析后的3p数据对象*/
        SubmitCircuitBreakerData3p submitCircuitBreakerData3p = (SubmitCircuitBreakerData3p) basePacket.getFrame();
        Boolean status = false;
        //总状态
        String genWattStateOpen = submitCircuitBreakerData3p.getGenWattStateOpen().toString();
        if (genWattStateOpen.equals("2")) {
            status = true;
        } else {
            status = false;
        }
        valueMap.put("gen_watt_state_open", status);

        /**
         * 除了开关状态，其它数据类型都用 bigdecimal
         * status			1			总状态
         * group_watt_u 	2		三相电压（群组）
         * group_watt_i	2		三相电流（群组）
         * stats_usage_watt_paet 4	正向有功总用电量 gen_watt_paet genWattPaet
         * gen_watt_il		2		漏电电流
         * gen_watt_acpt	3		总有功功率
         * gen_watt_rept	3		总无功功率    gen_watt_rept      genWattRept
         * group_watt_pf	1		功率因数      gen_watt_pft
         *
         * gen_watt_ua		2		A相电压
         * gen_watt_ia		2		A相电流
         * gen_watt_acpa	3		A相有功功率
         * gen_watt_repa	3		A相无功功率
         * gen_watt_pfa	1		A相功率因数
         * gen_watt_tempa	1		A相线温度
         * gen_watt_ub		2		B相电压
         * gen_watt_ib		2		B相电流
         * gen_watt_acpb	3		B相有功功率
         * gen_watt_repb	3		B相无功功率
         * gen_watt_pfb	1		B相功率因数
         * gen_watt_tempb	1		B相线温度
         *
         * gen_watt_uc		2		C相电压
         * gen_watt_ic		2		C相电流
         * gen_watt_acpc	3		C相有功功率
         * gen_watt_repc	3		C相无功功率
         * gen_watt_pfc	1		C相功率因数
         * gen_watt_tempc	1		C相线温度
         * gen_watt_in 2	负载N线电流
         * gen_watt_tempn	1		零线温度
         *
         * 总状态 1 HEX data 01H  ：断开  ：02H  闭合  03H:离线      - gen_watt_state_open
         * 总电压 2 HEX data 总电压，精确度0.1V  (不要存)
         * 总电流 2 HEX data 总电流，精确度0.01A  (不要存)
         * 总电量 4 HEX data 总电量，精确度0.01KW.H                  - gen_watt_paet
         * 总漏电 2 HEX data 总漏电，精确度1mA                       - gen_watt_il
         * 总有功功率 3 HEX data 有功总功率，精确度1W                 - gen_watt_acpt
         * 总无功功率 3 HEX data 无功总功率，精确度1W                 - gen_watt_rept
         * 功率因素 1 HEX data 功率因素 百分比                          - gen_watt_pft * 0.01
         * A相电压 2 HEX data A相电压，精确度0.1V                      - gen_watt_ua
         * A相电流 2 HEX data A相电流，精确度0.01A   `                 - gen_watt_ia
         * A有功功率 3 HEX data A有功功率，精确度1W                   - gen_watt_acpa
         * A无功功率 3 HEX data A无功功率，精确度1W                   - gen_watt_repa
         * A功率因素 1 HEX data A功率因素 百分比                      - gen_watt_pfa * 0.01
         * A相温度 1 HEX data A相温度，补码格式，-127~128温度            - gen_watt_tempa
         * B相电压 2 HEX data B相电压，精确度0.1V                        - gen_watt_ub
         * B相电流 2 HEX data B相电流，精确度0.01A                       - gen_watt_ib
         * B有功功率 3 HEX data B  功率，精确度1W                     - gen_watt_acpb
         * B无功功率 3 HEX data B功率，精确度1W                       - gen_watt_repb
         * B功率因素 1 HEX data B功率因素 百分比                       - gen_watt_pfb * 0.01
         * B相温度 1 HEX data B相温度，补码格式，-127~128温度            - gen_watt_tempb
         * C相电压 2 HEX data C相电压，精确度0.1V                        - gen_watt_uc
         * C相电流 2 HEX data C相电流，精确度0.01A                       - gen_watt_ic
         * C有功功率 3 HEX data C有功功率，精确度1W                     - gen_watt_acpc
         * C无功功率 3 HEX data C无功功率，精确度1W                     - gen_watt_repc
         * C功率因素 1 HEX data C功率因素 百分比                        - gen_watt_pfc * 0.01
         * C相温度 1 HEX data C相温度，补码格式，-127~128温度            - gen_watt_tempc
         * N线电流 2 HEX data N线电流，精确度0.01A                      - gen_watt_in
         * N线温度 1 HEX data N线温度，补码格式，-127~128温度            - gen_watt_tempn
         * DATA8-KEY 4 HEX data 目前开关次数  (不要存)
         * DATA-Hour 1 HEX Data 半个小时标记，1-48  (不要存)
         */
        //总电量
        int totalPower = submitCircuitBreakerData3p.getTotalPower();
        BigDecimal totalPower1 = new BigDecimal(totalPower).multiply(BigDecimal.valueOf(0.01));
        valueMap.put("gen_watt_paet", totalPower1);
        //总漏电
        int totalCreepage = submitCircuitBreakerData3p.getTotalCreepage();
        valueMap.put("gen_watt_il", new BigDecimal(totalCreepage));
        //总有功功率
        int totalActivePower = submitCircuitBreakerData3p.getTotalActivePower();
        BigDecimal totalActivePower1 = new BigDecimal(totalActivePower).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_acpt", totalActivePower1);
        //总无功功率
        int totalReactivePower = submitCircuitBreakerData3p.getTotalReactivePower();
        BigDecimal totalReactivePower1 = new BigDecimal(totalReactivePower).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_rept", totalReactivePower1);
        //功率因素
        int powerFactor = submitCircuitBreakerData3p.getPowerFactor();
        BigDecimal powerFactor1 = new BigDecimal(powerFactor).multiply(new BigDecimal("0.01"));
        valueMap.put("gen_watt_pft", powerFactor1);
        //A相电压
        int genWattUa = submitCircuitBreakerData3p.getGenWattUa();
        BigDecimal genWattUa1 = new BigDecimal(genWattUa).multiply(BigDecimal.valueOf(0.1));
        valueMap.put("gen_watt_ua", genWattUa1);
        //A相电流
        int genWattIa = submitCircuitBreakerData3p.getGenWattIa();
        BigDecimal genWattIa1 = new BigDecimal(genWattIa).multiply(BigDecimal.valueOf(0.01));
        valueMap.put("gen_watt_ia", genWattIa1);
        //A相有功功率值
        int genWattAcpa = submitCircuitBreakerData3p.getGenWattAcpa();
        BigDecimal genWattAcpa1 = new BigDecimal(genWattAcpa).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_acpa", genWattAcpa1);
        //A相无功功率值
        int GenWattRepa = submitCircuitBreakerData3p.getGenWattRepa();
        BigDecimal GenWattRepa1 = new BigDecimal(GenWattRepa).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_repa", GenWattRepa1);
        //A功率因素
        int genWattPfta = submitCircuitBreakerData3p.getGenWattPfta();
        BigDecimal genWattPfta1 = new BigDecimal(genWattPfta).multiply(new BigDecimal("0.01"));
        valueMap.put("gen_watt_pfa", genWattPfta1);
        //A相温度
        int temperatureA = submitCircuitBreakerData3p.getTemperatureA();
        BigDecimal temperatureA1 = new BigDecimal(temperatureA);
        valueMap.put("gen_watt_tempa", temperatureA1);
        //B相电压
        int genWattUb = submitCircuitBreakerData3p.getGenWattUb();
        BigDecimal genWattUb1 = new BigDecimal(genWattUb).multiply(BigDecimal.valueOf(0.1));
        valueMap.put("gen_watt_ub", genWattUb1);
        //B相电流
        int genWattIb = submitCircuitBreakerData3p.getGenWattIb();
        BigDecimal genWattIb1 = new BigDecimal(genWattIb).multiply(BigDecimal.valueOf(0.01));
        valueMap.put("gen_watt_ib", genWattIb1);
        //B相有功功率值
        int genWattAcpb = submitCircuitBreakerData3p.getGenWattAcpb();
        BigDecimal genWattAcpb1 = new BigDecimal(genWattAcpb).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_acpb", genWattAcpb1);
        //B相无功功率值
        int GenWattRepb = submitCircuitBreakerData3p.getGenWattRepb();
        BigDecimal GenWattRepb1 = new BigDecimal(GenWattRepb).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_repb", GenWattRepb1);
        //B功率因素
        int genWattPftb = submitCircuitBreakerData3p.getGenWattPftb();
        BigDecimal genWattPftb1 = new BigDecimal(genWattPftb).multiply(new BigDecimal("0.01"));
        valueMap.put("gen_watt_pfb", genWattPftb1);
        //B相温度
        int temperatureB = submitCircuitBreakerData3p.getTemperatureB();
        BigDecimal temperatureB1 = new BigDecimal(temperatureB);
        valueMap.put("gen_watt_tempb", temperatureB1);

        //C相电压
        int genWattUc = submitCircuitBreakerData3p.getGenWattUc();
        BigDecimal genWattUc1 = new BigDecimal(genWattUc).multiply(BigDecimal.valueOf(0.1));
        valueMap.put("gen_watt_uc", genWattUc1);
        //C相电流
        int genWattIc = submitCircuitBreakerData3p.getGenWattIc();
        BigDecimal genWattIc1 = new BigDecimal(genWattIc).multiply(BigDecimal.valueOf(0.01));
        valueMap.put("gen_watt_ic", genWattIc1);
        //C相有功功率值
        int genWattAcpc = submitCircuitBreakerData3p.getGenWattAcpc();
        BigDecimal genWattAcpc1 = new BigDecimal(genWattAcpc).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_acpc", genWattAcpc1);
        //C相无功功率值
        int GenWattRepc = submitCircuitBreakerData3p.getGenWattRepc();
        BigDecimal GenWattRepc1 = new BigDecimal(GenWattRepc).multiply(BigDecimal.valueOf(0.001));
        valueMap.put("gen_watt_repc", GenWattRepc1);
        //C功率因素
        int genWattPftc = submitCircuitBreakerData3p.getGenWattPftc();
        BigDecimal genWattPftc1 = new BigDecimal(genWattPftc).multiply(new BigDecimal("0.01"));
        valueMap.put("gen_watt_pfc", genWattPftc1);
        //C相温度
        int temperatureC = submitCircuitBreakerData3p.getTemperatureC();
        BigDecimal temperatureC1 = new BigDecimal(temperatureC);
        valueMap.put("gen_watt_tempc", temperatureC1);
        //C线电流
        int genWattIn = submitCircuitBreakerData3p.getGenWattIn();
        BigDecimal genWattIn1 = new BigDecimal(genWattIn).multiply(BigDecimal.valueOf(0.01));
        valueMap.put("gen_watt_in", genWattIn1);
        //C线温度
        int temperatureN = submitCircuitBreakerData3p.getTemperatureN();
        BigDecimal temperatureN1 = new BigDecimal(temperatureN);
        valueMap.put("gen_watt_tempn", temperatureN1);
        return valueMap;
    }

    /**
     * byte数组转hex
     *
     * @param bytes
     * @return
     */
    private static String byteToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; n++) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            // 每个字节由两个字符表示，位数不够，高位补0
            sb.append((strHex.length() == 1) ? "0" + strHex : strHex);
        }
        return sb.toString().trim();
    }

    /***
     * 功能描述   数据入库
     * @author zhouyi
     * @return
     * @data 2021/5/21
     *
     */
    private void dataProcessing(String topic, String payloadByte, Map<String, Object> valueMap, TimuDevMeterService timuDevMeterService, MeasDataStoreService measDataStoreService,
                                AccessMgmtService accessMgmtService, String[] tpcs, MeasDataService measDataService,
                                SoeRecordOnOffAlarmService soeRecordOnOffAlarmService,
                                TimuMqttmsgLogService timuMqttmsgLogService,
                                TimuGmDevMeterDo devMeterByDevMeterCommAddr, byte data, Boolean status, String addr) {

        TimuGmopsDevMeter timuGmDevMeterDo = new TimuGmopsDevMeter();
        timuGmDevMeterDo.setDevMeterId(devMeterByDevMeterCommAddr.getId());
        long timeStamp = System.currentTimeMillis();
        timuGmDevMeterDo.setGmtMessageUp(timeStamp);
        timuGmDevMeterDo.setGmtMeasdataUp(timeStamp);
        timuGmDevMeterDo.setGmtAlarmUp(timeStamp);
        timuGmDevMeterDo.setGmtReadingUp(timeStamp);
        timuGmDevMeterDo.setValid(true);

        // 解析的数据记录日志
        TimuMqttmsgReceivedLogDo receivedLogDo = new TimuMqttmsgReceivedLogDo();
        receivedLogDo.setPayload(payloadByte);
        receivedLogDo.setReceivedClientId(addr);
        receivedLogDo.setTopic(topic);
        receivedLogDo.setAnalysis(JsonConvertUtils.convertToString(valueMap));
        receivedLogDo.setRetained(false);
        receivedLogDo.setDuplicate(false);
        receivedLogDo.setReceivedMessageId(addr);
        receivedLogDo.setReceivedProductKey("YINDE");
        timuMqttmsgLogService.insertOrUpdateTimuMqttmsgReceivedValueLog(receivedLogDo);


        // 1 打开，0，关闭
        timuGmDevMeterDo.setMeterStateOpen(data);
        timuDevMeterService.insertOrUpdateTimuGmDevMeterDo(timuGmDevMeterDo);
        TimuUtil.updateValue(devMeterByDevMeterCommAddr.getMeasPointId(), valueMap, measDataStoreService, accessMgmtService);
        soeRecordOnOffAlarmService.updateBoundSoeRecordOnOffAlarmDo(measDataService);
        SoeRecordOnOffAlarmDo onOffAlarmDo = new SoeRecordOnOffAlarmDo();
        onOffAlarmDo.setOnOff(status);
        onOffAlarmDo.setDevMeterCommAddr(addr);
        onOffAlarmDo.setDevTermCommAddr(tpcs[2]);
        soeRecordOnOffAlarmService.updateSoeRecordOnOffAlarmDo(onOffAlarmDo);

    }


}
