package com.iesms.springbootapps.bizprocessors.timuiot.pack;

import com.iesms.springbootapps.bizprocessors.timuiot.frame.FrameFactory;
import com.iesms.springbootapps.bizprocessors.timuiot.frame.FrameType;
import com.iesms.springbootapps.bizprocessors.timuiot.pack.data.Bcd6;
import com.iesms.springbootapps.bizprocessors.timuiot.procotol.BaseInformationElement;
import io.netty.buffer.ByteBuf;
import org.apache.commons.codec.binary.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @param
 * @ClassName BasePacket
 * @Author zhouyi
 * @Data 2021/5/18 15:54
 * @Version 1.0
 **/
public class BasePacket extends BaseInformationElement {


    private static final Logger logger = LoggerFactory.getLogger(BasePacket.class);

    public final static byte MAGIC_NUMBER = 0X68;
    /**
     * 开始符  一个字节
     */
    private byte header;

    /***
     * @param
     */
    private Boolean isEncrypt;

    /***
     * 功能描述
     * @author zhouyi
     * @return 密钥
     * @data 2021/5/21
     * @param null
     */
    private String key;

    /**
     * 长度  两个字节
     */
    private Integer len;

    /**
     * 控制域  一个字节
     */
    private Short ctrl;

    /**
     * 地址域  六个字节
     */
    private Bcd6 addr;

    /**
     * 功能码  一个字节
     */
    private FrameType frameType;

    /**
     * 数据时效   六个字节
     */
    private Bcd6 time;

    private BaseInformationElement frame;
    /**
     * 数据时效   六个字节
     */
    private Short cs;
    /**
     * 终止符 一个字节
     */
    private Short stop;

    public BasePacket(ByteBuf byteBuf) {
        super(byteBuf);
        //从下标0开始读一位   开始符
        header = byteBuf.readByte();

      /* if (header != MAGIC_NUMBER){
           throw new RuntimeException("报文起始符错误");
       }*/

        //从下标1开始读两位   长度
        len = byteBuf.readUnsignedShort();
        ByteBuf encryptBuf;
//        if (isEncrypt) {
//            //ByteBuf unEncrypt =   byteBuf.readBytes(len-1-2-1-1);
        //  TimuUtil.decCmd(key,);
//            //
//        }else {
//            encryptBuf = byteBuf;
//        }
        //从下标3开始读一位  控制域
        ctrl = byteBuf.readUnsignedByte();
        //从下标4开始读六位   地址域
        addr = new Bcd6(byteBuf);
        //从下标10开始读一位   功能码
        short type = byteBuf.readUnsignedByte();
        frameType = FrameType.typeFor(type);
        if (frameType == null) {
            logger.error("未定义的类型:{}", type);
        }
        frame = FrameFactory.deserialize(FrameFactory.getClass(frameType), byteBuf);
        time = new Bcd6(byteBuf);
        cs = byteBuf.readUnsignedByte();
        stop = byteBuf.readUnsignedByte();
    }

    @Override
    public void encode(ByteBuf byteBuf) {
        // todo 目前版本没有实现
    }

    @Override
    public int getLen() {
        // todo 目前版本没有实现
        return 0;
    }


    public Short getCtrl() {
        return ctrl;
    }

    public Bcd6 getAddr() {
        return addr;
    }

    public FrameType getFrameType() {
        return frameType;
    }

    public BaseInformationElement getFrame() {
        return frame;
    }

    @Override
    public String toString() {
        return "BasePacket{" +
                "header=" + header +
                ", isEncrypt=" + isEncrypt +
                ", key='" + key + '\'' +
                ", len=" + len +
                ", ctrl=" + ctrl +
                ", addr=" + addr +
                ", frameType=" + frameType +
                ", time=" + time +
                ", frame=" + frame +
                ", cs=" + cs +
                ", stop=" + stop +
                '}';
    }
}
