package com.iesms.springbootapps.bizprocessors.timuiot.provider4dubbo;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.timuiotgateway.constant.TimuResponseResultEnum;
import com.iesms.bizprocessors.timuiotgateway.request.TimuGatewaySettingUpdateRequest;
import com.iesms.bizprocessors.timuiotgateway.response.TimuReturnResponse;
import com.iesms.bizprocessors.timuiotgateway.service.TimuGatewayService;
import com.iesms.springbootapps.bizprocessors.timuiot.gateway.TimuIotMqttSendGateway;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.Map;

/**
 *
 * @author Nick Zhang
 * @date 2019-04-08
 */
@Service(delay = -1, timeout = 60000)
public class TimuGatewayService4DubboImpl implements TimuGatewayService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private TimuIotMqttSendGateway timuIotMqttSendGateway;

    @Override
    public TimuReturnResponse updateGatewaySetting(TimuGatewaySettingUpdateRequest timuGatewaySettingUpdateRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start updateGatewaySetting >>>>>> ");
            logger.debug(" timuGatewaySettingUpdateRequest      : " + JsonConvertUtils.convertToString(timuGatewaySettingUpdateRequest));
        }
        TimuReturnResponse timuReturnResponse = new TimuReturnResponse();
        timuReturnResponse.setReturnResponseResult(TimuResponseResultEnum.FAILURE);
        if(timuGatewaySettingUpdateRequest != null) {
            Map<String, BigDecimal> keyToValueMap = timuGatewaySettingUpdateRequest.getKeyToValueMap();
            if(keyToValueMap != null && keyToValueMap.size() > 0) {
                for(String key : keyToValueMap.keySet()) {
                    Map<String, Object> params = Maps.newLinkedHashMap();
                    params.put("Device", timuGatewaySettingUpdateRequest.getUpcommLogicAddr());
                    params.put("Key", key);
                    params.put("Value", keyToValueMap.get(key).intValue());
                    timuIotMqttSendGateway.sendToMqtt(JsonConvertUtils.convertToString(params).getBytes(), "YINDE/SERVERtoLINK/" + timuGatewaySettingUpdateRequest.getUpcommLogicAddr() + "/setting/update", 0);
                }
                timuReturnResponse.setReturnResponseResult(TimuResponseResultEnum.SUCCESS);
            }
        }
        if(logger.isDebugEnabled()) {
            logger.debug(" TimuReturnResponse  : " + JsonConvertUtils.convertToString(timuReturnResponse));
            logger.debug(" <<<<<<< end updateGatewaySetting <<<<<<< ");
        }
        return timuReturnResponse;
    }

}
