package com.iesms.springbootapps.bizprocessors.timuiot.provider4dubbo;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.iesms.bizprocessors.timuiotgateway.constant.TimuResponseResultEnum;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuGmDevMeterDo;
import com.iesms.bizprocessors.timuiotgateway.entity.TimuGmopsDevMeter;
import com.iesms.bizprocessors.timuiotgateway.request.TimuSwitchLineSettingUpdateRequest;
import com.iesms.bizprocessors.timuiotgateway.request.TimuSwitchLineStatusUpdateRequest;
import com.iesms.bizprocessors.timuiotgateway.response.TimuReturnResponse;
import com.iesms.bizprocessors.timuiotgateway.service.TimuDevMeterService;
import com.iesms.bizprocessors.timuiotgateway.service.TimuSwitchLineService;
import com.iesms.springbootapps.bizprocessors.timuiot.gateway.TimuIotMqttSendGateway;
import com.iesms.springbootapps.bizprocessors.timuiot.utils.ByteUtil;
import com.iesms.springbootapps.bizprocessors.timuiot.utils.TimuUtil;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;


/**
 * @author ghl
 */
@Service(delay = -1, timeout = 120000)
public class TimuSwitchLineService4DubboImpl implements TimuSwitchLineService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Resource
    private TimuIotMqttSendGateway timuSmartMqttSendGateway;

    @Resource
    private MeasDataStoreService measDataStoreService;

    @Resource
    private TimuDevMeterService timuDevMeterService;

    @Override
    public TimuReturnResponse updateSwitchLineStatus(TimuSwitchLineStatusUpdateRequest switchLineStatusUpdateRequest) {
        if (logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start updateSwitchLineStatus >>>>>> ");
            logger.debug(" SwitchLineStatusUpdateRequest    : " + JsonConvertUtils.convertToString(switchLineStatusUpdateRequest));
        }
        if (switchLineStatusUpdateRequest == null) {
            return new TimuReturnResponse("FAILURE", "switchLineStatusUpdateRequest参数不能为空");
        }
        String upcommLogicAddr = switchLineStatusUpdateRequest.getUpcommLogicAddr();

        if (upcommLogicAddr.length() != 12) {
            return new TimuReturnResponse("FAILURE", "设备地址不对");
        }
        Map<String, Boolean> measSnToStatusMap = switchLineStatusUpdateRequest.getMeasSnToStatusMap();

        if (measSnToStatusMap == null || measSnToStatusMap.size() < 1) {
            return new TimuReturnResponse("FAILURE", "measSnToStatusMap为空");
        }
        TimuReturnResponse returnResponse = new TimuReturnResponse();
        returnResponse.setReturnResponseResult(TimuResponseResultEnum.FAILURE);

        String sendTopic = "YINDE/SERVERtoLINK/" + upcommLogicAddr;
        String time = TimuUtil.getTime();
        measSnToStatusMap.forEach((addr, value) -> {
            String upToOn = value ? "02" : "01";


            if (addr.startsWith("EC")) {
                // 单项控制
                StringBuffer check = new StringBuffer();
                check.append("80");
                check.append(addr);
                check.append("37");
                check.append(upToOn);
                check.append(time);
                String checkStr = check.toString();
                // 数据校验计算，计算规则：加密前，控制域、地址域、功能码、数据域、数据时效的累加和。
                byte[] sendMessHX = ByteUtil.hexStringToByteArray(checkStr);
                byte checkCode = ByteUtil.getCheckCode(sendMessHX);
                String message = "68000F" + checkStr + "00" + "16";
                byte[] sendMessB = ByteUtil.hexStringToByteArray(message);
                sendMessB[sendMessB.length - 2] = checkCode;
                timuSmartMqttSendGateway.sendToMqtt(sendMessB, sendTopic, 0);
            } else {
                // 三项控制
                StringBuffer check3 = new StringBuffer();
                check3.append("80");
                check3.append(addr);
                check3.append("4E");
                check3.append(upToOn);
                check3.append(time);
                String checkStr3 = check3.toString();
                // 数据校验计算，计算规则：加密前，控制域、地址域、功能码、数据域、数据时效的累加和。
                byte[] sendMessHX3 = ByteUtil.hexStringToByteArray(checkStr3);
                byte checkCode3 = ByteUtil.getCheckCode(sendMessHX3);
                String message3 = "68000F" + checkStr3 + "00" + "16";
                // 三项报文解密
                String substring3 = message3.substring(6, message3.length() - 4);
                String decCmd3 = TimuUtil.encCmd("201803", TimuUtil.hesStrToInts(substring3)).replaceAll(" ", "").trim();
                decCmd3 = "68000F" + decCmd3 + "00" + "16";
                byte[] sendMessB3 = ByteUtil.hexStringToByteArray(decCmd3);
                sendMessB3[sendMessB3.length - 2] = checkCode3;
                timuSmartMqttSendGateway.sendToMqtt(sendMessB3, sendTopic, 0);
            }

            Map<String, String> mapAddr = new HashMap<>();
            mapAddr.put("devMeterCommAddr", addr);
            mapAddr.put("devTermCommAddr", upcommLogicAddr);

            // 根据开关地址查询表计地址
            TimuGmDevMeterDo devMeterByDevMeterCommAddr = timuDevMeterService.getDevMeterByDevMeterCommAddr(mapAddr);
            if (devMeterByDevMeterCommAddr != null) {
                TimuGmopsDevMeter timuGmDevMeterDo = new TimuGmopsDevMeter();
                timuGmDevMeterDo.setDevMeterId(devMeterByDevMeterCommAddr.getId());
                // 1 打开，0，关闭
//                timuGmDevMeterDo.setMeterStateOpen(value ? 1 : 0);

                long timeMillis = System.currentTimeMillis();
                timuGmDevMeterDo.setGmtMessageUp(timeMillis);
                timuGmDevMeterDo.setGmtMeasdataUp(timeMillis);
                timuGmDevMeterDo.setGmtAlarmUp(timeMillis);
                timuGmDevMeterDo.setGmtReadingUp(timeMillis);
                timuGmDevMeterDo.setValid(true);
                timuGmDevMeterDo.setCreator("");
                timuGmDevMeterDo.setModifier("");
                timuGmDevMeterDo.setInvalider("");
                timuGmDevMeterDo.setGmtInvalid(timeMillis);

                timuDevMeterService.insertOrUpdateTimuGmDevMeterDo(timuGmDevMeterDo);
            }
        });

        return new TimuReturnResponse("SUCCESS", "成功！");

    }


    @Override
    public TimuReturnResponse updateSwitchLineSetting(TimuSwitchLineSettingUpdateRequest switchLineSettingUpdateRequest) {
        if (logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start updateSwitchLineSetting >>>>>> ");
            logger.debug(" SwitchLineSettingUpdateRequest   : " + JsonConvertUtils.convertToString(switchLineSettingUpdateRequest));
        }
        TimuReturnResponse returnResponse = new TimuReturnResponse();
        returnResponse.setReturnResponseResult(TimuResponseResultEnum.FAILURE);
        if (switchLineSettingUpdateRequest != null) {
            Map<String, BigDecimal> keyToValueMap = switchLineSettingUpdateRequest.getKeyToValueMap();
            if (keyToValueMap != null && keyToValueMap.size() > 0) {

                timuSmartMqttSendGateway.sendToMqtt(null, "YINDE/SERVERtoLINK/" + switchLineSettingUpdateRequest.getUpcommLogicAddr() + "/setting/update", 0);

                returnResponse.setReturnResponseResult(TimuResponseResultEnum.SUCCESS);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug(" TimuReturnResponse  : " + JsonConvertUtils.convertToString(returnResponse));
            logger.debug(" <<<<<<< end updateSwitchLineSetting <<<<<<< ");
        }
        return returnResponse;
    }

}
