package com.iesms.springbootapps.bizprocessors.timuiot.utils;

/**
 * @author ghl
 * 字节转换类工具类
 */
public class ByteUtil {

    /**
     * 字节转short
     *
     * @param b
     * @return
     */
    public static short byteToShort(byte b) {
        if ((b & 0x80) == 0x80) {
            return (short) (128 + (b & 0x7f));
        } else {
            return (short) b;
        }
    }

    /**
     * 字节数组转换为短整型
     *
     * @param b1 高位字节
     * @param b2 低位字节
     * @return 返回数据
     */
    public static short bytesToShort(byte b1, byte b2) {
        short res = b1;
        res = (short) ((b1 << 8) | (b2 & 0x00FF));
        return res;
    }

    /**
     * 短整型转字节数组
     *
     * @param sh
     * @return
     */
    public static byte[] shortToByte(short sh) {
        byte[] bytes = new byte[2];
        bytes[0] = (byte) ((sh & 0xff) >> 8);
        bytes[1] = (byte) (sh & 0xff);
        return bytes;
    }

    /**
     * int转byte[]数组
     *
     * @param integer
     * @return
     */
    public static byte[] int2Bytes(int i) {
        byte[] result = new byte[4];
        //由高位到低位
        result[0] = (byte) ((i >> 24) & 0xFF);
        result[1] = (byte) ((i >> 16) & 0xFF);
        result[2] = (byte) ((i >> 8) & 0xFF);
        result[3] = (byte) (i & 0xFF);
        return result;
    }

    /**
     * 16进制表示的字符串转换为字节数组
     *
     * @param hexString 16进制表示的字符串
     * @return byte[] 字节数组
     */
    public static byte[] hexStringToByteArray(String hexString) {
        hexString = hexString.replaceAll(" ", "");
//        hexString.replace("-", "");
        int len = hexString.length();
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            // 两位一组，表示一个字节,把这样表示的16进制字符串，还原成一个字节
            bytes[i / 2] = (byte) ((Character.digit(hexString.charAt(i), 16) << 4) + Character
                    .digit(hexString.charAt(i + 1), 16));
        }
        return bytes;
    }

    /**
     * 计算校验码
     *
     * @param bytes
     * @return
     */
    public static byte getCheckCode(byte[] bytes) {
        byte code = 0x00;
        for (int i = 0; i < bytes.length; i++) {
            code = (byte) (code + bytes[i]);
        }
        return code;
    }

    /**
     * byte数组转hex
     *
     * @param bytes
     * @return
     */
    public static String byteToHex(byte[] bytes) {
        String strHex = "";
        StringBuilder sb = new StringBuilder("");
        for (int n = 0; n < bytes.length; n++) {
            strHex = Integer.toHexString(bytes[n] & 0xFF);
            // 每个字节由两个字符表示，位数不够，高位补0
            sb.append((strHex.length() == 1) ? "0" + strHex : strHex);
        }
        return sb.toString().trim();
    }

    /**
     * 公共的字节处理
     *
     * @param bytes
     * @return
     */
    public static byte[] commomValue(byte[] bytes) {

        return bytes;
    }

}
