package com.iesms.springbootapps.bizprocessors.timuiot.utils;

import com.iesms.springbootapps.bizprocessors.timuiot.gateway.TimuIotMqttSendGateway;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;

/**
 * @author ghl
 * timuMqtt Message消息解析工具类
 */
public class TimuResolverUtil {

    public static void resolver(byte[] payloads, TimuIotMqttSendGateway mqttSendGateway) {
        if (payloads == null || payloads.length < 19) {
            return;
        }
        byte[] retByte = null;

        // 获取功能码
        byte type = payloads[10];

        switch (type) {
            case 49:
                resolver31(payloads, mqttSendGateway);
                break;
            case 50:
                retByte = resolver32(payloads);
            default:
                retByte = null;
        }

    }

    /**
     * 2.1.	Link网关请求时间－－31H
     *
     * @param payloads
     * @return
     */
    private static void resolver31(byte[] payloads, TimuIotMqttSendGateway mqttSendGateway) {
        // 获取时间，年份为后两位1字节表示。比如2017-04-22 13:58:00是170422135800
        String time = TimuUtil.getTime();
        byte[] timeBytes = ByteUtil.hexStringToByteArray(time);
        System.out.println("timebytes ===" + Arrays.toString(timeBytes));
        int tlen = timeBytes.length;
        int plen = payloads.length;
        int totalLen = tlen + plen;
        byte[] retByte = new byte[totalLen];
        int tIndex = 0;
        int pIndex = 0;
        for (int i = 0; i < totalLen; i++) {
            if (i < 11) {
                retByte[i] = payloads[pIndex++];
            } else {
                if (tIndex < tlen) {
                    retByte[i] = timeBytes[tIndex++];
                } else {
                    retByte[i] = payloads[pIndex++];
                }
            }
        }
        retByte[3] = (byte) 128;

        // 数据校验计算，计算规则：加密前，控制域、地址域、功能码、数据域、数据时效的累加和。
        byte checkCode = ByteUtil.getCheckCode(retByte);
        // 计算长度
        // 获取长度
        byte b1 = payloads[1];
        byte b2 = payloads[2];

        short len = ByteUtil.bytesToShort(b1, b2);
        len = (short) (len + timeBytes.length);
        byte[] bytes = ByteUtil.shortToByte(len);
        retByte[1] = bytes[0];
        retByte[2] = bytes[1];

        retByte[retByte.length - 2] = checkCode;

        String resTopic = "YINDE/SERVERtoLINK/timuiot_sender_test01";
        mqttSendGateway.sendToMqtt(retByte, resTopic, 0);

    }

    /**
     * @param payloads
     * @return
     */
    private static byte[] resolver32(byte[] payloads) {


        return null;
    }


}
