package com.iesms.springbootapps.bizprocessors.timuiot.utils;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.AccessMgmtService;
import com.easesource.iot.datacenter.openservice.MeasDataStoreService;
import com.easesource.iot.datacenter.openservice.request.RunMeasPointOpsInfoUpdateRequest;
import com.easesource.iot.datacenter.openservice.response.RunMeasPointOpsInfoUpdateResponse;
import com.google.common.collect.Maps;
import com.iesms.bizprocessors.common.request.GmDevMeterGetRequest;
import com.iesms.bizprocessors.common.request.GmopsDevMeterRefreshRequest;
import com.iesms.bizprocessors.common.response.GmDevMeterGetResponse;
import com.iesms.bizprocessors.common.response.GmopsDevMeterRefreshResponse;
import com.iesms.bizprocessors.common.service.GmDevMeterService;
import com.iesms.bizprocessors.common.service.GmopsDevMeterService;
import com.sun.org.apache.xpath.internal.operations.Bool;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

/**
 * @author ghl
 * 日期工具类
 */
public class TimuUtil {

    /**
     * 获取返回日期
     *
     * @return
     */
    public static String getTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMddHHmmss");
        String format = dateFormat.format(new Date());
        System.out.println(format);
        return format;
    }

    /**
     * 更新开关状态
     *
     * @param gmopsDevMeterService
     * @param gmDevMeterService
     * @param accessMgmtService
     * @param measDataStoreService
     * @param status
     * @param measPointId
     */
    public static void updateSwitchStatus(GmopsDevMeterService gmopsDevMeterService, GmDevMeterService gmDevMeterService, AccessMgmtService accessMgmtService, MeasDataStoreService measDataStoreService, Boolean status, Long measPointId) {
        // 更新开关状态
        Map<String, Object> measDataInfoStatus = Maps.newHashMap();
        measDataInfoStatus.put("measItemCode", "gen_watt_state_open");
        measDataInfoStatus.put("measDataClass", Boolean.class);
        measDataInfoStatus.put("measDataValue", status);
        measDataInfoStatus.put("measDataSource", 0);
        measDataInfoStatus.put("gmtMeasDataLatest", System.currentTimeMillis());
        updateRunMeasPointOpsInfo(accessMgmtService, measPointId);
        Map<String, Object> measDataInfoSet = Maps.newHashMap();
        measDataInfoSet.put("meter_state_open", status);
        updateGmopsDevMeter(gmopsDevMeterService, gmDevMeterService, measPointId, measDataInfoSet);
        measDataStoreService.updateMeasDataLatest(measPointId, (String) measDataInfoStatus.get("measItemCode"), measDataInfoStatus);
    }

    /**
     * 更新运行量量测点
     *
     * @param accessMgmtService
     * @param measPointId
     */
    public static void updateRunMeasPointOpsInfo(AccessMgmtService accessMgmtService, Long measPointId) {

        RunMeasPointOpsInfoUpdateRequest runMeasPointOpsInfoUpdateRequest = new RunMeasPointOpsInfoUpdateRequest();
        runMeasPointOpsInfoUpdateRequest.setMeasPointId(measPointId);
        runMeasPointOpsInfoUpdateRequest.setGmtMessageUp(System.currentTimeMillis());
        runMeasPointOpsInfoUpdateRequest.setGmtMeasdataUp(System.currentTimeMillis());
        RunMeasPointOpsInfoUpdateResponse runMeasPointOpsInfoUpdateResponse = accessMgmtService.updateRunMeasPointOpsInfo(runMeasPointOpsInfoUpdateRequest);
    }

    /**
     * 刷新表计数据
     *
     * @param gmopsDevMeterService
     * @param gmDevMeterService
     * @param measPointId
     * @param measDataInfoSet
     */
    public static void updateGmopsDevMeter(GmopsDevMeterService gmopsDevMeterService, GmDevMeterService gmDevMeterService, Long measPointId, Map<String, Object> measDataInfoSet) {
        GmDevMeterGetRequest gmDevMeterGetRequest = new GmDevMeterGetRequest();
        gmDevMeterGetRequest.setMeasPointId(measPointId);
        GmDevMeterGetResponse gmDevMeterGetResponse = gmDevMeterService.getGmDevMeter(gmDevMeterGetRequest);
        GmopsDevMeterRefreshRequest gmopsDevMeterRefreshRequest = null;
        if (gmDevMeterGetResponse.isSuccess()) {
            gmopsDevMeterRefreshRequest = new GmopsDevMeterRefreshRequest();
            gmopsDevMeterRefreshRequest.setDevMeterId(gmDevMeterGetResponse.getGmDevMeter().getId());
            gmopsDevMeterRefreshRequest.setGmtMessageUp(System.currentTimeMillis());
            gmopsDevMeterRefreshRequest.setGmtMeasdataUp(System.currentTimeMillis());
            if (measDataInfoSet != null) {
                Integer meterStateOpen = (Integer) measDataInfoSet.get("meter_state_open");
                if (meterStateOpen != null) {
                    gmopsDevMeterRefreshRequest.setMeterStateOpen(meterStateOpen);
                }
            }
        }
        GmopsDevMeterRefreshResponse gmopsDevMeterRefreshResponse = gmopsDevMeterService.refreshGmopsDevMeter(gmopsDevMeterRefreshRequest);
    }


    public static void updateValue(Long measPointId, Map<String, Object> valueMap, MeasDataStoreService measDataStoreService, AccessMgmtService accessMgmtService) {

        Map<String, Object> measDataInfoVoltage = Maps.newHashMap();
        measDataInfoVoltage.put("measDataSource", 0);
        measDataInfoVoltage.put("gmtMeasDataLatest", System.currentTimeMillis());

        valueMap.forEach((measItemCode, value) -> {

            measDataInfoVoltage.put("measItemCode", measItemCode);
            measDataInfoVoltage.put("measDataClass", value.getClass());
            measDataInfoVoltage.put("measDataValue", value);

            try {
//                updateRunMeasPointOpsInfo(accessMgmtService, measPointId);
                measDataStoreService.updateMeasDataLatest(measPointId, (String) measDataInfoVoltage.get("measItemCode"), measDataInfoVoltage);
            } catch (RuntimeException e) {
                e.printStackTrace();
            }
        });
    }

    public static void updateMeasDataLatest(MeasDataStoreService measDataStoreService, Long measPointId, String measItemCode, Boolean status) {
        // 更新开关状态
        Map<String, Object> measDataInfoStatus = Maps.newHashMap();
        measDataInfoStatus.put("measItemCode", "gen_watt_state_open");
        measDataInfoStatus.put("measDataClass", Boolean.class);
        measDataInfoStatus.put("measDataValue", status);
        measDataInfoStatus.put("measDataSource", 0);
        measDataInfoStatus.put("gmtMeasDataLatest", System.currentTimeMillis());
        Map<String, Object> measDataInfoSet = Maps.newHashMap();
        measDataInfoSet.put("meter_state_open", status);
        measDataStoreService.updateMeasDataLatest(measPointId, (String) measDataInfoStatus.get("measItemCode"), measDataInfoStatus);
    }

    /**
     * TIMU加密算法
     * 加密区域： 控制域+地址域+功能码+数据域+数据有效时间
     *
     * @param encKey
     * @param intCmd
     * @return
     */
    public static String encCmd(String encKey, int[] intCmd) {
        int cmdLen = intCmd.length;
        int[] intKey = new int[encKey.length()];
        for (int i = 0; i < encKey.length(); i++) {
            intKey[i] = encKey.charAt(i);
        }
        for (int i = 0; i < cmdLen; i++) {
            intCmd[i] = (intCmd[i] + intKey[i % encKey.length()]) % 0x100;
        }
        String encHexCmd = "";
        for (int i = 0; i < cmdLen; i++) {
            encHexCmd += intToHexStr(intCmd[i], 2) + " ";
        }
        return encHexCmd;
    }

    /**
     * TIMU解密算法
     *
     * @param encKey
     * @param intCmd
     * @return
     */
    public static String decCmd(String encKey, int[] intCmd) {
        int cmdLen = intCmd.length;
        int[] intKey = new int[encKey.length()];
        for(int i = 0; i < encKey.length(); i++) {
            intKey[i] = encKey.charAt(i);
        }
        for(int i = 0; i < cmdLen; i++) {
            intCmd[i] = (intCmd[i] - intKey[i % encKey.length()] + 0x100) % 0x100;
        }
        String decHexCmd = "";
        for(int j : intCmd) {
            decHexCmd += intToHexStr(j, 2) + " ";
        }
        return decHexCmd;
    }


    /**
     * 整型转16进制字符串
     *
     * @param source
     * @param len
     * @return
     */
    public static String intToHexStr(int source, int len) {
        String hexStr = String.format("%" + (len > 0 ? len : "") + "s", Integer.toHexString(source)).replace(' ', '0');
        return (len == 0) ? hexStr : hexStr.substring(hexStr.length() - len, hexStr.length());
    }

    /**
     * 116进制字符串转整型
     *
     * @param hexStr
     * @return
     */
    public static int hexStrToInt(String hexStr) {
        try {
            return Integer.valueOf(hexStr, 16);
        } catch (Exception e) {
            return 0;
        }
    }

    /**
     * 16进制字符串转整型数组
     *
     * @param hexStr
     * @return
     */
    public static int[] hesStrToInts(String hexStr) {
        if (hexStr == null || hexStr.length() < 2) {
            return null;
        }
        int[] ints = new int[hexStr.length() / 2];

        int j = 0;

        for (int i = 0; i < hexStr.length() - 1; i = i + 2) {
            String s = hexStr.substring(i, i + 2);
            int strToInt = hexStrToInt(s);
            ints[j++] = strToInt;
        }

        return ints;
    }

}
