package com.iesms.bizprocessors.common.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GmDevCollectorDo implements Serializable {

    private static final long serialVersionUID = 6737630589060404305L;

    /** 采集器标识;SnowflakeId */
    private Long id;
    /** 系统单位编号 */
    private String orgNo;
    /** 采集器编号 */
    private String devCollectorNo;
    /** 采集器名称 */
    private String devCollectorName;
    /** 采集器状态;1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除； */
    private int devCollectorStatus;
    /** 采集器通讯地址 */
    private String devCollectorCommAddr;
    /** 生产厂家 */
    private String mfrCode;
    /** 设备型号 */
    private String modelCode;
    /** 接入中继设备标识;采集器投运后，后台自动注册采集平台接入中继设备，注册成功后回填入接入中继设备标识； */
    private Long accessTrunkingId;
    /** 排序序号 */
    private int sortSn;
    /** 是否有效 */
    private boolean valid;
    /** 创建人;系统用户表用户编号字段（user_no） */
    private String creator;
    /** 创建时间;为0表示为空 */
    private long gmtCreate;
    /** 更新人;系统用户表用户编号字段（user_no） */
    private String modifier;
    /** 更新时间;为0表示为空 */
    private long gmtModified;
    /** 失效人;系统用户表用户编号字段（user_no） */
    private String invalider;
    /** 失效时间;为0表示为空 */
    private long gmtInvalid;
    /** 版本号;用于乐观锁 */
    private int version;
    
}
