package com.iesms.bizprocessors.common.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GmDevMeterVo implements Serializable {

    private static final long serialVersionUID = 3524076676902263389L;

    /** 量测表计标识;SnowflakeId */
    private Long id;
    /** 系统单位编号 */
    private String orgNo;
    /** 采集终端编号 */
    private String devTermNo;
    /** 采集终端名称 */
    private String devTermName;
    /** 采集终端状态;1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除； */
    private int devTermStatus;
    /** 采集终端通讯规约;
     * GAEADCU - 佳和DCU规约终端；
     IEC104 - IEC104规约终端；
     QGDW1376_1 - 国电网1376.1规约终端；
     QZDJFAAL - 浙电现场管理与服务终端； */
    private String devTermCommProto;
    /** 采集终端通讯规约版本 */
    private String devTermCommProtoVer;
    /** 采集终端通讯方式;1 - TCP；2 - UDP； */
    private int devTermCommMode;
    /** 采集终端通讯地址 */
    private String devTermCommAddr;
    /** 采集终端通讯参数 */
    private String devTermCommParam;
    /** 是否加密 */
    private boolean devTermEncrypt;
    /** 加密方式 */
    private String devTermEncryptType;
    /** 加密信息 */
    private String devTermEncryptInfo;
    /** 生产厂家 */
    private String devTermMfrCode;
    /** 设备型号 */
    private String devTermModelCode;
    /** SIM卡号 */
    private String devTermSimNo;
    /** IMEI号 */
    private String devTermImeiNo;
    /** 量测表计编号 */
    private String devMeterNo;
    /** 量测表计名称 */
    private String devMeterName;
    /** 量测表计状态;1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除； */
    private int devMeterStatus;
    /** 量测表计类型;1 – 电表；
     2 – 水表；
     3 – 气表；
     4 – 热表；
     5 - 汽表； */
    private int devMeterType;
    /** 量测通信方式;ACSAMP – 交流采样；
     RS485 – RS485；
     MBUS - M-BUS；
     MODBUS - MODBUS； */
    private String devMeterCommMode;
    /** 量测通信规约;CJT188-2004 - CJ/T 188—2004户用计量仪表通信协议；
     CJT188-2018 - CJ/T 188—2018户用计量仪表通信协议；
     DLT645-1997 - DL/T 645—1997多功能电能表通信协议；
     DLT645-2007 - DL/T 645—1997多功能电能表通信协议； */
    private String devMeterCommProto;
    /** 量测通信地址 */
    private String devMeterCommAddr;
    /** 生产厂家 */
    private String devMeterMfrCode;
    /** 设备型号 */
    private String devMeterModelCode;
    /** 自身倍率 */
    private BigDecimal devMeterSelfRate;
    /** CT倍率 */
    private BigDecimal devMeterCtRate;
    /** PT倍率 */
    private BigDecimal devMeterPtRate;
    /** 接入网关设备标识;采集终端投运后，后台自动注册采集平台接入网关设备，注册成功后回填入接入网关设备标识 */
    private Long accessGatewayId;
    /** 接入中继设备标识 */
    private Long accessTrunkingId;
    /** 接入量测设备标识 */
    private Long accessMeasureId;
    /** 量测点标识 */
    private Long measPointId;
    /** 量测点性质 */
    private int measKind;
    /** 量测点序号 */
    private int measSn;
    /** 量测通信端口 */
    private int measCommPort;
    /** 量测通信参数 */
    private String measCommParam;
    /** 排序序号 */
    private int sortSn;
    /** 是否有效 */
    private boolean valid;
    /** 创建人;系统用户表用户编号字段（user_no） */
    private String creator;
    /** 创建时间;为0表示为空 */
    private long gmtCreate;
    /** 更新人;系统用户表用户编号字段（user_no） */
    private String modifier;
    /** 更新时间;为0表示为空 */
    private long gmtModified;
    /** 失效人;系统用户表用户编号字段（user_no） */
    private String invalider;
    /** 失效时间;为0表示为空 */
    private long gmtInvalid;
    /** 版本号;用于乐观锁 */
    private int version;
    
}
