package com.iesms.bizprocessors.common.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GmDevTermDo implements Serializable {

    private static final long serialVersionUID = -8273049493803637026L;

    /** 采集终端标识;SnowflakeId */
    private Long id;
    /** 系统单位编号 */
    private String orgNo;
    /** 采集终端编号 */
    private String devTermNo;
    /** 采集终端名称 */
    private String devTermName;
    /** 采集终端状态;1 - 待装；2 - 待投；3 - 投运；4 - 故障；5 - 暂停；6 - 停运；7 - 拆除； */
    private int devTermStatus;
    /** 采集终端通讯规约;
     * GAEADCU - 佳和DCU规约终端；
     IEC104 - IEC104规约终端；
     QGDW1376_1 - 国电网1376.1规约终端；
     QZDJFAAL - 浙电现场管理与服务终端； */
    private String devTermCommProto;
    /** 采集终端通讯规约版本 */
    private String devTermCommProtoVer;
    /** 采集终端通讯方式;1 - TCP；2 - UDP； */
    private int devTermCommMode;
    /** 采集终端通讯地址 */
    private String devTermCommAddr;
    /** 采集终端通讯参数 */
    private String devTermCommParam;
    /** 是否加密 */
    private boolean encrypt;
    /** 加密方式 */
    private String encryptType;
    /** 加密信息 */
    private String encryptInfo;
    /** 生产厂家 */
    private String mfrCode;
    /** 设备型号 */
    private String modelCode;
    /** SIM卡号 */
    private String simNo;
    /** IMEI号 */
    private String imeiNo;
    /** 接入网关设备标识;采集终端投运后，后台自动注册采集平台接入网关设备，注册成功后回填入接入网关设备标识及量测点标识； */
    private Long accessGatewayId;
    /** 量测点标识;采集终端投运后，后台自动注册采集平台接入网关设备，注册成功后回填入接入网关设备标识及量测点标识； */
    private Long measPointId;
    /** 排序序号 */
    private int sortSn;
    /** 是否有效 */
    private boolean valid;
    /** 创建人;系统用户表用户编号字段（user_no） */
    private String creator;
    /** 创建时间;为0表示为空 */
    private long gmtCreate;
    /** 更新人;系统用户表用户编号字段（user_no） */
    private String modifier;
    /** 更新时间;为0表示为空 */
    private long gmtModified;
    /** 失效人;系统用户表用户编号字段（user_no） */
    private String invalider;
    /** 失效时间;为0表示为空 */
    private long gmtInvalid;
    /** 版本号;用于乐观锁 */
    private int version;

}
