package com.iesms.bizprocessors.common.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GmopsDevMeterDo implements Serializable {

    private static final long serialVersionUID = -8315729531775274576L;
    /** 设备工况标识;SnowflakeId */
    private Long id;
    /** 量测表计标识 */
    private Long devMeterId;
    /** 最近一次报文上行时间 */
    private long gmtMessageUp;
    /** 最近一次量测数据上行时间 */
    private long gmtMeasdataUp;
    /** 最近一次告警上行时间 */
    private long gmtAlarmUp;
    /** 最近一次抄表示数上行时间 */
    private long gmtReadingUp;
    /** 最近一次抄表示数值 */
    private BigDecimal readingValue;
    /** 最近一次量测表计状态;1 - 打开；0 - 关闭； */
    private int meterStateOpen;
    /** 最近一次量测数据集 */
    private String measDataInfoSet;
    /** 是否有效 */
    private boolean valid;
    /** 创建人;系统用户表用户编号字段（user_no） */
    private String creator;
    /** 创建时间;为0表示为空 */
    private long gmtCreate;
    /** 更新人;系统用户表用户编号字段（user_no） */
    private String modifier;
    /** 更新时间;为0表示为空 */
    private long gmtModified;
    /** 失效人;系统用户表用户编号字段（user_no） */
    private String invalider;
    /** 失效时间;为0表示为空 */
    private long gmtInvalid;
    /** 版本号;用于乐观锁 */
    private int version;

}
