package com.iesms.bizprocessors.common.entity;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class SoeRecordOnOffAlarmDto implements Serializable {

    private static final long serialVersionUID = -680904041902275482L;
    /**
     * 事件标识;SnowflakeId
     */
    private Long id;
    /**
     * 系统单位编号
     */
    private String orgNo;
    /**
     * 事件对象类型;1 - 采集终端设备；2 - 采集器设备；3 - 量测表计设备；10 - 用能点；20 - 用能资源；30 - 社区资源；40 - 社交用户；
     */
    private int soeObjectType;

    /**
     * 采集终端名称
     */
    private String devTermName;

    /**
     * 用能点id
     */
    private Long measPointId;

    /**
     * 终端网关地址
     */
    private String devTermCommAddr;
    /**
     * 事件对象标识
     */
    private Long soeObjectId;
    /**
     * 表计名称
     */
    private String devMeterName;
    /**
     * 事件对象名称
     */
    private String soeObjectName;
    /**
     * 事件分类编号
     */
    private String soeSortNo;
    /**
     * 事件等级;1 - 一般事件；2 - 次要事件；3 - 重要事件；
     */
    private int soeLevel;
    /**
     * 严重等级;1 - 轻微；2 - 普通；3 - 严重；
     */
    private int graveLevel;
    /**
     * 事件标题
     */
    private String soeTitle;
    /**
     * 事件说明
     */
    private String soeDesc;
    /**
     * 事件发生时间
     */
    private String soeGenTime;
    /**
     * 事件发生值
     */
    private String soeGenValue;
    /**
     * 是否复归
     */
    private boolean recovery;
    /**
     * 事件复归时间
     */
    private String soeRecTime;
    /**
     * 事件复归值
     */
    private String soeRecValue;
    /**
     * 是否发送短信
     */
    private boolean sendSms;
    /**
     * 发送短信次数
     */
    private int sendSmsCount;
    /**
     * 排序序号
     */
    private int sortSn;
    /**
     * 是否有效
     */
    private boolean valid;
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;
    /**
     * 创建时间;为0表示为空
     */
    private long gmtCreate;
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;
    /**
     * 更新时间;为0表示为空
     */
    private long gmtModified;
    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    private String invalider;
    /**
     * 失效时间;为0表示为空
     */
    private long gmtInvalid;

    /**
     * 量测通讯地址
     */
    private String devMeterCommAddr;

    /**
     * 表计标识
     */
    private Long devMeterId;

    private Boolean onOff;

    /**
     * 上行通讯规约
     */
    private String upcommProto;
    /**
     * 版本号;用于乐观锁
     */
    private int version;
}
