package com.iesms.bizprocessors.common.entity;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@Data
public class SoeThresholdSetAlarmDo implements Serializable {

    private static final long serialVersionUID = 4620607005644908624L;

    /**
     * 设备ID
     */
    private Long ceDevId;
    /**
     * 设备类型
     */
    private String ceResSortNo;
    /**
     * 数据项编码
     */
    private String measItemCode;
    /**
     * 数据项名称
     */
    private String measItemAlias;
    /**
     * 越上限值
     */
    private BigDecimal upperLimit;
    /**
     * 越上上限值
     */
    private BigDecimal upperUpperLimit;
    /**
     * 越下限值
     */
    private BigDecimal downLimit;
    /**
     * 越下下限值
     */
    private BigDecimal downDownLimit;
    /**
     * 排序序号
     */
    private int sortSn;
    /**
     * 是否有效
     */
    private boolean valid;
    /**
     * 创建人;系统用户表用户编号字段（user_no）
     */
    private String creator;
    /**
     * 创建时间;为0表示为空
     */
    private long gmtCreate;
    /**
     * 更新人;系统用户表用户编号字段（user_no）
     */
    private String modifier;
    /**
     * 更新时间;为0表示为空
     */
    private long gmtModified;
    /**
     * 失效人;系统用户表用户编号字段（user_no）
     */
    private String invalider;
    /**
     * 失效时间;为0表示为空
     */
    private long gmtInvalid;
    /**
     * 版本号;用于乐观锁
     */
    private int version;

    /**
     * 单位
     */
    private String orgNo;
    //设备名称
    private String ceResName;
    //设备名称
    private String measPointIdList;
}
