package com.iesms.bizprocessors.common.request;

import com.iesms.bizprocessors.common.response.GmDevTermGetResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GmDevMeterGetRequest implements BaseRequest<GmDevTermGetResponse> {

    private static final long serialVersionUID = -5656165171079413106L;

    /** 量测表计标识 */
    private Long devMeterId;
    /** 系统单位编号 */
    private String orgNo;
    /** 量测表计编号 */
    private String devMeterNo;
    /** 量测通信规约;CJT188-2004 - CJ/T 188—2004户用计量仪表通信协议；
     CJT188-2018 - CJ/T 188—2018户用计量仪表通信协议；
     DLT645-1997 - DL/T 645—1997多功能电能表通信协议；
     DLT645-2007 - DL/T 645—1997多功能电能表通信协议； */
    private String devMeterCommProto;
    /** 量测通信地址 */
    private String devMeterCommAddr;
    /** 接入量测设备标识 */
    private Long accessMeasureId;
    /** 量测点标识 */
    private Long measPointId;

    @Override
    public Class<GmDevTermGetResponse> getResponseClass() {
        return GmDevTermGetResponse.class;
    }

}
