package com.iesms.bizprocessors.common.request;

import com.iesms.bizprocessors.common.response.GmDevTermGetResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GmDevTermGetRequest implements BaseRequest<GmDevTermGetResponse> {

    private static final long serialVersionUID = -5656165171079413106L;

    /** 采集终端标识 */
    private Long devTermId;
    /** 系统单位编号 */
    private String orgNo;
    /** 采集终端编号 */
    private String devTermNo;
    /** 采集终端通讯规约;
     * GAEADCU - 佳和DCU规约终端；
     IEC104 - IEC104规约终端；
     QGDW1376_1 - 国电网1376.1规约终端；
     QZDJFAAL - 浙电现场管理与服务终端； */
    private String devTermCommProto;
    /** 采集终端通讯地址 */
    private String devTermCommAddr;
    /** 接入网关设备标识;采集终端投运后，后台自动注册采集平台接入网关设备，注册成功后回填入接入网关设备标识及量测点标识； */
    private Long accessGatewayId;

    @Override
    public Class<GmDevTermGetResponse> getResponseClass() {
        return GmDevTermGetResponse.class;
    }

}
