package com.iesms.bizprocessors.common.request;

import com.iesms.bizprocessors.common.response.GmopsDevMeterBatchRefreshResponse;
import com.iesms.bizprocessors.common.response.GmopsDevMeterRefreshResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GmopsDevMeterBatchRefreshRequest implements BaseRequest<GmopsDevMeterBatchRefreshResponse> {

    private static final long serialVersionUID = -3497100190770131950L;
    /** 量测表计标识 */
    private Long devMeterId;
    /** 最近一次报文上行时间 */
    private Long gmtMessageUp;
    /** 最近一次量测数据上行时间 */
    private Long gmtMeasdataUp;
    /** 最近一次告警上行时间 */
    private Long gmtAlarmUp;
    /** 最近一次抄表示数上行时间 */
    private Long gmtReadingUp;
    /** 最近一次抄表示数值 */
    private BigDecimal readingValue;
    /** 最近一次量测表计状态;1 - 打开；0 - 关闭； */
    private Integer meterStateOpen;
    /** 最近一次量测数据集 */
    private String measDataInfoSet;

    @Override
    public Class<GmopsDevMeterBatchRefreshResponse> getResponseClass() {
        return GmopsDevMeterBatchRefreshResponse.class;
    }

}
