package com.iesms.bizprocessors.common.request;

import com.iesms.bizprocessors.common.response.GmopsDevTermRefreshResponse;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class GmopsDevTermRefreshRequest implements BaseRequest<GmopsDevTermRefreshResponse> {

    private static final long serialVersionUID = 5698772314719765437L;

    /** 采集终端标识 */
    private Long devTermId;
    /** 最近一次在线时间 */
    private Long gmtConnectedAt;
    /** 最近一次心跳通讯时间 */
    private Long gmtHeartbeatUp;
    /** 最近一次报文上行时间 */
    private Long gmtMessageUp;
    /** 最近一次量测数据上行时间 */
    private Long gmtMeasdataUp;
    /** 最近一次告警上行时间 */
    private Long gmtAlarmUp;

    @Override
    public Class<GmopsDevTermRefreshResponse> getResponseClass() {
        return GmopsDevTermRefreshResponse.class;
    }

}
