package com.iesms.bizprocessors.common.response;

import lombok.Data;

import java.io.Serializable;

/**
 *
 * @author Nick Zhang
 * @date 2019-10-30
 */
@Data
public abstract class BaseResponse implements Serializable {

    private static final long serialVersionUID = -8030695113999773940L;

    private static final String RETURN_CODE_SUCCESS = "SUCCESS";
    private static final String RETURN_MSG_SUCCESS = "成功";
    private static final String RETURN_CODE_FAILURE = "FAILURE";
    private static final String RETURN_MSG_FAILURE = "失败";
    private static final String FAILURE_CODE_UNKNOWN = "-1";
    private static final String FAILURE_MSG_UNKNOWN = "未知";

    private String returnCode;
    private String returnMsg;
    private String failureCode;
    private String failureMsg;

    public boolean isSuccess() {
        return RETURN_CODE_SUCCESS.equals(returnCode);
    }

    public void setSuccess() {
        setReturnCode(RETURN_CODE_SUCCESS);
        setReturnMsg(RETURN_MSG_SUCCESS);
        setFailureCode(null);
        setFailureMsg(null);
    }

    public void setFailure(String failureCode, String failureMsg) {
        setReturnCode(RETURN_CODE_FAILURE);
        setReturnMsg(RETURN_MSG_FAILURE);
        setFailureCode(failureCode != null && failureCode.trim().length() > 0 ? failureCode.trim() : FAILURE_CODE_UNKNOWN);
        setFailureMsg(failureMsg != null && failureMsg.trim().length() > 0 ? failureMsg.trim() : FAILURE_MSG_UNKNOWN);
    }

    public void setFailureDefault() {
        setFailure(null, null);
    }

}
