package com.iesms.bizprocessors.common.service;

import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDo;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDto;

import java.util.List;
import java.util.Map;

public interface SoeRecordOnOffAlarmService {
    /**
     * 告警插入
     *
     * @param list
     */
    void insertSoeRecordOnOffAlarmDo(List<SoeRecordOnOffAlarmDo> list);


    /**
     * 告警插入(电能质量)
     *
     * @param list
     */
    void insertSoeRecordOnOffAlarmDto(List<SoeRecordOnOffAlarmDto> list);


    /**
     * 更新告警
     * @param newAlarm
     * @param oldAlarm
     */
    void updateSoeRecordOnOffAlarmDo(SoeRecordOnOffAlarmDo onOffAlarmDo);

    /**
     * 上下限告警
     * @param alarmDo1
     * @param alarmDo2
     */
    void updateBoundSoeRecordOnOffAlarmDo(MeasDataService measDataService);

    /**
     * 查询最新的未复归的告警信息
     *
     * @param params
     * @return
     */
    SoeRecordOnOffAlarmDo getSoeRecordOnOffAlarmDo(Map<String, Object> params);


    /**
     * 上下限告警(新造)

     */
    void newUpdateBoundSoeRecordOnOffAlarmDo(MeasDataService measDataService,List<Long> ids)  throws Exception;

}
