package com.iesms.bizprocessors.common.service.impl;

import com.easesource.commons.util.StringUtils;
import com.easesource.commons.util.convert.JsonConvertUtils;
import com.iesms.bizprocessors.common.dao.GmDevTermDao;
import com.iesms.bizprocessors.common.entity.GmDevTermDo;
import com.iesms.bizprocessors.common.request.GmDevTermGetRequest;
import com.iesms.bizprocessors.common.response.GmDevTermGetResponse;
import com.iesms.bizprocessors.common.service.AbstractIesmsBaseService;
import com.iesms.bizprocessors.common.service.GmDevTermService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 *
 */
@Service
public class GmDevTermServiceImpl extends AbstractIesmsBaseService implements GmDevTermService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private GmDevTermDao gmDevTermDao;

    @Autowired
    public GmDevTermServiceImpl(GmDevTermDao gmDevTermDao) {
        this.gmDevTermDao = gmDevTermDao;
    }

    @Override
    public GmDevTermGetResponse getGmDevTerm(GmDevTermGetRequest gmDevTermGetRequest) {
        if(logger.isDebugEnabled()) {
            logger.debug(" >>>>>> start getGmDevTerm >>>>>> ");
            logger.debug(" GmDevTermGetRequest          : " + JsonConvertUtils.convertToString(gmDevTermGetRequest));
        }
        GmDevTermGetResponse gmDevTermGetResponse = new GmDevTermGetResponse();
        gmDevTermGetResponse.setFailureDefault();
        GmDevTermDo gmDevTerm = null;
        if(gmDevTermGetRequest != null && gmDevTermGetRequest.getDevTermId() != null && gmDevTermGetRequest.getDevTermId() > 0L) {
            gmDevTerm = gmDevTermDao.get(gmDevTermGetRequest.getDevTermId());
        }
        else if(gmDevTermGetRequest != null && StringUtils.isNotBlank(gmDevTermGetRequest.getOrgNo())) {
            if(StringUtils.isNotBlank(gmDevTermGetRequest.getDevTermNo())) {
                gmDevTerm = gmDevTermDao.getByOrgNoAndDevTermNo(gmDevTermGetRequest.getOrgNo(), gmDevTermGetRequest.getDevTermNo());
            }
            else if(StringUtils.isNotBlank(gmDevTermGetRequest.getDevTermCommProto()) && StringUtils.isNotBlank(gmDevTermGetRequest.getDevTermCommAddr())) {
                gmDevTerm = gmDevTermDao.getByOrgNoAndDevTermCommProtoAndDevTermCommAddr(gmDevTermGetRequest.getOrgNo(), gmDevTermGetRequest.getDevTermCommProto(), gmDevTermGetRequest.getDevTermCommAddr());
            }
        }
        else if(gmDevTermGetRequest != null && gmDevTermGetRequest.getAccessGatewayId() != null && gmDevTermGetRequest.getAccessGatewayId() > 0L) {
            gmDevTerm = gmDevTermDao.getByAccessGatewayId(gmDevTermGetRequest.getAccessGatewayId());
        }

        if(gmDevTerm == null) {
            gmDevTermGetResponse.setFailure("GM_DEV_TERM_NOTEXIST", "该采集终端设备不存在");
        }
        else {
            gmDevTermGetResponse.setSuccess();
            gmDevTermGetResponse.setGmDevTerm(gmDevTerm);
        }

        if(logger.isDebugEnabled()) {
            logger.debug(" GmDevTermGetResponse            : " + JsonConvertUtils.convertToString(gmDevTermGetResponse));
            logger.debug(" <<<<<<< end getGmDevTerm <<<<<<< ");
        }
        return gmDevTermGetResponse;
    }

}
