/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.bizprocessors.common.service.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.iesms.bizprocessors.common.dao.SoeRecordOnOffAlarmDao;
import com.iesms.bizprocessors.common.entity.AlarmVo;
import com.iesms.bizprocessors.common.entity.SoeDevMeterAlarmVo;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDo;
import com.iesms.bizprocessors.common.entity.SoeRecordOnOffAlarmDto;
import com.iesms.bizprocessors.common.entity.SoeThresholdSetAlarmDo;
import com.iesms.bizprocessors.common.service.AbstractIesmsBaseService;
import com.iesms.bizprocessors.common.service.SoeRecordOnOffAlarmService;
import com.iesms.bizprocessors.common.util.MeasStatUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SoeRecordOnOffAlarmServiceImpl
extends AbstractIesmsBaseService
implements SoeRecordOnOffAlarmService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentHashMap<String, Long> concurrentHashMap = new ConcurrentHashMap();
    @Resource
    private SoeRecordOnOffAlarmDao soeRecordOnOffAlarmDao;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public void insertSoeRecordOnOffAlarmDo(List<SoeRecordOnOffAlarmDo> list) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> \u544a\u8b66\u8bb0\u5f55\u63d2\u5165\u5f00\u59cb >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u8bb0\u5f55\u6570\u4e3a\uff1a" + list.size());
        }
        if (list == null) {
            return;
        }
        list.removeIf(Objects::isNull);
        if (list.size() < 1) {
            return;
        }
        long time1 = System.currentTimeMillis();
        list.forEach(alarmDo -> {
            alarmDo.setId(Long.valueOf(this.idGenerator.nextId()));
            alarmDo.setSoeLevel(3);
            alarmDo.setGraveLevel(3);
            alarmDo.setSendSms(false);
            alarmDo.setSendSmsCount(0);
            alarmDo.setSortSn(1);
            alarmDo.setValid(true);
            alarmDo.setGmtCreate(System.currentTimeMillis());
            alarmDo.setGmtModified(System.currentTimeMillis());
            alarmDo.setCreator("alarmSystem");
            alarmDo.setCreator("alarmSystem");
            alarmDo.setInvalider("alarmSystem");
            alarmDo.setModifier("alarmSystem");
            alarmDo.setGmtInvalid(0L);
            alarmDo.setVersion(0);
        });
        for (int i = 0; i < list.size(); ++i) {
            this.soeRecordOnOffAlarmDao.insertSoeRecordOnOffAlarmDo(list.get(i));
        }
        long time2 = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> \u544a\u8b66\u8bb0\u5f55\u63d2\u5165\u7ed3\u675f>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>\u544a\u8b66\u8bb0\u5f55\u63d2\u5165\u65f6\u95f4\u4e3a\uff1a" + (time2 - time1) / 1000L + "\u79d2");
            this.logger.debug(" ===================================\u5f00\u5408\u544a\u8b66\u63a8\u9001\u5f00\u59cb===================================");
        }
        list.forEach(alarm -> {
            AlarmVo alarmVo = new AlarmVo();
            alarmVo.setOrgNo(alarm.getOrgNo());
            alarmVo.setDeviceName(alarm.getSoeObjectName());
            alarmVo.setGraveLevel("3");
            alarmVo.setSoeSortNo(alarm.getSoeSortNo());
            alarmVo.setSoeSortName(alarm.getSoeDesc());
            this.stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT", (Object)JsonConvertUtils.convertToString((Object)alarmVo));
        });
        long time3 = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u544a\u8b66\u63a8\u9001\u65f6\u95f4\u4e3a\uff1a" + (time3 - time2) / 1000L);
            this.logger.debug(" ===================================\u5f00\u5408\u544a\u8b66\u63a8\u9001\u7ed3\u675f ==================================");
        }
    }

    public void insertSoeRecordOnOffAlarmDto(List<SoeRecordOnOffAlarmDto> list) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("******************************************** \u7535\u80fd\u8d28\u91cf\u544a\u8b66\u8bb0\u5f55\u63d2\u5165\u5f00\u59cb******************************************** \u544a\u8b66\u8bb0\u5f55\u6570\uff1a" + list.size());
        }
        long time1 = System.currentTimeMillis();
        for (int i = 0; i < list.size(); ++i) {
            this.soeRecordOnOffAlarmDao.insertSoeRecordOnOffAlarmDto(list.get(i));
        }
        long time2 = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("******************************************** \u7535\u80fd\u8d28\u91cf\u544a\u8b66\u8bb0\u5f55\u63d2\u5165\u7ed3\u675f******************************************** \u544a\u8b66\u8bb0\u5f55\u63d2\u5165\u65f6\u95f4\u4e3a\uff1a" + (time2 - time1) / 1000L + "\u79d2");
            this.logger.debug("******************************************** \u7535\u80fd\u8d28\u91cf\u544a\u8b66\u63a8\u9001\u5f00\u59cb********************************************");
        }
        list.forEach(alarm -> {
            AlarmVo alarmVo = new AlarmVo();
            alarmVo.setOrgNo(alarm.getOrgNo());
            alarmVo.setDeviceName(alarm.getSoeObjectName());
            alarmVo.setGraveLevel("3");
            alarmVo.setSoeSortNo(alarm.getSoeSortNo());
            alarmVo.setSoeSortName(alarm.getSoeDesc());
            this.stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT", (Object)JsonConvertUtils.convertToString((Object)alarmVo));
        });
        long time3 = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u544a\u8b66\u63a8\u9001\u65f6\u95f4\u4e3a\uff1a" + (time3 - time2) / 1000L + "\u79d2");
            this.logger.debug("********************************************\u7535\u80fd\u8d28\u91cf\u544a\u8b66\u63a8\u9001\u7ed3\u675f********************************************");
        }
    }

    public void updateSoeRecordOnOffAlarmDo(SoeRecordOnOffAlarmDo onOffAlarmDo) {
        HashMap<String, String> map;
        String devMeterCommAddr = onOffAlarmDo.getDevMeterCommAddr();
        String devTermCommAddr = onOffAlarmDo.getDevTermCommAddr();
        Long measPointId = onOffAlarmDo.getMeasPointId();
        SoeRecordOnOffAlarmDo devMeterInfo = null;
        if (devTermCommAddr != null) {
            map = new HashMap<String, String>();
            map.put("devMeterCommAddr", devMeterCommAddr);
            map.put("devTermCommAddr", devTermCommAddr);
            devMeterInfo = this.soeRecordOnOffAlarmDao.getDevMeterInfo(map);
        } else {
            map = new HashMap();
            map.put("devMeterCommAddr", devMeterCommAddr);
            map.put("measPointId", measPointId.toString());
            devMeterInfo = this.soeRecordOnOffAlarmDao.getDevMeterInfoByMeasePointId(map);
        }
        if (devMeterInfo == null) {
            return;
        }
        ArrayList<SoeRecordOnOffAlarmDo> onOffAlarmDoList = new ArrayList<SoeRecordOnOffAlarmDo>();
        Long devMeterId = devMeterInfo.getId();
        String devMeterName = devMeterInfo.getDevMeterName();
        String devTermName = devMeterInfo.getDevTermName();
        String orgNo = devMeterInfo.getOrgNo();
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        objectMap.put("soeObjectId", devMeterId);
        objectMap.put("soeSortNo", "SOE_GEN_WATT_STATE_SHIFT_ALARM");
        objectMap.put("recovery", false);
        SoeRecordOnOffAlarmDo beforeOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(objectMap);
        Boolean onOff = onOffAlarmDo.getOnOff();
        HashMap<String, Boolean> stringMap = new HashMap<String, Boolean>();
        stringMap.put("gen_watt_state_open", onOff);
        String soeGenValue = JsonConvertUtils.convertToString(stringMap);
        onOffAlarmDo.setOrgNo(orgNo);
        onOffAlarmDo.setSoeObjectId(devMeterId);
        onOffAlarmDo.setSoeObjectName(devMeterName);
        onOffAlarmDo.setSoeObjectType(3);
        onOffAlarmDo.setSoeGenTime(new Date());
        onOffAlarmDo.setSoeGenValue(soeGenValue);
        onOffAlarmDo.setDevMeterName(devMeterName);
        onOffAlarmDo.setSoeSortNo("SOE_GEN_WATT_STATE_SHIFT_ALARM");
        if (onOff.booleanValue()) {
            onOffAlarmDo.setSoeTitle(devMeterName);
            onOffAlarmDo.setSoeDesc("\u5408(\u95ed\u5408)\u95f8\u544a\u8b66");
        } else {
            onOffAlarmDo.setSoeTitle(devMeterName);
            onOffAlarmDo.setSoeDesc("\u5f00(\u65ad\u5f00)\u95f8\u544a\u8b66");
        }
        if (beforeOffAlarmDo == null) {
            onOffAlarmDo.setRecovery(false);
            onOffAlarmDoList.add(onOffAlarmDo);
        } else {
            String beforeDoSoeGenValue = beforeOffAlarmDo.getSoeGenValue();
            Map map1 = (Map)JsonConvertUtils.convertFromString((String)beforeDoSoeGenValue, Map.class);
            Boolean wattStateOpen = (Boolean)map1.get("gen_watt_state_open");
            if (wattStateOpen == false == onOff) {
                onOffAlarmDoList.add(onOffAlarmDo);
                beforeOffAlarmDo.setRecovery(true);
                HashMap<String, Boolean> stringMap1 = new HashMap<String, Boolean>();
                stringMap1.put("gen_watt_state_open", onOff);
                String soeGenValue1 = JsonConvertUtils.convertToString(stringMap1);
                beforeOffAlarmDo.setSoeRecValue(soeGenValue1);
                beforeOffAlarmDo.setSoeRecTime(new Date());
                beforeOffAlarmDo.setGmtModified(System.currentTimeMillis());
                this.soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(beforeOffAlarmDo);
            }
        }
        if (onOffAlarmDoList.size() > 0) {
            this.insertSoeRecordOnOffAlarmDo(onOffAlarmDoList);
        }
    }

    public void updateBoundSoeRecordOnOffAlarmDo(MeasDataService measDataService) {
        List<SoeThresholdSetAlarmDo> thresholdSetAlarmDo;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u8c03\u7528\u4e0a\u4e0b\u9650\u544a\u8b66 \u53c2\u6570\uff1a{}", (Object)measDataService);
        }
        if ((thresholdSetAlarmDo = this.soeRecordOnOffAlarmDao.getSoeThresholdSetAlarmDo()) == null) {
            return;
        }
        Map<Long, List<SoeThresholdSetAlarmDo>> mapList = thresholdSetAlarmDo.stream().collect(Collectors.groupingBy(SoeThresholdSetAlarmDo::getCeDevId));
        ArrayList alarmDoList = new ArrayList();
        mapList.forEach((ceDeviceId, alarmList) -> {
            SoeDevMeterAlarmVo alarmVo = new SoeDevMeterAlarmVo();
            alarmVo.setCeDeviceId(ceDeviceId);
            List<SoeDevMeterAlarmVo> devMeterAlarmList = this.soeRecordOnOffAlarmDao.getSoeDevMeterAlarmList(alarmVo);
            if (devMeterAlarmList == null || devMeterAlarmList.size() < 1) {
                return;
            }
            Set<String> measIdList = MeasStatUtil.getMeasIdList(devMeterAlarmList);
            String orgNo = devMeterAlarmList.get(0).getOrgNo();
            String ceResName = devMeterAlarmList.get(0).getCeResName();
            TreeSet<String> measItemCodeSet = new TreeSet<String>();
            alarmList.forEach(meterAlarmVo -> measItemCodeSet.add(meterAlarmVo.getMeasItemCode()));
            Map<String, BigDecimal> decimalMap = MeasStatUtil.getValueSum(measItemCodeSet, measIdList, measDataService);
            alarmList.forEach(alarm -> {
                HashMap<String, BigDecimal> map2;
                String convert;
                HashMap<String, BigDecimal> map;
                SoeRecordOnOffAlarmDo alarmDo;
                SoeRecordOnOffAlarmDo recordOnOffAlarmDo;
                String sortNo;
                HashMap<String, Object> map1;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u544a\u8b66\u7684\u8bbe\u5907id\u662f\uff1a", ceDeviceId);
                }
                String measItemCode = alarm.getMeasItemCode();
                String similar = measItemCode.substring(0, 10);
                ArrayList list = new ArrayList();
                measItemCodeSet.forEach(code -> {
                    String simi = code.substring(0, 10);
                    if (simi.equals(similar)) {
                        list.add(code);
                    }
                });
                String measItemCode2 = alarm.getMeasItemCode();
                BigDecimal upperLimit = alarm.getUpperLimit();
                BigDecimal upperUpperLimit = alarm.getUpperUpperLimit();
                BigDecimal downLimit = alarm.getDownLimit();
                BigDecimal downDownLimit = alarm.getDownDownLimit();
                Object value = decimalMap.get(measItemCode);
                if (value == null) {
                    return;
                }
                String measItemAlias = alarm.getMeasItemAlias();
                BigDecimal currValue = new BigDecimal(value.toString());
                if (upperUpperLimit != null) {
                    map1 = new HashMap<String, Object>();
                    map1.put("soeObjectId", ceDeviceId);
                    map1.put("recovery", false);
                    sortNo = "SOE_" + measItemCode.toUpperCase() + "_OUUL_ALARM";
                    map1.put("soeSortNo", sortNo);
                    recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                    if (recordOnOffAlarmDo == null && currValue.compareTo(upperUpperLimit) > 0) {
                        alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setSoeObjectType(20);
                        alarmDo.setSoeRecTime(new Date());
                        alarmDo.setSoeSortNo(measItemCode);
                        map = new HashMap<String, BigDecimal>();
                        map.put(measItemCode2 + "_curr_value", currValue);
                        map.put(measItemCode2 + "_set_value", upperUpperLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                            map.put((String)code, decimal);
                        });
                        convert = JsonConvertUtils.convertToString(map);
                        alarmDo.setSoeGenValue(convert);
                        this.comp(alarmDo, measItemAlias, upperUpperLimit, currValue, 1);
                        if (!alarmDo.getSoeSortNo().equals("")) {
                            alarmDoList.add(alarmDo);
                        }
                    } else if (currValue.compareTo(upperUpperLimit) <= 0) {
                        alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setRecovery(true);
                        map2 = new HashMap<String, BigDecimal>();
                        map2.put(measItemCode2 + "_curr_value", currValue);
                        map2.put(measItemCode2 + "_set_value", upperUpperLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                            map2.put((String)code, decimal);
                        });
                        convert = JsonConvertUtils.convertToString(map2);
                        alarmDo.setSoeRecValue(convert);
                        alarmDo.setSoeRecTime(new Date());
                        alarmDo.setSoeSortNo(sortNo);
                        alarmDo.setGmtModified(System.currentTimeMillis());
                        this.soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                    }
                }
                if (upperLimit != null) {
                    map1 = new HashMap();
                    map1.put("soeObjectId", ceDeviceId);
                    map1.put("recovery", false);
                    sortNo = "SOE_" + measItemCode.toUpperCase() + "_OUL_ALARM";
                    map1.put("soeSortNo", sortNo);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u83b7\u53d6\u5f53\u524d\u662f\u5426\u6709\u544a\u8b66\u7684\u53c2\u6570\u4e3a\uff1a", (Object)((Object)map1).toString());
                    }
                    recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u544a\u8b66\u7684\u4fe1\u606f\u4e3a================\uff1a", (Object)recordOnOffAlarmDo);
                    }
                    if (recordOnOffAlarmDo == null && currValue.compareTo(upperLimit) > 0) {
                        alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setSoeSortNo(measItemCode);
                        alarmDo.setSoeObjectType(20);
                        alarmDo.setSoeGenTime(new Date());
                        map = new HashMap();
                        map.put(measItemCode2 + "_curr_value", currValue);
                        map.put(measItemCode2 + "_set_value", upperLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                            map.put((String)code, decimal);
                        });
                        convert = JsonConvertUtils.convertToString(map);
                        alarmDo.setSoeGenValue(convert);
                        this.comp(alarmDo, measItemAlias, upperLimit, currValue, 2);
                        if (!alarmDo.getSoeSortNo().equals("")) {
                            alarmDoList.add(alarmDo);
                        }
                    } else if (currValue.compareTo(upperLimit) <= 0) {
                        alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setRecovery(true);
                        map2 = new HashMap();
                        map2.put(measItemCode2 + "_curr_value", currValue);
                        map2.put(measItemCode2 + "_set_value", upperLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                            map2.put((String)code, decimal);
                        });
                        convert = JsonConvertUtils.convertToString(map2);
                        alarmDo.setSoeRecValue(convert);
                        alarmDo.setSoeRecTime(new Date());
                        alarmDo.setSoeSortNo(sortNo);
                        alarmDo.setGmtModified(System.currentTimeMillis());
                        this.soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                    }
                }
                if (downLimit != null) {
                    map1 = new HashMap();
                    map1.put("soeObjectId", ceDeviceId);
                    map1.put("recovery", false);
                    sortNo = "SOE_" + measItemCode.toUpperCase() + "_OLL_ALARM";
                    map1.put("soeSortNo", sortNo);
                    recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                    if (recordOnOffAlarmDo == null && currValue.compareTo(downLimit) < 0) {
                        alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setSoeSortNo(measItemCode);
                        alarmDo.setSoeGenTime(new Date());
                        map = new HashMap();
                        map.put(measItemCode2 + "_curr_value", currValue);
                        map.put(measItemCode2 + "_set_value", downLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                            map.put((String)code, decimal);
                        });
                        alarmDo.setSoeObjectType(20);
                        convert = JsonConvertUtils.convertToString(map);
                        alarmDo.setSoeGenValue(convert);
                        this.comp(alarmDo, measItemAlias, downLimit, currValue, 3);
                        if (!alarmDo.getSoeSortNo().equals("")) {
                            alarmDoList.add(alarmDo);
                        }
                    } else if (currValue.compareTo(downLimit) >= 0) {
                        alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setRecovery(true);
                        map2 = new HashMap();
                        map2.put(measItemCode2 + "_curr_value", currValue);
                        map2.put(measItemCode2 + "_set_value", downLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                            map2.put((String)code, decimal);
                        });
                        convert = JsonConvertUtils.convertToString(map2);
                        alarmDo.setSoeRecValue(convert);
                        alarmDo.setSoeRecTime(new Date());
                        alarmDo.setSoeSortNo(sortNo);
                        alarmDo.setGmtModified(System.currentTimeMillis());
                        this.soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                    }
                }
                if (downDownLimit != null) {
                    map1 = new HashMap();
                    map1.put("soeObjectId", ceDeviceId);
                    map1.put("recovery", false);
                    sortNo = "SOE_" + measItemCode.toUpperCase() + "_OLLL_ALARM";
                    map1.put("soeSortNo", sortNo);
                    recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                    if (recordOnOffAlarmDo == null && currValue.compareTo(downDownLimit) < 0) {
                        alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setSoeSortNo(measItemCode);
                        alarmDo.setSoeGenTime(new Date());
                        map = new HashMap();
                        map.put(measItemCode2 + "_curr_value", currValue);
                        map.put(measItemCode2 + "_set_value", downDownLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                            map.put((String)code, decimal);
                        });
                        alarmDo.setSoeObjectType(20);
                        convert = JsonConvertUtils.convertToString(map);
                        alarmDo.setSoeGenValue(convert);
                        this.comp(alarmDo, measItemAlias, downDownLimit, currValue, 4);
                        if (!alarmDo.getSoeSortNo().equals("")) {
                            alarmDoList.add(alarmDo);
                        }
                    } else if (currValue.compareTo(downDownLimit) >= 0) {
                        alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setRecovery(true);
                        map2 = new HashMap();
                        map2.put(measItemCode2 + "_curr_value", currValue);
                        map2.put(measItemCode2 + "_set_value", downDownLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                            map2.put((String)code, decimal);
                        });
                        convert = JsonConvertUtils.convertToString(map2);
                        alarmDo.setSoeRecValue(convert);
                        alarmDo.setSoeRecTime(new Date());
                        alarmDo.setSoeSortNo(sortNo);
                        alarmDo.setGmtModified(System.currentTimeMillis());
                        this.soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                    }
                }
            });
        });
        if (alarmDoList.size() > 0) {
            ArrayList list = alarmDoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<SoeRecordOnOffAlarmDo>(Comparator.comparing(SoeRecordOnOffAlarmDo::getSoeSortNo))), ArrayList::new));
            this.insertSoeRecordOnOffAlarmDo(list);
        }
    }

    private void comp(SoeRecordOnOffAlarmDo alarmDo, String measItemAlias, BigDecimal limitValue, BigDecimal currValue, int level) {
        if (currValue == null || limitValue == null) {
            return;
        }
        int i = currValue.compareTo(limitValue);
        Boolean limit1 = i > 0;
        Boolean limit2 = i < 0;
        StringBuffer sb = new StringBuffer();
        sb.append("SOE_");
        String soeSortNo = alarmDo.getSoeSortNo().toUpperCase();
        sb.append(soeSortNo);
        String mess = "";
        String valueDes = "";
        String toString = currValue.toString();
        String zeroAndDot = MeasStatUtil.subZeroAndDot(toString);
        String subZeroAndDot = MeasStatUtil.subZeroAndDot(limitValue.toString());
        switch (level) {
            case 1: {
                if (limit1.booleanValue()) {
                    mess = " \u8d8a\u4e0a\u4e0a\u9650\u544a\u8b66";
                    sb.append("_OUUL_ALARM");
                    valueDes = "\u4e0a\u4e0a\u9650\u8bbe\u7f6e\u503c\uff1a" + subZeroAndDot + " , \u5f53\u524d\u503c\uff1a" + zeroAndDot;
                    break;
                }
                sb = null;
                break;
            }
            case 2: {
                if (limit1.booleanValue()) {
                    mess = " \u8d8a\u4e0a\u9650\u544a\u8b66";
                    sb.append("_OUL_ALARM");
                    valueDes = "\u4e0a\u9650\u8bbe\u7f6e\u503c\uff1a" + subZeroAndDot + " , \u5f53\u524d\u503c\uff1a" + zeroAndDot;
                    break;
                }
                sb = null;
                break;
            }
            case 3: {
                if (limit2.booleanValue()) {
                    mess = " \u8d8a\u4e0b\u9650\u544a\u8b66";
                    sb.append("_OLL_ALARM");
                    valueDes = "\u4e0b\u9650\u8bbe\u7f6e\u503c\uff1a" + subZeroAndDot + " , \u5f53\u524d\u503c\uff1a" + zeroAndDot;
                    break;
                }
                sb = null;
                break;
            }
            case 4: {
                if (limit2.booleanValue()) {
                    mess = " \u8d8a\u4e0b\u4e0b\u9650\u544a\u8b66";
                    sb.append("_OLLL_ALARM");
                    valueDes = "\u4e0b\u4e0b\u9650\u8bbe\u7f6e\u503c\uff1a" + subZeroAndDot + " , \u5f53\u524d\u503c\uff1a" + zeroAndDot;
                    break;
                }
                sb = null;
            }
        }
        if (sb != null) {
            alarmDo.setSoeTitle(measItemAlias + "\u544a\u8b66");
            alarmDo.setSoeDesc(measItemAlias + mess + " ," + valueDes);
            alarmDo.setSoeSortNo(sb.toString());
        } else {
            alarmDo.setSoeTitle("");
            alarmDo.setSoeDesc("");
            alarmDo.setSoeSortNo("");
        }
    }

    public SoeRecordOnOffAlarmDo getSoeRecordOnOffAlarmDo(Map<String, Object> params) {
        if (params == null) {
            return null;
        }
        return this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(params);
    }

    public static void main(String[] args) throws Exception {
        BigDecimal currValue = new BigDecimal("229.300000");
        BigDecimal upperUpperLimit = new BigDecimal("242.0");
        System.out.println("=================" + currValue.compareTo(upperUpperLimit));
    }

    public void newUpdateBoundSoeRecordOnOffAlarmDo(MeasDataService measDataService, List<Long> ids) throws Exception {
        try {
            ArrayList<String> midList = new ArrayList<String>();
            ArrayList<SoeRecordOnOffAlarmDo> alarmDoList = new ArrayList<SoeRecordOnOffAlarmDo>();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u6267\u884c\u91cf\u4fa7\u70b9\u603b\u6570\u4e3a" + ids.size());
            }
            for (Long id : ids) {
                if (this.concurrentHashMap.get(String.valueOf(id)) != null) continue;
                this.concurrentHashMap.put(String.valueOf(id), id);
                midList.add(String.valueOf(id));
                SoeDevMeterAlarmVo alarmVo = new SoeDevMeterAlarmVo();
                alarmVo.setMeasPointId(id);
                List<SoeThresholdSetAlarmDo> thresholdSetAlarmDo = this.soeRecordOnOffAlarmDao.getAlarmMsg(alarmVo);
                if (thresholdSetAlarmDo == null || thresholdSetAlarmDo.size() == 0) continue;
                Map<Long, List<SoeThresholdSetAlarmDo>> mapList = thresholdSetAlarmDo.stream().collect(Collectors.groupingBy(SoeThresholdSetAlarmDo::getCeDevId));
                mapList.forEach((ceDeviceId, alarmList) -> {
                    String orgNo = ((SoeThresholdSetAlarmDo)alarmList.get(0)).getOrgNo();
                    String ceResName = ((SoeThresholdSetAlarmDo)alarmList.get(0)).getCeResName();
                    TreeSet<String> measItemCodeSet = new TreeSet<String>();
                    alarmList.forEach(meterAlarmVo -> measItemCodeSet.add(meterAlarmVo.getMeasItemCode()));
                    ConcurrentHashMap<String, Long> measMaps = new ConcurrentHashMap<String, Long>();
                    String measPointIds = ((SoeThresholdSetAlarmDo)alarmList.get(0)).getMeasPointIdList();
                    String[] measPointIds2 = null;
                    if (measPointIds != null && !measPointIds.equals("[]") && !measPointIds.equals("[0]")) {
                        measPointIds2 = (String[])JsonConvertUtils.convertFromString((String)measPointIds, String[].class);
                    }
                    if (measPointIds2 != null && measPointIds2.length > 0) {
                        for (String measId : measPointIds2) {
                            measMaps.put(measId, Long.valueOf(measId));
                        }
                    }
                    Set<String> measIdList = measMaps.keySet();
                    Map<String, BigDecimal> decimalMap = MeasStatUtil.getValueSum(measItemCodeSet, measIdList, measDataService);
                    alarmList.forEach(alarm -> {
                        HashMap<String, BigDecimal> map2;
                        String convert;
                        HashMap<String, BigDecimal> map;
                        SoeRecordOnOffAlarmDo alarmDo;
                        SoeRecordOnOffAlarmDo recordOnOffAlarmDo;
                        String sortNo;
                        HashMap<String, Object> map1;
                        String measItemCode = alarm.getMeasItemCode();
                        String similar = measItemCode.substring(0, 10);
                        ArrayList list = new ArrayList();
                        measItemCodeSet.forEach(code -> {
                            String simi = code.substring(0, 10);
                            if (simi.equals(similar)) {
                                list.add(code);
                            }
                        });
                        String measItemCode2 = alarm.getMeasItemCode();
                        BigDecimal upperLimit = alarm.getUpperLimit();
                        BigDecimal upperUpperLimit = alarm.getUpperUpperLimit();
                        BigDecimal downLimit = alarm.getDownLimit();
                        BigDecimal downDownLimit = alarm.getDownDownLimit();
                        Object value = decimalMap.get(measItemCode);
                        if (value == null) {
                            return;
                        }
                        String measItemAlias = alarm.getMeasItemAlias();
                        BigDecimal currValue = new BigDecimal(value.toString());
                        if (upperUpperLimit != null) {
                            map1 = new HashMap<String, Object>();
                            map1.put("soeObjectId", ceDeviceId);
                            map1.put("recovery", false);
                            sortNo = "SOE_" + measItemCode.toUpperCase() + "_OUUL_ALARM";
                            map1.put("soeSortNo", sortNo);
                            recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                            if (recordOnOffAlarmDo == null && currValue.compareTo(upperUpperLimit) > 0) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("\u8fdb\u5165\u8d8a\u4e0a\u4e0a\u9650\u88c1\u5b9a ======================\u5f53\u524d\u503c\u4e3a\uff1a" + currValue + "\u8d8a\u4e0a\u4e0a\u9650\u503c\u4e3a\uff1a" + upperUpperLimit);
                                }
                                alarmDo = new SoeRecordOnOffAlarmDo();
                                alarmDo.setOrgNo(orgNo);
                                alarmDo.setSoeObjectId(ceDeviceId);
                                alarmDo.setSoeObjectName(ceResName);
                                alarmDo.setSoeObjectType(20);
                                alarmDo.setSoeGenTime(new Date());
                                alarmDo.setSoeSortNo(measItemCode);
                                map = new HashMap<String, BigDecimal>();
                                map.put(measItemCode2 + "_curr_value", currValue);
                                map.put(measItemCode2 + "_set_value", upperUpperLimit);
                                measItemCodeSet.forEach(code -> {
                                    BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                                    map.put((String)code, decimal);
                                });
                                convert = JsonConvertUtils.convertToString(map);
                                alarmDo.setSoeGenValue(convert);
                                this.comp(alarmDo, measItemAlias, upperUpperLimit, currValue, 1);
                                if (!alarmDo.getSoeSortNo().equals("")) {
                                    alarmDoList.add(alarmDo);
                                }
                            } else if (currValue.compareTo(upperUpperLimit) <= 0) {
                                alarmDo = new SoeRecordOnOffAlarmDo();
                                alarmDo.setOrgNo(orgNo);
                                alarmDo.setSoeObjectId(ceDeviceId);
                                alarmDo.setSoeObjectName(ceResName);
                                alarmDo.setRecovery(true);
                                map2 = new HashMap<String, BigDecimal>();
                                map2.put(measItemCode2 + "_curr_value", currValue);
                                map2.put(measItemCode2 + "_set_value", upperUpperLimit);
                                measItemCodeSet.forEach(code -> {
                                    BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                                    map2.put((String)code, decimal);
                                });
                                convert = JsonConvertUtils.convertToString(map2);
                                alarmDo.setSoeRecValue(convert);
                                alarmDo.setSoeRecTime(new Date());
                                alarmDo.setSoeSortNo(sortNo);
                                alarmDo.setGmtModified(System.currentTimeMillis());
                                this.soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                            }
                        }
                        if (upperLimit != null) {
                            map1 = new HashMap();
                            map1.put("soeObjectId", ceDeviceId);
                            map1.put("recovery", false);
                            sortNo = "SOE_" + measItemCode.toUpperCase() + "_OUL_ALARM";
                            map1.put("soeSortNo", sortNo);
                            recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                            if (recordOnOffAlarmDo == null && currValue.compareTo(upperLimit) > 0) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("\u8fdb\u5165\u8d8a\u4e0a\u9650\u88c1\u5b9a ======================\u5f53\u524d\u503c\u4e3a\uff1a" + currValue + "\u8d8a\u4e0a\u9650\u503c\u4e3a\uff1a" + upperLimit);
                                    this.logger.debug("\u83b7\u53d6\u5f53\u524d\u662f\u5426\u6709\u544a\u8b66\u7684\u53c2\u6570\u4e3a\uff1a" + ((Object)map1).toString());
                                }
                                alarmDo = new SoeRecordOnOffAlarmDo();
                                alarmDo.setOrgNo(orgNo);
                                alarmDo.setSoeObjectId(ceDeviceId);
                                alarmDo.setSoeObjectName(ceResName);
                                alarmDo.setSoeSortNo(measItemCode);
                                alarmDo.setSoeObjectType(20);
                                alarmDo.setSoeGenTime(new Date());
                                map = new HashMap();
                                map.put(measItemCode2 + "_curr_value", currValue);
                                map.put(measItemCode2 + "_set_value", upperLimit);
                                measItemCodeSet.forEach(code -> {
                                    BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                                    map.put((String)code, decimal);
                                });
                                convert = JsonConvertUtils.convertToString(map);
                                alarmDo.setSoeGenValue(convert);
                                this.comp(alarmDo, measItemAlias, upperLimit, currValue, 2);
                                if (!alarmDo.getSoeSortNo().equals("")) {
                                    alarmDoList.add(alarmDo);
                                }
                            } else if (currValue.compareTo(upperLimit) <= 0) {
                                alarmDo = new SoeRecordOnOffAlarmDo();
                                alarmDo.setOrgNo(orgNo);
                                alarmDo.setSoeObjectId(ceDeviceId);
                                alarmDo.setSoeObjectName(ceResName);
                                alarmDo.setRecovery(true);
                                map2 = new HashMap();
                                map2.put(measItemCode2 + "_curr_value", currValue);
                                map2.put(measItemCode2 + "_set_value", upperLimit);
                                measItemCodeSet.forEach(code -> {
                                    BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                                    map2.put((String)code, decimal);
                                });
                                convert = JsonConvertUtils.convertToString(map2);
                                alarmDo.setSoeRecValue(convert);
                                alarmDo.setSoeRecTime(new Date());
                                alarmDo.setSoeSortNo(sortNo);
                                alarmDo.setGmtModified(System.currentTimeMillis());
                                this.soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                            }
                        }
                        if (downLimit != null) {
                            map1 = new HashMap();
                            map1.put("soeObjectId", ceDeviceId);
                            map1.put("recovery", false);
                            sortNo = "SOE_" + measItemCode.toUpperCase() + "_OLL_ALARM";
                            map1.put("soeSortNo", sortNo);
                            recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                            if (recordOnOffAlarmDo == null && currValue.compareTo(downLimit) < 0) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("\u8fdb\u5165\u8d8a\u4e0b\u9650\u88c1\u5b9a ======================\u5f53\u524d\u503c\u4e3a\uff1a" + currValue + "\u8d8a\u4e0b\u9650\u503c\u4e3a\uff1a" + downLimit);
                                }
                                alarmDo = new SoeRecordOnOffAlarmDo();
                                alarmDo.setOrgNo(orgNo);
                                alarmDo.setSoeObjectId(ceDeviceId);
                                alarmDo.setSoeObjectName(ceResName);
                                alarmDo.setSoeSortNo(measItemCode);
                                alarmDo.setSoeGenTime(new Date());
                                map = new HashMap();
                                map.put(measItemCode2 + "_curr_value", currValue);
                                map.put(measItemCode2 + "_set_value", downLimit);
                                measItemCodeSet.forEach(code -> {
                                    BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                                    map.put((String)code, decimal);
                                });
                                alarmDo.setSoeObjectType(20);
                                convert = JsonConvertUtils.convertToString(map);
                                alarmDo.setSoeGenValue(convert);
                                this.comp(alarmDo, measItemAlias, downLimit, currValue, 3);
                                if (!alarmDo.getSoeSortNo().equals("")) {
                                    alarmDoList.add(alarmDo);
                                }
                            } else if (currValue.compareTo(downLimit) >= 0) {
                                alarmDo = new SoeRecordOnOffAlarmDo();
                                alarmDo.setOrgNo(orgNo);
                                alarmDo.setSoeObjectId(ceDeviceId);
                                alarmDo.setSoeObjectName(ceResName);
                                alarmDo.setRecovery(true);
                                map2 = new HashMap();
                                map2.put(measItemCode2 + "_curr_value", currValue);
                                map2.put(measItemCode2 + "_set_value", downLimit);
                                measItemCodeSet.forEach(code -> {
                                    BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                                    map2.put((String)code, decimal);
                                });
                                convert = JsonConvertUtils.convertToString(map2);
                                alarmDo.setSoeRecValue(convert);
                                alarmDo.setSoeRecTime(new Date());
                                alarmDo.setSoeSortNo(sortNo);
                                alarmDo.setGmtModified(System.currentTimeMillis());
                                this.soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                            }
                        }
                        if (downDownLimit != null) {
                            map1 = new HashMap();
                            map1.put("soeObjectId", ceDeviceId);
                            map1.put("recovery", false);
                            sortNo = "SOE_" + measItemCode.toUpperCase() + "_OLLL_ALARM";
                            map1.put("soeSortNo", sortNo);
                            recordOnOffAlarmDo = this.soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                            if (recordOnOffAlarmDo == null && currValue.compareTo(downDownLimit) < 0) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug("\u8fdb\u5165\u8d8a\u4e0b\u4e0b\u9650\u88c1\u5b9a ======================\u5f53\u524d\u503c\u4e3a\uff1a" + currValue + "\u8d8a\u4e0b\u4e0b\u9650\u503c\u4e3a\uff1a" + downDownLimit);
                                    this.logger.debug("\u83b7\u53d6\u5f53\u524d\u662f\u5426\u6709\u544a\u8b66\u7684\u53c2\u6570\u4e3a\uff1a" + ((Object)map1).toString());
                                }
                                alarmDo = new SoeRecordOnOffAlarmDo();
                                alarmDo.setOrgNo(orgNo);
                                alarmDo.setSoeObjectId(ceDeviceId);
                                alarmDo.setSoeObjectName(ceResName);
                                alarmDo.setSoeSortNo(measItemCode);
                                alarmDo.setSoeGenTime(new Date());
                                map = new HashMap();
                                map.put(measItemCode2 + "_curr_value", currValue);
                                map.put(measItemCode2 + "_set_value", downDownLimit);
                                measItemCodeSet.forEach(code -> {
                                    BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                                    map.put((String)code, decimal);
                                });
                                alarmDo.setSoeObjectType(20);
                                convert = JsonConvertUtils.convertToString(map);
                                alarmDo.setSoeGenValue(convert);
                                this.comp(alarmDo, measItemAlias, downDownLimit, currValue, 4);
                                if (!alarmDo.getSoeSortNo().equals("")) {
                                    alarmDoList.add(alarmDo);
                                }
                            } else if (currValue.compareTo(downDownLimit) >= 0) {
                                alarmDo = new SoeRecordOnOffAlarmDo();
                                alarmDo.setOrgNo(orgNo);
                                alarmDo.setSoeObjectId(ceDeviceId);
                                alarmDo.setSoeObjectName(ceResName);
                                alarmDo.setRecovery(true);
                                map2 = new HashMap();
                                map2.put(measItemCode2 + "_curr_value", currValue);
                                map2.put(measItemCode2 + "_set_value", downDownLimit);
                                measItemCodeSet.forEach(code -> {
                                    BigDecimal decimal = (BigDecimal)decimalMap.get(code);
                                    map2.put((String)code, decimal);
                                });
                                convert = JsonConvertUtils.convertToString(map2);
                                alarmDo.setSoeRecValue(convert);
                                alarmDo.setSoeRecTime(new Date());
                                alarmDo.setSoeSortNo(sortNo);
                                alarmDo.setGmtModified(System.currentTimeMillis());
                                this.soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                            }
                        }
                    });
                });
            }
            if (alarmDoList.size() > 0) {
                this.insertSoeRecordOnOffAlarmDo(alarmDoList);
            }
            midList.forEach(mid -> this.concurrentHashMap.remove(mid));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

