/*
 * Decompiled with CFR 0.152.
 */
package com.iesms.bizprocessors.common.util;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.easesource.iot.datacenter.openservice.entity.MeasDataLatestInfo;
import com.easesource.iot.datacenter.openservice.request.MeasDataLatestGetRequest;
import com.easesource.iot.datacenter.openservice.response.MeasDataLatestGetResponse;
import com.iesms.bizprocessors.common.entity.SoeDevMeterAlarmVo;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class MeasStatUtil {
    public static MeasDataLatestGetResponse getMeasStatCumDayValue(Set<String> measItemCodeSet, Long measPointId, MeasDataService measDataService) {
        MeasDataLatestGetRequest getRequest = new MeasDataLatestGetRequest();
        getRequest.setMeasPointId(measPointId);
        getRequest.setMeasDataSideType(1);
        getRequest.setMeasItemCodeSet(measItemCodeSet);
        MeasDataLatestGetResponse response = measDataService.getMeasDataLatest(getRequest);
        return response;
    }

    public static Set<String> getMeasIdList(List<SoeDevMeterAlarmVo> devMeterAlarmList) {
        ConcurrentHashMap measMaps = new ConcurrentHashMap();
        devMeterAlarmList.forEach(meterAlarmVo -> {
            Long measPointId = meterAlarmVo.getMeasPointId();
            String measPointIds = meterAlarmVo.getMeasPointIdList();
            String[] measPointIds2 = null;
            if (measPointIds != null && !measPointIds.equals("[]") && !measPointIds.equals("[0]")) {
                measPointIds2 = (String[])JsonConvertUtils.convertFromString((String)measPointIds, String[].class);
            }
            if (measPointIds2 != null && measPointIds2.length > 0) {
                for (String measId : measPointIds2) {
                    measMaps.put(measId, Long.valueOf(measId));
                }
            }
            if (measPointId != null) {
                measMaps.put(measPointId.toString(), measPointId);
            }
        });
        Set<String> strings = measMaps.keySet();
        return strings;
    }

    public static Map<String, BigDecimal> getValueSum(Set<String> measItemCodeSet, Set<String> measIdList, MeasDataService measDataService) {
        ConcurrentHashMap<String, BigDecimal> valueMap = new ConcurrentHashMap<String, BigDecimal>();
        measIdList.forEach(measPointId -> {
            MeasDataLatestGetResponse getResponse = MeasStatUtil.getMeasStatCumDayValue(measItemCodeSet, Long.valueOf(measPointId), measDataService);
            if (getResponse != null && getResponse.isSuccess()) {
                Map measDataMap = getResponse.getMeasDataMap();
                measItemCodeSet.forEach(itemCode -> {
                    MeasDataLatestInfo dataLatestInfo = (MeasDataLatestInfo)measDataMap.get(itemCode);
                    if (dataLatestInfo == null) {
                        return;
                    }
                    Object measDataValue = dataLatestInfo.getMeasDataValue();
                    if (measDataValue == null) {
                        return;
                    }
                    String value = measDataValue.toString();
                    if (value.equals("0E-8")) {
                        value = "0.0";
                    }
                    BigDecimal valueDecimal = new BigDecimal(value);
                    if (valueMap.containsKey(itemCode)) {
                        if (itemCode.startsWith("gen_watt_temp") || itemCode.startsWith("gen_watt_u") || itemCode.startsWith("gen_watt_pf")) {
                            BigDecimal bigDecimal = (BigDecimal)valueMap.get(itemCode);
                            int i = bigDecimal.compareTo(valueDecimal);
                            if (i < 0) {
                                valueMap.put((String)itemCode, valueDecimal);
                            }
                        } else if (valueMap.containsKey(itemCode)) {
                            BigDecimal bigDecimal = (BigDecimal)valueMap.get(itemCode);
                            BigDecimal decimal = bigDecimal.add(valueDecimal);
                            valueMap.put((String)itemCode, decimal);
                        }
                    } else {
                        valueMap.put((String)itemCode, valueDecimal);
                    }
                });
            }
        });
        return valueMap;
    }

    public static String subZeroAndDot(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(".") > 0) {
            s = s.replaceAll("0+?$", "");
            s = s.replaceAll("[.]$", "");
        }
        return s;
    }
}

