package com.iesms.bizprocessors.common.service.impl;

import com.easesource.commons.util.convert.JsonConvertUtils;
import com.easesource.iot.datacenter.openservice.MeasDataService;
import com.iesms.bizprocessors.common.dao.SoeRecordOnOffAlarmDao;
import com.iesms.bizprocessors.common.entity.*;
import com.iesms.bizprocessors.common.service.AbstractIesmsBaseService;
import com.iesms.bizprocessors.common.service.SoeRecordOnOffAlarmService;
import com.iesms.bizprocessors.common.util.MeasStatUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.sql.ClientInfoStatus;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

/**
 * 设备告警soe业务处理
 */
@Service
public class SoeRecordOnOffAlarmServiceImpl extends AbstractIesmsBaseService implements SoeRecordOnOffAlarmService {

    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    private final ConcurrentHashMap<String, Long> concurrentHashMap = new ConcurrentHashMap<>();

    @Resource
    private SoeRecordOnOffAlarmDao soeRecordOnOffAlarmDao;

    @Resource
    private StringRedisTemplate stringRedisTemplate;


    @Override
    public void insertSoeRecordOnOffAlarmDo(List<SoeRecordOnOffAlarmDo> list) {
        if(logger.isDebugEnabled()) {
            logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 告警记录插入开始 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>记录数为：" + list.size());
        }
        if (list == null) {
            return;
        }
        list.removeIf(Objects::isNull);
        if (list.size() < 1) {
            return;
        }
        long time1 = System.currentTimeMillis();
        list.forEach(alarmDo -> {
            alarmDo.setId(idGenerator.nextId());
            alarmDo.setSoeLevel(3);
            alarmDo.setGraveLevel(3);
//            alarmDo.setSoeGenTime(new Date());
//            alarmDo.setSoeGenTime(alarmDo.getSoeGenTime() == null ? new Date() : alarmDo.getSoeGenTime());
            alarmDo.setSendSms(false);
            alarmDo.setSendSmsCount(0);
            alarmDo.setSortSn(1);
            alarmDo.setValid(true);
            alarmDo.setGmtCreate(System.currentTimeMillis());
            alarmDo.setGmtModified(System.currentTimeMillis());
            alarmDo.setCreator("alarmSystem");
            alarmDo.setCreator("alarmSystem");
            alarmDo.setInvalider("alarmSystem");
            alarmDo.setModifier("alarmSystem");
            alarmDo.setGmtInvalid(0);
            alarmDo.setVersion(0);
        });
        for (int i = 0; i < list.size(); i++) {
            soeRecordOnOffAlarmDao.insertSoeRecordOnOffAlarmDo(list.get(i));
        }
        long time2 = System.currentTimeMillis();
        if(logger.isDebugEnabled()) {
            logger.debug(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>> 告警记录插入结束>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>告警记录插入时间为：" + ((time2 - time1) / 1000) + "秒");
            logger.debug(" ===================================开合告警推送开始===================================");
        }
        list.forEach(alarm -> {
            AlarmVo alarmVo = new AlarmVo();
            alarmVo.setOrgNo(alarm.getOrgNo());
            alarmVo.setDeviceName(alarm.getSoeObjectName());
            alarmVo.setGraveLevel("3"); // 默认等级3
            alarmVo.setSoeSortNo(alarm.getSoeSortNo());
            alarmVo.setSoeSortName(alarm.getSoeDesc());
            stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT", JsonConvertUtils.convertToString(alarmVo));
        });
        long time3 = System.currentTimeMillis();
        if(logger.isDebugEnabled()) {
            logger.debug("告警推送时间为：" + ((time3 - time2) / 1000));
            logger.debug(" ===================================开合告警推送结束 ==================================");
        }
    }

    @Override
    public void insertSoeRecordOnOffAlarmDto(List<SoeRecordOnOffAlarmDto> list) {
        if(logger.isDebugEnabled()) {
            logger.debug("******************************************** 电能质量告警记录插入开始******************************************** 告警记录数：" + list.size());
        }
        long time1 = System.currentTimeMillis();
        for (int i = 0; i <list.size() ; i++) {
            soeRecordOnOffAlarmDao.insertSoeRecordOnOffAlarmDto(list.get(i));
        }

        long time2 = System.currentTimeMillis();
        if(logger.isDebugEnabled()) {
            logger.debug("******************************************** 电能质量告警记录插入结束******************************************** 告警记录插入时间为：" + ((time2 - time1) / 1000) + "秒");
            logger.debug("******************************************** 电能质量告警推送开始********************************************");
        }
        list.forEach(alarm -> {
            AlarmVo alarmVo = new AlarmVo();
            alarmVo.setOrgNo(alarm.getOrgNo());
            alarmVo.setDeviceName(alarm.getSoeObjectName());
            alarmVo.setGraveLevel("3"); // 默认等级3
            alarmVo.setSoeSortNo(alarm.getSoeSortNo());
            alarmVo.setSoeSortName(alarm.getSoeDesc());
            stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT", JsonConvertUtils.convertToString(alarmVo));
        });
        long time3 = System.currentTimeMillis();
        if(logger.isDebugEnabled()) {
            logger.debug("告警推送时间为：" + ((time3 - time2) / 1000) + "秒");
            logger.debug("********************************************电能质量告警推送结束********************************************");
        }
    }

    @Override
    public void updateSoeRecordOnOffAlarmDo(SoeRecordOnOffAlarmDo onOffAlarmDo) {
        String devMeterCommAddr = onOffAlarmDo.getDevMeterCommAddr();
        String devTermCommAddr = onOffAlarmDo.getDevTermCommAddr();
        Long measPointId = onOffAlarmDo.getMeasPointId();

        // 查询表计地址
        SoeRecordOnOffAlarmDo devMeterInfo = null;
        if (devTermCommAddr != null) {
            Map<String, String> map = new HashMap<>();
            map.put("devMeterCommAddr", devMeterCommAddr);
            map.put("devTermCommAddr", devTermCommAddr);
            devMeterInfo = soeRecordOnOffAlarmDao.getDevMeterInfo(map);
        } else {
            Map<String, String> map = new HashMap<>();
            map.put("devMeterCommAddr", devMeterCommAddr);
            map.put("measPointId", measPointId.toString());
            devMeterInfo = soeRecordOnOffAlarmDao.getDevMeterInfoByMeasePointId(map);
        }
        //logger.info("表计地址 devMeterInfo：{}", devMeterInfo);
        //如果表计地址不存在则返回
        if (devMeterInfo == null) {
            return;
        }

        List<SoeRecordOnOffAlarmDo> onOffAlarmDoList = new ArrayList<>();

        // 查询是否有未复归的告警，如果有则判断是否复归，如果没有则插入
        Long devMeterId = devMeterInfo.getId();
        String devMeterName = devMeterInfo.getDevMeterName();
        String devTermName = devMeterInfo.getDevTermName();
        String orgNo = devMeterInfo.getOrgNo();
        Map<String, Object> objectMap = new HashMap<>();
        objectMap.put("soeObjectId", devMeterId);
        objectMap.put("soeSortNo", "SOE_GEN_WATT_STATE_SHIFT_ALARM");
        objectMap.put("recovery", false);
        SoeRecordOnOffAlarmDo beforeOffAlarmDo = soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(objectMap);
        Boolean onOff = onOffAlarmDo.getOnOff();

        Map<String, Object> stringMap = new HashMap<>();
        stringMap.put("gen_watt_state_open", onOff);
        String soeGenValue = JsonConvertUtils.convertToString(stringMap);
        onOffAlarmDo.setOrgNo(orgNo);
        onOffAlarmDo.setSoeObjectId(devMeterId);
        onOffAlarmDo.setSoeObjectName(devMeterName);
        onOffAlarmDo.setSoeObjectType(3);
        onOffAlarmDo.setSoeGenTime(new Date());
        onOffAlarmDo.setSoeGenValue(soeGenValue);
        onOffAlarmDo.setDevMeterName(devMeterName);
        onOffAlarmDo.setSoeSortNo("SOE_GEN_WATT_STATE_SHIFT_ALARM");
        if (onOff) {
            onOffAlarmDo.setSoeTitle(devMeterName);
            onOffAlarmDo.setSoeDesc("合(闭合)闸告警");
        } else {
            onOffAlarmDo.setSoeTitle(devMeterName);
            onOffAlarmDo.setSoeDesc("开(断开)闸告警");
        }

        if (beforeOffAlarmDo == null) {
            // 插入
            onOffAlarmDo.setRecovery(false);
            onOffAlarmDoList.add(onOffAlarmDo);
        } else {
            // 有未复归的告警，则判断是否是相同的告警，如果是相同的告警则跳过，如果是不同的告警，则生成新的告警，并复归之前的告警
            String beforeDoSoeGenValue = beforeOffAlarmDo.getSoeGenValue();
            Map<String, Object> map1 = JsonConvertUtils.convertFromString(beforeDoSoeGenValue, Map.class);
            Boolean wattStateOpen = (Boolean) map1.get("gen_watt_state_open");
            if (!wattStateOpen == onOff) {
                // 复归之前的告警，生成新的告警
                onOffAlarmDoList.add(onOffAlarmDo);

                beforeOffAlarmDo.setRecovery(true);
                Map<String, Object> stringMap1 = new HashMap<>();
                stringMap1.put("gen_watt_state_open", onOff);
                String soeGenValue1 = JsonConvertUtils.convertToString(stringMap1);
                beforeOffAlarmDo.setSoeRecValue(soeGenValue1);
                beforeOffAlarmDo.setSoeRecTime(new Date());
                beforeOffAlarmDo.setGmtModified(System.currentTimeMillis());
                soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(beforeOffAlarmDo);
                //生成新的告警
//                onOffAlarmDo.setRecovery(false);
//                onOffAlarmDo.setSoeGenTime(new Date());
//                onOffAlarmDo.setSoeDesc("开(断开)闸告警");
//                stringMap1.put("gen_watt_state_open", false);
//                onOffAlarmDo.setSoeGenValue(JsonConvertUtils.convertToString(stringMap1));
                //onOffAlarmDoList.add(onOffAlarmDo);
            }
        }
        if (onOffAlarmDoList.size() > 0) {
//           onOffAlarmDoList.forEach(soeRecordOnOffAlarmDo -> {
//               stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT",JsonConvertUtils.convertToString(soeRecordOnOffAlarmDo));
//           });
            insertSoeRecordOnOffAlarmDo(onOffAlarmDoList);
        }
    }

    @Override
    public void updateBoundSoeRecordOnOffAlarmDo(MeasDataService measDataService) {
        if(logger.isDebugEnabled()) {
            logger.debug("调用上下限告警 参数：{}", measDataService);
        }

        // 查询上下限告警设置项
        List<SoeThresholdSetAlarmDo> thresholdSetAlarmDo = soeRecordOnOffAlarmDao.getSoeThresholdSetAlarmDo();
        if (thresholdSetAlarmDo == null) {
            return;
        }

        Map<Long, List<SoeThresholdSetAlarmDo>> mapList = thresholdSetAlarmDo.stream().collect(Collectors.groupingBy(SoeThresholdSetAlarmDo::getCeDevId));
        List<SoeRecordOnOffAlarmDo> alarmDoList = new ArrayList<>();

        mapList.forEach((ceDeviceId, alarmList) -> {

            SoeDevMeterAlarmVo alarmVo = new SoeDevMeterAlarmVo();
            alarmVo.setCeDeviceId(ceDeviceId);
            List<SoeDevMeterAlarmVo> devMeterAlarmList = soeRecordOnOffAlarmDao.getSoeDevMeterAlarmList(alarmVo);
            if (devMeterAlarmList == null || devMeterAlarmList.size() < 1) {
                return;
            }

            Set<String> measIdList = MeasStatUtil.getMeasIdList(devMeterAlarmList);
            String orgNo = devMeterAlarmList.get(0).getOrgNo();
            String ceResName = devMeterAlarmList.get(0).getCeResName();

            Set<String> measItemCodeSet = new TreeSet<>();
            alarmList.forEach(meterAlarmVo -> {
                // 获取量测项编码 soeDesc
                measItemCodeSet.add(meterAlarmVo.getMeasItemCode());
            });
            Map<String, BigDecimal> decimalMap = MeasStatUtil.getValueSum(measItemCodeSet, measIdList, measDataService);
            alarmList.forEach(alarm -> {
                if(logger.isDebugEnabled()) {
                    logger.debug("告警的设备id是：", ceDeviceId);
                }
                String measItemCode = alarm.getMeasItemCode();

                String similar = measItemCode.substring(0, 10);
                List<String> list = new ArrayList<>();
                measItemCodeSet.forEach(code -> {
                    String simi = code.substring(0, 10);
                    if (simi.equals(similar)) {
                        list.add(code);
                    }
                });


                String measItemCode2 = alarm.getMeasItemCode();
                BigDecimal upperLimit = alarm.getUpperLimit();
                BigDecimal upperUpperLimit = alarm.getUpperUpperLimit();
                BigDecimal downLimit = alarm.getDownLimit();
                BigDecimal downDownLimit = alarm.getDownDownLimit();
                Object value = decimalMap.get(measItemCode);
                if (value == null) {
                    return;
                }
                // 上下限告警复归或插入
                String measItemAlias = alarm.getMeasItemAlias();
                BigDecimal currValue = new BigDecimal(value.toString());
                if (upperUpperLimit != null) {
                    // 查询是否有未复归告警
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("soeObjectId", ceDeviceId);
                    map1.put("recovery", false);

                    String sortNo = "SOE_" + measItemCode.toUpperCase() + "_OUUL_ALARM";
                    map1.put("soeSortNo", sortNo);
//                    logger.info("upperUpperLimit map1", map1.toString());
                    SoeRecordOnOffAlarmDo recordOnOffAlarmDo = soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
//                    logger.info("upperUpperLimit recordOnOffAlarmDo", recordOnOffAlarmDo.toString());
                    if (recordOnOffAlarmDo == null && currValue.compareTo(upperUpperLimit) > 0) {
                        // 新增
                        SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setSoeObjectType(20);
                        alarmDo.setSoeRecTime(new Date());
                        alarmDo.setSoeSortNo(measItemCode);
                        Map<String, Object> map = new HashMap<>();
                        map.put(measItemCode2 + "_curr_value", currValue);
                        map.put(measItemCode2 + "_set_value", upperUpperLimit);

                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = decimalMap.get(code);
                            map.put(code, decimal);
                        });

                        String convert = JsonConvertUtils.convertToString(map);
                        alarmDo.setSoeGenValue(convert);
                        comp(alarmDo, measItemAlias, upperUpperLimit, currValue, 1);
                        if (!alarmDo.getSoeSortNo().equals("")) {
                            alarmDoList.add(alarmDo);

                        }
                    } else {
                        if (currValue.compareTo(upperUpperLimit) <= 0) {

                            SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                            alarmDo.setOrgNo(orgNo);
                            alarmDo.setSoeObjectId(ceDeviceId);
                            alarmDo.setSoeObjectName(ceResName);
                            alarmDo.setRecovery(true);
                            Map<String, Object> map2 = new HashMap<>();
                            map2.put(measItemCode2 + "_curr_value", currValue);
                            map2.put(measItemCode2 + "_set_value", upperUpperLimit);
                            measItemCodeSet.forEach(code -> {
                                BigDecimal decimal = decimalMap.get(code);
                                map2.put(code, decimal);
                            });
                            String convert = JsonConvertUtils.convertToString(map2);
                            alarmDo.setSoeRecValue(convert);
                            alarmDo.setSoeRecTime(new Date());
                            alarmDo.setSoeSortNo(sortNo);
                            alarmDo.setGmtModified(System.currentTimeMillis());
//                            logger.info("upperUpperLimit rec:" + alarmDo.toString());
                            soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                        }
                    }
                }

                if (upperLimit != null) {

                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("soeObjectId", ceDeviceId);
                    map1.put("recovery", false);
                    String sortNo = "SOE_" + measItemCode.toUpperCase() + "_OUL_ALARM";
                    map1.put("soeSortNo", sortNo);
//                    logger.info("upperUpperLimit map1", map1.toString());
                    if(logger.isDebugEnabled()) {
                        logger.debug("获取当前是否有告警的参数为：", map1.toString());
                    }
                    SoeRecordOnOffAlarmDo recordOnOffAlarmDo = soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                    if(logger.isDebugEnabled()) {
                        logger.debug("告警的信息为================：", recordOnOffAlarmDo);
                    }
//                    logger.info("upperUpperLimit recordOnOffAlarmDo", recordOnOffAlarmDo.toString());
                    if (recordOnOffAlarmDo == null && currValue.compareTo(upperLimit) > 0) {
                        // 新增
                        SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setSoeSortNo(measItemCode);
                        alarmDo.setSoeObjectType(20);
                        alarmDo.setSoeGenTime(new Date());

                        Map<String, Object> map = new HashMap<>();
                        map.put(measItemCode2 + "_curr_value", currValue);
                        map.put(measItemCode2 + "_set_value", upperLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = decimalMap.get(code);
                            map.put(code, decimal);
                        });
                        String convert = JsonConvertUtils.convertToString(map);
                        alarmDo.setSoeGenValue(convert);
                        comp(alarmDo, measItemAlias, upperLimit, currValue, 2);
                        if (!alarmDo.getSoeSortNo().equals("")) {
                            alarmDoList.add(alarmDo);

                        }
                    } else {
                        if (currValue.compareTo(upperLimit) <= 0) {

                            SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                            alarmDo.setOrgNo(orgNo);
                            alarmDo.setSoeObjectId(ceDeviceId);
                            alarmDo.setSoeObjectName(ceResName);
                            alarmDo.setRecovery(true);

                            Map<String, Object> map2 = new HashMap<>();
                            map2.put(measItemCode2 + "_curr_value", currValue);
                            map2.put(measItemCode2 + "_set_value", upperLimit);
                            measItemCodeSet.forEach(code -> {
                                BigDecimal decimal = decimalMap.get(code);
                                map2.put(code, decimal);
                            });
                            String convert = JsonConvertUtils.convertToString(map2);
                            alarmDo.setSoeRecValue(convert);
                            alarmDo.setSoeRecTime(new Date());
                            alarmDo.setSoeSortNo(sortNo);
                            alarmDo.setGmtModified(System.currentTimeMillis());
//                            logger.info("upperLimit rec:" + alarmDo.toString());
                            soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                        }
                    }
                }

                if (downLimit != null) {
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("soeObjectId", ceDeviceId);
                    map1.put("recovery", false);
                    String sortNo = "SOE_" + measItemCode.toUpperCase() + "_OLL_ALARM";
                    map1.put("soeSortNo", sortNo);

                    SoeRecordOnOffAlarmDo recordOnOffAlarmDo = soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);

                    if (recordOnOffAlarmDo == null && currValue.compareTo(downLimit) < 0) {
                        // 新增
                        SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setSoeSortNo(measItemCode);
                        alarmDo.setSoeGenTime(new Date());
                        Map<String, Object> map = new HashMap<>();
                        map.put(measItemCode2 + "_curr_value", currValue);
                        map.put(measItemCode2 + "_set_value", downLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = decimalMap.get(code);
                            map.put(code, decimal);
                        });
                        alarmDo.setSoeObjectType(20);
                        String convert = JsonConvertUtils.convertToString(map);
                        alarmDo.setSoeGenValue(convert);
                        comp(alarmDo, measItemAlias, downLimit, currValue, 3);
                        if (!alarmDo.getSoeSortNo().equals("")) {
                            alarmDoList.add(alarmDo);
                        }
                    } else {
                        if (currValue.compareTo(downLimit) >= 0) {

                            SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                            alarmDo.setOrgNo(orgNo);
                            alarmDo.setSoeObjectId(ceDeviceId);
                            alarmDo.setSoeObjectName(ceResName);
                            alarmDo.setRecovery(true);
                            Map<String, Object> map2 = new HashMap<>();
                            map2.put(measItemCode2 + "_curr_value", currValue);
                            map2.put(measItemCode2 + "_set_value", downLimit);
                            measItemCodeSet.forEach(code -> {
                                BigDecimal decimal = decimalMap.get(code);
                                map2.put(code, decimal);
                            });
                            String convert = JsonConvertUtils.convertToString(map2);
                            alarmDo.setSoeRecValue(convert);
                            alarmDo.setSoeRecTime(new Date());
                            alarmDo.setSoeSortNo(sortNo);
                            alarmDo.setGmtModified(System.currentTimeMillis());
//                            logger.info("downLimit rec:" + alarmDo.toString());
                            soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                        }
                    }
                }

                if (downDownLimit != null) {
                    Map<String, Object> map1 = new HashMap<>();
                    map1.put("soeObjectId", ceDeviceId);
                    map1.put("recovery", false);
                    String sortNo = "SOE_" + measItemCode.toUpperCase() + "_OLLL_ALARM";
                    map1.put("soeSortNo", sortNo);
                    SoeRecordOnOffAlarmDo recordOnOffAlarmDo = soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                    if (recordOnOffAlarmDo == null && currValue.compareTo(downDownLimit) < 0) {
                        // 新增
                        SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                        alarmDo.setOrgNo(orgNo);
                        alarmDo.setSoeObjectId(ceDeviceId);
                        alarmDo.setSoeObjectName(ceResName);
                        alarmDo.setSoeSortNo(measItemCode);
                        alarmDo.setSoeGenTime(new Date());
                        Map<String, Object> map = new HashMap<>();
                        map.put(measItemCode2 + "_curr_value", currValue);
                        map.put(measItemCode2 + "_set_value", downDownLimit);
                        measItemCodeSet.forEach(code -> {
                            BigDecimal decimal = decimalMap.get(code);
                            map.put(code, decimal);
                        });
                        alarmDo.setSoeObjectType(20);
                        String convert = JsonConvertUtils.convertToString(map);
                        alarmDo.setSoeGenValue(convert);
                        comp(alarmDo, measItemAlias, downDownLimit, currValue, 4);
                        if (!alarmDo.getSoeSortNo().equals("")) {
                            alarmDoList.add(alarmDo);
                        }
                    } else {
                        if (currValue.compareTo(downDownLimit) >= 0) {

                            SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                            alarmDo.setOrgNo(orgNo);
                            alarmDo.setSoeObjectId(ceDeviceId);
                            alarmDo.setSoeObjectName(ceResName);
                            alarmDo.setRecovery(true);
                            Map<String, Object> map2 = new HashMap<>();
                            map2.put(measItemCode2 + "_curr_value", currValue);
                            map2.put(measItemCode2 + "_set_value", downDownLimit);
                            measItemCodeSet.forEach(code -> {
                                BigDecimal decimal = decimalMap.get(code);
                                map2.put(code, decimal);
                            });
                            String convert = JsonConvertUtils.convertToString(map2);
                            alarmDo.setSoeRecValue(convert);
                            alarmDo.setSoeRecTime(new Date());
                            alarmDo.setSoeSortNo(sortNo);
                            alarmDo.setGmtModified(System.currentTimeMillis());
//                            logger.info("downDownLimit rec:" + alarmDo.toString());
                            soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                        }
                    }
                }
            });

        });


        if (alarmDoList.size() > 0) {
            ArrayList<SoeRecordOnOffAlarmDo> list = alarmDoList.stream().collect(
                    Collectors.collectingAndThen(
                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(SoeRecordOnOffAlarmDo::getSoeSortNo))), ArrayList::new));
//            list.forEach(soeRecordOnOffAlarmDo -> {
//
//                stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT",JsonConvertUtils.convertToString(soeRecordOnOffAlarmDo));
//            });
            insertSoeRecordOnOffAlarmDo(list);
        }
    }


    private void comp(SoeRecordOnOffAlarmDo alarmDo, String measItemAlias, BigDecimal limitValue, BigDecimal currValue, int level) {
        if (currValue == null || limitValue == null) {
            return;
        }
        int i = currValue.compareTo(limitValue);
        Boolean limit1 = i > 0;
        Boolean limit2 = i < 0;
        StringBuffer sb = new StringBuffer();
        sb.append("SOE_");
        String soeSortNo = alarmDo.getSoeSortNo().toUpperCase();
        sb.append(soeSortNo);
        String mess = "";
        String valueDes = "";
        String toString = currValue.toString();
        String zeroAndDot = MeasStatUtil.subZeroAndDot(toString);
        String subZeroAndDot = MeasStatUtil.subZeroAndDot(limitValue.toString());
        switch (level) {
            case 1:
                if (limit1) {
                    mess = " 越上上限告警";
                    sb.append("_OUUL_ALARM");
                    valueDes = "上上限设置值：" + subZeroAndDot + " , 当前值：" + zeroAndDot;
                } else {
                    sb = null;
                }
                break;
            case 2:
                if (limit1) {
                    mess = " 越上限告警";
                    sb.append("_OUL_ALARM");
                    valueDes = "上限设置值：" + subZeroAndDot + " , 当前值：" + zeroAndDot;
                } else {
                    sb = null;
                }
                break;
            case 3:
                if (limit2) {
                    mess = " 越下限告警";
                    sb.append("_OLL_ALARM");
                    valueDes = "下限设置值：" + subZeroAndDot + " , 当前值：" + zeroAndDot;
                } else {
                    sb = null;
                }
                break;
            case 4:
                if (limit2) {
                    mess = " 越下下限告警";
                    sb.append("_OLLL_ALARM");
                    valueDes = "下下限设置值：" + subZeroAndDot + " , 当前值：" + zeroAndDot;
                } else {
                    sb = null;
                }
                break;
        }
        if (sb != null) {
            alarmDo.setSoeTitle(measItemAlias + "告警");
            alarmDo.setSoeDesc(measItemAlias + mess + " ," + valueDes);
            alarmDo.setSoeSortNo(sb.toString());
        } else {
            alarmDo.setSoeTitle("");
            alarmDo.setSoeDesc("");
            alarmDo.setSoeSortNo("");
        }

    }

    @Override
    public SoeRecordOnOffAlarmDo getSoeRecordOnOffAlarmDo(Map<String, Object> params) {
        if (params == null) {
            return null;
        }
        return soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(params);
    }

    public static void main(String[] args) throws Exception{
        BigDecimal currValue = new BigDecimal("229.300000");
        BigDecimal upperUpperLimit = new BigDecimal("242.0");
        System.out.println("=================" + currValue.compareTo(upperUpperLimit));
    }
    @Override
    public void newUpdateBoundSoeRecordOnOffAlarmDo(MeasDataService measDataService, List<Long> ids) throws Exception {
        try {
            List<String> midList = new ArrayList<String>();
            // 根据量测点查找相应的设备对象告警设置
            List<SoeRecordOnOffAlarmDo> alarmDoList = new ArrayList<>();
            if(logger.isDebugEnabled()) {
                logger.debug("执行量侧点总数为" + ids.size());
            }
            for (Long id : ids) {
                if (concurrentHashMap.get(String.valueOf(id)) == null) {
                    concurrentHashMap.put(String.valueOf(id), id);
                    midList.add(String.valueOf(id));
                } else {
                    continue;
                }
                SoeDevMeterAlarmVo alarmVo = new SoeDevMeterAlarmVo();
                alarmVo.setMeasPointId(id);
                List<SoeThresholdSetAlarmDo> thresholdSetAlarmDo = soeRecordOnOffAlarmDao.getAlarmMsg(alarmVo);
                if (thresholdSetAlarmDo == null || thresholdSetAlarmDo.size() == 0) {
                    continue;
                } else {
                    Map<Long, List<SoeThresholdSetAlarmDo>> mapList = thresholdSetAlarmDo.stream().collect(Collectors.groupingBy(SoeThresholdSetAlarmDo::getCeDevId));
                    mapList.forEach((ceDeviceId, alarmList) -> {
                        String orgNo = alarmList.get(0).getOrgNo();
                        String ceResName = alarmList.get(0).getCeResName();
                        Set<String> measItemCodeSet = new TreeSet<>();
                        alarmList.forEach(meterAlarmVo -> {
                            // 获取量测项编码 soeDesc
                            measItemCodeSet.add(meterAlarmVo.getMeasItemCode());
                        });
                        Map<String, Long> measMaps = new ConcurrentHashMap<>();
                        String measPointIds = alarmList.get(0).getMeasPointIdList();
                        String[] measPointIds2 = null;
                        if (measPointIds != null && !measPointIds.equals("[]") && !measPointIds.equals("[0]")) {
                            measPointIds2 = JsonConvertUtils.convertFromString(measPointIds, String[].class);
                        }
                        if (measPointIds2 != null && measPointIds2.length > 0) {
                            for (String measId : measPointIds2) {
                                measMaps.put(measId, Long.valueOf(measId));
                            }
                        }
                        Set<String> measIdList = measMaps.keySet();
                        Map<String, BigDecimal> decimalMap = MeasStatUtil.getValueSum(measItemCodeSet, measIdList, measDataService);
                        alarmList.forEach(alarm -> {
                            String measItemCode = alarm.getMeasItemCode();

                            String similar = measItemCode.substring(0, 10);
                            List<String> list = new ArrayList<>();
                            measItemCodeSet.forEach(code -> {
                                String simi = code.substring(0, 10);
                                if (simi.equals(similar)) {
                                    list.add(code);
                                }
                            });

                            String measItemCode2 = alarm.getMeasItemCode();
                            BigDecimal upperLimit = alarm.getUpperLimit();
                            BigDecimal upperUpperLimit = alarm.getUpperUpperLimit();
                            BigDecimal downLimit = alarm.getDownLimit();
                            BigDecimal downDownLimit = alarm.getDownDownLimit();
                            Object value = decimalMap.get(measItemCode);
                            if (value == null) {
                                return;
                            }
                            // 上下限告警复归或插入
                            String measItemAlias = alarm.getMeasItemAlias();
                            BigDecimal currValue = new BigDecimal(value.toString());
                            if (upperUpperLimit != null) {
                                // 查询是否有未复归告警
                                Map<String, Object> map1 = new HashMap<>();
                                map1.put("soeObjectId", ceDeviceId);
                                map1.put("recovery", false);

                                String sortNo = "SOE_" + measItemCode.toUpperCase() + "_OUUL_ALARM";
                                map1.put("soeSortNo", sortNo);
                                SoeRecordOnOffAlarmDo recordOnOffAlarmDo = soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                                if (recordOnOffAlarmDo == null && currValue.compareTo(upperUpperLimit) > 0) {
                                    if(logger.isDebugEnabled()) {
                                        logger.debug("进入越上上限裁定 ======================当前值为：" + currValue + "越上上限值为：" + upperUpperLimit);
                                    }
                                    // 新增
                                    SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setSoeObjectType(20);
                                    alarmDo.setSoeGenTime(new Date());
                                    alarmDo.setSoeSortNo(measItemCode);
                                    Map<String, Object> map = new HashMap<>();
                                    map.put(measItemCode2 + "_curr_value", currValue);
                                    map.put(measItemCode2 + "_set_value", upperUpperLimit);

                                    measItemCodeSet.forEach(code -> {
                                        BigDecimal decimal = decimalMap.get(code);
                                        map.put(code, decimal);
                                    });

                                    String convert = JsonConvertUtils.convertToString(map);
                                    alarmDo.setSoeGenValue(convert);
                                    comp(alarmDo, measItemAlias, upperUpperLimit, currValue, 1);
                                    if (!alarmDo.getSoeSortNo().equals("")) {
                                        alarmDoList.add(alarmDo);
                                    }
                                } else {
                                    if (currValue.compareTo(upperUpperLimit) <= 0) {
                                        SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                                        alarmDo.setOrgNo(orgNo);
                                        alarmDo.setSoeObjectId(ceDeviceId);
                                        alarmDo.setSoeObjectName(ceResName);
                                        alarmDo.setRecovery(true);
                                        Map<String, Object> map2 = new HashMap<>();
                                        map2.put(measItemCode2 + "_curr_value", currValue);
                                        map2.put(measItemCode2 + "_set_value", upperUpperLimit);
                                        measItemCodeSet.forEach(code -> {
                                            BigDecimal decimal = decimalMap.get(code);
                                            map2.put(code, decimal);
                                        });
                                        String convert = JsonConvertUtils.convertToString(map2);
                                        alarmDo.setSoeRecValue(convert);
                                        alarmDo.setSoeRecTime(new Date());
                                        alarmDo.setSoeSortNo(sortNo);
                                        alarmDo.setGmtModified(System.currentTimeMillis());
//                            logger.info("upperUpperLimit rec:" + alarmDo.toString());
                                        soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                                    }
                                }
                            }

                            if (upperLimit != null) {
                                Map<String, Object> map1 = new HashMap<>();
                                map1.put("soeObjectId", ceDeviceId);
                                map1.put("recovery", false);
                                String sortNo = "SOE_" + measItemCode.toUpperCase() + "_OUL_ALARM";
                                map1.put("soeSortNo", sortNo);
                                SoeRecordOnOffAlarmDo recordOnOffAlarmDo = soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                                if (recordOnOffAlarmDo == null && currValue.compareTo(upperLimit) > 0) {
                                    if(logger.isDebugEnabled()) {
                                        logger.debug("进入越上限裁定 ======================当前值为：" + currValue + "越上限值为：" + upperLimit);
                                        logger.debug("获取当前是否有告警的参数为：" + map1.toString());
                                    }
                                    // 新增
                                    SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setSoeSortNo(measItemCode);
                                    alarmDo.setSoeObjectType(20);
                                    alarmDo.setSoeGenTime(new Date());

                                    Map<String, Object> map = new HashMap<>();
                                    map.put(measItemCode2 + "_curr_value", currValue);
                                    map.put(measItemCode2 + "_set_value", upperLimit);
                                    measItemCodeSet.forEach(code -> {
                                        BigDecimal decimal = decimalMap.get(code);
                                        map.put(code, decimal);
                                    });
                                    String convert = JsonConvertUtils.convertToString(map);
                                    alarmDo.setSoeGenValue(convert);
                                    comp(alarmDo, measItemAlias, upperLimit, currValue, 2);
                                    if (!alarmDo.getSoeSortNo().equals("")) {
                                        alarmDoList.add(alarmDo);

                                    }
                                } else {
                                    if (currValue.compareTo(upperLimit) <= 0) {

                                        SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                                        alarmDo.setOrgNo(orgNo);
                                        alarmDo.setSoeObjectId(ceDeviceId);
                                        alarmDo.setSoeObjectName(ceResName);
                                        alarmDo.setRecovery(true);

                                        Map<String, Object> map2 = new HashMap<>();
                                        map2.put(measItemCode2 + "_curr_value", currValue);
                                        map2.put(measItemCode2 + "_set_value", upperLimit);
                                        measItemCodeSet.forEach(code -> {
                                            BigDecimal decimal = decimalMap.get(code);
                                            map2.put(code, decimal);
                                        });
                                        String convert = JsonConvertUtils.convertToString(map2);
                                        alarmDo.setSoeRecValue(convert);
                                        alarmDo.setSoeRecTime(new Date());
                                        alarmDo.setSoeSortNo(sortNo);
                                        alarmDo.setGmtModified(System.currentTimeMillis());
//                            logger.info("upperLimit rec:" + alarmDo.toString());
                                        soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                                    }
                                }
                            }

                            if (downLimit != null) {
                                Map<String, Object> map1 = new HashMap<>();
                                map1.put("soeObjectId", ceDeviceId);
                                map1.put("recovery", false);
                                String sortNo = "SOE_" + measItemCode.toUpperCase() + "_OLL_ALARM";
                                map1.put("soeSortNo", sortNo);

                                SoeRecordOnOffAlarmDo recordOnOffAlarmDo = soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);

                                if (recordOnOffAlarmDo == null && currValue.compareTo(downLimit) < 0) {
                                    if(logger.isDebugEnabled()) {
                                        logger.debug("进入越下限裁定 ======================当前值为：" + currValue + "越下限值为：" + downLimit);
                                    }
                                    // 新增
                                    SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setSoeSortNo(measItemCode);
                                    alarmDo.setSoeGenTime(new Date());
                                    Map<String, Object> map = new HashMap<>();
                                    map.put(measItemCode2 + "_curr_value", currValue);
                                    map.put(measItemCode2 + "_set_value", downLimit);
                                    measItemCodeSet.forEach(code -> {
                                        BigDecimal decimal = decimalMap.get(code);
                                        map.put(code, decimal);
                                    });
                                    alarmDo.setSoeObjectType(20);
                                    String convert = JsonConvertUtils.convertToString(map);
                                    alarmDo.setSoeGenValue(convert);
                                    comp(alarmDo, measItemAlias, downLimit, currValue, 3);
                                    if (!alarmDo.getSoeSortNo().equals("")) {
                                        alarmDoList.add(alarmDo);
                                    }
                                } else {
                                    if (currValue.compareTo(downLimit) >= 0) {
                                        SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                                        alarmDo.setOrgNo(orgNo);
                                        alarmDo.setSoeObjectId(ceDeviceId);
                                        alarmDo.setSoeObjectName(ceResName);
                                        alarmDo.setRecovery(true);
                                        Map<String, Object> map2 = new HashMap<>();
                                        map2.put(measItemCode2 + "_curr_value", currValue);
                                        map2.put(measItemCode2 + "_set_value", downLimit);
                                        measItemCodeSet.forEach(code -> {
                                            BigDecimal decimal = decimalMap.get(code);
                                            map2.put(code, decimal);
                                        });
                                        String convert = JsonConvertUtils.convertToString(map2);
                                        alarmDo.setSoeRecValue(convert);
                                        alarmDo.setSoeRecTime(new Date());
                                        alarmDo.setSoeSortNo(sortNo);
                                        alarmDo.setGmtModified(System.currentTimeMillis());
//                            logger.info("downLimit rec:" + alarmDo.toString());
                                        soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                                    }
                                }
                            }

                            if (downDownLimit != null) {
                                Map<String, Object> map1 = new HashMap<>();
                                map1.put("soeObjectId", ceDeviceId);
                                map1.put("recovery", false);
                                String sortNo = "SOE_" + measItemCode.toUpperCase() + "_OLLL_ALARM";
                                map1.put("soeSortNo", sortNo);
                                SoeRecordOnOffAlarmDo recordOnOffAlarmDo = soeRecordOnOffAlarmDao.getSoeRecordOnOffAlarmDo(map1);
                                if (recordOnOffAlarmDo == null && currValue.compareTo(downDownLimit) < 0) {
                                    if(logger.isDebugEnabled()) {
                                        logger.debug("进入越下下限裁定 ======================当前值为：" + currValue + "越下下限值为：" + downDownLimit);
                                        logger.debug("获取当前是否有告警的参数为：" + map1.toString());
                                    }
                                    // 新增
                                    SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                                    alarmDo.setOrgNo(orgNo);
                                    alarmDo.setSoeObjectId(ceDeviceId);
                                    alarmDo.setSoeObjectName(ceResName);
                                    alarmDo.setSoeSortNo(measItemCode);
                                    alarmDo.setSoeGenTime(new Date());
                                    Map<String, Object> map = new HashMap<>();
                                    map.put(measItemCode2 + "_curr_value", currValue);
                                    map.put(measItemCode2 + "_set_value", downDownLimit);
                                    measItemCodeSet.forEach(code -> {
                                        BigDecimal decimal = decimalMap.get(code);
                                        map.put(code, decimal);
                                    });
                                    alarmDo.setSoeObjectType(20);
                                    String convert = JsonConvertUtils.convertToString(map);
                                    alarmDo.setSoeGenValue(convert);
                                    comp(alarmDo, measItemAlias, downDownLimit, currValue, 4);
                                    if (!alarmDo.getSoeSortNo().equals("")) {
                                        alarmDoList.add(alarmDo);
                                    }
                                } else {
                                    if (currValue.compareTo(downDownLimit) >= 0) {

                                        SoeRecordOnOffAlarmDo alarmDo = new SoeRecordOnOffAlarmDo();
                                        alarmDo.setOrgNo(orgNo);
                                        alarmDo.setSoeObjectId(ceDeviceId);
                                        alarmDo.setSoeObjectName(ceResName);
                                        alarmDo.setRecovery(true);
                                        Map<String, Object> map2 = new HashMap<>();
                                        map2.put(measItemCode2 + "_curr_value", currValue);
                                        map2.put(measItemCode2 + "_set_value", downDownLimit);
                                        measItemCodeSet.forEach(code -> {
                                            BigDecimal decimal = decimalMap.get(code);
                                            map2.put(code, decimal);
                                        });
                                        String convert = JsonConvertUtils.convertToString(map2);
                                        alarmDo.setSoeRecValue(convert);
                                        alarmDo.setSoeRecTime(new Date());
                                        alarmDo.setSoeSortNo(sortNo);
                                        alarmDo.setGmtModified(System.currentTimeMillis());
//                            logger.info("downDownLimit rec:" + alarmDo.toString());
                                        soeRecordOnOffAlarmDao.updateSoeRecordOnOffAlarmDo(alarmDo);
                                    }
                                }
                            }
                        });
                    });
                }
            };
            if (alarmDoList.size() > 0) {
//            ArrayList<SoeRecordOnOffAlarmDo> list = alarmDoList.stream().collect(
//                    Collectors.collectingAndThen(
//                            Collectors.toCollection(() -> new TreeSet<>(Comparator.comparing(SoeRecordOnOffAlarmDo::getSoeSortNo))), ArrayList::new));
                //            list.forEach(soeRecordOnOffAlarmDo -> {
                //
                //                stringRedisTemplate.convertAndSend("IESMS_SOE_EVENT",JsonConvertUtils.convertToString(soeRecordOnOffAlarmDo));
                //            });
                insertSoeRecordOnOffAlarmDo(alarmDoList);
            }

            // 从map里移除正在执行的量测信息
            midList.forEach( (mid) ->{
                concurrentHashMap.remove(mid);
            });
        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
